/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.IGraphics;
import de.geocalc.awt.IViewport;
import de.geocalc.geom.DPoint;
import de.geocalc.geom.DRectangle;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.Drawable;
import de.geocalc.kafplot.Flurstueck;
import de.geocalc.kafplot.GObject;
import de.geocalc.kafplot.GObjectManipulator;
import de.geocalc.kafplot.InputObject;
import de.geocalc.kafplot.KafPlotProperties;
import de.geocalc.kafplot.Linie;
import de.geocalc.kafplot.Message;
import de.geocalc.kafplot.Messager;
import de.geocalc.kafplot.Nutzung;
import de.geocalc.lang.Exceptionable;
import de.geocalc.util.VoidEnumerator;
import java.awt.Cursor;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class InputObjectUnion
extends InputObject
implements Exceptionable,
Messager,
Drawable {
    private GObject firstUnionObject;
    private GObject nextUnionObject;
    private GObject unionGeometry;
    private Vector objects = new Vector();
    private Vector relevantObjects = new Vector();
    private static final int VOID = 0;
    private static final int DELETE_ZERLEGUNG = 1;
    private static final int DELETE_VERSCHMELZUNG = 2;
    private static final int CREATE_VERSCHMELZUNG = 3;
    private static final int APPEND_VERSCHMELZUNG = 4;
    private static final int APPEND_NUTZUNG = 9;
    private int mode = 0;

    @Override
    public int dataMode() {
        return 1;
    }

    @Override
    public int steps() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int need() {
        return 2048;
    }

    @Override
    public boolean isReady() {
        if (this.mode == 2) {
            return this.step >= 1;
        }
        return this.step > 1;
    }

    @Override
    public boolean isAbortable() {
        return true;
    }

    @Override
    public Object getDefault() {
        return null;
    }

    public void setObject(Object object, int n) {
    }

    @Override
    public boolean reverse(int n) {
        return false;
    }

    private Enumeration searchObjects() {
        if (KafPlotProperties.getEditObjectSwitch() == 2201) {
            return DataBase.flurstuecke();
        }
        if (KafPlotProperties.getEditObjectSwitch() == 2204) {
            return DataBase.nutzungen();
        }
        return new VoidEnumerator();
    }

    @Override
    public boolean accept(Object object) {
        if (this.objects.contains(object)) {
            return false;
        }
        if (KafPlotProperties.getEditObjectSwitch() == 2201) {
            if (object instanceof Flurstueck) {
                if (this.step == 0) {
                    Flurstueck flurstueck = (Flurstueck)object;
                    if (flurstueck.isTeilstueck()) {
                        return false;
                    }
                    if (flurstueck.isVereinigungTeilstueck()) {
                        return false;
                    }
                    return !flurstueck.hasTeile();
                }
                if (this.unionGeometry != null) {
                    Flurstueck flurstueck = (Flurstueck)object;
                    if (!this.unionGeometry.isNeighbor(flurstueck)) {
                        return false;
                    }
                    switch (this.mode) {
                        case 1: {
                            return flurstueck.isTeilstueck() && flurstueck.equalsIgnoreTeil((Flurstueck)this.firstUnionObject);
                        }
                        case 2: {
                            return flurstueck.isVereinigungTeilstueck() && flurstueck.equalsIgnoreTeil((Flurstueck)this.firstUnionObject);
                        }
                        case 3: {
                            return flurstueck.isFlurstueck();
                        }
                        case 4: {
                            return flurstueck.isFlurstueck();
                        }
                    }
                }
            }
        } else if (KafPlotProperties.getEditObjectSwitch() == 2204 && object instanceof Nutzung) {
            if (this.step == 0) {
                return true;
            }
            if (this.unionGeometry != null) {
                return this.unionGeometry.isNeighbor((GObject)object);
            }
        }
        return false;
    }

    @Override
    public void setObject(Object object, boolean bl) {
        GObject gObject = (GObject)object;
        if (this.accept(gObject)) {
            if (this.step == 0) {
                this.firstUnionObject = gObject;
                if (gObject instanceof Flurstueck) {
                    Flurstueck flurstueck = (Flurstueck)gObject;
                    if (flurstueck.isTeilstueck()) {
                        this.mode = 1;
                    } else if (flurstueck.isVereinigungStammstueck()) {
                        this.mode = 4;
                    } else if (flurstueck.isVereinigungTeilstueck()) {
                        this.mode = 2;
                    } else if (flurstueck.isFlurstueck()) {
                        this.mode = 3;
                    }
                } else {
                    this.mode = gObject instanceof Nutzung ? 9 : 0;
                }
                if (bl) {
                    this.objects.addElement(gObject);
                    try {
                        this.unionGeometry = (GObject)gObject.clone();
                    }
                    catch (Exception exception) {}
                }
            } else if (bl && !this.objects.contains(gObject)) {
                this.objects.addElement(gObject);
                try {
                    new GObjectManipulator(this.unionGeometry).union(this.unionGeometry, this.objects);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            this.nextUnionObject = gObject;
            if (bl) {
                ++this.step;
            }
            this.lastIn = gObject;
        }
    }

    @Override
    public Cursor getCurrentCursor() {
        return Cursor.getDefaultCursor();
    }

    public void save(Enumeration enumeration) {
        if (this.mode != 1 && this.mode != 2) {
            if (this.mode == 3) {
                Flurstueck flurstueck = (Flurstueck)this.firstUnionObject;
                int n = DataBase.FLST.getLastVereinigungNr() + 1;
                Flurstueck flurstueck2 = new Flurstueck(601, flurstueck.getGemarkung(), flurstueck.getFlur(), 100000 + n, 0, 0);
                flurstueck2.setLage(flurstueck.getLage());
                Hashtable<Object, Linie> hashtable = new Hashtable<Object, Linie>();
                Enumeration enumeration2 = this.unionGeometry.elements();
                while (enumeration2.hasMoreElements()) {
                    Linie linie = (Linie)enumeration2.nextElement();
                    flurstueck2.addElement(linie);
                    hashtable.put(linie.getHashKey(), linie);
                }
                double d = 0.0;
                double d2 = 0.0;
                Enumeration enumeration3 = this.objects.elements();
                while (enumeration3.hasMoreElements()) {
                    Flurstueck flurstueck3 = (Flurstueck)enumeration3.nextElement();
                    if (!flurstueck3.isFlurstueck()) continue;
                    flurstueck3.setTeil(100000 + n);
                    flurstueck3.setArt(709);
                    d += flurstueck3.x;
                    d2 += flurstueck3.y;
                    Enumeration enumeration4 = flurstueck3.elements();
                    while (enumeration4.hasMoreElements()) {
                        Linie linie = (Linie)enumeration4.nextElement();
                        if (hashtable.get(linie.getHashKey()) != null) continue;
                        linie.setUntergang(true);
                    }
                }
                flurstueck2.x = d / (double)this.objects.size();
                flurstueck2.y = d2 / (double)this.objects.size();
                flurstueck2.initGeom();
                try {
                    DataBase.FLST.put(flurstueck2);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else if (this.mode == 4) {
                Flurstueck flurstueck = (Flurstueck)this.firstUnionObject;
                if (!flurstueck.isVereinigungStammstueck()) {
                    return;
                }
                int n = flurstueck.getVereinigungNr();
                flurstueck.removeAllElements();
                Hashtable<Object, Linie> hashtable = new Hashtable<Object, Linie>();
                Enumeration enumeration5 = this.unionGeometry.elements();
                while (enumeration5.hasMoreElements()) {
                    Linie linie = (Linie)enumeration5.nextElement();
                    flurstueck.addElement(linie);
                    hashtable.put(linie.getHashKey(), linie);
                }
                double d = flurstueck.x;
                double d3 = flurstueck.y;
                Enumeration enumeration6 = this.objects.elements();
                while (enumeration6.hasMoreElements()) {
                    Flurstueck flurstueck4 = (Flurstueck)enumeration6.nextElement();
                    if (!flurstueck4.isFlurstueck()) continue;
                    flurstueck4.setTeil(100000 + n);
                    flurstueck4.setArt(709);
                    d += flurstueck4.x;
                    d3 += flurstueck4.y;
                    Enumeration enumeration7 = flurstueck4.elements();
                    while (enumeration7.hasMoreElements()) {
                        Linie linie = (Linie)enumeration7.nextElement();
                        if (hashtable.get(linie.getHashKey()) != null) continue;
                        linie.setUntergang(true);
                    }
                }
                flurstueck.x = d / (double)this.objects.size();
                flurstueck.y = d3 / (double)this.objects.size();
                flurstueck.initGeom();
            } else if (this.mode == 9) {
                // empty if block
            }
        }
    }

    @Override
    public Message getMessage() {
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.isFull()) {
            switch (this.mode) {
                case 1: {
                    stringBuffer.append("Flurst\u00fcckszerlegung aufheben");
                    break;
                }
                case 2: {
                    stringBuffer.append("Verschmelzung aufheben");
                    break;
                }
                case 3: {
                    stringBuffer.append("Verschmelzung erzeugen");
                    break;
                }
                case 4: {
                    stringBuffer.append("Verschmelzung erg\u00e4nzen");
                    break;
                }
                case 9: {
                    stringBuffer.append("Verschmelzung von Nutzungen");
                }
            }
            if (this.objects.size() > 0) {
                stringBuffer.append("(");
                stringBuffer.append(this.objects.size());
                stringBuffer.append(")");
            }
            stringBuffer.append(": ");
            if (this.nextUnionObject != null) {
                stringBuffer.append(this.nextUnionObject.getExceptionableName());
            }
        } else {
            stringBuffer.append(this.getExceptionableName());
        }
        return new Message(this, stringBuffer.toString(), stringBuffer.toString());
    }

    @Override
    public String getClassName() {
        return "Objektvereinigung";
    }

    @Override
    public String getObjectName() {
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer.toString();
    }

    @Override
    public DRectangle getBounds() {
        if (this.unionGeometry != null) {
            this.unionGeometry.initGeom();
            return this.unionGeometry.getBounds();
        }
        return new DRectangle();
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    @Override
    public boolean isViewable(IViewport iViewport) {
        return iViewport.intersects(this.getBounds());
    }

    @Override
    public DPoint getHashPoint() {
        if (this.unionGeometry != null) {
            if (this.unionGeometry.x == 0.0 || this.unionGeometry.y == 0.0) {
                this.unionGeometry.initGeom();
            }
            return new DPoint(this.unionGeometry.y, this.unionGeometry.x);
        }
        return new DPoint();
    }

    @Override
    public void drawObject(IGraphics iGraphics, boolean bl, boolean bl2) {
        if (this.nextUnionObject != null) {
            this.nextUnionObject.drawObject(iGraphics, bl, bl2);
        }
        if (this.unionGeometry != null) {
            this.unionGeometry.drawForeground(iGraphics, bl, bl2);
        }
    }

    @Override
    public void drawBackground(IGraphics iGraphics, boolean bl, boolean bl2) {
    }

    @Override
    public void drawForeground(IGraphics iGraphics, boolean bl, boolean bl2) {
    }

    @Override
    public void drawInscription(IGraphics iGraphics, boolean bl, boolean bl2) {
    }

    public String toString() {
        return this.getExceptionableName();
    }
}

