/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.DataContainerTable;
import de.geocalc.kafplot.GeoImageLocation;
import de.geocalc.kafplot.Identitaet;
import de.geocalc.kafplot.InputBedingung;
import de.geocalc.kafplot.InputLinieClip;
import de.geocalc.kafplot.InputLinieConnect;
import de.geocalc.kafplot.InputMessung;
import de.geocalc.kafplot.InputObject;
import de.geocalc.kafplot.InputObjectClip;
import de.geocalc.kafplot.InputObjectUnion;
import de.geocalc.kafplot.InputPunkt;
import de.geocalc.kafplot.KafPlotProperties;
import de.geocalc.kafplot.Punkt;
import de.geocalc.kafplot.PunktMove;
import de.geocalc.kafplot.PunktTable;
import de.geocalc.kafplot.Riss;

public class InputProperties {
    private static long nextFreeNumberStart = 0L;
    private static int newPunktSearchMode = PunktTable.SEARCH_NEXT_NUMBER + PunktTable.SEARCH_FREE_NUMBER + PunktTable.SEARCH_LOKAL_NUMBER;
    private static int oldPunktSearchMode = PunktTable.SEARCH_NEXT_NUMBER + PunktTable.SEARCH_RESERVED_NUMBER + PunktTable.SEARCH_LOKAL_NUMBER;
    public static final int INPUT_FANG_NUMMER = 901;
    public static final int INPUT_FANG_PUNKT = 902;
    public static final int INPUT_FANG_LINIE = 903;
    private static int messListe = 204;
    private static int bedListe = 602;
    private static int inputFangSwitch = 902;
    private static boolean isInputFree = true;
    private static final String EINGABE = "Eingabe";
    private static String messRissName = null;
    private static String bedRissName = null;

    public static boolean isInputFree() {
        return isInputFree;
    }

    public static void setInputFree(boolean bl) {
        isInputFree = bl;
    }

    public static int getInputFangSwitch() {
        return inputFangSwitch;
    }

    public static void setInputFangSwitch(int n) {
        inputFangSwitch = n;
    }

    public static void setRiss(int n, String string) {
        switch (n) {
            case 201: 
            case 202: 
            case 203: 
            case 204: 
            case 205: 
            case 206: {
                messListe = n;
                messRissName = string;
                break;
            }
            case 601: 
            case 602: {
                bedListe = n;
                bedRissName = string;
            }
        }
        Riss riss = InputProperties.getRiss();
    }

    public static String getBedingungRiss() {
        return bedRissName;
    }

    public static void setBedingungRiss(String string) {
        bedRissName = string;
    }

    public static int getBedingungListe() {
        return bedListe;
    }

    public static void setBedingungListe(int n) {
        bedListe = n;
    }

    public static String getMessungRiss() {
        return messRissName;
    }

    public static void setMessungRiss(String string) {
        messRissName = string;
    }

    public static int getMessungListe() {
        return messListe;
    }

    public static void setMessungListe(int n) {
        messListe = n;
    }

    public static long getNextFreeNumberStart() {
        return nextFreeNumberStart;
    }

    public static void setNextFreeNumberStart(long l) {
        nextFreeNumberStart = l;
    }

    public static long getNextFreeNumber() {
        return Long.parseLong(DataBase.P.searchNumber(Long.toString(nextFreeNumberStart), newPunktSearchMode).getNummer());
    }

    public static long getNextReservedNumber() {
        return Long.parseLong(DataBase.P.searchNumber(Long.toString(0L), oldPunktSearchMode).getNummer());
    }

    public static Punkt getOldPunkt(long l) {
        return (Punkt)DataBase.P.get(l);
    }

    public static Punkt getNewPunkt(long l) {
        Punkt punkt = (Punkt)DataBase.P.get(l);
        if (punkt == null) {
            punkt = new Punkt(l);
            DataBase.P.put(punkt);
            return punkt;
        }
        return null;
    }

    public static void removeObject(InputObject inputObject) throws ClassCastException {
        if (inputObject instanceof PunktMove) {
            DataBase.PM.remove((PunktMove)inputObject);
        } else if (inputObject instanceof Identitaet) {
            DataBase.PI.remove((PunktMove)inputObject);
        }
    }

    public static void saveObject(InputObject inputObject) throws ClassCastException {
        if (inputObject instanceof InputPunkt) {
            DataBase.P.put(((InputPunkt)inputObject).getPunkt());
            DataBase.isSaved = false;
        } else if (inputObject instanceof InputLinieClip) {
            InputLinieClip inputLinieClip = (InputLinieClip)inputObject;
            if (KafPlotProperties.isObjectCatch(1)) {
                inputLinieClip.save(DataBase.flurstuecke());
            }
            if (KafPlotProperties.isObjectCatch(8)) {
                inputLinieClip.save(DataBase.nutzungen());
            }
            if (KafPlotProperties.isObjectCatch(16)) {
                inputLinieClip.save(DataBase.bodenObjekte());
            }
            if (KafPlotProperties.isObjectCatch(2)) {
                inputLinieClip.save(DataBase.gebaeude());
            }
            if (KafPlotProperties.isObjectCatch(4)) {
                inputLinieClip.save(DataBase.topObjekte());
            }
            DataBase.isSaved = false;
        } else if (inputObject instanceof InputLinieConnect) {
            InputLinieConnect inputLinieConnect = (InputLinieConnect)inputObject;
            if (KafPlotProperties.isObjectCatch(1)) {
                inputLinieConnect.save(DataBase.flurstuecke());
            }
            if (KafPlotProperties.isObjectCatch(8)) {
                inputLinieConnect.save(DataBase.nutzungen());
            }
            if (KafPlotProperties.isObjectCatch(16)) {
                inputLinieConnect.save(DataBase.bodenObjekte());
            }
            if (KafPlotProperties.isObjectCatch(2)) {
                inputLinieConnect.save(DataBase.gebaeude());
            }
            if (KafPlotProperties.isObjectCatch(4)) {
                inputLinieConnect.save(DataBase.topObjekte());
            }
            DataBase.isSaved = false;
        } else if (inputObject instanceof InputObjectClip) {
            InputObjectClip inputObjectClip = (InputObjectClip)inputObject;
            inputObjectClip.save(null);
            DataBase.isSaved = false;
        } else if (inputObject instanceof InputObjectUnion) {
            InputObjectUnion inputObjectUnion = (InputObjectUnion)inputObject;
            inputObjectUnion.save(null);
            DataBase.isSaved = false;
        } else if (inputObject instanceof PunktMove) {
            DataBase.PM.put((PunktMove)inputObject);
            DataBase.isSaved = false;
        } else if (inputObject instanceof Identitaet) {
            DataBase.PI.put((Identitaet)inputObject);
            DataBase.isSaved = false;
        } else if (inputObject instanceof InputBedingung) {
            Riss riss = InputProperties.getRiss(bedRissName);
            ((InputBedingung)inputObject).save(riss);
            riss.initGeom();
            DataBase.isSaved = false;
        } else if (inputObject instanceof InputMessung) {
            Riss riss = InputProperties.getRiss(messRissName);
            ((InputMessung)inputObject).save(riss);
            riss.initGeom();
            DataBase.isSaved = false;
        } else if (inputObject instanceof GeoImageLocation) {
            GeoImageLocation geoImageLocation = (GeoImageLocation)inputObject;
            geoImageLocation.transform();
            geoImageLocation.getParent().setImageLocation(geoImageLocation);
            geoImageLocation.setStep(0);
            DataBase.sendUpdateEvent();
        } else {
            throw new ClassCastException(inputObject.getExceptionableName() + " konnte nicht gespeichert werden");
        }
    }

    public static int getListe() {
        switch (KafPlotProperties.getInputSwitch()) {
            case 811: 
            case 812: 
            case 871: 
            case 872: 
            case 873: 
            case 874: 
            case 875: 
            case 876: {
                return bedListe;
            }
            case 821: 
            case 822: 
            case 823: 
            case 824: 
            case 825: 
            case 826: {
                return messListe;
            }
        }
        return 0;
    }

    public static Riss getRiss() {
        switch (InputProperties.getListe()) {
            case 201: 
            case 202: 
            case 203: 
            case 204: 
            case 205: 
            case 206: {
                return InputProperties.getRiss(messRissName);
            }
            case 601: 
            case 602: {
                return InputProperties.getRiss(bedRissName);
            }
        }
        return null;
    }

    public static DataContainerTable getTable() {
        switch (InputProperties.getListe()) {
            case 201: {
                return DataBase.MG;
            }
            case 202: {
                return DataBase.MP;
            }
            case 203: {
                return DataBase.MM;
            }
            case 204: {
                return DataBase.MK;
            }
            case 205: {
                return DataBase.MV;
            }
            case 206: {
                return DataBase.ME;
            }
            case 601: {
                return DataBase.BH;
            }
            case 602: {
                return DataBase.BB;
            }
        }
        return null;
    }

    private static Riss createRiss(String string) {
        switch (InputProperties.getListe()) {
            case 201: {
                messRissName = string != null ? string : EINGABE;
                return new Riss(messRissName, 1, 202);
            }
            case 202: {
                messRissName = string != null ? string : EINGABE;
                return new Riss(messRissName, 1, 201);
            }
            case 203: {
                messRissName = string != null ? string : EINGABE;
                return new Riss(messRissName, 1, 203);
            }
            case 205: {
                messRissName = string != null ? string : EINGABE;
                return new Riss(messRissName, 1, 205);
            }
            case 206: {
                messRissName = string != null ? string : EINGABE;
                return new Riss(messRissName, 1, 206);
            }
            case 204: {
                messRissName = string != null ? string : EINGABE;
                return new Riss(messRissName, 2, 204);
            }
            case 601: {
                bedRissName = string != null ? string : EINGABE;
                return new Riss(bedRissName, 6, 601);
            }
            case 602: {
                bedRissName = string != null ? string : EINGABE;
                return new Riss(bedRissName, 6, 602);
            }
        }
        return null;
    }

    private static Riss getRiss(String string) {
        Riss riss = null;
        int n = InputProperties.getListe();
        DataContainerTable dataContainerTable = InputProperties.getTable();
        if (dataContainerTable == null) {
            return null;
        }
        if (string != null) {
            for (int i = dataContainerTable.size() - 1; i >= 0; --i) {
                riss = (Riss)dataContainerTable.elementAt(i);
                if (!string.equals(riss.getName())) continue;
                return riss;
            }
        }
        riss = InputProperties.createRiss(string);
        dataContainerTable.addElement(riss);
        return riss;
    }
}

