/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.IGraphics;
import de.geocalc.awt.IViewport;
import de.geocalc.geom.DPoint;
import de.geocalc.geom.DRectangle;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.Drawable;
import de.geocalc.kafplot.InputObject;
import de.geocalc.kafplot.InputProperties;
import de.geocalc.kafplot.KafPlotColor;
import de.geocalc.kafplot.Message;
import de.geocalc.kafplot.Messager;
import de.geocalc.kafplot.Punkt;
import de.geocalc.kafplot.Symbol;
import de.geocalc.lang.Exceptionable;
import de.geocalc.text.IFormat;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;

public class InputPunkt
extends InputObject
implements Exceptionable,
Messager,
Drawable {
    private Punkt p = new Punkt();

    public InputPunkt() {
        this.p.setInternalPs(2);
    }

    public Punkt getPunkt() {
        return this.p;
    }

    @Override
    public int dataMode() {
        return 1;
    }

    @Override
    public int steps() {
        return 4;
    }

    @Override
    public int need() {
        switch (this.step) {
            case 0: 
            case 1: {
                return InputProperties.isInputFree() ? 32 : 8;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 1;
            }
        }
        return 32;
    }

    @Override
    public boolean isReady() {
        return this.isFull();
    }

    @Override
    public boolean isAbortable() {
        return true;
    }

    @Override
    public Object getDefault() {
        switch (this.step) {
            case 0: {
                return new Double((int)((DataBase.ymin + DataBase.ymax) / 2.0) / 1000 * 1000);
            }
            case 1: {
                return new Double((int)((DataBase.xmin + DataBase.xmax) / 2.0) / 1000 * 1000);
            }
            case 2: {
                return new Long(InputProperties.getNextFreeNumber());
            }
            case 3: {
                return new Integer(0);
            }
        }
        return null;
    }

    public void setObject(Object object, int n) {
    }

    @Override
    public void setObject(Object object, boolean bl) {
        switch (this.step) {
            case 0: {
                if (object instanceof Number) {
                    this.p.y = (Double)object;
                } else if (object instanceof DPoint) {
                    this.p.y = ((DPoint)object).y;
                    this.p.x = ((DPoint)object).x;
                    if (bl) {
                        ++this.step;
                    }
                }
                if (!bl) break;
                ++this.step;
                break;
            }
            case 1: {
                if (object instanceof Number) {
                    this.p.x = (Double)object;
                } else if (object instanceof DPoint) {
                    this.p.y = ((DPoint)object).y;
                    this.p.x = ((DPoint)object).x;
                }
                if (!bl) break;
                ++this.step;
                break;
            }
            case 2: {
                if (!(object instanceof Number)) break;
                if (DataBase.P.get(((Number)object).longValue()) != null) {
                    return;
                }
                this.p.nr = ((Number)object).longValue();
                if (!bl) break;
                ++this.step;
                break;
            }
            case 3: {
                if (!(object instanceof Number)) break;
                int n = ((Number)object).intValue();
                if (n == 1 || n == 2) {
                    this.p.setPs(n);
                } else {
                    this.p.setPs(0);
                }
                if (!bl) break;
                ++this.step;
            }
        }
        this.lastIn = object;
    }

    @Override
    public Cursor getCurrentCursor() {
        return InputProperties.isInputFree() && this.step < 2 ? Cursor.getPredefinedCursor(1) : Cursor.getDefaultCursor();
    }

    @Override
    public Message getMessage() {
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.isReady()) {
            switch (this.step) {
                case 0: 
                case 1: {
                    if (InputProperties.isInputFree()) {
                        stringBuffer.append("Punkt: ");
                        if (this.p.y != 0.0) {
                            stringBuffer.append(IFormat.f_3.format(this.p.y));
                        }
                        stringBuffer.append(" ");
                        if (this.p.x == 0.0) break;
                        stringBuffer.append(IFormat.f_3.format(this.p.x));
                        break;
                    }
                    stringBuffer.append(this.step == 0 ? "Rechtswert: " : "Hochwert ");
                    break;
                }
                case 2: {
                    stringBuffer.append("Punktnummer: ");
                    break;
                }
                case 3: {
                    stringBuffer.append("Punktstatus: ");
                }
            }
        } else {
            stringBuffer.append(this.getExceptionableName());
        }
        return new Message(this, stringBuffer.toString(), stringBuffer.toString());
    }

    @Override
    public String getClassName() {
        return "Punkt";
    }

    @Override
    public String getObjectName() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.p.nr);
        if (this.p.y != 0.0) {
            stringBuffer.append(" ");
            stringBuffer.append(IFormat.f_3.format(this.p.y));
        }
        if (this.p.x != 0.0) {
            stringBuffer.append(" ");
            stringBuffer.append(IFormat.f_3.format(this.p.x));
        }
        return stringBuffer.toString();
    }

    @Override
    public DRectangle getBounds() {
        return new DRectangle(this.p.y, this.p.x, 0.0, 0.0);
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    @Override
    public boolean isViewable(IViewport iViewport) {
        return iViewport.intersects(this.getBounds());
    }

    @Override
    public DPoint getHashPoint() {
        return this.p;
    }

    @Override
    public void drawObject(IGraphics iGraphics, boolean bl, boolean bl2) {
        this.drawForeground(iGraphics, bl, bl2);
    }

    @Override
    public void drawBackground(IGraphics iGraphics, boolean bl, boolean bl2) {
    }

    @Override
    public void drawForeground(IGraphics iGraphics, boolean bl, boolean bl2) {
        if (this.isViewable(iGraphics.getViewport())) {
            Graphics graphics = iGraphics.getGraphics();
            Symbol symbol = Symbol.UNDEF;
            Symbol.setForeground(KafPlotColor.OFFLINE);
            Symbol.setBackground(KafPlotColor.BACKGROUND);
            if (bl2) {
                iGraphics.setXORMode();
            } else {
                iGraphics.setPaintMode();
            }
            Point point = iGraphics.getGraphicPoint(this.p, new Point());
            symbol.draw(graphics, point.x, point.y, 0.0, 0.2, (byte)0);
        }
    }

    @Override
    public void drawInscription(IGraphics iGraphics, boolean bl, boolean bl2) {
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("InputPunkt: ");
        stringBuffer.append(this.getObjectName());
        return stringBuffer.toString();
    }
}

