/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.FlowText;
import de.geocalc.awt.IBorder;
import de.geocalc.awt.IFrame;
import de.geocalc.awt.ILabel;
import de.geocalc.awt.IList;
import de.geocalc.awt.IOptionDialog;
import de.geocalc.awt.IPanel;
import de.geocalc.awt.ITextField;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.DataContainerTable;
import de.geocalc.kafplot.InputProperties;
import de.geocalc.kafplot.KafPlotNames;
import de.geocalc.kafplot.KafPlotProperties;
import de.geocalc.kafplot.Riss;
import de.geocalc.text.IFormat;
import java.awt.Button;
import java.awt.Choice;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;

public class InputRissDialog
extends IOptionDialog
implements ActionListener,
ItemListener {
    private static final String INSERT = "Einf\u00fcgen";
    private static final String RENAME = "Umbenennen";
    private Choice listeChoice;
    private IList rissList;
    private ITextField rissTextField;
    private ITextField freeNumberTextField;

    public InputRissDialog(IFrame iFrame, String string) {
        super(iFrame, string, 5);
        this.setModal(true);
    }

    @Override
    protected IPanel layoutDialogPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        IPanel iPanel = new IPanel(gridBagLayout);
        iPanel.setBorder(new IBorder(1));
        ILabel iLabel = new ILabel("Liste:");
        iPanel.add(iLabel);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(iLabel, gridBagConstraints);
        this.listeChoice = new Choice();
        iPanel.add(this.listeChoice);
        this.listeChoice.addItemListener(this);
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(this.listeChoice, gridBagConstraints);
        iLabel = new ILabel("Risse:");
        iPanel.add(iLabel);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(iLabel, gridBagConstraints);
        this.rissList = new IList(5);
        iPanel.add(this.rissList);
        this.rissList.addItemListener(this);
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.rissList, gridBagConstraints);
        iLabel = new ILabel("Auswahl:");
        iPanel.add(iLabel);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(iLabel, gridBagConstraints);
        this.rissTextField = new ITextField(10);
        iPanel.add(this.rissTextField);
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(this.rissTextField, gridBagConstraints);
        Button button = new Button(INSERT);
        iPanel.add(button);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        button.addActionListener(this);
        gridBagLayout.setConstraints(button, gridBagConstraints);
        button = new Button(RENAME);
        iPanel.add(button);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        button.addActionListener(this);
        gridBagLayout.setConstraints(button, gridBagConstraints);
        FlowText flowText = new FlowText("Start freie\nPunktnummer:", true);
        iPanel.add(flowText);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagLayout.setConstraints(flowText, gridBagConstraints);
        this.freeNumberTextField = new ITextField(10);
        iPanel.add(this.freeNumberTextField);
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagLayout.setConstraints(this.freeNumberTextField, gridBagConstraints);
        return iPanel;
    }

    private void setListLayout() {
        this.rissList.removeAll();
        int n = KafPlotNames.getKey(this.listeChoice.getSelectedItem());
        if (n >= 0) {
            this.setListLayout(DataBase.getDataContainer(n));
            Riss riss = InputProperties.getRiss();
            if (riss == null) {
                this.rissTextField.setText(riss.getName());
            }
            int n2 = -1;
            if (InputProperties.getListe() == n && riss != null && (n2 = this.rissList.indexOf(riss.getName())) >= 0) {
                this.rissList.select(n2);
                this.rissList.makeVisible(n2);
                this.rissTextField.setText(riss.getName());
            } else {
                n2 = this.rissList.countItems() - 1;
                if (n2 >= 0) {
                    this.rissList.select(n2);
                    this.rissList.makeVisible(n2);
                    this.rissTextField.setText(this.rissList.getItem(n2));
                }
            }
        }
    }

    private void setListLayout(DataContainerTable dataContainerTable) {
        if (dataContainerTable == null) {
            return;
        }
        Enumeration enumeration = dataContainerTable.elements();
        while (enumeration.hasMoreElements()) {
            String string = ((Riss)enumeration.nextElement()).getName();
            this.rissList.addItem(string);
        }
    }

    @Override
    protected void setOptions() {
        Object var1_1 = null;
        int n = KafPlotNames.getKey(this.listeChoice.getSelectedItem());
        int n2 = this.rissList.getSelectedIndex();
        try {
            if (n >= 0 && n2 >= 0) {
                InputProperties.setRiss(n, ((Riss)DataBase.getDataContainer(n).elementAt(n2)).getName());
            }
            InputProperties.setNextFreeNumberStart(Long.parseLong(IFormat.getDigits(this.freeNumberTextField.getText())));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void setVisible(boolean bl) {
        this.listeChoice.removeAll();
        Object var2_2 = null;
        boolean bl2 = false;
        switch (KafPlotProperties.getInputSwitch()) {
            case 811: 
            case 812: 
            case 871: 
            case 872: 
            case 873: 
            case 874: 
            case 875: 
            case 876: {
                this.listeChoice.add("Homogenisierung");
                this.listeChoice.add("Bedingungen");
                this.listeChoice.select(KafPlotNames.getName(InputProperties.getBedingungListe()));
                break;
            }
            case 821: 
            case 822: 
            case 823: 
            case 824: 
            case 825: 
            case 826: {
                this.listeChoice.add("Polare Messungen");
                this.listeChoice.add("GPS-Basislinien");
                this.listeChoice.add("Messband-Messungen");
                this.listeChoice.add("KatasterNachweis");
                this.listeChoice.add("Vorgaben");
                this.listeChoice.add("Einrechnung");
                this.listeChoice.select(KafPlotNames.getName(InputProperties.getMessungListe()));
            }
        }
        this.setListLayout();
        this.freeNumberTextField.setText(Long.toString(InputProperties.getNextFreeNumberStart()));
        super.setVisible(bl);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(INSERT)) {
            String string2 = this.rissTextField.getText();
            if (string2 != null && string2.trim().length() > 0) {
                InputProperties.setRiss(KafPlotNames.getKey(this.listeChoice.getSelectedItem()), string2);
                this.rissList.addItem(InputProperties.getRiss().getName());
                this.rissList.select(this.rissList.getItemCount() - 1);
            }
        } else if (string.equals(RENAME)) {
            Riss riss = null;
            int n = this.rissList.getSelectedIndex();
            String string3 = this.rissTextField.getText();
            if (n >= 0 && string3 != null && string3.trim().length() > 0) {
                InputProperties.setRiss(KafPlotNames.getKey(this.listeChoice.getSelectedItem()), this.rissList.getSelectedItem());
                riss = InputProperties.getRiss();
                if (riss != null) {
                    riss.setName(string3);
                }
                this.rissList.replaceItem(string3, n);
                this.rissList.select(n);
            }
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.rissList) {
            this.rissTextField.setText(this.rissList.getSelectedItem());
        } else if (object == this.listeChoice) {
            this.setListLayout();
        }
        super.itemStateChanged(itemEvent);
    }
}

