/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.IBorder;
import de.geocalc.awt.IDialog;
import de.geocalc.awt.IFrame;
import de.geocalc.awt.INumTextField;
import de.geocalc.awt.IPanel;
import de.geocalc.geom.DPoint;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.Punkt;
import de.geocalc.kafplot.PunktMove;
import de.geocalc.kafplot.TrafoPunkt;
import de.geocalc.kafplot.TrafoSystem;
import de.geocalc.text.IFormat;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Choice;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;

public class InsertTrafoDialog
extends IDialog
implements ActionListener {
    private static final String OK_COMMAND = "OK";
    private static final String ABORT_COMMAND = "Abbrechen";
    Punkt p = null;
    TrafoPunkt tp = null;
    TrafoSystem system = null;
    private Label nrLabel;
    private INumTextField yTextField;
    private INumTextField xTextField;
    private Choice systemChoice;

    public InsertTrafoDialog(IFrame iFrame, String string) {
        super(iFrame, string, true);
        this.setLayout(new BorderLayout());
        this.add("Center", this.createInputPanel());
        this.add("South", this.createButtonPanel());
        this.pack();
        this.setLocationOfParent(iFrame, -11);
        this.setResizable(false);
    }

    private Panel createInputPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        IPanel iPanel = new IPanel(gridBagLayout);
        iPanel.setBorder(new IBorder(1));
        Label label = new Label("Punkt:");
        iPanel.add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.nrLabel = new Label("");
        iPanel.add(this.nrLabel);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 4;
        gridBagLayout.setConstraints(this.nrLabel, gridBagConstraints);
        label = new Label("y:");
        iPanel.add(label);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.yTextField = new INumTextField(12);
        iPanel.add(this.yTextField);
        this.yTextField.addActionListener(this);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(this.yTextField, gridBagConstraints);
        label = new Label("x:");
        iPanel.add(label);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.xTextField = new INumTextField(12);
        iPanel.add(this.xTextField);
        this.xTextField.addActionListener(this);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(this.xTextField, gridBagConstraints);
        label = new Label("System:");
        iPanel.add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.systemChoice = new Choice();
        iPanel.add(this.systemChoice);
        Enumeration enumeration = DataBase.T.elements();
        while (enumeration.hasMoreElements()) {
            this.systemChoice.addItem(((TrafoSystem)enumeration.nextElement()).getName());
        }
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 4;
        gridBagLayout.setConstraints(this.systemChoice, gridBagConstraints);
        return iPanel;
    }

    private Panel createButtonPanel() {
        Panel panel = new Panel(new FlowLayout(1));
        Button button = new Button(OK_COMMAND);
        button.addActionListener(this);
        panel.add(button);
        Button button2 = new Button(ABORT_COMMAND);
        button2.addActionListener(this);
        panel.add(button2);
        return panel;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (actionEvent.getActionCommand().equals(OK_COMMAND) || object instanceof INumTextField) {
            this.doStandardAction();
        } else {
            this.doAbortAction();
        }
    }

    public void setPunkt(Punkt punkt) {
        this.p = punkt;
        this.tp = null;
        if (punkt != null) {
            DPoint dPoint = new DPoint(punkt.getOriginal().y, punkt.getOriginal().x);
            PunktMove punktMove = (PunktMove)DataBase.PM.get(punkt.nr);
            if (punktMove != null) {
                dPoint.y += (double)punktMove.getMoveY();
                dPoint.x += (double)punktMove.getMoveX();
            }
            this.nrLabel.setText(Long.toString(punkt.nr));
            this.yTextField.setText(IFormat.f_3.format(dPoint.y));
            this.xTextField.setText(IFormat.f_3.format(dPoint.x));
        } else {
            this.nrLabel.setText(" ");
            this.yTextField.setText(" ");
            this.xTextField.setText(" ");
        }
    }

    public void setSystem(TrafoSystem trafoSystem) {
        this.system = trafoSystem;
        if (this.systemChoice != null && trafoSystem != null) {
            this.systemChoice.select(trafoSystem.getName());
        }
    }

    public TrafoPunkt getTrafoPunkt() {
        return this.tp;
    }

    @Override
    protected void doStandardAction() {
        Object var1_1 = null;
        String string = this.systemChoice.getSelectedItem();
        Enumeration enumeration = DataBase.T.elements();
        while (enumeration.hasMoreElements()) {
            TrafoSystem trafoSystem = (TrafoSystem)enumeration.nextElement();
            if (!string.equals(trafoSystem.getName()) || trafoSystem.contains(this.p)) continue;
            this.tp = new TrafoPunkt(this.p, new Double(this.yTextField.getText()), new Double(this.xTextField.getText()));
            if (trafoSystem.size() > 0) {
                this.tp.setGewichte(((TrafoPunkt)trafoSystem.elementAt(0)).getGewichte());
            }
            trafoSystem.addElement(this.tp);
            break;
        }
        this.endDialog();
    }

    @Override
    protected void doAbortAction() {
        this.endDialog();
    }
}

