/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.ErrorDialog;
import de.geocalc.awt.ExceptionList;
import de.geocalc.awt.IBorder;
import de.geocalc.awt.IException;
import de.geocalc.awt.IFrame;
import de.geocalc.awt.IPanel;
import de.geocalc.io.GeoFile;
import de.geocalc.kafplot.KafDatProperties;
import de.geocalc.kafplot.KafPlotVersion;
import de.geocalc.kafplot.PropertyLoader;
import de.geocalc.kafplot.PunktNummer;
import de.geocalc.kafplot.PunktStatus;
import de.geocalc.kafplot.RissMerger;
import de.geocalc.kafplot.io.DatCreator;
import de.geocalc.kafplot.io.IGpsReader;
import de.geocalc.kafplot.io.IPolarReader;
import de.geocalc.kafplot.io.dat.KafkaIOProperties;
import de.geocalc.kafplot.io.dat.SteuerDaten;
import de.geocalc.text.GeoNumberFormat;
import de.geocalc.text.IFormat;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.CardLayout;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.Label;
import java.awt.SystemColor;
import java.awt.TextField;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.UIManager;

class KafDat
extends IFrame
implements ActionListener,
ItemListener,
TextListener,
DropTargetListener {
    public static final String TITLE = "KafDat";
    public static final String VERSION = "2.0.000";
    private static final String ARG_STEUER_DATEN = "/st";
    private static final String ARG_PUNKT_DATEN = "/bk";
    private static final String ARG_POLAR_DATEN = "/bp";
    private static final String ARG_ORTHO_DATEN = "/bo";
    private static final String ARG_FLUCHT_DATEN = "/bf";
    private static final String ARG_MESSBAND_DATEN = "/bm";
    private static final String ARG_EDM_DATEN = "/be";
    private static final String ARG_BOGEN_DATEN = "/bs";
    private static final String ARG_DIGIT_DATEN = "/bt";
    private static final String ARG_BEDINGUNG_DATEN = "/bb";
    private static final String ARG_LONG_FORMAT = "/l";
    private static final String ARG_FLST_DATEN = "/zf";
    private static final String ARG_BEM_DATEN = "/zb";
    private static final String ARG_NUMBEZ_DATEN = "/zn";
    private static final String ARG_IDENT_DATEN = "/zi";
    private static final String ARG_UMNUM_DATEN = "/zu";
    private static final String ARG_GEW_ANSCHLS = "/ga";
    private static final String ARG_LAGEGENAUIGKEIT = "/pl";
    private static final String ARG_PUNKTSTATUS = "/ps";
    private static final String ARG_MESSGENAUIGKEIT = "/mg";
    private static final String ARG_3D = "/3d";
    private static final String ARG_HELP_1 = "/?";
    private static final String ARG_HELP_2 = "/h";
    private static final String DAT_FILE_COMMAND = "dat_file";
    private static final String RISS_DIR_COMMAND = "riss_dir";
    private static final String IN_FILE_COMMAND = "in_file";
    private static final String ALLBOXES_COMMAND = "Alles";
    private static final String ABORT_COMMAND = "Beenden";
    private static final String DO_COMMAND = "Ausf\u00fchren";
    private static final String HELP_COMMAND = "Hilfe";
    private static final String VOID_PANEL = "void";
    private static final String KOO_CONTROL_PANEL = "kooc";
    private static final String POLAR_CONTROL_PANEL = "polc";
    private static final String GPS_CONTROL_PANEL = "gpsc";
    private static final String MODEL_VOID = " ";
    private static final String MODEL_ALKIS = "ALKIS";
    private static final String MODEL_ALK = "ALK";
    private static final String PUNKT_MODE_EINGABE = "als Punkteingabe";
    private static final String PUNKT_MODE_TRAFO = "als Transformation";
    private static final String PUNKT_MODE_MESSUNG = "als Koordinatenmessung";
    private Button datFileButton;
    private Button rissDirButton;
    private Button inFileButton;
    private Button allBoxesButton;
    private Button doButton;
    private Button abortButton;
    private TextField datFileTextField;
    private TextField rissDirTextField;
    private TextField inFileTextField;
    private TextField punktLageGenauigkeitTextField;
    private TextField sDiffTextField;
    private TextField rDiffTextField;
    private TextField gpsGenauigkeitTextField;
    private Choice steuerDatenChoice;
    private Choice modelChoice;
    private Choice punktStatusChoice;
    private Choice punktNummerChoice;
    private Choice punktModeChoice;
    private Checkbox rissRenameCheckbox;
    private Checkbox steuerDatenCheckbox;
    private Checkbox punktDatenCheckbox;
    private Checkbox gpsDatenCheckbox;
    private Checkbox polarDatenCheckbox;
    private Checkbox fluchtDatenCheckbox;
    private Checkbox messbandDatenCheckbox;
    private Checkbox edmDatenCheckbox;
    private Checkbox orthoDatenCheckbox;
    private Checkbox bogenDatenCheckbox;
    private Checkbox hoehenDatenCheckbox;
    private Checkbox digitDatenCheckbox;
    private Checkbox bedingungDatenCheckbox;
    private Checkbox flstDatenCheckbox;
    private Checkbox gebDatenCheckbox;
    private Checkbox topDatenCheckbox;
    private Checkbox bemerkungDatenCheckbox;
    private Checkbox numbezDatenCheckbox;
    private Checkbox identDatenCheckbox;
    private Checkbox umnumDatenCheckbox;
    private Checkbox longFormatCheckbox;
    private Checkbox punktHoeheCheckbox;
    private Checkbox isMittelCheckbox;
    private Checkbox isReduzierenCheckbox;
    private Checkbox withLageCheckbox;
    private Checkbox withHoeheCheckbox;
    private Checkbox withHoeheGpsCheckbox;
    private Label punktStatusLabel;
    private Label punktNummerLabel;
    private Label punktLageGenauigkeitLabel;
    private Label punktHoeheLabel;
    private Label sDiffLabel;
    private Label rDiffLabel;
    private IPanel inFileControlPanel;
    private CardLayout card;
    private int inFileGroup;
    private DatCreator datParser;
    private RissMerger rissMerger;
    private ExceptionList exceptions;
    private File inDir;
    private boolean allBoxes;
    int model;
    private DropTarget dropTarget;
    private String HELP;

    public static void main(String[] stringArray) {
        KafDat kafDat;
        if (stringArray.length == 0) {
            String[] stringArray2 = new String[]{".NO_ARGS"};
            kafDat = new KafDat(stringArray2);
        } else {
            kafDat = new KafDat(stringArray);
        }
        kafDat.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
    }

    public KafDat(String[] stringArray) {
        Object object;
        Exception exception;
        block8: {
            this.card = new CardLayout(0, 0);
            this.inFileGroup = -1;
            this.datParser = null;
            this.rissMerger = null;
            this.exceptions = new ExceptionList();
            this.inDir = new File(".");
            this.allBoxes = false;
            this.model = 2;
            this.dropTarget = null;
            this.HELP = "KafDat: Umsetzen von Punkt und Messdaten nach Kafka\n2.0.000 (Java) \u00b8 Joerg Schroeder                    \nAufruf: KAF <Projekt> [Quelle] [/optionen]             \n   <projekt>  Projektname     [quelle]   Quelldatei    \n";
            try {
                UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
            }
            catch (Exception exception2) {
                // empty catch block
            }
            this.datParser = new DatCreator();
            this.rissMerger = new RissMerger();
            this.loadIconSet(TITLE);
            this.setTitle(TITLE);
            this.setResizable(false);
            this.setBackground(SystemColor.control);
            exception = null;
            if (!stringArray[0].startsWith(".NO_ARGS")) {
                try {
                    this.parseArgs(stringArray);
                }
                catch (Exception exception3) {
                    exception = exception3;
                }
            }
            try {
                object = new PropertyLoader();
                ((PropertyLoader)object).loadProperties("KafDat.properties");
                ((PropertyLoader)object).loadProperties("transfer.properties");
                ((PropertyLoader)object).loadProperties("kafplot.licence");
            }
            catch (IOException iOException) {
                if (exception != null) break block8;
                exception = iOException;
            }
        }
        object = new IPanel(new BorderLayout());
        IPanel iPanel = new IPanel(new BorderLayout());
        iPanel.setBorder(new IBorder(1));
        iPanel.add("North", this.createDatFilePanel());
        iPanel.add("South", this.createBeispielDatenPanel());
        ((Container)object).add("North", iPanel);
        IPanel iPanel2 = new IPanel(new BorderLayout());
        iPanel2.setBorder(new IBorder(1));
        iPanel2.add("North", this.createInFilePanel());
        this.inFileControlPanel = this.createInFileControlPanel();
        iPanel2.add("South", this.inFileControlPanel);
        ((Container)object).add("Center", iPanel2);
        IPanel iPanel3 = new IPanel(new FlowLayout(2));
        this.doButton = new Button(DO_COMMAND);
        iPanel3.add(this.doButton);
        this.doButton.addActionListener(this);
        this.abortButton = new Button(ABORT_COMMAND);
        iPanel3.add(this.abortButton);
        this.abortButton.addActionListener(this);
        ((Container)object).add("South", iPanel3);
        this.add((Component)object);
        this.pack();
        this.setInFileView(null);
        this.setVisible(true);
        this.setDialogWindow(this.getBounds());
        if (exception != null) {
            ErrorDialog errorDialog = new ErrorDialog((IFrame)this, exception);
            errorDialog.setVisible(true);
        }
        this.dropTarget = new DropTarget(this, 1, this, true);
        this.showProperties();
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        try {
            Transferable transferable = dropTargetDropEvent.getTransferable();
            DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
            for (int i = 0; i < dataFlavorArray.length; ++i) {
                if (dataFlavorArray[i].isFlavorJavaFileListType()) {
                    dropTargetDropEvent.acceptDrop(dropTargetDropEvent.getDropAction());
                    Object[] objectArray = ((List)transferable.getTransferData(dataFlavorArray[i])).toArray();
                    for (int j = 0; j < objectArray.length; ++j) {
                        File file;
                        if (!(objectArray[j] instanceof File) || !(file = (File)objectArray[j]).isFile()) continue;
                        if (file.getName().toLowerCase().endsWith(".dat")) {
                            this.datParser.setDatFile(file);
                            this.datFileTextField.setText(file.getAbsolutePath());
                            if (!file.exists()) {
                                this.steuerDatenCheckbox.setState(true);
                                this.steuerDatenCheckbox.setEnabled(false);
                                continue;
                            }
                            this.steuerDatenCheckbox.setEnabled(true);
                            continue;
                        }
                        this.datParser.setInFile(file);
                        this.inFileTextField.setText(file.getAbsolutePath());
                        this.setInFileView(file);
                    }
                    continue;
                }
                System.out.println("Alternatives Drop-Flavor: " + String.valueOf(dataFlavorArray[i]));
            }
            dropTargetDropEvent.dropComplete(true);
            return;
        }
        catch (Throwable throwable) {
            dropTargetDropEvent.rejectDrop();
            return;
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        try {
            Object object = actionEvent.getSource();
            if (object instanceof TextField) {
                if (actionEvent.getSource().equals(this.datFileTextField)) {
                    File file = new File(this.datFileTextField.getText());
                    this.datParser.setDatFile(file);
                    if (!file.exists()) {
                        this.steuerDatenCheckbox.setState(true);
                        this.steuerDatenCheckbox.setEnabled(false);
                    } else {
                        this.steuerDatenCheckbox.setEnabled(true);
                    }
                    this.steuerDatenChoice.setEnabled(this.steuerDatenCheckbox.getState());
                    this.showProperties();
                } else if (actionEvent.getSource().equals(this.inFileTextField)) {
                    File file = new File(this.inFileTextField.getText());
                    this.datParser.setInFile(file);
                    this.setInFileView(file);
                }
            } else if (object instanceof Button) {
                String string = actionEvent.getActionCommand();
                if (string.equals(IN_FILE_COMMAND)) {
                    JFileChooser jFileChooser = new JFileChooser();
                    jFileChooser.setSelectedFile(this.datParser.getInFile());
                    this.inDir = GeoFile.getDirectory(this.datParser.getInFile());
                    jFileChooser.setCurrentDirectory(this.inDir);
                    jFileChooser.setDialogTitle("Eingabedaten");
                    jFileChooser.setDialogType(0);
                    if (jFileChooser.showOpenDialog(this) == 0) {
                        File file = jFileChooser.getSelectedFile();
                        this.datParser.setInFile(file);
                        this.inFileTextField.setText(file.getAbsolutePath());
                        this.setInFileView(file);
                    }
                    this.showProperties();
                } else if (string.equals(DAT_FILE_COMMAND)) {
                    JFileChooser jFileChooser = new JFileChooser();
                    if (this.datParser.getDatFile() != null) {
                        jFileChooser.setSelectedFile(this.datParser.getDatFile());
                        jFileChooser.setCurrentDirectory(this.datParser.getDatFile());
                    } else {
                        jFileChooser.setCurrentDirectory(new File("."));
                    }
                    jFileChooser.setDialogTitle("Auftragsdatei");
                    jFileChooser.setFileFilter(GeoFile.fileFilter(501));
                    jFileChooser.setDialogType(0);
                    if (jFileChooser.showOpenDialog(this) == 0) {
                        File file = jFileChooser.getSelectedFile();
                        this.datParser.setDatFile(file);
                        this.datFileTextField.setText(file.getAbsolutePath());
                        if (!file.exists()) {
                            this.steuerDatenCheckbox.setState(true);
                            this.steuerDatenCheckbox.setEnabled(false);
                        } else {
                            this.steuerDatenCheckbox.setEnabled(true);
                        }
                    }
                    this.showProperties();
                } else if (string.equals(RISS_DIR_COMMAND)) {
                    JFileChooser jFileChooser = new JFileChooser();
                    jFileChooser.setCurrentDirectory(new File("."));
                    jFileChooser.setDialogTitle("Rissverzeichnis");
                    jFileChooser.setDialogType(0);
                    jFileChooser.setFileSelectionMode(1);
                    if (jFileChooser.showOpenDialog(this) == 0) {
                        this.rissMerger.setDirectory(jFileChooser.getSelectedFile());
                    }
                    this.showProperties();
                } else if (string.equals(ALLBOXES_COMMAND)) {
                    this.allBoxes = !this.allBoxes;
                    this.setBoxes(this.allBoxes);
                } else if (string.equals(DO_COMMAND)) {
                    this.doButton.setEnabled(false);
                    this.abortButton.setEnabled(false);
                    this.parseDatFile();
                    this.steuerDatenCheckbox.setState(false);
                    this.punktDatenCheckbox.setState(false);
                    this.gpsDatenCheckbox.setState(false);
                    this.polarDatenCheckbox.setState(false);
                    this.fluchtDatenCheckbox.setState(false);
                    this.messbandDatenCheckbox.setState(false);
                    this.edmDatenCheckbox.setState(false);
                    this.orthoDatenCheckbox.setState(false);
                    this.bogenDatenCheckbox.setState(false);
                    this.digitDatenCheckbox.setState(false);
                    this.bedingungDatenCheckbox.setState(false);
                    this.hoehenDatenCheckbox.setState(false);
                    this.flstDatenCheckbox.setState(false);
                    this.gebDatenCheckbox.setState(false);
                    this.topDatenCheckbox.setState(false);
                    this.bemerkungDatenCheckbox.setState(false);
                    this.numbezDatenCheckbox.setState(false);
                    this.identDatenCheckbox.setState(false);
                    this.umnumDatenCheckbox.setState(false);
                } else if (string.equals(ABORT_COMMAND)) {
                    System.exit(0);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (!this.exceptions.isEmpty()) {
                ErrorDialog errorDialog = new ErrorDialog((IFrame)this, "Es sind Fehler beim Einlesen der Daten aufgetreten, \ndie fehlerhafte Daten wurden ignoriert.", this.exceptions);
                errorDialog.setVisible(true);
                this.exceptions.removeExceptions();
            }
            ErrorDialog errorDialog = new ErrorDialog((IFrame)this, exception);
            errorDialog.setVisible(true);
        }
        this.doButton.setEnabled(true);
        this.abortButton.setEnabled(true);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        ItemSelectable itemSelectable = itemEvent.getItemSelectable();
        if (itemSelectable instanceof Checkbox) {
            Checkbox checkbox = (Checkbox)itemSelectable;
            if (checkbox.equals(this.steuerDatenCheckbox)) {
                this.steuerDatenChoice.setEnabled(this.steuerDatenCheckbox.getState());
            } else if (checkbox.equals(this.punktHoeheCheckbox)) {
                if (this.punktHoeheCheckbox.getState()) {
                    this.punktModeChoice.select(PUNKT_MODE_EINGABE);
                    this.punktModeChoice.setEnabled(false);
                } else {
                    this.punktModeChoice.setEnabled(true);
                }
            } else if (checkbox.equals(this.isMittelCheckbox)) {
                this.sDiffTextField.setEnabled(this.isMittelCheckbox.getState());
                this.sDiffTextField.setEditable(this.isMittelCheckbox.getState());
                this.rDiffTextField.setEnabled(this.isMittelCheckbox.getState());
                this.rDiffTextField.setEditable(this.isMittelCheckbox.getState());
            } else if (checkbox.equals(this.rissRenameCheckbox)) {
                this.rissMerger.renameFiles(this.rissRenameCheckbox.getState());
            }
        } else if (itemSelectable instanceof Choice) {
            if (itemSelectable.equals(this.steuerDatenChoice)) {
                this.steuerDatenCheckbox.setState(true);
            } else if (itemSelectable.equals(this.punktModeChoice)) {
                if (this.punktModeChoice.getSelectedItem().equals(PUNKT_MODE_EINGABE)) {
                    this.punktStatusChoice.setEnabled(true);
                    this.punktHoeheLabel.setEnabled(true);
                    this.punktHoeheCheckbox.setEnabled(true);
                } else {
                    this.punktStatusChoice.setEnabled(false);
                    this.punktHoeheLabel.setEnabled(false);
                    this.punktHoeheCheckbox.setEnabled(false);
                    this.punktHoeheCheckbox.setState(false);
                }
            }
        }
    }

    @Override
    public void textValueChanged(TextEvent textEvent) {
        this.showProperties();
    }

    public void parseDatFile() throws Exception {
        Object object;
        Vector vector = this.rissMerger.getRisse();
        this.datParser.setRisse(vector);
        if (this.datFileTextField.getText().length() <= 0) {
            throw new IException("Bitte zu erzeugende Kafka-Datei angeben");
        }
        this.datParser.setDatFile(new File(this.datFileTextField.getText()));
        if (this.inFileTextField.getText().length() > 0) {
            this.datParser.setInFile(new File(this.inFileTextField.getText()));
        } else {
            this.datParser.setInFile(null);
        }
        this.datParser.steuerDaten = this.steuerDatenCheckbox.getState();
        if (this.datParser.steuerDaten) {
            object = KafDatProperties.getSteuerDaten();
            for (int i = 0; i < ((Vector)object).size(); ++i) {
                SteuerDaten steuerDaten = (SteuerDaten)((Vector)object).elementAt(i);
                if (!steuerDaten.getName().equals(this.steuerDatenChoice.getSelectedItem())) continue;
                this.datParser.setSteuerDaten(steuerDaten);
                break;
            }
        }
        if (this.modelChoice.isEnabled()) {
            object = this.modelChoice.getSelectedItem();
            KafkaIOProperties.datVersion = ((String)object).equals(MODEL_ALK) ? 2 : 3;
        }
        this.datParser.punktDaten = this.punktDatenCheckbox.getState();
        this.datParser.gpsDaten = this.gpsDatenCheckbox.getState();
        this.datParser.polarDaten = this.polarDatenCheckbox.getState();
        this.datParser.fluchtDaten = this.fluchtDatenCheckbox.getState();
        this.datParser.messbandDaten = this.messbandDatenCheckbox.getState();
        this.datParser.edmDaten = this.edmDatenCheckbox.getState();
        this.datParser.orthoDaten = this.orthoDatenCheckbox.getState();
        this.datParser.bogenDaten = this.bogenDatenCheckbox.getState();
        this.datParser.digitDaten = this.digitDatenCheckbox.getState();
        this.datParser.bedingungDaten = this.bedingungDatenCheckbox.getState();
        this.datParser.hoehenDaten = this.hoehenDatenCheckbox.getState();
        this.datParser.flstDaten = this.flstDatenCheckbox.getState();
        this.datParser.gebDaten = this.gebDatenCheckbox.getState();
        this.datParser.topDaten = this.topDatenCheckbox.getState();
        this.datParser.bemerkungDaten = this.bemerkungDatenCheckbox.getState();
        this.datParser.numbezDaten = this.numbezDatenCheckbox.getState();
        this.datParser.identDaten = this.identDatenCheckbox.getState();
        this.datParser.umnumDaten = this.umnumDatenCheckbox.getState();
        this.datParser.longFormat = this.longFormatCheckbox.getState();
        if (this.inFileGroup == 100) {
            this.datParser.ps = PunktStatus.getStatus(this.punktStatusChoice.getSelectedItem());
            this.datParser.pl = PunktNummer.getLength(this.punktNummerChoice.getSelectedItem());
            object = this.punktModeChoice.getSelectedItem();
            this.datParser.punktMode = ((String)object).equals(PUNKT_MODE_TRAFO) ? 2 : (((String)object).equals(PUNKT_MODE_MESSUNG) ? 1 : 0);
            this.datParser.m3D = this.punktHoeheCheckbox.getState();
            try {
                Double d = new Double(this.punktLageGenauigkeitTextField.getText().trim());
                this.datParser.plg = d;
            }
            catch (NumberFormatException numberFormatException) {
                throw new IException("Ung\u00fcltiger Wert im Feld Lagegenauigkeit");
            }
        }
        if (this.inFileGroup == 200) {
            IPolarReader.setMitteln(this.isMittelCheckbox.getState());
            IPolarReader.setReduzieren(this.isReduzierenCheckbox.getState());
            this.datParser.m2d = this.withLageCheckbox != null ? this.withLageCheckbox.getState() : true;
            this.datParser.m3D = this.withHoeheCheckbox != null ? this.withHoeheCheckbox.getState() : false;
            try {
                IPolarReader.setStreckeDiff(new Double(this.sDiffTextField.getText().trim()));
            }
            catch (NumberFormatException numberFormatException) {
                throw new IException("Ung\u00fcltiger Wert im Feld Streckendifferenz");
            }
            try {
                IPolarReader.setRichtungDiff(new Double(this.rDiffTextField.getText().trim()));
            }
            catch (NumberFormatException numberFormatException) {
                throw new IException("Ung\u00fcltiger Wert im Feld Richtungsdifferenz");
            }
        }
        if (this.inFileGroup == 400) {
            this.datParser.m3D = this.withHoeheGpsCheckbox != null ? this.withHoeheGpsCheckbox.getState() : false;
            try {
                IGpsReader.setSA(new Double(this.gpsGenauigkeitTextField.getText().trim()));
            }
            catch (Exception exception) {
                throw new IException("Ung\u00fcltiger Wert im Feld Standardabweichung");
            }
        } else if (this.inFileGroup == 500) {
            this.datParser.ps = -9;
        }
        this.datParser.setInFileTyp(this.inFileGroup);
        this.datParser.setParent(this);
        this.datParser.parse();
    }

    private IPanel createDatFilePanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        IPanel iPanel = new IPanel(gridBagLayout);
        this.steuerDatenCheckbox = new Checkbox("Steuerdaten", this.datParser.steuerDaten);
        iPanel.add(this.steuerDatenCheckbox);
        this.steuerDatenCheckbox.addItemListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(this.steuerDatenCheckbox, gridBagConstraints);
        this.steuerDatenChoice = new Choice();
        iPanel.add(this.steuerDatenChoice);
        this.steuerDatenChoice.addItemListener(this);
        Vector vector = KafDatProperties.getSteuerDaten();
        for (int i = 0; i < vector.size(); ++i) {
            this.steuerDatenChoice.addItem(((SteuerDaten)vector.elementAt(i)).getName());
        }
        this.steuerDatenChoice.setEnabled(this.datParser.steuerDaten);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(this.steuerDatenChoice, gridBagConstraints);
        Label label = new Label("Kafka-Datei:");
        iPanel.add(label);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.datFileTextField = new TextField(30);
        iPanel.add(this.datFileTextField);
        this.datFileTextField.addActionListener(this);
        this.datFileTextField.addTextListener(this);
        if (this.datParser.getDatFile() != null) {
            this.datFileTextField.setText(this.datParser.getDatFile().getName());
        }
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(this.datFileTextField, gridBagConstraints);
        this.datFileButton = new Button("...");
        iPanel.add(this.datFileButton);
        this.datFileButton.setActionCommand(DAT_FILE_COMMAND);
        this.datFileButton.addActionListener(this);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(this.datFileButton, gridBagConstraints);
        this.modelChoice = new Choice();
        iPanel.add(this.modelChoice);
        this.modelChoice.addItem(MODEL_VOID);
        this.modelChoice.addItem(MODEL_ALKIS);
        this.modelChoice.addItem(MODEL_ALK);
        this.modelChoice.setEnabled(false);
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(this.modelChoice, gridBagConstraints);
        label = new Label("Riss-Verzeichnis:");
        iPanel.add(label);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.rissDirTextField = new TextField(30);
        iPanel.add(this.rissDirTextField);
        this.rissDirTextField.addActionListener(this);
        this.rissDirTextField.addTextListener(this);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.rissDirTextField, gridBagConstraints);
        if (this.datParser.getDatFile() != null) {
            this.datFileTextField.setText(this.datParser.getDatFile().getName());
        }
        this.rissDirButton = new Button("...");
        iPanel.add(this.rissDirButton);
        this.rissDirButton.setActionCommand(RISS_DIR_COMMAND);
        this.rissDirButton.addActionListener(this);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.rissDirButton, gridBagConstraints);
        this.rissRenameCheckbox = new Checkbox("Umbenennen", this.rissMerger.renameFiles());
        iPanel.add(this.rissRenameCheckbox);
        this.rissRenameCheckbox.addItemListener(this);
        this.rissRenameCheckbox.setEnabled(this.rissMerger.getDirectory() != null);
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.rissRenameCheckbox, gridBagConstraints);
        return iPanel;
    }

    private IPanel createBeispielDatenPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        IPanel iPanel = new IPanel(gridBagLayout);
        iPanel.setBorder(new IBorder(1, "Beispiele"));
        this.punktDatenCheckbox = new Checkbox("Punktdaten", this.datParser.punktDaten);
        iPanel.add(this.punktDatenCheckbox);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(this.punktDatenCheckbox, gridBagConstraints);
        this.digitDatenCheckbox = new Checkbox("Transformation", this.datParser.digitDaten);
        iPanel.add(this.digitDatenCheckbox);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.digitDatenCheckbox, gridBagConstraints);
        this.bedingungDatenCheckbox = new Checkbox("Bedingungen", this.datParser.bedingungDaten);
        iPanel.add(this.bedingungDatenCheckbox);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(this.bedingungDatenCheckbox, gridBagConstraints);
        this.hoehenDatenCheckbox = new Checkbox("H\u00f6hen", this.datParser.hoehenDaten);
        iPanel.add(this.hoehenDatenCheckbox);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagLayout.setConstraints(this.hoehenDatenCheckbox, gridBagConstraints);
        this.gpsDatenCheckbox = new Checkbox("Gps-Basislinien", this.datParser.gpsDaten);
        iPanel.add(this.gpsDatenCheckbox);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(this.gpsDatenCheckbox, gridBagConstraints);
        this.polarDatenCheckbox = new Checkbox("Polare Messung", this.datParser.polarDaten);
        iPanel.add(this.polarDatenCheckbox);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.polarDatenCheckbox, gridBagConstraints);
        this.edmDatenCheckbox = new Checkbox("Edm-Messung", this.datParser.edmDaten);
        iPanel.add(this.edmDatenCheckbox);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(this.edmDatenCheckbox, gridBagConstraints);
        this.orthoDatenCheckbox = new Checkbox("Orthogonale Linie", this.datParser.orthoDaten);
        iPanel.add(this.orthoDatenCheckbox);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(this.orthoDatenCheckbox, gridBagConstraints);
        this.fluchtDatenCheckbox = new Checkbox("Fluchtungslinie", this.datParser.fluchtDaten);
        iPanel.add(this.fluchtDatenCheckbox);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.fluchtDatenCheckbox, gridBagConstraints);
        this.messbandDatenCheckbox = new Checkbox("Messbandstrecke", this.datParser.messbandDaten);
        iPanel.add(this.messbandDatenCheckbox);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(this.messbandDatenCheckbox, gridBagConstraints);
        this.bogenDatenCheckbox = new Checkbox("Bogenschnitt", this.datParser.bogenDaten);
        iPanel.add(this.bogenDatenCheckbox);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagLayout.setConstraints(this.bogenDatenCheckbox, gridBagConstraints);
        this.flstDatenCheckbox = new Checkbox("Flurst\u00fccke", this.datParser.flstDaten);
        iPanel.add(this.flstDatenCheckbox);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(this.flstDatenCheckbox, gridBagConstraints);
        this.gebDatenCheckbox = new Checkbox("Geb\u00e4ude", this.datParser.gebDaten);
        iPanel.add(this.gebDatenCheckbox);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.gebDatenCheckbox, gridBagConstraints);
        this.topDatenCheckbox = new Checkbox("Topographie", this.datParser.topDaten);
        iPanel.add(this.topDatenCheckbox);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(this.topDatenCheckbox, gridBagConstraints);
        this.bemerkungDatenCheckbox = new Checkbox("Bemerkungen", this.datParser.bemerkungDaten);
        iPanel.add(this.bemerkungDatenCheckbox);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(this.bemerkungDatenCheckbox, gridBagConstraints);
        this.identDatenCheckbox = new Checkbox("Identit\u00e4ten", this.datParser.identDaten);
        iPanel.add(this.identDatenCheckbox);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.identDatenCheckbox, gridBagConstraints);
        this.numbezDatenCheckbox = new Checkbox("Nummerierungsbezirk", this.datParser.numbezDaten);
        iPanel.add(this.numbezDatenCheckbox);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(this.numbezDatenCheckbox, gridBagConstraints);
        this.umnumDatenCheckbox = new Checkbox("Umnummerierung", this.datParser.umnumDaten);
        iPanel.add(this.umnumDatenCheckbox);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        gridBagLayout.setConstraints(this.umnumDatenCheckbox, gridBagConstraints);
        this.longFormatCheckbox = new Checkbox("langschriftliche Beispiele", this.datParser.longFormat);
        iPanel.add(this.longFormatCheckbox);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.gridheight = 1;
        gridBagLayout.setConstraints(this.longFormatCheckbox, gridBagConstraints);
        this.allBoxesButton = new Button(ALLBOXES_COMMAND);
        iPanel.add(this.allBoxesButton);
        this.allBoxesButton.addActionListener(this);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagLayout.setConstraints(this.allBoxesButton, gridBagConstraints);
        return iPanel;
    }

    private IPanel createInFilePanel() {
        IPanel iPanel = new IPanel(new FlowLayout(2));
        iPanel.add(new Label("Eingabe-Datei:"));
        this.inFileTextField = new TextField(30);
        this.inFileTextField.addActionListener(this);
        if (this.datParser.getInFile() != null) {
            this.inFileTextField.setText(this.datParser.getInFile().getName());
        }
        iPanel.add(this.inFileTextField);
        this.inFileButton = new Button("...");
        iPanel.add(this.inFileButton);
        this.inFileButton.setActionCommand(IN_FILE_COMMAND);
        this.inFileButton.addActionListener(this);
        return iPanel;
    }

    private IPanel createKooControlPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.ipady = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        IPanel iPanel = new IPanel(gridBagLayout);
        iPanel.setBorder(new IBorder(1, "Koordinatendatei"));
        this.punktStatusLabel = new Label("Punktstatus:");
        iPanel.add(this.punktStatusLabel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagLayout.setConstraints(this.punktStatusLabel, gridBagConstraints);
        this.punktStatusChoice = new Choice();
        iPanel.add(this.punktStatusChoice);
        this.punktStatusChoice.addItem(PunktStatus.getString(0));
        this.punktStatusChoice.addItem(PunktStatus.getString(1));
        this.punktStatusChoice.addItem(PunktStatus.getString(2));
        this.punktStatusChoice.addItem(PunktStatus.getString(-1));
        this.punktStatusChoice.addItem(PunktStatus.getString(-3));
        this.punktStatusChoice.select(PunktStatus.getString(this.datParser.ps));
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagLayout.setConstraints(this.punktStatusChoice, gridBagConstraints);
        this.punktNummerLabel = new Label("Punktnummer:");
        iPanel.add(this.punktNummerLabel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagLayout.setConstraints(this.punktNummerLabel, gridBagConstraints);
        this.punktNummerChoice = new Choice();
        iPanel.add(this.punktNummerChoice);
        String[] stringArray = PunktNummer.getNames(this.model);
        for (int i = 0; i < stringArray.length; ++i) {
            this.punktNummerChoice.addItem(stringArray[i]);
        }
        this.punktNummerChoice.select(PunktNummer.getLengthAsString(this.datParser.pl, this.model));
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagLayout.setConstraints(this.punktNummerChoice, gridBagConstraints);
        this.punktLageGenauigkeitLabel = new Label("Lagegenauigkeit:");
        iPanel.add(this.punktLageGenauigkeitLabel);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagLayout.setConstraints(this.punktLageGenauigkeitLabel, gridBagConstraints);
        this.punktLageGenauigkeitTextField = new TextField(5);
        iPanel.add(this.punktLageGenauigkeitTextField);
        this.punktLageGenauigkeitTextField.setText("" + this.datParser.plg);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagLayout.setConstraints(this.punktLageGenauigkeitTextField, gridBagConstraints);
        this.punktModeChoice = new Choice();
        iPanel.add(this.punktModeChoice);
        this.punktModeChoice.addItem(PUNKT_MODE_EINGABE);
        this.punktModeChoice.addItem(PUNKT_MODE_TRAFO);
        this.punktModeChoice.addItem(PUNKT_MODE_MESSUNG);
        this.punktModeChoice.select(0);
        this.punktModeChoice.addItemListener(this);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagLayout.setConstraints(this.punktModeChoice, gridBagConstraints);
        this.punktHoeheLabel = new Label("mit H\u00f6he:");
        iPanel.add(this.punktHoeheLabel);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagLayout.setConstraints(this.punktHoeheLabel, gridBagConstraints);
        this.punktHoeheCheckbox = new Checkbox("");
        iPanel.add(this.punktHoeheCheckbox);
        this.punktHoeheCheckbox.addItemListener(this);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagLayout.setConstraints(this.punktHoeheCheckbox, gridBagConstraints);
        return iPanel;
    }

    private IPanel createPolarControlPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.ipady = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        IPanel iPanel = new IPanel(gridBagLayout);
        iPanel.setBorder(new IBorder(1, "Polardatei"));
        this.isMittelCheckbox = new Checkbox("Doppelmessungen mitteln", IPolarReader.isMitteln());
        iPanel.add(this.isMittelCheckbox);
        this.isMittelCheckbox.addItemListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagLayout.setConstraints(this.isMittelCheckbox, gridBagConstraints);
        this.sDiffLabel = new Label("max. Streckendifferenz: ");
        iPanel.add(this.sDiffLabel);
        this.sDiffLabel.setEnabled(this.isMittelCheckbox.getState());
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagLayout.setConstraints(this.sDiffLabel, gridBagConstraints);
        this.sDiffTextField = new TextField(GeoNumberFormat.m43.format(IPolarReader.getStreckeDiff()).toString(), 5);
        iPanel.add(this.sDiffTextField);
        this.sDiffTextField.setEnabled(this.isMittelCheckbox.getState());
        this.sDiffTextField.setEditable(this.isMittelCheckbox.getState());
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagLayout.setConstraints(this.sDiffTextField, gridBagConstraints);
        this.rDiffLabel = new Label("max. Richtungsdifferenz: ");
        iPanel.add(this.rDiffLabel);
        this.rDiffLabel.setEnabled(this.isMittelCheckbox.getState());
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagLayout.setConstraints(this.rDiffLabel, gridBagConstraints);
        this.rDiffTextField = new TextField(GeoNumberFormat.m43.format(IPolarReader.getRichtungDiff()).toString(), 5);
        iPanel.add(this.rDiffTextField);
        this.rDiffTextField.setEnabled(this.isMittelCheckbox.getState());
        this.rDiffTextField.setEditable(this.isMittelCheckbox.getState());
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagLayout.setConstraints(this.rDiffTextField, gridBagConstraints);
        this.isReduzierenCheckbox = new Checkbox("Richtungen reduzieren", IPolarReader.isReduzieren());
        iPanel.add(this.isReduzierenCheckbox);
        this.isReduzierenCheckbox.addItemListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagLayout.setConstraints(this.isReduzierenCheckbox, gridBagConstraints);
        if (KafPlotVersion.isSigned("Hoehe.class")) {
            this.withLageCheckbox = new Checkbox("Lage erzeugen", this.datParser.m2d);
            iPanel.add(this.withLageCheckbox);
            this.withLageCheckbox.addItemListener(this);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagLayout.setConstraints(this.withLageCheckbox, gridBagConstraints);
            this.withHoeheCheckbox = new Checkbox("H\u00f6hen erzeugen", false);
            iPanel.add(this.withHoeheCheckbox);
            this.withHoeheCheckbox.addItemListener(this);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagLayout.setConstraints(this.withHoeheCheckbox, gridBagConstraints);
        }
        return iPanel;
    }

    private IPanel createGpsControlPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.ipady = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        IPanel iPanel = new IPanel(gridBagLayout);
        iPanel.setBorder(new IBorder(1, "GPS-Basisliniendatei"));
        Label label = new Label("Standardabweichung der Basislinie: ");
        iPanel.add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.gpsGenauigkeitTextField = new TextField(IFormat.f_3.format(IGpsReader.getSA()).toString(), 5);
        iPanel.add(this.gpsGenauigkeitTextField);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(this.gpsGenauigkeitTextField, gridBagConstraints);
        this.withHoeheGpsCheckbox = new Checkbox("H\u00f6hen erzeugen", false);
        iPanel.add(this.withHoeheGpsCheckbox);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.withHoeheGpsCheckbox, gridBagConstraints);
        return iPanel;
    }

    private void showProperties() {
        this.isMittelCheckbox.setState(IPolarReader.isMitteln());
        this.sDiffLabel.setEnabled(this.isMittelCheckbox.getState());
        this.sDiffTextField.setEnabled(this.isMittelCheckbox.getState());
        this.sDiffTextField.setEditable(this.isMittelCheckbox.getState());
        this.rDiffLabel.setEnabled(this.isMittelCheckbox.getState());
        this.rDiffTextField.setEnabled(this.isMittelCheckbox.getState());
        this.rDiffTextField.setEditable(this.isMittelCheckbox.getState());
        this.isReduzierenCheckbox.setState(IPolarReader.isReduzieren());
        boolean bl = new File(this.datFileTextField.getText()).exists();
        this.modelChoice.select(bl ? MODEL_VOID : MODEL_ALKIS);
        this.modelChoice.setEnabled(!bl);
        if (this.rissMerger.getDirectory() != null) {
            this.rissDirTextField.setText(this.rissMerger.getDirectory().getAbsolutePath());
        }
        this.rissRenameCheckbox.setEnabled(this.rissMerger.getDirectory() != null);
    }

    private IPanel createVoidPanel() {
        IPanel iPanel = new IPanel();
        iPanel.setBorder(new IBorder(1));
        return iPanel;
    }

    private IPanel createInFileControlPanel() {
        IPanel iPanel = new IPanel(this.card);
        iPanel.add((Component)this.createVoidPanel(), VOID_PANEL);
        iPanel.add((Component)this.createKooControlPanel(), KOO_CONTROL_PANEL);
        iPanel.add((Component)this.createPolarControlPanel(), POLAR_CONTROL_PANEL);
        iPanel.add((Component)this.createGpsControlPanel(), GPS_CONTROL_PANEL);
        this.card.first(iPanel);
        return iPanel;
    }

    private void setInFileView(File file) {
        boolean bl = false;
        try {
            if (file != null) {
                GeoFile geoFile = new GeoFile(file);
                this.inFileGroup = geoFile.getFileGroup();
                bl = geoFile.is3DTyp();
            } else {
                this.inFileGroup = -1;
            }
        }
        catch (Exception exception) {
            ErrorDialog errorDialog = new ErrorDialog((IFrame)this, new IException("Das Format der Datei " + file.getName() + " wurde nicht erkannt!"));
            errorDialog.setVisible(true);
            this.inFileGroup = -1;
        }
        if (this.inFileGroup == 100) {
            this.card.show(this.inFileControlPanel, KOO_CONTROL_PANEL);
        } else if (this.inFileGroup == 200) {
            this.card.show(this.inFileControlPanel, POLAR_CONTROL_PANEL);
            if (this.withHoeheCheckbox != null) {
                if (this.withHoeheCheckbox.getState()) {
                    this.withHoeheCheckbox.setState(bl);
                }
                this.withHoeheCheckbox.setEnabled(bl);
            }
        } else if (this.inFileGroup == 400) {
            this.card.show(this.inFileControlPanel, GPS_CONTROL_PANEL);
        } else {
            this.card.show(this.inFileControlPanel, VOID_PANEL);
        }
    }

    private void setBoxes(boolean bl) {
        this.punktDatenCheckbox.setState(bl);
        this.gpsDatenCheckbox.setState(bl);
        this.polarDatenCheckbox.setState(bl);
        this.fluchtDatenCheckbox.setState(bl);
        this.messbandDatenCheckbox.setState(bl);
        this.edmDatenCheckbox.setState(bl);
        this.orthoDatenCheckbox.setState(bl);
        this.bogenDatenCheckbox.setState(bl);
        this.digitDatenCheckbox.setState(bl);
        this.bedingungDatenCheckbox.setState(bl);
        this.hoehenDatenCheckbox.setState(bl);
        this.flstDatenCheckbox.setState(bl);
        this.gebDatenCheckbox.setState(bl);
        this.topDatenCheckbox.setState(bl);
        this.bemerkungDatenCheckbox.setState(bl);
        this.numbezDatenCheckbox.setState(bl);
        this.identDatenCheckbox.setState(bl);
        this.umnumDatenCheckbox.setState(bl);
    }

    private void parseArgs(String[] stringArray) throws IException {
        boolean bl = false;
        String string = stringArray[0];
        if (string.startsWith(ARG_HELP_1) || string.startsWith(ARG_HELP_2)) {
            System.out.println(this.HELP);
            System.exit(1);
        }
        if (string.startsWith("/")) {
            throw new IException("Keine Ausgabedatei angegeben!");
        }
        if (string.lastIndexOf(".") == -1) {
            string = new String(string + ".dat");
        }
        this.datParser.setDatFile(new File(string));
    }
}

