/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.IException;
import de.geocalc.kafplot.KoordinatenSystem;
import de.geocalc.kafplot.PropertyLoader;
import de.geocalc.kafplot.io.dat.SteuerDaten;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.util.StringTokenizer;
import java.util.Vector;

public class KafDatProperties {
    private static final int STANDARD = 0;
    private static final int STEUERDATEN = 1;
    private static final String STANDARD_STRING = "STANDARD";
    private static final String STEUERDATEN_STRING = "STEUERDATEN";
    private static final char UNDER_LINE = '_';
    private static final char SPACE = ' ';
    private static final Vector steuerDaten = new Vector();
    private static KoordinatenSystem kooSystem = new KoordinatenSystem(-1);
    private static String vermStelle;
    private static String adresse1;
    private static String adresse2;
    private static String adresse3;
    private static String katasteramt;
    private static int gelaendeHoehe;

    public static String getVermStelle() {
        if (vermStelle == null) {
            return "";
        }
        return vermStelle;
    }

    public static void setVermStelle(String string) {
        vermStelle = string;
    }

    public static String getAdresse1() {
        if (adresse1 == null) {
            return "";
        }
        return adresse1;
    }

    public static void setAdresse1(String string) {
        adresse1 = string;
    }

    public static String getAdresse2() {
        if (adresse2 == null) {
            return "";
        }
        return adresse2;
    }

    public static void setAdresse2(String string) {
        adresse2 = string;
    }

    public static String getAdresse3() {
        if (adresse3 == null) {
            return "";
        }
        return adresse3;
    }

    public static void setAdresse3(String string) {
        adresse3 = string;
    }

    public static String getKatasteramt() {
        if (katasteramt == null) {
            return "";
        }
        return katasteramt;
    }

    public static void setKatasteramt(String string) {
        katasteramt = string;
    }

    public static void setKooSystem(String string) throws IException {
        kooSystem.setSystem(string);
    }

    public static String getKooSystemAsString() {
        return kooSystem.getSystemName();
    }

    public static int getKafkaKooSystemNummer() {
        return kooSystem.getKafkaSystemNummer();
    }

    public static int getGelaendeHoehe() {
        return gelaendeHoehe;
    }

    public static void setGelaendeHoehe(int n) {
        gelaendeHoehe = n;
    }

    public static Vector getSteuerDaten() {
        return steuerDaten;
    }

    public static SteuerDaten getDefaultSteuerDaten() {
        if (steuerDaten == null || steuerDaten.size() == 0) {
            return new SteuerDaten("DEFAULT");
        }
        return (SteuerDaten)steuerDaten.firstElement();
    }

    public static void load(InputStream inputStream) throws IOException {
        LineNumberReader lineNumberReader = null;
        boolean bl = false;
        try {
            String string;
            lineNumberReader = PropertyLoader.createReader(inputStream);
            while ((string = lineNumberReader.readLine()) != null) {
                Object object;
                if (string.length() == 0 || string.charAt(0) == '#') continue;
                if (string.startsWith("[")) {
                    try {
                        object = string.substring(string.indexOf(91) + 1, string.indexOf(93)).trim().toUpperCase();
                        if (((String)object).equals(STANDARD_STRING)) {
                            bl = false;
                            continue;
                        }
                        if (((String)object).equals(STEUERDATEN_STRING)) {
                            bl = true;
                            continue;
                        }
                        throw new IOException("unbekanntes Abschnittskennzeichen: " + (String)object);
                    }
                    catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                        throw new IOException("ung\u00fcltiges Format");
                    }
                }
                if (!bl) {
                    object = new StringTokenizer(string, "=");
                    int n = ((StringTokenizer)object).countTokens();
                    if (n == 0) {
                        throw new IOException("fehlende Variablendefinition");
                    }
                    if (n == 1) {
                        throw new IOException("fehlender Wert zur Variablen: " + ((StringTokenizer)object).nextToken());
                    }
                    if (n > 2) {
                        throw new IOException("Das '='-Zeichen ist in der Wertzuweisung un g\u00fcltig");
                    }
                    String string2 = ((StringTokenizer)object).nextToken().trim();
                    String string3 = ((StringTokenizer)object).nextToken().trim();
                    if (string2.equalsIgnoreCase("KafDatProperties.vermStelle")) {
                        KafDatProperties.setVermStelle(string3.replace('_', ' '));
                        continue;
                    }
                    if (string2.equalsIgnoreCase("KafDatProperties.adresse1")) {
                        KafDatProperties.setAdresse1(string3.replace('_', ' '));
                        continue;
                    }
                    if (string2.equalsIgnoreCase("KafDatProperties.adresse2")) {
                        KafDatProperties.setAdresse2(string3.replace('_', ' '));
                        continue;
                    }
                    if (string2.equalsIgnoreCase("KafDatProperties.adresse3")) {
                        KafDatProperties.setAdresse3(string3.replace('_', ' '));
                        continue;
                    }
                    if (string2.equalsIgnoreCase("KafDatProperties.katasteramt")) {
                        KafDatProperties.setKatasteramt(string3.replace('_', ' '));
                        continue;
                    }
                    if (string2.equalsIgnoreCase("KafDatProperties.kooSystem")) {
                        KafDatProperties.setKooSystem(string3.replace('_', ' '));
                        continue;
                    }
                    if (string2.equalsIgnoreCase("KafDatProperties.gelaendeHoehe")) {
                        KafDatProperties.setGelaendeHoehe(Integer.parseInt(string3.trim()));
                        continue;
                    }
                    throw new IOException("unbekannte Variable: " + string2);
                }
                if (!bl || (object = (SteuerDaten)SteuerDaten.parsePropertiesLine(string)) == null) continue;
                if (steuerDaten.contains(object)) {
                    steuerDaten.removeElement(object);
                }
                steuerDaten.addElement(object);
            }
        }
        catch (IOException iOException) {
            throw new IOException("Fehler in Zeile: " + (lineNumberReader != null ? lineNumberReader.getLineNumber() : 0) + "\n" + iOException.getMessage());
        }
        catch (Exception exception) {
            throw new IOException("Fehler in Zeile: " + (lineNumberReader != null ? lineNumberReader.getLineNumber() : 0) + "\nWert fehlerhaft");
        }
        if (steuerDaten.size() == 0) {
            steuerDaten.addElement(new SteuerDaten("Standard"));
        }
    }
}

