/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.Messung;
import de.geocalc.kafplot.MessungGewicht;
import de.geocalc.kafplot.Riss;
import java.awt.Dimension;
import java.util.Enumeration;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;

public class KafEdit
extends JFrame {
    private DataBase db;
    private JSplitPane splitPane;
    private JScrollPane rootPane;
    private JScrollPane dataPane;

    public KafEdit(DataBase dataBase) {
        super("KafEdit");
        super.setDefaultCloseOperation(1);
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.db = dataBase;
        this.rootPane = new JScrollPane(this.createTree(dataBase));
        JTable jTable = new JTable();
        jTable.setPreferredScrollableViewportSize(new Dimension(500, 70));
        jTable.setFillsViewportHeight(true);
        this.dataPane = new JScrollPane(jTable);
        this.splitPane = new JSplitPane(1, this.rootPane, this.dataPane);
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setDividerLocation(150);
        this.splitPane.setPreferredSize(new Dimension(600, 800));
        this.setContentPane(this.splitPane);
        this.pack();
        this.setVisible(true);
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                KafEdit kafEdit = new KafEdit(null);
            }
        });
    }

    private JTree createTree(DataBase dataBase) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Daten", true);
        JTree jTree = new JTree(defaultMutableTreeNode);
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Punkte", true);
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode("Messungen", true);
        DefaultMutableTreeNode defaultMutableTreeNode4 = new DefaultMutableTreeNode("GPS", true);
        this.addObjectTree(defaultMutableTreeNode4, dataBase.gpsRisse());
        defaultMutableTreeNode3.add(defaultMutableTreeNode4);
        DefaultMutableTreeNode defaultMutableTreeNode5 = new DefaultMutableTreeNode("Polar", true);
        this.addObjectTree(defaultMutableTreeNode5, dataBase.polarRisse());
        defaultMutableTreeNode3.add(defaultMutableTreeNode5);
        DefaultMutableTreeNode defaultMutableTreeNode6 = new DefaultMutableTreeNode("Eigene", true);
        this.addObjectTree(defaultMutableTreeNode6, dataBase.messbandRisse());
        defaultMutableTreeNode3.add(defaultMutableTreeNode6);
        DefaultMutableTreeNode defaultMutableTreeNode7 = new DefaultMutableTreeNode("Nachweis", true);
        this.addObjectTree(defaultMutableTreeNode7, dataBase.katasterRisse());
        defaultMutableTreeNode3.add(defaultMutableTreeNode7);
        DefaultMutableTreeNode defaultMutableTreeNode8 = new DefaultMutableTreeNode("Einrechnung", true);
        this.addObjectTree(defaultMutableTreeNode8, dataBase.einrechenRisse());
        defaultMutableTreeNode3.add(defaultMutableTreeNode8);
        DefaultMutableTreeNode defaultMutableTreeNode9 = new DefaultMutableTreeNode("Vorgaben", true);
        this.addObjectTree(defaultMutableTreeNode9, dataBase.vorgabeRisse());
        defaultMutableTreeNode3.add(defaultMutableTreeNode9);
        defaultMutableTreeNode.add(defaultMutableTreeNode3);
        DefaultMutableTreeNode defaultMutableTreeNode10 = new DefaultMutableTreeNode("Transformationen", true);
        this.addObjectTree(defaultMutableTreeNode10, dataBase.trafoRisse());
        defaultMutableTreeNode.add(defaultMutableTreeNode10);
        DefaultMutableTreeNode defaultMutableTreeNode11 = new DefaultMutableTreeNode("Bedingungen", true);
        DefaultMutableTreeNode defaultMutableTreeNode12 = new DefaultMutableTreeNode("Bedingungen", true);
        this.addObjectTree(defaultMutableTreeNode12, dataBase.bedingungRisse());
        defaultMutableTreeNode11.add(defaultMutableTreeNode12);
        DefaultMutableTreeNode defaultMutableTreeNode13 = new DefaultMutableTreeNode("Homogenisierung", true);
        this.addObjectTree(defaultMutableTreeNode13, dataBase.homogenisierungRisse());
        defaultMutableTreeNode11.add(defaultMutableTreeNode13);
        defaultMutableTreeNode.add(defaultMutableTreeNode11);
        DefaultMutableTreeNode defaultMutableTreeNode14 = new DefaultMutableTreeNode("Objekte", true);
        DefaultMutableTreeNode defaultMutableTreeNode15 = new DefaultMutableTreeNode("Flurst\u00fccke", true);
        this.addObjectTree(defaultMutableTreeNode15, dataBase.flurstuecke());
        defaultMutableTreeNode14.add(defaultMutableTreeNode15);
        DefaultMutableTreeNode defaultMutableTreeNode16 = new DefaultMutableTreeNode("Nutzungen", true);
        this.addObjectTree(defaultMutableTreeNode16, dataBase.nutzungen());
        defaultMutableTreeNode14.add(defaultMutableTreeNode16);
        DefaultMutableTreeNode defaultMutableTreeNode17 = new DefaultMutableTreeNode("Boden", true);
        this.addObjectTree(defaultMutableTreeNode17, dataBase.bodenObjekte());
        defaultMutableTreeNode14.add(defaultMutableTreeNode17);
        DefaultMutableTreeNode defaultMutableTreeNode18 = new DefaultMutableTreeNode("Geb\u00e4ude", true);
        this.addObjectTree(defaultMutableTreeNode18, dataBase.gebaeude());
        defaultMutableTreeNode14.add(defaultMutableTreeNode18);
        DefaultMutableTreeNode defaultMutableTreeNode19 = new DefaultMutableTreeNode("Topografie", true);
        this.addObjectTree(defaultMutableTreeNode19, dataBase.topObjekte());
        defaultMutableTreeNode14.add(defaultMutableTreeNode19);
        DefaultMutableTreeNode defaultMutableTreeNode20 = new DefaultMutableTreeNode("Eigentum", true);
        this.addObjectTree(defaultMutableTreeNode20, dataBase.bestaende());
        defaultMutableTreeNode14.add(defaultMutableTreeNode20);
        defaultMutableTreeNode.add(defaultMutableTreeNode14);
        DefaultMutableTreeNode defaultMutableTreeNode21 = new DefaultMutableTreeNode("Bemerkungen", true);
        defaultMutableTreeNode.add(defaultMutableTreeNode21);
        DefaultMutableTreeNode defaultMutableTreeNode22 = new DefaultMutableTreeNode("Nummerierungsbezirke", true);
        defaultMutableTreeNode.add(defaultMutableTreeNode22);
        DefaultMutableTreeNode defaultMutableTreeNode23 = new DefaultMutableTreeNode("Identit\u00e4ten", true);
        defaultMutableTreeNode.add(defaultMutableTreeNode23);
        DefaultMutableTreeNode defaultMutableTreeNode24 = new DefaultMutableTreeNode("Umnummerierung", true);
        defaultMutableTreeNode.add(defaultMutableTreeNode24);
        jTree.expandPath(new TreePath(defaultMutableTreeNode.getPath()));
        jTree.expandPath(new TreePath(defaultMutableTreeNode3.getPath()));
        try {
            ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("tree_table.png"));
            DefaultTreeCellRenderer defaultTreeCellRenderer = (DefaultTreeCellRenderer)jTree.getCellRenderer();
            defaultTreeCellRenderer.setLeafIcon(imageIcon);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        jTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treeSelectionEvent.getPath().getLastPathComponent();
                Object object = defaultMutableTreeNode.getUserObject();
                System.out.println(object);
                if (object instanceof Riss) {
                    KafEdit.this.dataPane.setViewportView(new JTable(new RissTableModel((Riss)object)));
                }
            }
        });
        return jTree;
    }

    private void addObjectTree(DefaultMutableTreeNode defaultMutableTreeNode, Enumeration enumeration) {
        while (enumeration.hasMoreElements()) {
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(enumeration.nextElement()));
        }
    }

    class RissTableModel
    extends AbstractTableModel {
        Riss riss;

        public RissTableModel(Riss riss) {
            this.riss = riss;
        }

        @Override
        public int getColumnCount() {
            return 10;
        }

        @Override
        public int getRowCount() {
            return this.riss.size();
        }

        @Override
        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return "MA";
                }
                case 1: {
                    return "PNA";
                }
                case 2: {
                    return "PNE";
                }
                case 3: {
                    return "m1";
                }
                case 4: {
                    return "m2";
                }
                case 5: {
                    return "G1";
                }
                case 6: {
                    return "G2";
                }
                case 7: {
                    return "G3";
                }
                case 8: {
                    return "G4";
                }
                case 9: {
                    return "BEM";
                }
            }
            return "";
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Messung messung = (Messung)this.riss.elementAt(n);
            MessungGewicht messungGewicht = messung.getGewichte();
            switch (n2) {
                case 0: {
                    return new Integer(messung.ma);
                }
                case 1: {
                    return new Long(messung.ps.nr);
                }
                case 2: {
                    return messung.pz != null ? new Long(messung.pz.nr) : "";
                }
                case 3: {
                    return new Double(messung.l1);
                }
                case 4: {
                    return new Double(messung.l2);
                }
                case 5: {
                    return new Float(messungGewicht.getG1());
                }
                case 6: {
                    return "G2";
                }
                case 7: {
                    return "G3";
                }
                case 8: {
                    return "G4";
                }
                case 9: {
                    return "BEM";
                }
            }
            return "";
        }

        public Class getColumnClass(int n) {
            switch (n) {
                case 0: {
                    return new Integer(0).getClass();
                }
            }
            return new String().getClass();
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return true;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            this.fireTableCellUpdated(n, n2);
        }
    }
}

