/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import com.sun.jimi.core.Jimi;
import com.sun.jimi.core.VMMControl;
import de.geocalc.awt.ErrorDialog;
import de.geocalc.awt.IButton;
import de.geocalc.awt.ICheckboxButton;
import de.geocalc.awt.ICheckboxButtonGroup;
import de.geocalc.awt.IException;
import de.geocalc.awt.IFrame;
import de.geocalc.awt.IGraphics;
import de.geocalc.awt.IProgressDialog;
import de.geocalc.awt.IQuestionDialog;
import de.geocalc.awt.ITimeDisplayer;
import de.geocalc.awt.IToolBar;
import de.geocalc.awt.event.ElementInfoListener;
import de.geocalc.awt.event.IMessageEvent;
import de.geocalc.geom.DPoint;
import de.geocalc.geom.DRectangle;
import de.geocalc.geom.GeoTransform;
import de.geocalc.io.GeoFile;
import de.geocalc.io.IFileInputException;
import de.geocalc.kafplot.BestandbelegDialog;
import de.geocalc.kafplot.CreateBedingungenDialog;
import de.geocalc.kafplot.CreateLgaDialog;
import de.geocalc.kafplot.CreatePointRasterDialog;
import de.geocalc.kafplot.CreateTrafoDialog;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.DataCheckDialog;
import de.geocalc.kafplot.EinrechnungDialog;
import de.geocalc.kafplot.ErrorObject;
import de.geocalc.kafplot.FlaechenbelegDialog;
import de.geocalc.kafplot.Flurstueck;
import de.geocalc.kafplot.FortfuehrungDialog;
import de.geocalc.kafplot.GeoFileReader;
import de.geocalc.kafplot.GeoFileWriterDialog;
import de.geocalc.kafplot.GeoImage;
import de.geocalc.kafplot.GetServicePortDialog;
import de.geocalc.kafplot.GraphicClip;
import de.geocalc.kafplot.Identitaet;
import de.geocalc.kafplot.ImageReader;
import de.geocalc.kafplot.InfoDialog;
import de.geocalc.kafplot.InputRissDialog;
import de.geocalc.kafplot.InsertTrafoDialog;
import de.geocalc.kafplot.KafEdit;
import de.geocalc.kafplot.KafPlotCommand;
import de.geocalc.kafplot.KafPlotFrame;
import de.geocalc.kafplot.KafPlotMainMenu;
import de.geocalc.kafplot.KafPlotModules;
import de.geocalc.kafplot.KafPlotProperties;
import de.geocalc.kafplot.KafPlotServiceMessage;
import de.geocalc.kafplot.KafPlotServiceServer;
import de.geocalc.kafplot.KafPlotSymbolBar;
import de.geocalc.kafplot.KafPlotVersion;
import de.geocalc.kafplot.KafkaReader;
import de.geocalc.kafplot.KafkaWriter;
import de.geocalc.kafplot.KafkaWriterDialog;
import de.geocalc.kafplot.KatasternachweisDialog;
import de.geocalc.kafplot.KoordinatenSystem;
import de.geocalc.kafplot.LoadKpsDialog;
import de.geocalc.kafplot.LoadWmsDialog;
import de.geocalc.kafplot.MessageListDialog;
import de.geocalc.kafplot.NasExportDialog;
import de.geocalc.kafplot.ObjectListDialog;
import de.geocalc.kafplot.PrintPage;
import de.geocalc.kafplot.PropertyLoader;
import de.geocalc.kafplot.Punkt;
import de.geocalc.kafplot.PunktAttDialog;
import de.geocalc.kafplot.PunktContainer;
import de.geocalc.kafplot.PunktMove;
import de.geocalc.kafplot.PunktTable;
import de.geocalc.kafplot.ReadMengeDialog;
import de.geocalc.kafplot.ReweightMessungDialog;
import de.geocalc.kafplot.SearchNearPointsDialog;
import de.geocalc.kafplot.SearchWwwDialog;
import de.geocalc.kafplot.StatistikbelegDialog;
import de.geocalc.kafplot.SystraExportDialog;
import de.geocalc.kafplot.TrafoFileReader;
import de.geocalc.kafplot.TrafoSysDialog;
import de.geocalc.kafplot.UmnumPointsDialog;
import de.geocalc.kafplot.VeraenderungDialog;
import de.geocalc.kafplot.ViewerWriterDialog;
import de.geocalc.kafplot.WmsGeoImage;
import de.geocalc.kafplot.WmsSaveDialog;
import de.geocalc.kafplot.event.GraphicEvent;
import de.geocalc.kafplot.event.ServiceEvent;
import de.geocalc.kafplot.event.ServiceListener;
import de.geocalc.kafplot.io.DatWriter;
import de.geocalc.kafplot.io.PdkReader;
import de.geocalc.text.IFormat;
import de.geocalc.webservice.BoundingBox;
import de.geocalc.webservice.Capability;
import de.geocalc.webservice.FeatureInfo;
import de.geocalc.webservice.Layer;
import de.geocalc.webservice.Map;
import de.geocalc.webservice.Service;
import de.geocalc.webservice.Srs;
import de.geocalc.webservice.WebService;
import java.awt.Color;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorEvent;
import java.awt.datatransfer.FlavorListener;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import java.awt.image.BufferedImage;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class KafPlot
extends KafPlotFrame
implements KafPlotCommand,
ActionListener,
KeyListener,
ElementInfoListener,
FlavorListener,
DropTargetListener,
Service,
ServiceListener {
    protected PunktAttDialog punktAttDialog = null;
    protected ReadMengeDialog readMengeDialog = null;
    int wmsPort = 0;
    int kpsPort = 0;
    public static final String FILTER = "*.";
    public static final String ALL_FILES_FILTER = "*.*";
    public static final String IMAGE_FILES_FILTER = "*.gif;*.jpg;*.tif;*.bmp;*.pcx;*.png";
    private KafPlotMainMenu mainMenu;
    private InputRissDialog inputRissDialog;
    private SearchWwwDialog searchWwwDialog;
    private KafEdit kafEdit;
    private WebService wms = null;
    private KafPlotServiceServer kps = null;
    private DropTarget dropTarget = null;
    private File imageFile = null;
    private double wms_ymin = 0.0;
    private double wms_xmin = 0.0;
    private double wms_ymax = 0.0;
    private double wms_xmax = 0.0;
    private double wms_m = 0.0;
    private int wms_width = 0;
    private int wms_height = 0;
    private static boolean debug = false;

    public static boolean debug() {
        return debug;
    }

    public static void main(String[] stringArray) {
        KafPlot kafPlot = new KafPlot(stringArray);
    }

    KafPlot(String[] stringArray) {
        this.sb.enableToolTips();
        this.gp.addGraphicListener(this);
        VMMControl.setVMMThreshold(0x6400000);
        Thread.setDefaultUncaughtExceptionHandler(new SystemErrorHandler(this));
        if (stringArray != null && stringArray.length > 0) {
            boolean bl = false;
            int n = 0;
            FileSelector fileSelector = new FileSelector(this);
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i].trim();
                if (KafPlot.debug()) {
                    System.out.println("Arg[" + i + "]:" + string);
                }
                if (string.length() == 0) continue;
                if (string.startsWith("-")) {
                    if (string.equalsIgnoreCase("-debug")) {
                        debug = true;
                        continue;
                    }
                    if (string.startsWith("-service:")) {
                        this.startService(string.substring(9));
                        continue;
                    }
                    System.out.println("Unbekannter Parameter: " + string);
                    continue;
                }
                if (string.startsWith("@")) {
                    bl = true;
                    this.interpreteCommand(string.substring(1), true);
                    continue;
                }
                if (n == 0 && this.openProject(string)) continue;
                File file = new File(string);
                if (file.exists()) {
                    fileSelector.add(file);
                    ++n;
                    continue;
                }
                ErrorDialog errorDialog = new ErrorDialog((IFrame)this, new IFileInputException("Datei " + file.getAbsolutePath() + " nicht gefunden"));
                errorDialog.setVisible(true);
            }
            this.readFiles(fileSelector);
            if (bl) {
                DataBase.setWork(false);
                this.gp.setView(this.db);
            }
            this.setTitle();
            KafPlotProperties.init(this.db);
        }
        this.dropTarget = new DropTarget(this, 1, this, true);
        this.setCommandInput();
        if (KafPlotProperties.externCommandSocket != 0) {
            try {
                final ServerSocket serverSocket = new ServerSocket(KafPlotProperties.externCommandSocket);
                new Thread(new Runnable(){
                    final /* synthetic */ KafPlot this$0;
                    {
                        this.this$0 = kafPlot;
                    }

                    @Override
                    public void run() {
                        while (true) {
                            try {
                                while (true) {
                                    Socket socket = serverSocket.accept();
                                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                                    String string = bufferedReader.readLine();
                                    this.this$0.interpreteCommand(string, false);
                                    this.this$0.sb.messagePerformed(new IMessageEvent(this, 1001, "KafPlotCmd " + string + " empfangen"));
                                    bufferedReader.close();
                                    socket.close();
                                }
                            }
                            catch (Exception exception) {
                                continue;
                            }
                            break;
                        }
                    }
                }).start();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        Toolkit.getDefaultToolkit().getSystemClipboard().addFlavorListener(this);
    }

    @Override
    public void graphicUpdated(GraphicEvent graphicEvent) {
        if (this.kps != null) {
            KafPlotServiceMessage kafPlotServiceMessage = new KafPlotServiceMessage();
            kafPlotServiceMessage.append("TRANSMIT", "SetView");
            kafPlotServiceMessage.append("CONTENT", IFormat.f_3.format(KafPlotProperties.getGrafikCenter().y) + "," + IFormat.f_3.format(KafPlotProperties.getGrafikCenter().x) + "," + IFormat.f_8.format(KafPlotProperties.getGrafikRotation()) + "," + IFormat.f_8.format(KafPlotProperties.getGrafikZoom()) + "," + IFormat.f_8.format(KafPlotProperties.getEllipseZoom()));
            this.kps.addMessage(kafPlotServiceMessage);
        }
        super.graphicUpdated(graphicEvent);
    }

    @Override
    public void flavorsChanged(FlavorEvent flavorEvent) {
        try {
            Clipboard clipboard = (Clipboard)flavorEvent.getSource();
            if (clipboard != null) {
                Transferable transferable = clipboard.getContents(null);
                this.mainMenu.setDataInEnabled(transferable.isDataFlavorSupported(DataFlavor.stringFlavor) || transferable.isDataFlavorSupported(DataFlavor.imageFlavor));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        DataBase.setWork(true);
        try {
            Transferable transferable = dropTargetDropEvent.getTransferable();
            DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
            FileSelector fileSelector = new FileSelector(this);
            for (int i = 0; i < dataFlavorArray.length; ++i) {
                if (dataFlavorArray[i].isFlavorJavaFileListType()) {
                    dropTargetDropEvent.acceptDrop(dropTargetDropEvent.getDropAction());
                    fileSelector.add(((List)transferable.getTransferData(dataFlavorArray[i])).toArray());
                    continue;
                }
                if (!KafPlot.debug()) continue;
                System.out.println("Alternatives Drop-Flavor: " + String.valueOf(dataFlavorArray[i]));
            }
            this.readFiles(fileSelector);
            DataBase.setWork(false);
            dropTargetDropEvent.dropComplete(true);
            return;
        }
        catch (Throwable throwable) {
            dropTargetDropEvent.rejectDrop();
            DataBase.setWork(false);
            return;
        }
    }

    @Override
    public void serviceStarted(ServiceEvent serviceEvent) {
        this.sb.messagePerformed(new IMessageEvent(this, 1001, "KafPlotService " + String.valueOf(serviceEvent.getSource()) + " gestartet"));
    }

    @Override
    public void serviceAborted(ServiceEvent serviceEvent) {
        this.sb.messagePerformed(new IMessageEvent(this, 1001, "KafPlotService " + String.valueOf(serviceEvent.getSource()) + " beendet"));
        this.setCommandInput();
    }

    @Override
    public void packetSended(ServiceEvent serviceEvent) {
        Object object = serviceEvent.getPacket();
        if (object instanceof KafPlotServiceMessage) {
            KafPlotServiceMessage kafPlotServiceMessage = (KafPlotServiceMessage)object;
            String string = kafPlotServiceMessage.getValue("TRANSMIT");
            if (string == null) {
                return;
            }
            this.sb.messagePerformed(new IMessageEvent(this, 1001, string + " von " + String.valueOf(serviceEvent.getSource())));
            if (string.equals("SetView")) {
                String string2 = kafPlotServiceMessage.getValue("CONTENT");
                if (string2 == null) {
                    return;
                }
                StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
                try {
                    double d = new Double(stringTokenizer.nextToken());
                    double d2 = new Double(stringTokenizer.nextToken());
                    KafPlotProperties.setGrafikCenter(new DPoint(d, d2));
                    double d3 = new Double(stringTokenizer.nextToken());
                    KafPlotProperties.setGrafikRotation(d3);
                    double d4 = new Double(stringTokenizer.nextToken());
                    KafPlotProperties.setGrafikZoom(d4);
                    double d5 = new Double(stringTokenizer.nextToken());
                    KafPlotProperties.setEllipseZoom(d5);
                    this.gp.setViewOfProperties();
                    this.gp.repaint();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void packetRequested(ServiceEvent serviceEvent) {
    }

    private boolean readFiles(FileSelector fileSelector) {
        IProgressDialog iProgressDialog;
        File[] fileArray;
        File file;
        int n;
        boolean bl;
        block9: {
            block10: {
                bl = false;
                if (fileSelector.hasKafFile()) {
                    File file2 = fileSelector.getKafFile();
                    if (this.endProjekt() && this.openProject(file2.getAbsolutePath())) {
                        DataBase.isSaved = true;
                        bl = true;
                    }
                }
                n = -1;
                file = null;
                if (!fileSelector.hasGeoFiles()) break block9;
                fileArray = fileSelector.getGeoFiles();
                if (!fileSelector.geoMultiHomogen()) break block10;
                GeoFileReader geoFileReader = new GeoFileReader((IFrame)this, "Importieren", this.db, fileArray, false);
                if (geoFileReader.isCanceled()) break block9;
                geoFileReader.read();
                if (geoFileReader.isAborted()) break block9;
                n = geoFileReader.getKooSystem();
                file = fileArray[0];
                bl = true;
                break block9;
            }
            for (int i = 0; i < fileArray.length && !((GeoFileReader)(iProgressDialog = new GeoFileReader((IFrame)this, "Importieren", this.db, fileArray[i]))).isCanceled(); ++i) {
                ((GeoFileReader)iProgressDialog).read();
                if (((GeoFileReader)iProgressDialog).isAborted()) continue;
                n = ((GeoFileReader)iProgressDialog).getKooSystem();
                if (file == null) {
                    file = fileArray[i];
                }
                bl = true;
            }
        }
        if (fileSelector.hasImgFiles()) {
            fileArray = fileSelector.getImgFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                iProgressDialog = new ImageReader((IFrame)this, "Bild laden", this.db, fileArray[i]);
                iProgressDialog.setVisible(true);
                if (n != -1) {
                    n = ((ImageReader)iProgressDialog).getKooSystem();
                }
                if (file == null) {
                    file = fileArray[i];
                }
                bl = true;
            }
        }
        if (bl) {
            this.db.setArea(n);
            DataBase.update(file);
            KafPlotProperties.init(this.db);
            this.sb.setText();
            this.setTitle();
            this.setCommandInput();
            this.gp.setView(this.db);
            this.gp.repaint();
            this.checkLizenz();
        }
        return bl;
    }

    protected void interpreteCommand(String string, boolean bl) {
        System.out.println("Command: " + string);
        int n = string.indexOf("(");
        int n2 = string.indexOf(")");
        String string2 = null;
        String string3 = null;
        if (n > 0 && n2 > n) {
            string2 = string.substring(0, n).toUpperCase();
            string3 = string.substring(n + 1, n2);
        } else {
            string2 = string.toUpperCase();
        }
        if (string2.equalsIgnoreCase("OPEN") && string3 != null && string3.length() > 0) {
            this.openProject(string3);
        } else if (string2.equalsIgnoreCase("READ") && string3 != null && string3.length() > 0) {
            DataBase.setWork(true);
            File file = new File(string3);
            GeoFileReader geoFileReader = new GeoFileReader((IFrame)this, "Importieren", this.db, file, true);
            geoFileReader.read();
            if (!geoFileReader.isAborted()) {
                DataBase.update(file);
                this.gp.setView(this.db);
                KafPlotProperties.init(this.db);
            }
            this.checkLizenz();
        } else if (string2.equalsIgnoreCase("IMG") && string3 != null && string3.length() > 0) {
            ImageReader imageReader = new ImageReader((IFrame)this, "Bild laden", this.db, new File(string3));
            imageReader.setVisible(true);
        } else if (string2.equalsIgnoreCase("WRITE") && string3 != null && string3.length() > 0) {
            String string4 = null;
            String string5 = null;
            if (string3.lastIndexOf(".") >= 0) {
                string4 = string3.substring(0, string3.lastIndexOf("."));
                string5 = string3.substring(string3.lastIndexOf(".") + 1);
            } else {
                KafPlot kafPlot = this;
                string4 = kafPlot.db.getSourceName();
                string5 = string3;
            }
            GeoFileWriterDialog geoFileWriterDialog = new GeoFileWriterDialog(this, "Exportieren", this.db, string4, string5, true);
        } else if (string2.equalsIgnoreCase("NAS_EXPORT")) {
            NasExportDialog nasExportDialog = new NasExportDialog(this, "NAS-Export", this.db, DataBase.antrag, true);
        } else if (string2.equalsIgnoreCase("PROP") && string3 != null && string3.length() > 0) {
            Properties properties = new Properties();
            int n3 = Math.max(string3.indexOf(":"), string3.indexOf("="));
            properties.put(string3.substring(0, n3).trim(), string3.substring(n3 + 1).trim());
            try {
                new PropertyLoader().readDefaultList(properties);
            }
            catch (IOException iOException) {}
        } else if (string2.equals("RELOAD")) {
            if (this.endProjekt()) {
                DataBase.setWork(true);
                KafPlot kafPlot = this;
                if (kafPlot.db.isInit()) {
                    int n4;
                    KafPlot kafPlot2 = this;
                    if (!kafPlot2.db.isEmpty()) {
                        KafPlot kafPlot3 = this;
                        v4 = kafPlot3.db.getKooSystem();
                    } else {
                        v4 = n4 = -9;
                    }
                    if (this.db.isKafkaSource()) {
                        KafPlot kafPlot4 = this;
                        KafkaReader kafkaReader = new KafkaReader((IFrame)this, "\u00d6ffnen", this.db, kafPlot4.db.getSourceFile());
                        this.db.clear(false);
                        kafkaReader.setVisible(true);
                        KafPlot kafPlot5 = this;
                        kafPlot5.db.update();
                    } else {
                        KafPlot kafPlot6 = this;
                        GeoFileReader geoFileReader = new GeoFileReader((IFrame)this, "Importieren", this.db, kafPlot6.db.getSourceFile());
                        if (!geoFileReader.isCanceled()) {
                            this.db.clear(false);
                            geoFileReader.read();
                            KafPlot kafPlot7 = this;
                            kafPlot7.db.update();
                        }
                    }
                    KafPlot kafPlot8 = this;
                    if (kafPlot8.db.getKooSystem() == n4) {
                        this.gp.setDataBase(this.db);
                    } else {
                        this.gp.setView(this.db);
                    }
                    KafPlotProperties.init(this.db);
                }
                DataBase.setWork(false);
                DataBase.isSaved = true;
            }
        } else if (string2.equalsIgnoreCase("CHECK")) {
            DataCheckDialog dataCheckDialog = new DataCheckDialog((IFrame)this, "Pr\u00fcfen", this.db, true);
        } else if (string2.equalsIgnoreCase("CLOSE")) {
            this.db.clear();
            DataBase.init(null);
            this.gp.setView(this.db);
        } else if (string2.equalsIgnoreCase("END")) {
            this.endSession();
        } else {
            System.out.println("Unbekanntes Kommando: " + string);
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void doCommand(int var1_1, Object var2_2, int var3_3) {
        switch (var1_1) {
            case 1: {
                if (!this.endProjekt()) break;
                this.db.clear();
                this.db.setArea(-1);
                this.gp.setView(this.db);
                break;
            }
            case 2: {
                if (!this.endProjekt()) break;
                DataBase.setWork(true);
                var4_4 = new FileDialog((Frame)this, "\u00d6ffnen", 0);
                v0 = this;
                var4_4.setDirectory(v0.db.getSourcePath());
                var4_4.setFile("*." + GeoFile.getFileTypExtension(103) + ";*." + GeoFile.getFileTypExtension(601) + ";*." + GeoFile.getFileTypExtension(602) + ";*." + GeoFile.getFileTypExtension(607));
                var4_4.setVisible(true);
                if (var4_4.getFile() != null) {
                    var5_59 = var4_4.getDirectory() + var4_4.getFile();
                    this.openProject(var5_59);
                }
                DataBase.setWork(false);
                DataBase.isSaved = true;
                break;
            }
            case 3: {
                var4_5 = new KafkaWriter((IFrame)this, "Speichern", this.db, DataBase.getDestFile(KafPlotVersion.isReaderVersion() != false ? "kpz" : "dat"));
                var4_5.setVisible(true);
                if (!var4_5.isCorrectSaved()) break;
                DataBase.isSaved = true;
                break;
            }
            case 4: {
                var4_6 = new StringBuffer("Speichern unter");
                v1 = this;
                if (v1.db.hasMenge()) {
                    var4_6.append(" (Menge)");
                }
                if ((var6_85 = (var5_60 = DataBase.getDestFile(null).getAbsolutePath()).indexOf(DatWriter.getFileVersionDelim())) >= 0 && IFormat.hasOnlyDigits(var5_60.substring(var6_85 + 1))) {
                    var5_60 = var5_60.substring(0, var6_85);
                }
                var6_85 = 0;
                while (new File(var5_60 + DatWriter.getFileVersionDelim() + ++var6_85 + ".dat").exists()) {
                }
                var7_95 = new KafkaWriterDialog((IFrame)this, var4_6.toString(), this.db, var5_60 + DatWriter.getFileVersionDelim() + var6_85 + ".dat");
                var7_95.setVisible(true);
                if (!var7_95.isCorrectSaved()) break;
                DataBase.isSaved = true;
                break;
            }
            case 10: {
                var4_7 = new DataCheckDialog((IFrame)this, "Pr\u00fcfen", this.db);
                var4_7.setActionCommand("_repaint");
                var4_7.addActionListener(this);
                var4_7.setVisible(true);
                break;
            }
            case 11: {
                if (DataBase.PLOTBOX != null) {
                    var4_8 = PrinterJob.getPrinterJob();
                    v2 = this;
                    if (v2.db.isInit()) {
                        v3 = this;
                        v4 = v3.db.getSourceName();
                    } else {
                        v4 = "KafPlot";
                    }
                    var4_8.setJobName(v4);
                    if (!var4_8.printDialog()) break;
                    var5_61 = new PrintPage(this.db);
                    var4_8.setPrintable(var5_61);
                    try {
                        var4_8.print();
                    }
                    catch (PrinterException var6_86) {
                        var6_86.printStackTrace();
                    }
                    break;
                }
                var4_9 = new ErrorDialog((IFrame)this, new Exception("Bitte erzeugen Sie zuerst eine Plotbox!"));
                var4_9.setVisible(true);
                break;
            }
            case 5: {
                if (!this.endProjekt()) break;
                if ((var3_3 & 1) == 1) {
                    try {
                        this.loadProperties();
                    }
                    catch (Exception var4_10) {
                        // empty catch block
                    }
                    if ((var3_3 & 2) != 0) {
                        KafPlotProperties.init(this.db);
                        this.gp.repaint();
                        break;
                    }
                }
                v5 = this;
                if (!v5.db.isInit()) break;
                DataBase.setWork(true);
                var4_11 = false;
                v6 = this;
                if (!v6.db.isEmpty()) {
                    v7 = this;
                    v8 = v7.db.getKooSystem();
                } else {
                    v8 = -9;
                }
                var5_62 = v8;
                v9 = this;
                var6_87 = v9.db.getSourceFile();
                if (this.db.isKafkaSource()) {
                    var7_96 = new KafkaReader((IFrame)this, "\u00d6ffnen", this.db, var6_87);
                    this.db.clear(false);
                    var7_96.setVisible(true);
                    var4_11 = true;
                } else {
                    var7_97 = new GeoFileReader((IFrame)this, "Importieren", this.db, var6_87);
                    if (!var7_97.isCanceled()) {
                        this.db.clear(false);
                        var7_97.read();
                        var4_11 = true;
                    }
                }
                if (var4_11) {
                    DataBase.init(var6_87);
                    v10 = this;
                    if (v10.db.getKooSystem() == var5_62) {
                        this.gp.setDataBase(this.db);
                    } else {
                        this.gp.setView(this.db);
                    }
                    KafPlotProperties.init(this.db);
                }
                DataBase.setWork(false);
                DataBase.isSaved = true;
                break;
            }
            case 6: {
                DataBase.setWork(true);
                var4_12 = new FileDialog((Frame)this, "Importieren", 0);
                v11 = this;
                var4_12.setDirectory(v11.db.getSourcePath());
                var4_12.setMultipleMode(true);
                var4_12.setFile("*.*");
                var4_12.setVisible(true);
                var5_63 = new FileSelector(this);
                var5_63.add(var4_12.getFiles());
                this.readFiles(var5_63);
                DataBase.setWork(false);
                break;
            }
            case 7102: {
                if (this.gp == null) break;
                v12 = this;
                if (v12.db.isEmpty()) break;
                if (this.readMengeDialog == null || !this.readMengeDialog.isVisible()) {
                    this.readMengeDialog = new ReadMengeDialog((IFrame)this, "Menge aus Datei", DataBase.MENGE);
                    this.readMengeDialog.setModal(false);
                    this.readMengeDialog.setActionCommand("_repaint_menge");
                    this.readMengeDialog.addActionListener(this);
                    this.readMengeDialog.addMessageListener(this.sb);
                    this.readMengeDialog.setVisible(true);
                    break;
                }
                this.readMengeDialog.setVisible(true);
                this.readMengeDialog.toFront();
                this.readMengeDialog.requestFocus();
                break;
            }
            case 8: {
                var5_64 = new FileDialog((Frame)this, "Bild laden", 0);
                v13 = this;
                var5_64.setDirectory(v13.db.getSourcePath());
                var5_64.setMultipleMode(true);
                var5_64.setFile("*.gif;*.jpg;*.tif;*.bmp;*.pcx;*.png");
                var5_64.setVisible(true);
                var4_13 = var5_64.getFile();
                if (var4_13 == null) break;
                var6_88 = new ImageReader((IFrame)this, "Bild laden", this.db, var5_64.getFiles());
                var6_88.setVisible(true);
                var7_98 = (GeoImage)DataBase.IMG.lastElement();
                KafPlotProperties.setGrafikRotation(-var7_98.getImageLocation().getAngle());
                this.db.setArea(var6_88.getKooSystem());
                this.gp.setView(this.db);
                this.gp.repaint();
                break;
            }
            case 7: {
                v14 = this;
                if (v14.db.isEmpty()) break;
                var4_14 = new StringBuffer("Exportieren");
                v15 = this;
                if (v15.db.hasMenge()) {
                    var4_14.append(" (Menge)");
                }
                v16 = this;
                var5_65 = new GeoFileWriterDialog((IFrame)this, var4_14.toString(), this.db, v16.db.getSourceName());
                var5_65.setVisible(true);
                break;
            }
            case 28: {
                if (this.kafEdit == null) {
                    this.kafEdit = new KafEdit(this.db);
                }
                this.kafEdit.setVisible(true);
                break;
            }
            case 20: 
            case 10020: {
                try {
                    var4_15 = false;
                    v17 = this;
                    var5_66 = new ClipTransfer(v17.db.hasMenge() ? DataBase.MENGE : this.gp.getCommandObject(), var1_1 == 10020);
                    this.getToolkit().getSystemClipboard().setContents(var5_66, null);
                    this.sb.messagePerformed(new IMessageEvent(this, 1001, var5_66.getMessage()));
                }
                catch (Exception var4_16) {}
                break;
            }
            case 960: {
                try {
                    var4_17 = new ClipTransfer(this.gp.getMarkObject(), false);
                    this.getToolkit().getSystemClipboard().setContents(var4_17, null);
                    this.sb.messagePerformed(new IMessageEvent(this, 1001, var4_17.getMessage()));
                }
                catch (Exception var4_18) {}
                break;
            }
            case 21: {
                try {
                    var4_19 = this.getToolkit().getSystemClipboard().getContents(this);
                    var5_67 = new StringBuffer();
                    if (var4_19 == null) break;
                    if (var4_19.isDataFlavorSupported(DataFlavor.imageFlavor)) {
                        try {
                            var6_89 = var4_19.getTransferData(DataFlavor.imageFlavor);
                            var7_99 = (BufferedImage)var6_89;
                            var8_102 = Jimi.createRasterImage(var7_99.getSource());
                            var9_106 = new GeoImage(var8_102, "Zwischenablage");
                            DataBase.addImage(var9_106);
                            var5_67.append(var9_106.toString() + " eingef\u00fcgt");
                        }
                        catch (Exception var6_90) {
                            var5_67.append("Zwischenablage konnte nicht eingef\u00fcgt werden");
                        }
                        this.gp.repaint();
                    } else {
                        var6_91 = 0;
                        var7_100 = 0;
                        var8_103 = 0;
                        try {
                            var9_107 = new StringTokenizer((String)var4_19.getTransferData(DataFlavor.stringFlavor), "\n");
                            while (var9_107.hasMoreTokens()) {
                                try {
                                    var10_110 = (Punkt)DataBase.P.put(PdkReader.stringToPunkt(var9_107.nextToken()));
                                    if (var10_110 == null) {
                                        ++var6_91;
                                        continue;
                                    }
                                    ++var7_100;
                                }
                                catch (Exception var10_111) {
                                    ++var8_103;
                                }
                            }
                        }
                        catch (Exception var9_108) {
                            // empty catch block
                        }
                        v18 = this;
                        v18.db.update();
                        this.db.setArea(-9);
                        this.gp.setView(this.db);
                        if (var6_91 > 0) {
                            var5_67.append(var6_91 + " neue");
                        }
                        if (var6_91 == 1) {
                            var5_67.append("r");
                        }
                        if (var7_100 > 0) {
                            if (var6_91 > 0) {
                                var5_67.append(", ");
                            }
                            var5_67.append(var7_100 + " vorhandene");
                            if (var7_100 == 1) {
                                var5_67.append("r");
                            }
                        }
                        if (var6_91 + var7_100 > 0) {
                            var5_67.append(" Punkt");
                            if (var6_91 + var7_100 > 1) {
                                var5_67.append("e");
                            }
                            var5_67.append(" eingef\u00fcgt");
                        }
                        if (var8_103 > 0) {
                            if (var6_91 + var7_100 > 0) {
                                var5_67.append(", ");
                            }
                            var5_67.append(var8_103 + " Zeile");
                            if (var8_103 > 1) {
                                var5_67.append("n");
                            }
                            var5_67.append(" ignoriert");
                        }
                    }
                    this.sb.messagePerformed(new IMessageEvent(this, 1001, var5_67.toString()));
                }
                catch (Exception var4_20) {}
                break;
            }
            case 1051: {
                var4_21 = this.gp.getCommandObject();
                if (var4_21 == null) break;
                if (var4_21 instanceof Identitaet) {
                    var5_68 = (Identitaet)var4_21;
                    this.gp.deleteCommandObject();
                    if (var5_68.getOperation() == 0) {
                        var5_68.setOperation(3);
                    }
                    this.gp.repaint(((Identitaet)var4_21).getBounds());
                    DataBase.isSaved = false;
                    this.sb.messagePerformed(new IMessageEvent(this, 1001, "Identit\u00e4t zur\u00fcckgesetzt"));
                    break;
                }
                if (!(var4_21 instanceof PunktMove)) break;
                var5_69 = (PunktMove)var4_21;
                this.gp.deleteCommandObject();
                if (var5_69.getOperation() == 0) {
                    var5_69.setOperation(3);
                }
                this.gp.repaint(((PunktMove)var4_21).getBounds());
                DataBase.isSaved = false;
                this.sb.messagePerformed(new IMessageEvent(this, 1001, "Punkverschiebung zur\u00fcckgesetzt"));
                break;
            }
            case 1050: {
                var4_22 = 0;
                var5_70 = "";
                var6_92 = "";
                v19 = this;
                if (v19.db.hasMenge()) {
                    var7_101 = DataBase.MENGE.elements();
                    while (var7_101.hasMoreElements()) {
                        var8_104 = (Punkt)var7_101.nextElement();
                        if (var8_104.isUsed()) continue;
                        ++var4_22;
                    }
                    if (var4_22 > 0) {
                        var7_101 = new IQuestionDialog(this, "Punkte l\u00f6schen", "Die Menge enth\u00e4lt " + var4_22 + " l\u00f6schbare Punkte.\nWirklich l\u00f6schen?", 1, false);
                        var7_101.setVisible(true);
                        if (var7_101.getAnswer() == 3) {
                            var8_104 = DataBase.MENGE.elements();
                            while (var8_104.hasMoreElements()) {
                                var9_109 = (Punkt)var8_104.nextElement();
                                if (var9_109.isUsed()) continue;
                                DataBase.P.remove(var9_109.nr);
                                DataBase.MENGE.remove(var9_109);
                                ++var4_22;
                            }
                            DataBase.isSaved = false;
                        } else {
                            var4_22 = 0;
                        }
                    }
                    this.gp.deleteCommandObject();
                    this.gp.repaint();
                    var5_70 = "Punkt";
                    var6_92 = "Punkte";
                } else {
                    var7_101 = this.gp.getCommandObject();
                    if (var7_101 != null) {
                        if (var7_101 instanceof Punkt) {
                            var5_70 = "Punkt";
                            var6_92 = "Punkte";
                            var8_105 = (Punkt)var7_101;
                            if (!var8_105.isUsed()) {
                                DataBase.P.remove(var8_105.nr);
                                this.gp.deleteCommandObject();
                                this.gp.repaint(new DRectangle(var8_105.y - 5.0, var8_105.x - 5.0, 30.0, 10.0));
                                var4_22 = 1;
                                DataBase.isSaved = false;
                            }
                        } else if (var7_101 instanceof Identitaet) {
                            var5_70 = "Identit\u00e4t";
                            var6_92 = "Identit\u00e4ten";
                            this.db.removeIdentitaet((Identitaet)var7_101);
                            this.gp.deleteCommandObject();
                            this.gp.repaint(((Identitaet)var7_101).getBounds());
                            var4_22 = 1;
                            DataBase.isSaved = false;
                        } else if (var7_101 instanceof PunktMove) {
                            var5_70 = "Punktverschiebung";
                            var6_92 = "Punktverschiebungen";
                            this.db.removePunktMove((PunktMove)var7_101);
                            this.gp.deleteCommandObject();
                            this.gp.repaint(((PunktMove)var7_101).getBounds());
                            var4_22 = 1;
                            DataBase.isSaved = false;
                        }
                    }
                }
                var7_101 = new StringBuffer();
                if (var4_22 == 0) {
                    var7_101.append("Keine " + var6_92);
                } else if (var4_22 == 1) {
                    var7_101.append(var4_22 + " " + var5_70);
                } else {
                    var7_101.append(var4_22 + " " + var6_92);
                }
                var7_101.append(" gel\u00f6scht");
                this.sb.messagePerformed(new IMessageEvent(this, 1001, var7_101.toString()));
                break;
            }
            case 27: {
                break;
            }
            case 23: {
                v20 = this;
                if (v20.db.isEmpty()) break;
                v21 = this;
                if (!v21.db.isInit()) break;
                var4_23 = new TrafoFileReader((IFrame)this, "Etrs-Transformation", this.db, 162);
                var4_23.setVisible(true);
                v22 = this;
                v22.db.update();
                this.gp.setView(this.db);
                break;
            }
            case 24: {
                var4_24 = "Transformation";
                v23 = this;
                if (v23.db.hasMenge()) {
                    var4_24 = (String)var4_24 + " (Menge)";
                }
                var5_71 = new TrafoSysDialog((IFrame)this, "Transformation", this.db);
                var5_71.setVisible(true);
                this.gp.setView(this.db);
                this.gp.repaint();
                break;
            }
            case 12: {
                if (!this.endProjekt()) break;
                this.db.clear();
                this.gp.setView(this.db);
                break;
            }
            case 7003: {
                if (this.searchWwwDialog == null || !this.searchWwwDialog.isVisible()) {
                    this.searchWwwDialog = new SearchWwwDialog(this, "suche im WWW");
                    this.searchWwwDialog.setActionCommand("_search_www");
                    this.searchWwwDialog.addActionListener(this);
                    this.searchWwwDialog.setVisible(true);
                    break;
                }
                this.searchWwwDialog.setVisible(true);
                this.searchWwwDialog.toFront();
                this.searchWwwDialog.requestFocus();
                break;
            }
            case 8923: {
                v24 = this;
                if (v24.db.isEmpty() || this.searchWwwDialog == null) break;
                var4_25 = this.searchWwwDialog.getResult();
                if (var4_25 != null && var4_25.hasLocation()) {
                    this.gp.centerOfPunkt(var4_25.y, var4_25.x);
                }
                this.gp.setMarkObject(var4_25);
                break;
            }
            case 30: {
                v25 = this;
                if (v25.db.isEmpty()) break;
                var4_26 = "Kataster-Nachweis";
                v26 = this;
                if (v26.db.hasMenge()) {
                    var4_26 = (String)var4_26 + " (Menge)";
                }
                v27 = this;
                var5_72 = new KatasternachweisDialog((IFrame)this, (String)var4_26, this.db, v27.db.getDestName());
                var5_72.setVisible(true);
                break;
            }
            case 31: {
                v28 = this;
                if (v28.db.isEmpty()) break;
                v29 = this;
                var4_27 = new FortfuehrungDialog((IFrame)this, "Fortf\u00fchrungsbeleg", this.db, v29.db.getDestName());
                var4_27.setVisible(true);
                break;
            }
            case 32: {
                v30 = this;
                if (v30.db.isEmpty()) break;
                var4_28 = new NasExportDialog((IFrame)this, "NAS-Export", this.db, DataBase.antrag);
                var4_28.setVisible(true);
                break;
            }
            case 33: {
                v31 = this;
                if (v31.db.isEmpty()) break;
                v32 = this;
                var4_29 = new VeraenderungDialog((IFrame)this, "Ver\u00e4nderungsliste", this.db, v32.db.getDestName());
                var4_29.setVisible(true);
                break;
            }
            case 34: {
                v33 = this;
                if (v33.db.isEmpty()) break;
                v34 = this;
                var4_30 = new EinrechnungDialog((IFrame)this, "Einrechnungsliste", this.db, v34.db.getDestName());
                var4_30.setVisible(true);
                break;
            }
            case 35: {
                v35 = this;
                if (v35.db.isEmpty()) break;
                v36 = this;
                var4_31 = new FlaechenbelegDialog((IFrame)this, "Fl\u00e4chenbeleg", this.db, v36.db.getDestName());
                var4_31.setVisible(true);
                break;
            }
            case 36: {
                v37 = this;
                if (v37.db.isEmpty()) break;
                v38 = this;
                var4_32 = new BestandbelegDialog((IFrame)this, "Eigent\u00fcmernachweis", this.db, v38.db.getDestName());
                var4_32.setVisible(true);
                break;
            }
            case 37: {
                v39 = this;
                if (v39.db.isEmpty()) break;
                v40 = this;
                var4_33 = new StatistikbelegDialog((IFrame)this, "Statistikbeleg", this.db, v40.db.getDestName());
                var4_33.setVisible(true);
                break;
            }
            case 38: {
                v41 = this;
                if (v41.db.isEmpty()) break;
                v42 = this;
                var4_34 = new ObjectListDialog((IFrame)this, "Objektliste", this.db, v42.db.getDestName());
                var4_34.setVisible(true);
                break;
            }
            case 39: {
                v43 = this;
                if (v43.db.isEmpty()) break;
                v44 = this;
                var4_35 = new MessageListDialog((IFrame)this, "Fehlerstapel", this.db, v44.db.getDestName());
                var4_35.setVisible(true);
                break;
            }
            case 40: {
                v45 = this;
                if (v45.db.isEmpty()) break;
                v46 = this;
                var4_36 = new ViewerWriterDialog((IFrame)this, "Viewer-Daten", this.db, v46.db.getDestName());
                var4_36.setVisible(true);
                break;
            }
            case 41: {
                v47 = this;
                if (v47.db.isEmpty()) break;
                v48 = this;
                var4_37 = new SystraExportDialog((IFrame)this, "Systra-Projekt", this.db, v48.db.getDestName());
                var4_37.setVisible(true);
                break;
            }
            case 70: {
                var4_38 = new LoadWmsDialog((IFrame)this, "WMS verbinden", this.db);
                var4_38.setVisible(true);
                if (KafPlotProperties.getViewport() == null) ** GOTO lbl596
                v49 = this;
                if (v49.db.getState() > 1) ** GOTO lbl597
lbl596:
                // 2 sources

                this.gp.setView(this.db);
lbl597:
                // 2 sources

                this.gp.repaint();
                break;
            }
            case 71: {
                var4_39 = "127.0.0.1";
                try {
                    var4_39 = InetAddress.getLocalHost().getHostAddress();
                }
                catch (Exception var5_73) {
                    // empty catch block
                }
                var5_74 = new GetServicePortDialog((IFrame)this, "WmsService", "http://" + var4_39);
                var5_74.setVisible(true);
                var6_93 = var5_74.getPort();
                if (var6_93 < 0) break;
                this.startService("WMS:" + var6_93);
                break;
            }
            case 72: {
                if (this.wms == null) break;
                try {
                    this.wms.interrupt();
                    this.wms.stop();
                    this.wms.close();
                    this.wms = null;
                    KafPlotProperties.setWmsPort(-1);
                }
                catch (Exception var4_40) {
                    var5_75 = new ErrorDialog((IFrame)this, var4_40);
                    var5_75.setVisible(true);
                }
                break;
            }
            case 73: {
                var4_41 = this.gp.getCommandObject();
                if (var4_41 == null || !(var4_41 instanceof WmsGeoImage)) break;
                var5_76 = (WmsGeoImage)var4_41;
                var5_76.query(this.gp.getMousePoint());
                break;
            }
            case 74: {
                var4_42 = this.gp.getCommandObject();
                if (var4_42 == null || !(var4_42 instanceof WmsGeoImage)) break;
                var5_77 = new WmsSaveDialog((IFrame)this, "WMS speichern", this.db, (WmsGeoImage)var4_42);
                var5_77.setVisible(true);
                break;
            }
            case 80: {
                var4_43 = new LoadKpsDialog((IFrame)this, "KafPlotService verbinden", this.db, "230.0.0.1");
                var4_43.addServiceListener(this);
                var4_43.setVisible(true);
                break;
            }
            case 81: {
                var4_44 = new GetServicePortDialog((IFrame)this, "KafPlotService", "230.0.0.1");
                var4_44.setVisible(true);
                var5_78 = var4_44.getPort();
                if (var5_78 < 0) break;
                this.startService("KPS:" + var5_78);
                break;
            }
            case 82: {
                if (this.kps != null) {
                    var4_45 = new KafPlotServiceMessage();
                    var4_45.append("CONNECTION", "End");
                    this.kps.addMessage(var4_45);
                    this.kps = null;
                }
                KafPlotProperties.setKpsPort(-1);
                break;
            }
            case 61: {
                v50 = this;
                if (v50.db.isEmpty()) break;
                v51 = this;
                var4_46 = new CreateTrafoDialog((IFrame)this, "Digitalisierung erzeugen" + (v51.db.hasMenge() != false ? " (Menge)" : ""), this.db);
                var4_46.addActionListener(this);
                var4_46.setVisible(true);
                break;
            }
            case 62: {
                v52 = this;
                if (v52.db.isEmpty()) break;
                var4_47 = new CreateBedingungenDialog((IFrame)this, "Bedingungen erzeugen", this.db);
                var4_47.addActionListener(this);
                var4_47.setVisible(true);
                break;
            }
            case 63: {
                v53 = this;
                if (v53.db.isEmpty()) break;
                v54 = this;
                var4_48 = new CreateLgaDialog((IFrame)this, "Lagegenauigkeitsstufe erzeugen" + (v54.db.hasMenge() != false ? " (Menge)" : ""), this.db);
                var4_48.addActionListener(this);
                var4_48.setVisible(true);
                break;
            }
            case 64: {
                v55 = this;
                if (v55.db.isEmpty()) break;
                var4_49 = new ReweightMessungDialog((IFrame)this, "Katasternachweis umgewichten", this.db);
                var4_49.addActionListener(this);
                var4_49.setVisible(true);
                break;
            }
            case 65: {
                v56 = this;
                if (v56.db.isEmpty()) break;
                var4_50 = new SearchNearPointsDialog((IFrame)this, "Doppelte Punkte suchen", this.db);
                var4_50.addActionListener(this);
                var4_50.setVisible(true);
                break;
            }
            case 66: {
                v57 = this;
                if (v57.db.isEmpty()) break;
                var4_51 = new CreatePointRasterDialog((IFrame)this, "Punktraster erzeugen", this.db);
                var4_51.addActionListener(this);
                var4_51.setVisible(true);
                break;
            }
            case 67: {
                v58 = this;
                if (v58.db.isEmpty()) break;
                var4_52 = new UmnumPointsDialog((IFrame)this, "Punkte umnummerieren", this.db);
                var4_52.addActionListener(this);
                var4_52.setVisible(true);
                break;
            }
            case 90: {
                var4_53 = new InfoDialog(this, "Info ");
                var4_53.setVisible(true);
                break;
            }
            case 91: {
                var4_54 = DataBase.model.getModel() == 2 ? KafPlotProperties.helpCommandV2 : KafPlotProperties.helpCommandV1;
                try {
                    var5_79 = Runtime.getRuntime().exec(var4_54);
                }
                catch (Exception var5_80) {
                    var6_94 = new ErrorDialog((IFrame)this, new IException("Starten des Standardbrowsers fehlgeschlagen!\nAufruf: " + var4_54 + "\n\u00dcberpr\u00fcfen Sie die Einstellungen in der Datei kafplot.properties"));
                    var6_94.setVisible(true);
                }
                break;
            }
            case 7201: {
                if (DataBase.PLOTBOX == null) break;
                this.gp.deletePlotbox(DataBase.PLOTBOX);
                DataBase.PLOTBOX = null;
                break;
            }
            case 8803: {
                v59 = this;
                this.mainMenu.setPlotboxEnabled(v59.db.hasPlotbox());
                break;
            }
            case 691: {
                if (this.inputRissDialog == null) {
                    this.inputRissDialog = new InputRissDialog(this, "Riss");
                }
                this.inputRissDialog.setVisible(true);
                break;
            }
            case 680: {
                var4_55 = this.gp.getCommandObject();
                if (var4_55 == null || !(var4_55 instanceof Punkt)) break;
                var5_81 = (Punkt)var4_55;
                if (this.insertTrafoDialog == null) {
                    this.insertTrafoDialog = new InsertTrafoDialog(this, "Transformation einf\u00fcgen");
                }
                this.insertTrafoDialog.setPunkt(var5_81);
                this.insertTrafoDialog.setVisible(true);
                this.gp.repaint(var5_81.getBounds());
                if (this.insertTrafoDialog.getTrafoPunkt() == null) break;
                DataBase.isSaved = false;
                break;
            }
            case 949: {
                var4_56 = this.gp.getCommandObject();
                if (!(var4_56 instanceof Punkt) || var4_56 == null) break;
                var5_82 = (Punkt)var4_56;
                if (this.punktAttDialog == null || !this.punktAttDialog.isVisible()) {
                    this.punktAttDialog = new PunktAttDialog((IFrame)this, "Punktattribute", var5_82);
                    this.punktAttDialog.setModal(false);
                    this.punktAttDialog.addObjectListener(this);
                    this.punktAttDialog.setVisible(true);
                    break;
                }
                this.punktAttDialog.setObject(var5_82);
                break;
            }
            case 940: 
            case 941: 
            case 942: 
            case 943: 
            case 944: 
            case 945: 
            case 946: {
                var4_57 = false;
                v60 = this;
                if (v60.db.hasMenge()) {
                    var5_83 = new IQuestionDialog(this, "Punktstatus \u00e4ndern?", "Die Menge enth\u00e4lt " + DataBase.MENGE.size() + " Punkte, Punktstatus \u00e4ndern?", 1, false);
                    var5_83.setVisible(true);
                    v61 = var4_57 = var5_83.getAnswer() == 3;
                }
                if (var4_57) {
                    var5_83 = DataBase.MENGE.elements();
                    while (var5_83.hasMoreElements()) {
                        ((Punkt)var5_83.nextElement()).setPsOfCommand(var1_1);
                    }
                    this.gp.repaint();
                    DataBase.isSaved = false;
                    break;
                }
                var5_83 = this.gp.getCommandObject();
                if (var5_83 == null || !(var5_83 instanceof Punkt)) break;
                ((Punkt)var5_83).setPsOfCommand(var1_1);
                this.gp.repaint(((Punkt)var5_83).getBounds());
                DataBase.isSaved = false;
                break;
            }
            case 951: 
            case 952: 
            case 953: 
            case 954: {
                var4_58 = this.gp.getCommandObject();
                if (var4_58 == null || !(var4_58 instanceof ErrorObject)) break;
                var5_84 = (ErrorObject)var4_58;
                if (var1_1 == 951) {
                    var5_84.setType((byte)3);
                } else if (var1_1 == 952) {
                    var5_84.setType((byte)2);
                } else if (var1_1 == 953) {
                    var5_84.setType((byte)1);
                } else if (var1_1 == 954) {
                    var5_84.setType((byte)99);
                }
                this.gp.repaint(var5_84.getBounds());
                break;
            }
            default: {
                super.doCommand(var1_1, var2_2, var3_3);
            }
        }
    }

    @Override
    protected IButton createIButton(int n, String string) {
        IButton iButton = super.createIButton(n, string);
        iButton.setToolTipText(string);
        return iButton;
    }

    @Override
    protected ICheckboxButton createICheckboxButton(int n, String string, boolean bl) {
        ICheckboxButton iCheckboxButton = super.createICheckboxButton(n, string, bl);
        iCheckboxButton.setToolTipText(string);
        return iCheckboxButton;
    }

    @Override
    protected ICheckboxButton createICheckboxButton(int n, String string, ICheckboxButtonGroup iCheckboxButtonGroup) {
        ICheckboxButton iCheckboxButton = super.createICheckboxButton(n, string, iCheckboxButtonGroup);
        iCheckboxButton.setToolTipText(string);
        return iCheckboxButton;
    }

    private void checkLizenz() {
        if (KafPlotVersion.isTestVersion()) {
            InfoDialog infoDialog = new InfoDialog(this, "Lizenz-Check", false);
            infoDialog.setVisible(true);
            LizenzTimer lizenzTimer = new LizenzTimer(this, infoDialog, 120000L);
            lizenzTimer.start();
        }
    }

    protected boolean endProjekt() {
        if (!DataBase.isSaved) {
            KafPlot kafPlot = this;
            IQuestionDialog iQuestionDialog = new IQuestionDialog((IFrame)this, "Schlie\u00dfen", "Das Projekt " + kafPlot.db.getSourceName() + " wurde ver\u00e4ndert.\n\u00c4nderungen jetzt speichern?");
            iQuestionDialog.setVisible(true);
            if (iQuestionDialog.getAnswer() == 3) {
                this.doCommand(3, null, 0);
            } else if (iQuestionDialog.getAnswer() == 1) {
                return false;
            }
        }
        KafPlot kafPlot = this;
        if (kafPlot.db.isInit()) {
            this.saveProjectProperties();
        }
        this.saveImageProperties();
        return true;
    }

    @Override
    protected void endSession() {
        if (this.endProjekt()) {
            if (this.kps != null) {
                KafPlotServiceMessage kafPlotServiceMessage = new KafPlotServiceMessage();
                kafPlotServiceMessage.append("CONNECTION", "End");
                this.kps.addMessage(kafPlotServiceMessage);
                this.kps = null;
            }
            System.exit(0);
        }
    }

    private File getPropertiesFile() {
        return DataBase.getSourceFile(".properties");
    }

    private void saveProjectProperties() {
        try {
            File file = this.getPropertiesFile();
            if (!file.getName().equalsIgnoreCase("kafplot.properties")) {
                String string = KafPlotProperties.themeName;
                KafPlotProperties.themeName = "DEFAULT";
                KafPlotProperties.save(new FileOutputStream(file), "KafPlot-Einstellungen");
                KafPlotProperties.themeName = string;
            }
        }
        catch (Exception exception) {
            return;
        }
    }

    private void saveImageProperties() {
        try {
            Enumeration enumeration = DataBase.IMG.elements();
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                if (e instanceof WmsGeoImage) continue;
                ((GeoImage)e).saveProperties();
            }
        }
        catch (Exception exception) {
            return;
        }
    }

    private void loadProjectProperties() {
        try {
            KafPlotProperties.load(new FileInputStream(this.getPropertiesFile()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setLayoutOfProperties();
    }

    @Override
    protected void setCommandInput() {
        KafPlot kafPlot = this;
        int n = kafPlot.db.getState();
        switch (n) {
            case -1: {
                this.mainMenu.setState(-1);
                break;
            }
            case 0: 
            case 1: {
                this.mainMenu.setState(0);
                break;
            }
            case 2: {
                this.mainMenu.setState(1);
                break;
            }
            case 3: {
                this.mainMenu.setState(2);
            }
        }
        KafPlot kafPlot2 = this;
        this.mainMenu.setDataOutEnabled(kafPlot2.db.hasMenge());
        this.mainMenu.setDataInEnabled(n >= 0 && this.getToolkit().getSystemClipboard().getContents(this) != null);
        KafPlot kafPlot3 = this;
        this.mainMenu.setPlotboxEnabled(kafPlot3.db.hasPlotbox());
        if (this.markButton != null) {
            this.markButton.setEnabled(n > 0);
        }
        if (this.centerButton != null) {
            this.centerButton.setEnabled(n >= 0);
        }
        if (this.zoomButton != null) {
            this.zoomButton.setEnabled(n >= 0);
        }
        if (this.ezoomButton != null) {
            this.ezoomButton.setEnabled(n >= 0);
        }
        if (this.rulerButton != null) {
            this.rulerButton.setEnabled(n >= 0);
        }
        if (this.inputButton != null) {
            this.inputButton.setEnabled(n >= 0);
        }
        if (this.amountButton != null) {
            this.amountButton.setEnabled(n > 0);
        }
        if (this.plotclipButton != null) {
            this.plotclipButton.setEnabled(n > 0);
        }
        this.setLayoutOfProperties();
    }

    private boolean openProject(String string) {
        File file = new File(string);
        if (file.exists()) {
            if (!KafkaReader.isProjektFile(file)) {
                return false;
            }
        } else {
            if (!KafkaReader.isProjektName(string)) {
                return false;
            }
            file = new File(string + ".lt3");
            if (!file.exists()) {
                return false;
            }
        }
        this.db.clear();
        KafkaReader kafkaReader = new KafkaReader((IFrame)this, "\u00d6ffnen", this.db, file);
        kafkaReader.setVisible(true);
        DataBase.init(file);
        this.loadProjectProperties();
        this.gp.setView(this.db);
        this.sb.setText();
        this.checkLizenz();
        return true;
    }

    public void startService(String string) {
        block6: {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
            String string2 = stringTokenizer.nextToken();
            try {
                if (string2.equals("WMS")) {
                    this.wmsPort = Integer.parseInt(stringTokenizer.nextToken());
                    this.wms = new WebService("OGC:WMS", this.wmsPort, this);
                    KafPlotProperties.setWmsPort(this.wmsPort);
                    this.sb.messagePerformed(new IMessageEvent(this, 1001, "WebMapService auf Port " + this.wmsPort + " gestartet"));
                    break block6;
                }
                if (string2.equals("KPS")) {
                    this.kpsPort = Integer.parseInt(stringTokenizer.nextToken());
                    KafPlotProperties.setKpsPort(this.kpsPort);
                    try {
                        this.kps = new KafPlotServiceServer("230.0.0.1", this.kpsPort);
                    }
                    catch (Exception exception) {
                        KafPlotProperties.setKpsPort(-1);
                        throw exception;
                    }
                    this.sb.messagePerformed(new IMessageEvent(this, 1001, "KafPlotService auf Port " + this.kpsPort + " gestartet"));
                    break block6;
                }
                throw new Exception("Service " + string2 + " unbekannt");
            }
            catch (Exception exception) {
                ErrorDialog errorDialog = new ErrorDialog((IFrame)this, exception);
                errorDialog.setVisible(true);
            }
        }
    }

    @Override
    public Capability getCapability() throws Exception {
        this.sb.messagePerformed(new IMessageEvent(this, 1001, "WebMapService Anfrage: @getCapability"));
        if (this.db == null) {
            throw new Exception("Uninitialize KafPlotService");
        }
        KafPlot kafPlot = this;
        if (kafPlot.db.getKooSystem() != 489) {
            throw new Exception("KafPlotService has data with unsupported Spatial Reference System");
        }
        Capability capability = new Capability();
        capability.setOnlineResource(InetAddress.getLocalHost().getHostAddress(), this.wmsPort);
        int n = KoordinatenSystem.getZone(DataBase.ymin);
        double[] dArray = new double[2];
        double[] dArray2 = new double[2];
        KoordinatenSystem.UTMXYToLatLon(DataBase.ymin, DataBase.xmin, n, false, dArray);
        KoordinatenSystem.UTMXYToLatLon(DataBase.ymax, DataBase.xmax, n, false, dArray2);
        capability.sName = "OGC:WMS";
        capability.sTitle = "KafPlotMapServer";
        capability.sKeywords = "KafPlot";
        capability.sContactPersonPrimaryPerson = DataBase.bearbeiter;
        capability.sContactPersonPrimaryOrganization = DataBase.vermStelle;
        Srs srs = new Srs("EPSG:3258" + n);
        Srs srs2 = new Srs("EPSG:258" + n);
        capability.addSRS(srs);
        capability.addSRS(srs2);
        capability.addBox(new BoundingBox(srs, DataBase.ymin, DataBase.xmin, DataBase.ymax, DataBase.xmax));
        capability.addBox(new BoundingBox(srs2, DataBase.ymin % 1000000.0, DataBase.xmin, DataBase.ymax % 1000000.0, DataBase.xmax));
        capability.setBox(dArray[1], dArray[0], dArray2[1], dArray2[0]);
        capability.setScale(1.0E-4, 999999.0);
        Layer layer = new Layer("Punkte", "Katasterpunkte", "enth\u00e4lt alle Punkte der Liegenschaftskarte");
        layer.setScale(1.0E-4, 1.0);
        layer.setQueryable(true);
        layer.setOpaque(false);
        capability.addLayer(layer);
        layer = new Layer("Punktnummern", "Nummern der Katasterpunkte", "enth\u00e4lt alle Numern der Punktdatenbank");
        layer.setScale(1.0E-4, 1.0);
        layer.setQueryable(true);
        layer.setOpaque(false);
        capability.addLayer(layer);
        layer = new Layer("Messelemente", "Elemente des Kasternachweises", "enth\u00e4lt alle Messelemente des Katasternachweises");
        layer.setScale(1.0E-4, 0.2);
        layer.setQueryable(false);
        layer.setOpaque(false);
        capability.addLayer(layer);
        layer = new Layer("Messzahlen", "Zahlenwerk des Kasternachweises", "enth\u00e4lt alle Ma\u00dfzahlen des Katasternachweises");
        layer.setScale(1.0E-4, 1.0);
        layer.setQueryable(false);
        layer.setOpaque(false);
        capability.addLayer(layer);
        layer = new Layer("Flurstuecke", "Flurst\u00fccke", "stellt alle Flurst\u00fccke der Liegenschaftskarte dar");
        layer.setScale(1.0E-4, 999999.0);
        layer.setQueryable(true);
        layer.setOpaque(true);
        capability.addLayer(layer);
        layer = new Layer("Gebaeude", "Geb\u00e4ude", "stellt alle Geb\u00e4ude der Liegenschaftskarte dar");
        layer.setScale(1.0E-4, 999999.0);
        layer.setQueryable(false);
        layer.setOpaque(true);
        capability.addLayer(layer);
        layer = new Layer("Topographie", "Topographie", "stellt die Topographie der Liegenschaftskarte dar");
        layer.setScale(1.0E-4, 999999.0);
        layer.setQueryable(false);
        layer.setOpaque(true);
        capability.addLayer(layer);
        layer = new Layer("Nutzung", "Tats\u00e4chliche Nutzung", "stellt die tats\u00e4chliche Nutzung dar");
        layer.setScale(1.0E-4, 999999.0);
        layer.setQueryable(false);
        layer.setOpaque(true);
        capability.addLayer(layer);
        layer = new Layer("Lage", "Lagebezeichnungen", "stellt die Lagebezeichnungen der Flurst\u00fccke dar");
        layer.setScale(1.0E-4, 999999.0);
        layer.setQueryable(false);
        layer.setOpaque(true);
        capability.addLayer(layer);
        layer = new Layer("Eigentum", "Eigentum", "stellt die Eigentumsverh\u00e4ltnisse dar");
        layer.setScale(1.0E-4, 999999.0);
        layer.setQueryable(false);
        layer.setOpaque(true);
        capability.addLayer(layer);
        layer = new Layer("Gitter", "Koordinatengitter", "stellt das Koordinatengitter dar");
        layer.setScale(1.0E-4, 999999.0);
        layer.setQueryable(false);
        layer.setOpaque(false);
        capability.addLayer(layer);
        return capability;
    }

    private void createWmsSys(String string, String string2, String string3) {
        block12: {
            block15: {
                block13: {
                    block14: {
                        this.wms_ymin = DataBase.ymin;
                        this.wms_xmin = DataBase.xmin;
                        this.wms_ymax = DataBase.ymax;
                        this.wms_xmax = DataBase.xmax;
                        this.wms_width = 200;
                        this.wms_height = 200;
                        this.wms_m = 1.0;
                        if (string == null) break block12;
                        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                        if (stringTokenizer.hasMoreTokens()) {
                            this.wms_ymin = new Double(IFormat.removeSpaces(stringTokenizer.nextToken()));
                        }
                        if (stringTokenizer.hasMoreTokens()) {
                            this.wms_xmin = new Double(IFormat.removeSpaces(stringTokenizer.nextToken()));
                        }
                        if (stringTokenizer.hasMoreTokens()) {
                            this.wms_ymax = new Double(IFormat.removeSpaces(stringTokenizer.nextToken()));
                        }
                        if (stringTokenizer.hasMoreTokens()) {
                            this.wms_xmax = new Double(IFormat.removeSpaces(stringTokenizer.nextToken()));
                        }
                        if (!(this.wms_ymin < 1000000.0)) break block13;
                        KafPlot kafPlot = this;
                        if (kafPlot.db.getKooSystem() == 489) break block14;
                        KafPlot kafPlot2 = this;
                        if (kafPlot2.db.getKooSystem() != 150) break block13;
                    }
                    this.wms_ymin += (double)((int)DataBase.ymin / 1000000) * 1000000.0;
                }
                if (!(this.wms_ymax < 1000000.0)) break block12;
                KafPlot kafPlot = this;
                if (kafPlot.db.getKooSystem() == 489) break block15;
                KafPlot kafPlot3 = this;
                if (kafPlot3.db.getKooSystem() != 150) break block12;
            }
            this.wms_ymax += (double)((int)DataBase.ymax / 1000000) * 1000000.0;
        }
        if (string2 != null) {
            this.wms_width = Integer.parseInt(string2);
        }
        if (string3 != null) {
            this.wms_height = Integer.parseInt(string3);
        }
        double d = (double)this.wms_width / (this.wms_ymax - this.wms_ymin);
        double d2 = (double)this.wms_height / (this.wms_xmax - this.wms_xmin);
        this.wms_m = (d + d2) / 2.0;
    }

    @Override
    public Map getMap(String string, String string2, String string3, String string4, String string5, String string6) throws Exception {
        Object object;
        this.sb.messagePerformed(new IMessageEvent(this, 1001, "WebMapService Anfrage: @GetMap " + string));
        this.createWmsSys(string, string2, string3);
        boolean bl = string5 != null && string5.toLowerCase().equals("true");
        Color color = Color.white;
        try {
            if (string6 != null) {
                color = new Color(Integer.parseInt(string6.toLowerCase().substring(2), 16));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        double d = (double)this.wms_width / 2.0;
        double d2 = (double)this.wms_height / 2.0;
        double d3 = (this.wms_xmax + this.wms_xmin) / 2.0;
        double d4 = (this.wms_ymax + this.wms_ymin) / 2.0;
        Image image = this.createImage(this.wms_width, this.wms_height);
        GeoTransform geoTransform = new GeoTransform(-d4, -d3, d2, d, 0.0, this.wms_m);
        Rectangle rectangle = new Rectangle(0, 0, this.wms_width, this.wms_height);
        IGraphics iGraphics = new IGraphics(image.getGraphics(), geoTransform, rectangle);
        if (string4 != null) {
            object = new StringTokenizer(string4, ",");
            Hashtable<String, Boolean> hashtable = new Hashtable<String, Boolean>();
            Boolean bl2 = new Boolean(true);
            while (((StringTokenizer)object).hasMoreTokens()) {
                hashtable.put(((StringTokenizer)object).nextToken(), bl2);
            }
            boolean bl3 = false;
            bl3 = hashtable.get("Punkte") != null;
            KafPlotProperties.isPunktVisible = this.wms_m > 1.0 ? bl3 : false;
            KafPlotProperties.isAllPointsVisible = true;
            boolean bl4 = bl3 = hashtable.get("Punktnummern") != null;
            if (bl3) {
                KafPlotProperties.isPunktVisible = bl3;
            }
            if (bl3) {
                KafPlotProperties.isAllPointsVisible = false;
            }
            KafPlotProperties.isPunktTextVisible = this.wms_m > 1.0 ? bl3 : false;
            bl3 = hashtable.get("Messelemente") != null;
            KafPlotProperties.isAufnahmeVisible = this.wms_m > 0.2 ? bl3 : false;
            KafPlotProperties.isOrthoVisible = this.wms_m > 0.2 ? bl3 : false;
            KafPlotProperties.isTrafoVisible = this.wms_m > 0.2 ? bl3 : false;
            bl3 = hashtable.get("Messzahlen") != null;
            KafPlotProperties.isMaszeVisible = this.wms_m > 1.0 ? bl3 : false;
            KafPlotProperties.isFlaecheFillVisible = true;
            KafPlotProperties.isFlaecheVisible = true;
            KafPlotProperties.isFlstVisible = true;
            KafPlotProperties.isFlstGmkVisible = true;
            KafPlotProperties.isFlstFlurVisible = true;
            KafPlotProperties.isFlstVngVisible = true;
            KafPlotProperties.isFlstFlstVisible = true;
            KafPlotProperties.isFlstTstVisible = true;
            KafPlotProperties.isNutzVisible = true;
            KafPlotProperties.isFlstPolyVisible = true;
            KafPlotProperties.isGebPolyVisible = true;
            KafPlotProperties.isTopPolyVisible = true;
            KafPlotProperties.isFlaecheTextVisible = true;
            KafPlotProperties.isAreaBuchVisible = false;
            KafPlotProperties.isAreaKooVisible = false;
            KafPlotProperties.isAreaDiffVisible = false;
            KafPlotProperties.isAreaPercVisible = false;
            KafPlotProperties.setColorSwitch(1006);
            KafPlotProperties.isFlaechePolyVisible = this.wms_m > 0.5;
            KafPlotProperties.isFlaechePatternVisible = this.wms_m > 2.0;
            KafPlotProperties.isFlstVisible = bl3 = hashtable.get("Flurstuecke") != null;
            if (bl3) {
                KafPlotProperties.isFlaechePolyVisible = bl3;
            }
            KafPlotProperties.isFlstTextOldVisible = this.wms_m > 2.0 ? bl3 : false;
            KafPlotProperties.isFlstTextNewVisible = this.wms_m > 2.0 ? bl3 : false;
            KafPlotProperties.isGebaeudeVisible = bl3 = hashtable.get("Gebaeude") != null;
            KafPlotProperties.isGebPolyVisible = this.wms_m > 0.5 ? bl3 : false;
            KafPlotProperties.isGebNumberVisible = this.wms_m > 4.0 ? bl3 : false;
            KafPlotProperties.isGebNameVisible = this.wms_m > 4.0 ? bl3 : false;
            KafPlotProperties.isGebSymVisible = this.wms_m > 4.0 ? bl3 : false;
            KafPlotProperties.isGebLfdnrVisible = this.wms_m > 8.0 ? bl3 : false;
            KafPlotProperties.isGebGschzVisible = this.wms_m > 8.0 ? bl3 : false;
            KafPlotProperties.isTopographieVisible = bl3 = hashtable.get("Topographie") != null;
            KafPlotProperties.isTopPolyVisible = this.wms_m > 0.5 ? bl3 : false;
            KafPlotProperties.isTopSymVisible = this.wms_m > 2.0 ? bl3 : false;
            KafPlotProperties.isTopNameVisible = this.wms_m > 2.0 ? bl3 : false;
            KafPlotProperties.isTopTextVisible = this.wms_m > 2.0 ? bl3 : false;
            boolean bl5 = bl3 = hashtable.get("Nutzung") != null;
            if (bl3) {
                KafPlotProperties.isFlstVisible = bl3;
            }
            KafPlotProperties.isNutzVisible = bl3;
            if (bl3) {
                KafPlotProperties.setColorSwitch(1002);
            }
            KafPlotProperties.isNutzSymVisible = this.wms_m > 1.0 ? bl3 : false;
            KafPlotProperties.isNutzTextVisible = this.wms_m > 2.0 ? bl3 : false;
            KafPlotProperties.isNutzNumberVisible = this.wms_m > 4.0 ? bl3 : false;
            boolean bl6 = bl3 = hashtable.get("Lage") != null;
            if (bl3) {
                KafPlotProperties.isFlstVisible = bl3;
            }
            if (bl3) {
                KafPlotProperties.setColorSwitch(1005);
            }
            KafPlotProperties.isLageKeyVisible = this.wms_m > 2.0 ? bl3 : false;
            KafPlotProperties.isLageTextVisible = this.wms_m > 4.0 ? bl3 : false;
            boolean bl7 = bl3 = hashtable.get("Eigentum") != null;
            if (bl3) {
                KafPlotProperties.isFlstVisible = bl3;
            }
            if (bl3) {
                KafPlotProperties.setColorSwitch(1003);
            }
            KafPlotProperties.isGbblVisible = this.wms_m > 2.0 ? bl3 : false;
            KafPlotProperties.isEtNameVisible = this.wms_m > 4.0 ? bl3 : false;
            KafPlotProperties.isEtAllVisible = this.wms_m > 6.0 ? bl3 : false;
            KafPlotProperties.isGitterVisible = bl3 = hashtable.get("Gitter") != null;
            KafPlotProperties.isGitterTextVisible = this.wms_m > 0.15 ? bl3 : false;
        }
        object = new GraphicClip(this.db, iGraphics, rectangle);
        ((Component)object).setSize(this.wms_width, this.wms_height);
        iGraphics.getGraphics().fillRect(0, 0, this.wms_width, this.wms_height);
        ((GraphicClip)object).paint(image.getGraphics());
        return new Map(image);
    }

    @Override
    public FeatureInfo getFeatureInfo(String string, String string2, String string3, String string4, String string5, String string6, String string7) throws Exception {
        this.sb.messagePerformed(new IMessageEvent(this, 1001, "WebMapService Anfrage: @GetFeatureInfo " + string));
        this.createWmsSys(string, string2, string3);
        double d = this.wms_ymin + new Double(string4) / this.wms_m;
        double d2 = this.wms_xmax - new Double(string5) / this.wms_m;
        int n = 1;
        if (string7 != null) {
            n = Integer.parseInt(string7);
        }
        double d3 = 20.0 / this.wms_m;
        FeatureInfo featureInfo = new FeatureInfo();
        if (string6.indexOf("Punkte") >= 0 || string6.indexOf("Punktnummern") >= 0) {
            double d4 = Double.MAX_VALUE;
            Punkt punkt = null;
            KafPlot kafPlot = this;
            Enumeration enumeration = kafPlot.db.punkte();
            while (enumeration.hasMoreElements()) {
                Punkt punkt2 = (Punkt)enumeration.nextElement();
                double d5 = DPoint.ptDist(punkt2.y, punkt2.x, d, d2);
                if (!(d5 < d3) || !(d5 < d4)) continue;
                punkt = punkt2;
                d4 = d5;
            }
            if (punkt != null) {
                featureInfo.addNode(punkt.toGml());
            }
        }
        if (string6.indexOf("Flurstuecke") >= 0) {
            KafPlot kafPlot = this;
            Enumeration enumeration = kafPlot.db.flurstuecke();
            while (enumeration.hasMoreElements()) {
                Flurstueck flurstueck = (Flurstueck)enumeration.nextElement();
                if (!flurstueck.isFlurstueck() || !flurstueck.contains(d, d2)) continue;
                featureInfo.addNode(flurstueck.toGml());
            }
        }
        return featureInfo;
    }

    @Override
    protected void setLayoutOfProperties() {
        super.setLayoutOfProperties();
        if (this.amountButton != null) {
            this.amountButton.setState(KafPlotProperties.getMouseSwitch() == 6);
        }
        if (this.plotclipButton != null) {
            this.plotclipButton.setState(KafPlotProperties.getMouseSwitch() == 7);
        }
        if (this.inputButton != null) {
            this.inputButton.setState(KafPlotProperties.getMouseSwitch() == 8);
        }
    }

    @Override
    protected void loadProperties() throws IOException {
        IOException iOException;
        block36: {
            PropertyLoader propertyLoader;
            block35: {
                block34: {
                    block33: {
                        block32: {
                            block31: {
                                block30: {
                                    block29: {
                                        block28: {
                                            block27: {
                                                block26: {
                                                    block25: {
                                                        iOException = null;
                                                        propertyLoader = new PropertyLoader();
                                                        try {
                                                            propertyLoader.loadProperties("KafPlot.properties");
                                                        }
                                                        catch (IOException iOException2) {
                                                            if (iOException != null) break block25;
                                                            iOException = iOException2;
                                                        }
                                                    }
                                                    try {
                                                        propertyLoader.loadProperties("KafDat.properties");
                                                    }
                                                    catch (IOException iOException3) {
                                                        if (iOException != null) break block26;
                                                        iOException = iOException3;
                                                    }
                                                }
                                                try {
                                                    propertyLoader.loadProperties("aemter.properties");
                                                }
                                                catch (IOException iOException4) {
                                                    if (iOException != null) break block27;
                                                    iOException = iOException4;
                                                }
                                            }
                                            try {
                                                propertyLoader.loadProperties("geograf.properties");
                                            }
                                            catch (IOException iOException5) {
                                                if (iOException != null) break block28;
                                                iOException = iOException5;
                                            }
                                        }
                                        try {
                                            propertyLoader.loadProperties("caddy.properties");
                                        }
                                        catch (IOException iOException6) {
                                            if (iOException != null) break block29;
                                            iOException = iOException6;
                                        }
                                    }
                                    try {
                                        propertyLoader.loadProperties("vermarkungen.properties");
                                    }
                                    catch (IOException iOException7) {
                                        if (iOException != null) break block30;
                                        iOException = iOException7;
                                    }
                                }
                                try {
                                    propertyLoader.loadProperties("nutzung.properties");
                                }
                                catch (IOException iOException8) {
                                    if (iOException != null) break block31;
                                    iOException = iOException8;
                                }
                            }
                            try {
                                propertyLoader.loadProperties("transfer.properties");
                            }
                            catch (IOException iOException9) {
                                if (iOException != null) break block32;
                                iOException = iOException9;
                            }
                        }
                        try {
                            propertyLoader.loadProperties("trafoparameter.properties");
                        }
                        catch (IOException iOException10) {
                            if (iOException != null) break block33;
                            iOException = iOException10;
                        }
                    }
                    try {
                        propertyLoader.loadProperties("themes.properties");
                    }
                    catch (IOException iOException11) {
                        if (iOException != null) break block34;
                        iOException = iOException11;
                    }
                }
                try {
                    propertyLoader.loadProperties("display.properties");
                }
                catch (IOException iOException12) {
                    if (iOException != null) break block35;
                    iOException = iOException12;
                }
            }
            try {
                propertyLoader.loadProperties("kafplot.licence");
            }
            catch (IOException iOException13) {
                if (iOException != null) break block36;
                iOException = iOException13;
            }
        }
        KafPlotProperties.initColors();
        if (iOException != null) {
            throw iOException;
        }
    }

    @Override
    protected void setTitle() {
        StringBuffer stringBuffer = new StringBuffer(KafPlotVersion.getTitle(1));
        KafPlot kafPlot = this;
        if (kafPlot.db.isInit()) {
            KafPlot kafPlot2 = this;
            stringBuffer.append(" [" + kafPlot2.db.getSourceName() + "] ");
        }
        this.setTitle(stringBuffer.toString());
    }

    @Override
    protected void addMainMenu() {
        this.mainMenu = new KafPlotMainMenu();
        this.mainMenu.addActionListener(this);
        Enumeration enumeration = KafPlotProperties.getThemesNames();
        while (enumeration.hasMoreElements()) {
            this.mainMenu.addTheme((String)enumeration.nextElement());
        }
        this.setMenuBar(this.mainMenu);
    }

    @Override
    protected Panel createSymbolBar() {
        this.mainBar = new KafPlotSymbolBar();
        this.mainBar.addActionListener(this);
        this.mainBar.addKeyListener(this);
        return this.mainBar;
    }

    @Override
    protected IToolBar createToolBar() {
        IToolBar iToolBar = super.createToolBar();
        if (KafPlotModules.getState(3)) {
            this.inputButton = this.createICheckboxButton(9, "Objekte erzeugen", this.toolGroup);
            iToolBar.add((Component)this.inputButton, iToolBar.getButtonCount() - 1);
        }
        this.amountButton = this.createICheckboxButton(7, "Menge bilden", this.toolGroup);
        iToolBar.add((Component)this.amountButton, iToolBar.getButtonCount() - 1);
        this.plotclipButton = this.createICheckboxButton(8, "Plotbox erzeugen", this.toolGroup);
        iToolBar.add((Component)this.plotclipButton, iToolBar.getButtonCount() - 1);
        return iToolBar;
    }

    private class SystemErrorHandler
    implements Thread.UncaughtExceptionHandler {
        private SystemErrorHandler(KafPlot kafPlot) {
        }

        @Override
        public void uncaughtException(Thread thread, Throwable throwable) {
            System.out.println("SystemErrorHandler:" + String.valueOf(throwable));
            throwable.printStackTrace();
        }
    }

    private class FileSelector {
        private File kafFile;
        private Vector<File> imgFiles = new Vector(10);
        private Vector<File> geoFiles = new Vector(10);
        private String geoExt = null;
        private boolean geoIsHomogen = true;

        private FileSelector(KafPlot kafPlot) {
        }

        public int size() {
            return this.geoFiles.size() + this.imgFiles.size();
        }

        public void add(Object object) {
            if (object instanceof File) {
                this.add((File)object);
            } else if (object instanceof File[]) {
                File[] fileArray = (File[])object;
                for (int i = 0; i < fileArray.length; ++i) {
                    this.add(fileArray[i]);
                }
            } else if (object instanceof String[]) {
                String[] stringArray = (String[])object;
                for (int i = 0; i < stringArray.length; ++i) {
                    this.add(stringArray[i]);
                }
            } else if (object instanceof Object[]) {
                Object[] objectArray = (Object[])object;
                for (int i = 0; i < objectArray.length; ++i) {
                    this.add(objectArray[i]);
                }
            } else {
                this.add(object.toString());
            }
        }

        public void add(String string) {
            this.add(new File(string));
        }

        private void add(File file) {
            String string = FileSelector.getExt(file.getName());
            if (this.kafFile == null && KafkaReader.isProjektFile(file)) {
                this.kafFile = file;
            } else if (FileSelector.isImg(string)) {
                this.imgFiles.add(file);
            } else {
                this.geoFiles.add(file);
                if (this.geoExt == null) {
                    this.geoExt = string;
                } else if (this.geoIsHomogen && !string.equals(this.geoExt)) {
                    this.geoIsHomogen = false;
                }
            }
        }

        public boolean hasKafFile() {
            return this.kafFile != null;
        }

        public boolean hasImgFiles() {
            return this.imgFiles.size() > 0;
        }

        public boolean hasGeoFiles() {
            return this.geoFiles.size() > 0;
        }

        public boolean geoMultiHomogen() {
            return this.geoFiles.size() > 1 && this.geoIsHomogen;
        }

        public File getKafFile() {
            return this.kafFile;
        }

        public File[] getImgFiles() {
            return this.imgFiles.toArray(new File[this.imgFiles.size()]);
        }

        public File[] getGeoFiles() {
            return this.geoFiles.toArray(new File[this.geoFiles.size()]);
        }

        private static boolean isImg(String string) {
            return string.equals(".gif") || string.equals(".jpg") || string.equals(".jpeg") || string.equals(".tif") || string.equals(".bmp") || string.equals(".pcx") || string.equals(".png");
        }

        private static String getExt(String string) {
            int n = string.lastIndexOf(46);
            return n > 0 ? string.substring(n).toLowerCase() : "";
        }
    }

    private class ClipTransfer
    implements Transferable {
        DataFlavor txtFlavor = DataFlavor.stringFlavor;
        DataFlavor htmFlavor = DataFlavor.fragmentHtmlFlavor;
        DataFlavor[] flavor = new DataFlavor[2];
        Object trans = null;
        boolean onlyNumber = false;
        int count;

        public ClipTransfer(Object object, boolean bl) {
            this.flavor[0] = this.txtFlavor;
            this.flavor[1] = this.htmFlavor;
            this.trans = object;
            this.onlyNumber = bl;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return this.flavor;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            return dataFlavor == this.txtFlavor || dataFlavor == this.htmFlavor;
        }

        @Override
        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
            StringBuffer stringBuffer = new StringBuffer();
            if (dataFlavor == this.htmFlavor) {
                stringBuffer.append("<table>" + (this.onlyNumber ? "<TR><TH>Nummer</TH></TR>" : "<TR><TH>Nummer</TH><TH>Rechtswert</TH><TH>Hochwert</TH><TH>H&ouml;he</TH><TH>Pa</TH><TH>Lg</TH><TH>Lz</TH><TH>Ea</TH><TH>Eq</TH><TH>Va</TH><TH>Vb</TH><TH>Bemerkung</TH></TR>"));
            }
            if (this.trans instanceof Punkt) {
                stringBuffer.append(this.out((Punkt)this.trans, dataFlavor));
            } else if (this.trans instanceof PunktTable) {
                PunktTable punktTable = (PunktTable)this.trans;
                Enumeration enumeration = punktTable.elements();
                while (enumeration.hasMoreElements()) {
                    stringBuffer.append(this.out((Punkt)enumeration.nextElement(), dataFlavor));
                    stringBuffer.append(IFormat.EOL);
                }
            } else if (this.trans instanceof PunktContainer) {
                PunktTable punktTable = ((PunktContainer)this.trans).getPunkte();
                Enumeration enumeration = punktTable.elements();
                while (enumeration.hasMoreElements()) {
                    stringBuffer.append(this.out((Punkt)enumeration.nextElement(), dataFlavor));
                    stringBuffer.append(IFormat.EOL);
                }
            }
            if (dataFlavor == this.htmFlavor) {
                stringBuffer.append("</table>");
            }
            return stringBuffer.toString();
        }

        private String out(Punkt punkt, DataFlavor dataFlavor) {
            ++this.count;
            if (dataFlavor == this.txtFlavor) {
                return this.onlyNumber ? Long.toString(punkt.nr) : punkt.toPdkLine(0, false, true);
            }
            return punkt.toHtmTableRowLine(0, false, this.onlyNumber);
        }

        public String getMessage() {
            StringBuffer stringBuffer = new StringBuffer(50);
            stringBuffer.append(this.count + " Punkt");
            if (this.count > 1) {
                stringBuffer.append("e");
            }
            stringBuffer.append(" in die Zwischenablage kopiert");
            return KafPlot.this.sb.toString();
        }
    }

    private class LizenzTimer
    extends Thread {
        long waitTime = 0L;
        ITimeDisplayer tdsp = null;

        private LizenzTimer(KafPlot kafPlot, ITimeDisplayer iTimeDisplayer, long l) {
            this.tdsp = iTimeDisplayer;
            this.waitTime = l;
            this.setPriority(1);
        }

        @Override
        public void run() {
            long l = 0L;
            do {
                try {
                    if (this.tdsp != null) {
                        this.tdsp.setTime(this.waitTime - l);
                    }
                    Thread.sleep(1000L);
                    l += 1000L;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            } while (l < this.waitTime);
            System.exit(9);
        }
    }
}

