/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.ErrorDialog;
import de.geocalc.awt.IButton;
import de.geocalc.awt.ICheckboxButton;
import de.geocalc.awt.ICheckboxButtonGroup;
import de.geocalc.awt.IException;
import de.geocalc.awt.IFrame;
import de.geocalc.awt.IInfoDialog;
import de.geocalc.awt.ISeparator;
import de.geocalc.awt.IToolBar;
import de.geocalc.awt.Konsole;
import de.geocalc.awt.TextDialog;
import de.geocalc.awt.event.ElementInfoEvent;
import de.geocalc.awt.event.ElementInfoListener;
import de.geocalc.awt.event.IMessageEvent;
import de.geocalc.awt.event.IObjectEvent;
import de.geocalc.awt.event.IObjectListener;
import de.geocalc.geom.DPoint;
import de.geocalc.geom.DPolygon;
import de.geocalc.geom.DRectangle;
import de.geocalc.geom.GeomException;
import de.geocalc.kafplot.Bedingung;
import de.geocalc.kafplot.BedingungInfoDialog;
import de.geocalc.kafplot.Bemerkung;
import de.geocalc.kafplot.BodenInfoDialog;
import de.geocalc.kafplot.BodenSchaetzung;
import de.geocalc.kafplot.Bogen;
import de.geocalc.kafplot.BuchungsArt;
import de.geocalc.kafplot.Buchungsstelle;
import de.geocalc.kafplot.CreateMengeDialog;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.Drawable;
import de.geocalc.kafplot.EigentuemerArt;
import de.geocalc.kafplot.ErrorManagerDialog;
import de.geocalc.kafplot.FileInfoDialog;
import de.geocalc.kafplot.Flaeche;
import de.geocalc.kafplot.FlurInfoDialog;
import de.geocalc.kafplot.Flurstueck;
import de.geocalc.kafplot.FlurstueckInfoDialog;
import de.geocalc.kafplot.GObject;
import de.geocalc.kafplot.GObjectManipulator;
import de.geocalc.kafplot.Gebaeude;
import de.geocalc.kafplot.GebaeudeInfoDialog;
import de.geocalc.kafplot.GebaeudeKennzeichen;
import de.geocalc.kafplot.Gemarkung;
import de.geocalc.kafplot.GemarkungInfoDialog;
import de.geocalc.kafplot.Gemeinde;
import de.geocalc.kafplot.GemeindeInfoDialog;
import de.geocalc.kafplot.GeoImage;
import de.geocalc.kafplot.GraphicPanel;
import de.geocalc.kafplot.GraphicPanelPopupMenu;
import de.geocalc.kafplot.GrundbuchInfoDialog;
import de.geocalc.kafplot.Grundbuchblatt;
import de.geocalc.kafplot.GrundstueckInfoDialog;
import de.geocalc.kafplot.ImageInfoDialog;
import de.geocalc.kafplot.ImageLoader;
import de.geocalc.kafplot.ImageObjectDialog;
import de.geocalc.kafplot.ImageObjectsDialog;
import de.geocalc.kafplot.InputObject;
import de.geocalc.kafplot.InputProperties;
import de.geocalc.kafplot.InsertTrafoDialog;
import de.geocalc.kafplot.IntegerAttributeListInfoDialog;
import de.geocalc.kafplot.KafPlotCommand;
import de.geocalc.kafplot.KafPlotProperties;
import de.geocalc.kafplot.KafPlotVersion;
import de.geocalc.kafplot.Linie;
import de.geocalc.kafplot.LinieInfoDialog;
import de.geocalc.kafplot.Messung;
import de.geocalc.kafplot.MessungInfoDialog;
import de.geocalc.kafplot.Nutzung;
import de.geocalc.kafplot.NutzungInfoDialog;
import de.geocalc.kafplot.NutzungsArt;
import de.geocalc.kafplot.NutzungsArtInfoDialog;
import de.geocalc.kafplot.ObjectInfoDialog;
import de.geocalc.kafplot.ObjectListSource;
import de.geocalc.kafplot.ObjectSupplier;
import de.geocalc.kafplot.OptionDialog;
import de.geocalc.kafplot.OrthoLinie;
import de.geocalc.kafplot.OrthoLinieDialog;
import de.geocalc.kafplot.PaintObject;
import de.geocalc.kafplot.Plotbox;
import de.geocalc.kafplot.PolarAufnahme;
import de.geocalc.kafplot.PolarAufnahmeDialog;
import de.geocalc.kafplot.Punkt;
import de.geocalc.kafplot.PunktCheckOptionDialog;
import de.geocalc.kafplot.PunktContainer;
import de.geocalc.kafplot.PunktInfoDialog;
import de.geocalc.kafplot.PunktSupplier;
import de.geocalc.kafplot.PunktTable;
import de.geocalc.kafplot.RechtsgemeinschaftsArt;
import de.geocalc.kafplot.RecorderDialog;
import de.geocalc.kafplot.RissInfoDialog;
import de.geocalc.kafplot.RotationDialog;
import de.geocalc.kafplot.SearchKooDialog;
import de.geocalc.kafplot.SearchObjectDialog;
import de.geocalc.kafplot.SearchPunktDialog;
import de.geocalc.kafplot.StatusBar;
import de.geocalc.kafplot.Strasse;
import de.geocalc.kafplot.StrasseInfoDialog;
import de.geocalc.kafplot.SymbolBar;
import de.geocalc.kafplot.TopObject;
import de.geocalc.kafplot.TopObjectInfoDialog;
import de.geocalc.kafplot.TrafoInfoDialog;
import de.geocalc.kafplot.TrafoPunkt;
import de.geocalc.kafplot.event.GraphicEvent;
import de.geocalc.kafplot.event.GraphicListener;
import de.geocalc.lang.Control;
import java.awt.BorderLayout;
import java.awt.Panel;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public abstract class KafPlotFrame
extends IFrame
implements KafPlotCommand,
ActionListener,
KeyListener,
ElementInfoListener,
IObjectListener,
GraphicListener {
    public static int FRAME_X = 0;
    public static int FRAME_Y = 0;
    public static int FRAME_B = 800;
    public static int FRAME_H = 600;
    protected ICheckboxButtonGroup toolGroup;
    protected ICheckboxButton markButton;
    protected ICheckboxButton centerButton;
    protected ICheckboxButton zoomButton;
    protected ICheckboxButton ezoomButton;
    protected ICheckboxButton rulerButton;
    protected ICheckboxButton amountButton;
    protected ICheckboxButton plotclipButton;
    protected ICheckboxButton inputButton;
    protected SymbolBar mainBar;
    private boolean withSwitchTools = true;
    protected GraphicPanel gp = null;
    protected StatusBar sb = null;
    protected DataBase db = DataBase.getInstance();
    protected FileInfoDialog fileInfoDialog = null;
    protected ErrorManagerDialog errorManagerDialog = null;
    protected RecorderDialog recorderDialog = null;
    protected SearchPunktDialog searchDialog = null;
    protected SearchObjectDialog searchObjectDialog = null;
    protected SearchKooDialog searchKooDialog = null;
    protected OptionDialog optionDialog = null;
    protected RotationDialog rotDialog = null;
    protected PunktCheckOptionDialog punktCheckOptionDialog = null;
    protected CreateMengeDialog mengeDialog = null;
    protected PunktInfoDialog punktInfoDialog = null;
    protected MessungInfoDialog messungInfoDialog = null;
    protected BedingungInfoDialog bedingungInfoDialog = null;
    protected TrafoInfoDialog trafoInfoDialog = null;
    protected LinieInfoDialog linieInfoDialog = null;
    protected FlurstueckInfoDialog flstInfoDialog = null;
    protected GebaeudeInfoDialog gebInfoDialog = null;
    protected NutzungInfoDialog nutzInfoDialog = null;
    protected BodenInfoDialog bodenInfoDialog = null;
    protected TopObjectInfoDialog topInfoDialog = null;
    protected GrundbuchInfoDialog buchInfoDialog = null;
    protected GemeindeInfoDialog gemeindeInfoDialog = null;
    protected GemarkungInfoDialog gemarkungInfoDialog = null;
    protected FlurInfoDialog flurInfoDialog = null;
    protected StrasseInfoDialog strasseInfoDialog = null;
    protected NutzungsArtInfoDialog nutzungInfoDialog = null;
    protected RissInfoDialog rissInfoDialog = null;
    protected ImageInfoDialog imgInfoDialog = null;
    protected OrthoLinieDialog orthoLinieDialog = null;
    protected PolarAufnahmeDialog polaraufnahmeDialog = null;
    protected InsertTrafoDialog insertTrafoDialog = null;
    protected ImageObjectsDialog imgObjectsDialog = null;
    protected ImageObjectDialog imgDialog = null;
    protected IntegerAttributeListInfoDialog buchungsArtDialog = null;
    protected IntegerAttributeListInfoDialog eigentuemerArtDialog = null;
    protected IntegerAttributeListInfoDialog rechtsgemeinschaftsArtDialog = null;
    protected static Hashtable<String, Integer> commands = new Hashtable();
    protected static Konsole konsole;

    KafPlotFrame() {
        String string = null;
        try {
            this.loadProperties();
        }
        catch (IOException iOException) {
            string = iOException.getMessage();
        }
        this.createLayout();
        if (KafPlotProperties.getUpdateInfo()) {
            KafPlotVersion.loadProviderVersionInfo(this.sb);
        }
        if (string != null) {
            ErrorDialog errorDialog = new ErrorDialog((IFrame)this, new IException(string));
            errorDialog.setVisible(true);
        }
        konsole = new Konsole(this);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.startsWith("Themen")) {
            int n = string.indexOf(".");
            if (n > 0) {
                if (KafPlotProperties.saveThemeOnChange) {
                    KafPlotProperties.saveTheme();
                }
                KafPlotProperties.loadTheme(string.substring(n + 1));
                KafPlotProperties.sendOptionUpdateEvent(this);
                this.gp.repaint();
            }
        } else {
            Integer n = commands.get(string);
            int n2 = n != null ? n : 0;
            this.doCommand(n2, actionEvent.getSource(), actionEvent.getModifiers());
        }
        this.sb.setText();
        this.setTitle();
        this.setCommandInput();
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.isControlDown()) {
            if (keyEvent.isAltDown()) {
                switch (keyEvent.getKeyCode()) {
                    case 76: {
                        this.actionPerformed(new ActionEvent(this, 1001, "?licence", 8));
                        keyEvent.consume();
                        break;
                    }
                    case 73: {
                        this.actionPerformed(new ActionEvent(this, 1001, "?systeminfo", 8));
                        keyEvent.consume();
                        break;
                    }
                    case 68: {
                        this.actionPerformed(new ActionEvent(this, 1001, "?konsole", 8));
                        keyEvent.consume();
                    }
                }
            } else {
                switch (keyEvent.getKeyCode()) {
                    case 107: {
                        this.gp.zoomIn(5.0);
                        keyEvent.consume();
                        break;
                    }
                    case 109: {
                        this.gp.zoomOut(5.0);
                        keyEvent.consume();
                        break;
                    }
                    case 106: {
                        this.gp.zoomEllipseIn(5.0);
                        keyEvent.consume();
                        break;
                    }
                    case 111: {
                        this.gp.zoomEllipseOut(5.0);
                        keyEvent.consume();
                        break;
                    }
                    case 37: {
                        this.gp.move(-10, 2.0);
                        keyEvent.consume();
                        break;
                    }
                    case 39: {
                        this.gp.move(10, 2.0);
                        keyEvent.consume();
                        break;
                    }
                    case 38: {
                        this.gp.move(-1, 2.0);
                        keyEvent.consume();
                        break;
                    }
                    case 40: {
                        this.gp.move(1, 2.0);
                        keyEvent.consume();
                    }
                }
            }
        } else if (keyEvent.isShiftDown()) {
            switch (keyEvent.getKeyCode()) {
                case 65: {
                    this.actionPerformed(new ActionEvent(this, 1001, "Aufnahmepfeile", KafPlotProperties.isAufnahmeVisible() ? 8 : 1));
                    break;
                }
                case 66: {
                    this.actionPerformed(new ActionEvent(this, 1001, "Bedingungen ", KafPlotProperties.isBedingungVisible() ? 8 : 1));
                    break;
                }
                case 69: {
                    this.actionPerformed(new ActionEvent(this, 1001, "Ellipsen", KafPlotProperties.isEllipseVisible() ? 8 : 1));
                    break;
                }
                case 70: {
                    this.actionPerformed(new ActionEvent(this, 1001, "Objekte", KafPlotProperties.isFlaecheVisible() ? 8 : 1));
                    break;
                }
                case 71: {
                    this.actionPerformed(new ActionEvent(this, 1001, "Gitternetz", KafPlotProperties.isGitterVisible() ? 8 : 1));
                    break;
                }
                case 72: {
                    this.actionPerformed(new ActionEvent(this, 1001, "Homogenisierung", KafPlotProperties.isHomogenisierungVisible() ? 8 : 1));
                    break;
                }
                case 73: {
                    this.actionPerformed(new ActionEvent(this, 1001, "Images", KafPlotProperties.isImagesVisible() ? 8 : 1));
                    break;
                }
                case 75: {
                    this.actionPerformed(new ActionEvent(this, 1001, "Katasternachweis", KafPlotProperties.isNachweisVisible() ? 8 : 1));
                    break;
                }
                case 76: {
                    this.actionPerformed(new ActionEvent(this, 1001, "lokale Punkte", KafPlotProperties.isAllPointsVisible() ? 8 : 1));
                    break;
                }
                case 77: {
                    this.actionPerformed(new ActionEvent(this, 1001, "Messbandmessungen", KafPlotProperties.isEigeneVisible() ? 8 : 1));
                    break;
                }
                case 78: {
                    this.actionPerformed(new ActionEvent(this, 1001, "Punktbeschriftung", KafPlotProperties.isPunktTextVisible() ? 8 : 1));
                    break;
                }
                case 79: {
                    this.actionPerformed(new ActionEvent(this, 1001, "Messungslinien", KafPlotProperties.isOrthoVisible() ? 8 : 1));
                    break;
                }
                case 80: {
                    this.actionPerformed(new ActionEvent(this, 1001, "Polare Messungen", KafPlotProperties.isPolarVisible() ? 8 : 1));
                    break;
                }
                case 81: {
                    this.actionPerformed(new ActionEvent(this, 1001, "Urgeometrie", KafPlotProperties.isInputShadowVisible() ? 8 : 1));
                    break;
                }
                case 82: {
                    this.actionPerformed(new ActionEvent(this, 1001, "Einrechnungen", KafPlotProperties.isEinrechnungVisible() ? 8 : 1));
                    break;
                }
                case 83: {
                    this.actionPerformed(new ActionEvent(this, 1001, "Punktarten", KafPlotProperties.isPunktArtVisible() ? 8 : 1));
                    break;
                }
                case 84: {
                    this.actionPerformed(new ActionEvent(this, 1001, "Transformationen", KafPlotProperties.isTrafoVisible() ? 8 : 1));
                    break;
                }
                case 85: {
                    this.actionPerformed(new ActionEvent(this, 1001, "unbenutzte", KafPlotProperties.isUnusedVisible() ? 8 : 1));
                    break;
                }
                case 86: {
                    this.actionPerformed(new ActionEvent(this, 1001, "Vorgaben", KafPlotProperties.isVorgabenVisible() ? 8 : 1));
                    break;
                }
                case 88: {
                    this.actionPerformed(new ActionEvent(this, 1001, "Bemerkungen", KafPlotProperties.isBemerkungVisible() ? 8 : 1));
                    break;
                }
                case 87: {
                    this.actionPerformed(new ActionEvent(this, 1001, "Punkte ohne Linien", KafPlotProperties.isPointWithOutLinesVisible ? 8 : 1));
                    break;
                }
                case 90: {
                    this.actionPerformed(new ActionEvent(this, 1001, "Ma\u00dfzahlen", KafPlotProperties.isMaszeVisible() ? 8 : 1));
                }
            }
        } else if (keyEvent.isAltDown()) {
            switch (keyEvent.getKeyCode()) {
                case 107: {
                    this.gp.zoomIn(1.1);
                    break;
                }
                case 109: {
                    this.gp.zoomOut(1.1);
                    break;
                }
                case 106: {
                    this.gp.zoomEllipseIn(1.1);
                    break;
                }
                case 111: {
                    this.gp.zoomEllipseOut(1.1);
                    break;
                }
                case 37: {
                    this.gp.move(-10, 0.1);
                    break;
                }
                case 39: {
                    this.gp.move(10, 0.1);
                    break;
                }
                case 38: {
                    this.gp.move(-1, 0.1);
                    break;
                }
                case 40: {
                    this.gp.move(1, 0.1);
                }
            }
        } else {
            switch (keyEvent.getKeyCode()) {
                case 107: {
                    this.gp.zoomIn(2.0);
                    break;
                }
                case 109: {
                    this.gp.zoomOut(2.0);
                    break;
                }
                case 106: {
                    this.gp.zoomEllipseIn(2.0);
                    break;
                }
                case 111: {
                    this.gp.zoomEllipseOut(2.0);
                    break;
                }
                case 37: {
                    this.gp.move(-10, 1.0);
                    break;
                }
                case 39: {
                    this.gp.move(10, 1.0);
                    break;
                }
                case 38: {
                    this.gp.move(-1, 1.0);
                    break;
                }
                case 40: {
                    this.gp.move(1, 1.0);
                    break;
                }
                case 33: {
                    this.gp.showView(-1);
                    break;
                }
                case 34: {
                    this.gp.showView(1);
                    break;
                }
                case 36: {
                    this.actionPerformed(new ActionEvent(this, 1001, "Neu Zeichnen"));
                    break;
                }
                case 113: {
                    this.actionPerformed(new ActionEvent(this, 1001, "Bearbeiten"));
                    break;
                }
                case 116: {
                    this.actionPerformed(new ActionEvent(this, 1001, "Nachladen"));
                    break;
                }
                case 120: {
                    this.actionPerformed(new ActionEvent(this, 1001, "Optionen"));
                    break;
                }
                case 8: {
                    this.gp.reverseInput();
                    keyEvent.consume();
                    break;
                }
                case 80: {
                    this.actionPerformed(new ActionEvent(this, 1001, "Punkte", KafPlotProperties.isPunktVisible ? 8 : 1));
                    break;
                }
                case 76: {
                    this.actionPerformed(new ActionEvent(this, 1001, "Linien", KafPlotProperties.isFlaechePolyVisible ? 8 : 1));
                    break;
                }
                case 70: {
                    this.actionPerformed(new ActionEvent(this, 1001, "Fl\u00e4chen", KafPlotProperties.isFlaecheFillVisible ? 8 : 1));
                    break;
                }
                case 84: {
                    this.actionPerformed(new ActionEvent(this, 1001, "Texte", KafPlotProperties.isFlaecheTextVisible ? 8 : 1));
                    break;
                }
                case 72: {
                    this.actionPerformed(new ActionEvent(this, 1001, "H\u00f6hen", KafPlotProperties.isPunktHoeheVisible ? 8 : 1));
                    break;
                }
                case 83: {
                    this.actionPerformed(new ActionEvent(this, 1001, "L\u00e4ngen", KafPlotProperties.isFlaecheLengthVisible ? 8 : 1));
                    break;
                }
                case 77: {
                    this.actionPerformed(new ActionEvent(this, 1001, "Linienmuster", KafPlotProperties.isFlaechePatternVisible ? 8 : 1));
                    break;
                }
                case 85: {
                    this.actionPerformed(new ActionEvent(this, 1001, "Urgeomatrie", KafPlotProperties.isInputShadowVisible ? 8 : 1));
                    break;
                }
                case 86: {
                    this.actionPerformed(new ActionEvent(this, 1001, "Vermarkung", KafPlotProperties.isVermarkungVisible ? 8 : 1));
                    break;
                }
                case 69: {
                    this.actionPerformed(new ActionEvent(this, 1001, "Eigent\u00fcmer", KafPlotProperties.isEtNameVisible ? 8 : 1));
                    break;
                }
                case 78: {
                    this.actionPerformed(new ActionEvent(this, 1001, "Freistellung", KafPlotProperties.isPunktTextBgVisible ? 8 : 1));
                    break;
                }
                case 79: {
                    this.actionPerformed(new ActionEvent(this, 1001, "Offline", KafPlotProperties.isUnusedVisible ? 8 : 1));
                }
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void graphicUpdated(GraphicEvent graphicEvent) {
        if (this.rotDialog != null) {
            this.rotDialog.update();
        }
    }

    @Override
    public void elementClicked(ElementInfoEvent elementInfoEvent) {
        Object object = elementInfoEvent.getElement();
        if (object == null) {
            return;
        }
        if (object instanceof NutzungsArt) {
            if (this.nutzungInfoDialog == null || !this.nutzungInfoDialog.isVisible()) {
                this.nutzungInfoDialog = new NutzungsArtInfoDialog(this, "Nutzungsarten");
                this.nutzungInfoDialog.setModal(false);
                this.nutzungInfoDialog.setVisible(true);
            }
            this.nutzungInfoDialog.setObject(object);
            this.nutzungInfoDialog.toFront();
            this.nutzungInfoDialog.requestFocus();
        } else if (object instanceof Strasse) {
            if (this.strasseInfoDialog == null || !this.strasseInfoDialog.isVisible()) {
                this.strasseInfoDialog = new StrasseInfoDialog(this, "Stra\u00dfen");
                this.strasseInfoDialog.setModal(false);
                this.strasseInfoDialog.setVisible(true);
            }
            this.strasseInfoDialog.setObject(object);
            this.strasseInfoDialog.toFront();
            this.strasseInfoDialog.requestFocus();
        } else if (object instanceof Gemarkung) {
            if (this.gemarkungInfoDialog == null || !this.gemarkungInfoDialog.isVisible()) {
                this.gemarkungInfoDialog = new GemarkungInfoDialog(this, "Gemarkungen");
                this.gemarkungInfoDialog.setModal(false);
                this.gemarkungInfoDialog.setVisible(true);
            }
            this.gemarkungInfoDialog.setObject(object);
            this.gemarkungInfoDialog.toFront();
            this.gemarkungInfoDialog.requestFocus();
        } else if (object instanceof Gemeinde) {
            if (this.gemeindeInfoDialog == null || !this.gemeindeInfoDialog.isVisible()) {
                this.gemeindeInfoDialog = new GemeindeInfoDialog(this, "Gemeinden");
                this.gemeindeInfoDialog.setModal(false);
                this.gemeindeInfoDialog.setVisible(true);
            }
            this.gemeindeInfoDialog.setObject(object);
            this.gemeindeInfoDialog.toFront();
            this.gemeindeInfoDialog.requestFocus();
        } else if (object instanceof Grundbuchblatt || object instanceof Buchungsstelle) {
            if (this.buchInfoDialog == null || !this.buchInfoDialog.isVisible()) {
                this.buchInfoDialog = new GrundbuchInfoDialog(this, "Grundbuch");
                this.buchInfoDialog.addActionListener(this);
                this.buchInfoDialog.setActionCommand("_list_flst");
                this.buchInfoDialog.addElementInfoListener(this);
                this.buchInfoDialog.setModal(false);
                this.buchInfoDialog.setVisible(true);
            }
            this.buchInfoDialog.setObject(object);
            this.buchInfoDialog.toFront();
            this.buchInfoDialog.requestFocus();
        } else if (object instanceof Flurstueck && ((Flurstueck)object).isFlur()) {
            if (this.flurInfoDialog == null || !this.flurInfoDialog.isVisible()) {
                this.flurInfoDialog = new FlurInfoDialog(this, "Flur");
                this.flurInfoDialog.addActionListener(this);
                this.flurInfoDialog.setActionCommand("_flst_command");
                this.flurInfoDialog.addElementInfoListener(this);
                this.flurInfoDialog.setModal(false);
                this.flurInfoDialog.setVisible(true);
            }
            this.flurInfoDialog.setObject(object);
            this.flurInfoDialog.toFront();
            this.flurInfoDialog.requestFocus();
        } else if (object instanceof BuchungsArt) {
            if (this.buchungsArtDialog == null) {
                this.buchungsArtDialog = new IntegerAttributeListInfoDialog((IFrame)this, "BuchungsArt", BuchungsArt.getList());
                this.buchungsArtDialog.setModal(false);
            }
            this.buchungsArtDialog.setVisible(true);
            this.buchungsArtDialog.select(object);
        } else if (object instanceof EigentuemerArt) {
            if (this.eigentuemerArtDialog == null) {
                this.eigentuemerArtDialog = new IntegerAttributeListInfoDialog((IFrame)this, "Eigent\u00fcmerArt", EigentuemerArt.getList());
                this.eigentuemerArtDialog.setModal(false);
            }
            this.eigentuemerArtDialog.setVisible(true);
            this.eigentuemerArtDialog.select(object);
        } else if (object instanceof RechtsgemeinschaftsArt) {
            if (this.rechtsgemeinschaftsArtDialog == null) {
                this.rechtsgemeinschaftsArtDialog = new IntegerAttributeListInfoDialog((IFrame)this, "RechtsgemeinschaftsArt", RechtsgemeinschaftsArt.getList());
                this.rechtsgemeinschaftsArtDialog.setModal(false);
            }
            this.rechtsgemeinschaftsArtDialog.setVisible(true);
            this.rechtsgemeinschaftsArtDialog.select(object);
        } else {
            this.gp.setCommandObject(object);
            if (object instanceof Drawable) {
                this.gp.centerOfPunkt(((Drawable)object).getHashPoint());
            } else if (object instanceof TrafoPunkt) {
                this.gp.centerOfPunkt(((TrafoPunkt)object).getPunkt().getHashPoint());
            }
            this.gp.setMarkObject(object);
            if (elementInfoEvent.getClickCount() > 1) {
                this.doCommand(900, this, elementInfoEvent.getModifiers());
            }
        }
    }

    protected void doCommand(int n, Object object, int n2) {
        switch (n) {
            case 9: {
                KafPlotFrame kafPlotFrame = this;
                if (kafPlotFrame.db.isEmpty()) break;
                if (this.fileInfoDialog == null || !this.fileInfoDialog.isVisible()) {
                    this.fileInfoDialog = new FileInfoDialog(this, "DateiInfo");
                    this.fileInfoDialog.setActionCommand("_repaint");
                    this.fileInfoDialog.addActionListener(this);
                    this.fileInfoDialog.setModal(false);
                    this.fileInfoDialog.setVisible(true);
                    break;
                }
                this.fileInfoDialog.setVisible(true);
                this.fileInfoDialog.toFront();
                this.fileInfoDialog.requestFocus();
                break;
            }
            case 13: {
                this.endSession();
                break;
            }
            case 7101: {
                if (this.gp == null) break;
                KafPlotFrame kafPlotFrame = this;
                if (kafPlotFrame.db.isEmpty()) break;
                if (this.mengeDialog == null || !this.mengeDialog.isVisible()) {
                    this.mengeDialog = new CreateMengeDialog((IFrame)this, "Menge erzeugen", this.db);
                    this.mengeDialog.setModal(false);
                    this.mengeDialog.setActionCommand("_repaint_menge");
                    this.mengeDialog.addActionListener(this);
                    this.mengeDialog.addMessageListener(this.sb);
                    this.mengeDialog.setVisible(true);
                    break;
                }
                this.mengeDialog.setVisible(true);
                this.mengeDialog.toFront();
                this.mengeDialog.requestFocus();
                break;
            }
            case 7103: {
                this.gp.deleteMenge(DataBase.MENGE);
                DataBase.changeMenge();
                this.gp.drawMenge(DataBase.MENGE);
                break;
            }
            case 7104: {
                KafPlotFrame kafPlotFrame = this;
                if (kafPlotFrame.db.isEmpty()) break;
                KafPlotFrame kafPlotFrame2 = this;
                if (!kafPlotFrame2.db.hasMenge()) break;
                this.gp.deleteMenge(DataBase.MENGE);
                DataBase.MENGE.removeAllElements();
                break;
            }
            case 961: {
                int n3 = 0;
                KafPlotFrame kafPlotFrame = this;
                boolean bl = !kafPlotFrame.db.hasMenge();
                Object object2 = this.gp.getCommandObject();
                if (object2 != null) {
                    this.gp.deleteMenge(DataBase.MENGE);
                    if (object2 instanceof Punkt) {
                        n3 = DataBase.buildMenge((Punkt)object2);
                    } else if (object2 instanceof PunktContainer) {
                        n3 = DataBase.buildMenge(((PunktContainer)object2).getPunkte());
                    } else if (object2 instanceof GeoImage) {
                        n3 = DataBase.buildMenge(((GeoImage)object2).getImageLocation().getImagePolygon());
                    }
                    this.gp.drawMenge(DataBase.MENGE);
                }
                StringBuffer stringBuffer = new StringBuffer();
                KafPlotFrame kafPlotFrame3 = this;
                if (!kafPlotFrame3.db.hasMenge()) {
                    stringBuffer.append("Keine Menge gebildet");
                } else if (bl) {
                    stringBuffer.append("Neue Menge aus ");
                    stringBuffer.append(n3);
                    stringBuffer.append(" Punkt");
                    if (n3 != 1) {
                        stringBuffer.append("en");
                    }
                    stringBuffer.append(" gebildet.");
                } else {
                    stringBuffer.append("Der Menge wurde");
                    if (n3 != 1) {
                        stringBuffer.append("n");
                    }
                    stringBuffer.append(" ");
                    stringBuffer.append(n3);
                    stringBuffer.append(" Punkt");
                    if (n3 != 1) {
                        stringBuffer.append("e");
                    }
                    stringBuffer.append(" hinzugef\u00fcgt.");
                }
                this.sb.messagePerformed(new IMessageEvent(this, 1001, stringBuffer.toString()));
                this.sb.messagePerformed(new IMessageEvent(this, 1002, null));
                break;
            }
            case 962: {
                int n4 = 0;
                Object object3 = this.gp.getCommandObject();
                if (object3 != null) {
                    this.gp.deleteMenge(DataBase.MENGE);
                    if (object3 instanceof Punkt) {
                        n4 = DataBase.removeMenge((Punkt)object3);
                    } else if (object3 instanceof PunktContainer) {
                        n4 = DataBase.removeMenge(((PunktContainer)object3).getPunkte());
                    } else if (object3 instanceof GeoImage) {
                        n4 = DataBase.removeMenge(((GeoImage)object3).getImageLocation().getImagePolygon());
                    }
                    this.gp.drawMenge(DataBase.MENGE);
                }
                StringBuffer stringBuffer = new StringBuffer();
                KafPlotFrame kafPlotFrame = this;
                if (!kafPlotFrame.db.hasMenge()) {
                    stringBuffer.append("Menge aufgel\u00f6st");
                } else {
                    stringBuffer.append("Aus der Menge wurde");
                    if (n4 != 1) {
                        stringBuffer.append("n");
                    }
                    stringBuffer.append(" ");
                    stringBuffer.append(n4);
                    stringBuffer.append(" Punkt");
                    if (n4 != 1) {
                        stringBuffer.append("e");
                    }
                    stringBuffer.append(" entfernt.");
                }
                this.sb.messagePerformed(new IMessageEvent(this, 1001, stringBuffer.toString()));
                this.sb.messagePerformed(new IMessageEvent(this, 1002, null));
                break;
            }
            case 963: {
                Object object4 = this.gp.getCommandObject();
                if (object4 == null || !(object4 instanceof PaintObject)) break;
                ((PaintObject)object4).setVisible(true);
                this.gp.deleteCommandObject();
                this.gp.repaint(((PaintObject)object4).getBounds());
                break;
            }
            case 964: {
                Object object5 = this.gp.getCommandObject();
                if (object5 == null || !(object5 instanceof PaintObject)) break;
                ((PaintObject)object5).setVisible(false);
                this.gp.deleteCommandObject();
                this.gp.repaint(((PaintObject)object5).getBounds());
                break;
            }
            case 965: {
                Object object6 = this.gp.getCommandObject();
                if (object6 == null || !(object6 instanceof PaintObject)) break;
                Enumeration enumeration = DataBase.elementsOf(object6);
                while (enumeration.hasMoreElements()) {
                    ((PaintObject)enumeration.nextElement()).setVisible(false);
                }
                ((PaintObject)object6).setVisible(true);
                this.gp.deleteCommandObject();
                this.gp.repaint();
                break;
            }
            case 966: {
                Object object7 = this.gp.getCommandObject();
                if (object7 == null || !(object7 instanceof PaintObject)) break;
                Enumeration enumeration = DataBase.elementsOf(object7);
                while (enumeration.hasMoreElements()) {
                    ((PaintObject)enumeration.nextElement()).setVisible(true);
                }
                this.gp.deleteCommandObject();
                this.gp.repaint();
                break;
            }
            case 50: {
                KafPlotProperties.clearView();
                KafPlotFrame kafPlotFrame = this;
                if (kafPlotFrame.db.isEmpty()) break;
                this.gp.setView(this.db);
                break;
            }
            case 51: {
                if (this.gp == null) break;
                KafPlotFrame kafPlotFrame = this;
                if (kafPlotFrame.db.isEmpty()) break;
                if (this.rotDialog == null || !this.rotDialog.isVisible()) {
                    this.rotDialog = new RotationDialog(this, "Drehen");
                    this.rotDialog.setActionCommand("_repaint");
                    this.rotDialog.addActionListener(this);
                    this.rotDialog.setModal(false);
                    this.rotDialog.setVisible(true);
                    break;
                }
                this.rotDialog.setVisible(true);
                this.rotDialog.toFront();
                this.rotDialog.requestFocus();
                break;
            }
            case 55: {
                if (this.gp == null) break;
                KafPlotFrame kafPlotFrame = this;
                if (kafPlotFrame.db.isEmpty()) break;
                if (this.optionDialog == null || !this.optionDialog.isVisible()) {
                    this.optionDialog = new OptionDialog((IFrame)this, "Optionen", this.db);
                    this.optionDialog.setActionCommand("_repaint");
                    this.optionDialog.addActionListener(this);
                    this.optionDialog.setModal(false);
                    this.optionDialog.setVisible(true);
                    break;
                }
                this.optionDialog.setVisible(true);
                this.optionDialog.toFront();
                this.optionDialog.requestFocus();
                break;
            }
            case 56: {
                if (this.gp == null) break;
                KafPlotFrame kafPlotFrame = this;
                if (kafPlotFrame.db.isEmpty()) break;
                if (this.punktCheckOptionDialog == null || !this.punktCheckOptionDialog.isVisible()) {
                    this.punktCheckOptionDialog = new PunktCheckOptionDialog(this, "Punktpr\u00fcfung");
                    this.punktCheckOptionDialog.setActionCommand("_repaint");
                    this.punktCheckOptionDialog.addActionListener(this);
                    this.punktCheckOptionDialog.setModal(false);
                    this.punktCheckOptionDialog.setVisible(true);
                    break;
                }
                this.punktCheckOptionDialog.setVisible(true);
                this.punktCheckOptionDialog.toFront();
                this.punktCheckOptionDialog.requestFocus();
                break;
            }
            case 201: {
                if (n2 != 8) {
                    KafPlotProperties.setMouseSwitch(1);
                } else {
                    KafPlotProperties.setMouseSwitch(0);
                }
                if (!(object instanceof ICheckboxButton)) {
                    this.markButton.setState(KafPlotProperties.getMouseSwitch() == 1);
                }
                this.gp.deleteMarkObject();
                this.gp.setMarkObject(null);
                this.gp.setCursor();
                break;
            }
            case 202: {
                if (n2 != 8) {
                    KafPlotProperties.setMouseSwitch(2);
                } else {
                    KafPlotProperties.setMouseSwitch(0);
                }
                if (!(object instanceof ICheckboxButton)) {
                    this.centerButton.setState(KafPlotProperties.getMouseSwitch() == 2);
                }
                this.gp.setMarkedPunkt(null);
                this.gp.setCursor();
                break;
            }
            case 203: {
                if (n2 != 8) {
                    KafPlotProperties.setMouseSwitch(3);
                } else {
                    KafPlotProperties.setMouseSwitch(0);
                }
                if (!(object instanceof ICheckboxButton)) {
                    this.zoomButton.setState(KafPlotProperties.getMouseSwitch() == 3);
                }
                this.gp.setMarkedPunkt(null);
                this.gp.setCursor();
                break;
            }
            case 204: {
                if (n2 != 8) {
                    KafPlotProperties.setMouseSwitch(4);
                } else {
                    KafPlotProperties.setMouseSwitch(0);
                }
                if (!(object instanceof ICheckboxButton)) {
                    this.ezoomButton.setState(KafPlotProperties.getMouseSwitch() == 4);
                }
                this.gp.setMarkedPunkt(null);
                this.gp.setCursor();
                break;
            }
            case 205: {
                Object object8;
                if (n2 != 8) {
                    KafPlotProperties.setMouseSwitch(5);
                } else {
                    KafPlotProperties.setMouseSwitch(0);
                }
                if (!(object instanceof ICheckboxButton)) {
                    this.rulerButton.setState(KafPlotProperties.getMouseSwitch() == 5);
                }
                if (!((object8 = this.gp.getMarkObject()) instanceof OrthoLinie || object8 instanceof PolarAufnahme || object8 instanceof Bogen || object8 instanceof Flaeche)) {
                    this.gp.deleteMarkObject();
                }
                this.gp.setMarkedPunkt(null);
                this.gp.setCursor();
                break;
            }
            case 208: {
                if (n2 != 8) {
                    KafPlotProperties.setMouseSwitch(8);
                } else {
                    KafPlotProperties.setMouseSwitch(0);
                }
                if (!(object instanceof ICheckboxButton)) {
                    this.inputButton.setState(KafPlotProperties.getMouseSwitch() == 5);
                }
                this.gp.deleteMarkObject();
                this.gp.setMarkedPunkt(null);
                this.gp.setCursor();
                break;
            }
            case 206: {
                if (n2 != 8) {
                    KafPlotProperties.setMouseSwitch(6);
                } else {
                    KafPlotProperties.setMouseSwitch(0);
                }
                if (!(object instanceof ICheckboxButton)) {
                    this.amountButton.setState(KafPlotProperties.getMouseSwitch() == 6);
                }
                if (!(this.gp.getMarkObject() instanceof DPolygon)) {
                    this.gp.deleteMarkObject();
                }
                this.gp.setMarkedPunkt(null);
                this.gp.setCursor();
                break;
            }
            case 207: {
                if (n2 != 8) {
                    KafPlotProperties.setMouseSwitch(7);
                } else {
                    KafPlotProperties.setMouseSwitch(0);
                }
                if (!(object instanceof ICheckboxButton)) {
                    this.plotclipButton.setState(KafPlotProperties.getMouseSwitch() == 7);
                }
                if (!(this.gp.getMarkObject() instanceof Plotbox)) {
                    this.gp.deleteMarkObject();
                }
                this.gp.setMarkedPunkt(null);
                this.gp.setCursor();
                break;
            }
            case 401: {
                KafPlotProperties.setMarkSwitch(601);
                this.gp.deleteMarkObject();
                break;
            }
            case 402: {
                KafPlotProperties.setMarkSwitch(604);
                this.gp.deleteMarkObject();
                break;
            }
            case 403: {
                KafPlotProperties.setMarkSwitch(602);
                this.gp.deleteMarkObject();
                break;
            }
            case 404: {
                KafPlotProperties.setMarkSwitch(603);
                this.gp.deleteMarkObject();
                break;
            }
            case 405: {
                KafPlotProperties.setMarkSwitch(605);
                this.gp.deleteMarkObject();
                break;
            }
            case 406: {
                KafPlotProperties.setMarkSwitch(606);
                this.gp.deleteMarkObject();
                break;
            }
            case 407: {
                KafPlotProperties.setMarkSwitch(607);
                this.gp.deleteMarkObject();
                break;
            }
            case 408: {
                KafPlotProperties.setMarkSwitch(608);
                this.gp.deleteMarkObject();
                break;
            }
            case 409: {
                KafPlotProperties.setMarkSwitch(609);
                this.gp.deleteMarkObject();
                break;
            }
            case 410: {
                KafPlotProperties.setMarkSwitch(610);
                this.gp.deleteMarkObject();
                break;
            }
            case 411: {
                KafPlotProperties.setMarkSwitch(611);
                this.gp.deleteMarkObject();
                break;
            }
            case 501: {
                KafPlotProperties.setMessSwitch(501);
                this.gp.deleteMarkObject();
                break;
            }
            case 502: {
                KafPlotProperties.setMessSwitch(502);
                this.gp.deleteMarkObject();
                break;
            }
            case 503: {
                KafPlotProperties.setMessSwitch(503);
                this.gp.deleteMarkObject();
                break;
            }
            case 504: {
                KafPlotProperties.setMessSwitch(504);
                this.gp.deleteMarkObject();
                break;
            }
            case 505: {
                KafPlotProperties.setMessSwitch(505);
                this.gp.deleteMarkObject();
                break;
            }
            case 599: {
                KafPlotProperties.setMessFree(n2 != 8);
                this.gp.setCursor();
                break;
            }
            case 661: {
                KafPlotProperties.setInputSwitch(812);
                break;
            }
            case 662: {
                KafPlotProperties.setInputSwitch(811);
                break;
            }
            case 611: {
                KafPlotProperties.setInputSwitch(851);
                break;
            }
            case 612: {
                KafPlotProperties.setInputSwitch(852);
                break;
            }
            case 631: {
                KafPlotProperties.setInputSwitch(861);
                break;
            }
            case 632: {
                KafPlotProperties.setInputSwitch(862);
                break;
            }
            case 621: {
                KafPlotProperties.setInputSwitch(821);
                break;
            }
            case 622: {
                KafPlotProperties.setInputSwitch(822);
                break;
            }
            case 623: {
                KafPlotProperties.setInputSwitch(823);
                break;
            }
            case 625: {
                KafPlotProperties.setInputSwitch(825);
                break;
            }
            case 626: {
                KafPlotProperties.setInputSwitch(826);
                break;
            }
            case 663: {
                KafPlotProperties.setInputSwitch(871);
                break;
            }
            case 664: {
                KafPlotProperties.setInputSwitch(872);
                break;
            }
            case 665: {
                KafPlotProperties.setInputSwitch(873);
                break;
            }
            case 666: {
                KafPlotProperties.setInputSwitch(874);
                break;
            }
            case 667: {
                KafPlotProperties.setInputSwitch(875);
                break;
            }
            case 668: {
                KafPlotProperties.setInputSwitch(876);
                break;
            }
            case 671: {
                KafPlotProperties.setInputSwitch(881);
                break;
            }
            case 672: {
                KafPlotProperties.setInputSwitch(882);
                break;
            }
            case 673: {
                KafPlotProperties.setInputSwitch(883);
                break;
            }
            case 674: {
                KafPlotProperties.setInputSwitch(884);
                break;
            }
            case 675: {
                KafPlotProperties.setInputSwitch(885);
                break;
            }
            case 683: {
                InputProperties.setInputFangSwitch(901);
                this.gp.refreshInputObject();
                break;
            }
            case 684: {
                InputProperties.setInputFangSwitch(902);
                this.gp.refreshInputObject();
                break;
            }
            case 685: {
                InputProperties.setInputFangSwitch(903);
                this.gp.refreshInputObject();
                break;
            }
            case 699: {
                InputProperties.setInputFree(n2 != 8);
                this.gp.refreshInputObject();
                break;
            }
            case 7501: {
                KafPlotProperties.setObjectCatch(1, n2 != 8);
                this.gp.refreshInputObject();
                break;
            }
            case 7502: {
                KafPlotProperties.setObjectCatch(2, n2 != 8);
                this.gp.refreshInputObject();
                break;
            }
            case 7503: {
                KafPlotProperties.setObjectCatch(4, n2 != 8);
                this.gp.refreshInputObject();
                break;
            }
            case 7504: {
                KafPlotProperties.setObjectCatch(8, n2 != 8);
                this.gp.refreshInputObject();
                break;
            }
            case 7505: {
                KafPlotProperties.setObjectCatch(16, n2 != 8);
                this.gp.refreshInputObject();
                break;
            }
            case 701: {
                KafPlotProperties.setEditObjectSwitch(2201);
                this.gp.refreshInputObject();
                break;
            }
            case 702: {
                KafPlotProperties.setEditObjectSwitch(2202);
                this.gp.refreshInputObject();
                break;
            }
            case 703: {
                KafPlotProperties.setEditObjectSwitch(2203);
                this.gp.refreshInputObject();
                break;
            }
            case 704: {
                KafPlotProperties.setEditObjectSwitch(2204);
                this.gp.refreshInputObject();
                break;
            }
            case 705: {
                KafPlotProperties.setEditObjectSwitch(2205);
                this.gp.refreshInputObject();
                break;
            }
            case 101: {
                KafPlotProperties.setPunktArtVisible(n2 != 8);
                KafPlotProperties.sendOptionUpdateEvent(this);
                this.gp.repaint();
                break;
            }
            case 102: {
                KafPlotProperties.setAufnahmeVisible(n2 != 8);
                KafPlotProperties.sendOptionUpdateEvent(this);
                this.gp.repaint();
                break;
            }
            case 152: {
                KafPlotProperties.setPolarVisible(n2 != 8);
                KafPlotProperties.sendOptionUpdateEvent(this);
                this.gp.repaint();
                break;
            }
            case 103: {
                KafPlotProperties.setOrthoVisible(n2 != 8);
                KafPlotProperties.sendOptionUpdateEvent(this);
                this.gp.repaint();
                break;
            }
            case 105: {
                KafPlotProperties.setFlaecheVisible(n2 != 8);
                KafPlotProperties.sendOptionUpdateEvent(this);
                this.gp.repaint();
                break;
            }
            case 106: {
                KafPlotProperties.setPunktTextVisible(n2 != 8);
                KafPlotProperties.sendOptionUpdateEvent(this);
                this.gp.repaint();
                break;
            }
            case 107: {
                KafPlotProperties.setPunktNummerVisible(n2 != 8);
                KafPlotProperties.sendOptionUpdateEvent(this);
                this.gp.repaint();
                break;
            }
            case 108: {
                KafPlotProperties.setEllipseVisible(n2 != 8);
                KafPlotProperties.sendOptionUpdateEvent(this);
                this.gp.repaint();
                break;
            }
            case 109: {
                KafPlotProperties.setMaszeVisible(n2 != 8);
                KafPlotProperties.sendOptionUpdateEvent(this);
                this.gp.repaint();
                break;
            }
            case 110: {
                KafPlotProperties.setGitterVisible(n2 != 8);
                KafPlotProperties.sendOptionUpdateEvent(this);
                this.gp.repaint();
                break;
            }
            case 111: {
                KafPlotProperties.setBemerkungVisible(n2 != 8);
                KafPlotProperties.sendOptionUpdateEvent(this);
                this.gp.repaint();
                break;
            }
            case 112: {
                KafPlotProperties.setImagesVisible(n2 != 8);
                KafPlotProperties.sendOptionUpdateEvent(this);
                this.gp.repaint();
                break;
            }
            case 121: {
                KafPlotProperties.setAllPointsVisible(n2 != 8);
                KafPlotProperties.sendOptionUpdateEvent(this);
                this.gp.repaint();
                break;
            }
            case 122: {
                KafPlotProperties.setUnusedVisible(n2 != 8);
                KafPlotProperties.sendOptionUpdateEvent(this);
                this.gp.repaint();
                break;
            }
            case 153: {
                KafPlotProperties.setEigeneVisible(n2 != 8);
                KafPlotProperties.sendOptionUpdateEvent(this);
                this.gp.repaint();
                break;
            }
            case 154: {
                KafPlotProperties.setNachweisVisible(n2 != 8);
                KafPlotProperties.sendOptionUpdateEvent(this);
                this.gp.repaint();
                break;
            }
            case 155: {
                KafPlotProperties.setEinrechnungVisible(n2 != 8);
                KafPlotProperties.sendOptionUpdateEvent(this);
                this.gp.repaint();
                break;
            }
            case 156: {
                KafPlotProperties.setVorgabenVisible(n2 != 8);
                KafPlotProperties.sendOptionUpdateEvent(this);
                this.gp.repaint();
                break;
            }
            case 157: {
                KafPlotProperties.setTrafoVisible(n2 != 8);
                KafPlotProperties.sendOptionUpdateEvent(this);
                this.gp.repaint();
                break;
            }
            case 104: {
                KafPlotProperties.setConditionVisible(n2 != 8);
                KafPlotProperties.sendOptionUpdateEvent(this);
                this.gp.repaint();
                break;
            }
            case 158: {
                KafPlotProperties.setBedingungVisible(n2 != 8);
                KafPlotProperties.sendOptionUpdateEvent(this);
                this.gp.repaint();
                break;
            }
            case 159: {
                KafPlotProperties.setHomogenisierungVisible(n2 != 8);
                KafPlotProperties.sendOptionUpdateEvent(this);
                this.gp.repaint();
                break;
            }
            case 123: {
                KafPlotProperties.setInputShadowVisible(n2 != 8);
                KafPlotProperties.sendOptionUpdateEvent(this);
                this.gp.repaint();
                break;
            }
            case 124: {
                KafPlotProperties.isPointWithOutLinesVisible = n2 != 8;
                KafPlotProperties.sendOptionUpdateEvent(this);
                this.gp.repaint();
                break;
            }
            case 161: {
                KafPlotProperties.isPunktVisible = n2 != 8;
                KafPlotProperties.sendOptionUpdateEvent(this);
                this.gp.repaint();
                break;
            }
            case 162: {
                KafPlotProperties.isFlaechePolyVisible = n2 != 8;
                KafPlotProperties.sendOptionUpdateEvent(this);
                this.gp.repaint();
                break;
            }
            case 163: {
                KafPlotProperties.isFlaecheFillVisible = n2 != 8;
                KafPlotProperties.sendOptionUpdateEvent(this);
                this.gp.repaint();
                break;
            }
            case 164: {
                KafPlotProperties.isFlaecheTextVisible = n2 != 8;
                KafPlotProperties.sendOptionUpdateEvent(this);
                this.gp.repaint();
                break;
            }
            case 165: {
                KafPlotProperties.isPunktHoeheVisible = n2 != 8;
                KafPlotProperties.isNivellementVisible = n2 != 8;
                KafPlotProperties.isZenitVisible = n2 != 8;
                KafPlotProperties.sendOptionUpdateEvent(this);
                this.gp.repaint();
                break;
            }
            case 166: {
                KafPlotProperties.isFlaecheLengthVisible = n2 != 8;
                KafPlotProperties.sendOptionUpdateEvent(this);
                this.gp.repaint();
                break;
            }
            case 167: {
                KafPlotProperties.isFlaechePatternVisible = n2 != 8;
                KafPlotProperties.sendOptionUpdateEvent(this);
                this.gp.repaint();
                break;
            }
            case 168: {
                KafPlotProperties.isInputShadowVisible = n2 != 8;
                KafPlotProperties.sendOptionUpdateEvent(this);
                this.gp.repaint();
                break;
            }
            case 169: {
                KafPlotProperties.isPunktTextBgVisible = n2 != 8;
                KafPlotProperties.sendOptionUpdateEvent(this);
                this.gp.repaint();
                break;
            }
            case 170: {
                KafPlotProperties.isVermarkungVisible = n2 != 8;
                KafPlotProperties.sendOptionUpdateEvent(this);
                this.gp.repaint();
                break;
            }
            case 171: {
                KafPlotProperties.isGbblVisible = n2 != 8;
                KafPlotProperties.isEtNameVisible = n2 != 8;
                KafPlotProperties.sendOptionUpdateEvent(this);
                this.gp.repaint();
                break;
            }
            case 172: {
                KafPlotProperties.isUnusedVisible = n2 != 8;
                KafPlotProperties.sendOptionUpdateEvent(this);
                this.gp.repaint();
                break;
            }
            case 301: {
                KafPlotProperties.setNummerSwitch(101);
                KafPlotProperties.sendOptionUpdateEvent(this);
                this.gp.repaint();
                break;
            }
            case 302: {
                KafPlotProperties.setNummerSwitch(102);
                KafPlotProperties.sendOptionUpdateEvent(this);
                this.gp.repaint();
                break;
            }
            case 303: {
                KafPlotProperties.setNummerSwitch(103);
                KafPlotProperties.sendOptionUpdateEvent(this);
                this.gp.repaint();
                break;
            }
            case 311: {
                KafPlotProperties.isFlstTextOldVisible = n2 != 8;
                KafPlotProperties.sendOptionUpdateEvent(this);
                this.gp.repaint();
                break;
            }
            case 312: {
                KafPlotProperties.isFlstTextNewVisible = n2 != 8;
                KafPlotProperties.sendOptionUpdateEvent(this);
                this.gp.repaint();
                break;
            }
            case 321: {
                KafPlotProperties.isNutzTextVisible = n2 != 8;
                KafPlotProperties.sendOptionUpdateEvent(this);
                this.gp.repaint();
                break;
            }
            case 322: {
                KafPlotProperties.isNutzNumberVisible = n2 != 8;
                KafPlotProperties.sendOptionUpdateEvent(this);
                this.gp.repaint();
                break;
            }
            case 304: {
                KafPlotProperties.setNummerSwitch(111);
                KafPlotProperties.sendOptionUpdateEvent(this);
                this.gp.repaint();
                break;
            }
            case 305: {
                KafPlotProperties.setNummerSwitch(112);
                KafPlotProperties.sendOptionUpdateEvent(this);
                this.gp.repaint();
                break;
            }
            case 7001: {
                if (this.searchDialog == null || !this.searchDialog.isVisible()) {
                    this.searchDialog = new SearchPunktDialog(this, "Punkt suchen");
                    this.searchDialog.setActionCommand("_search_punkt");
                    this.searchDialog.addActionListener(this);
                    DataBase.addDataBaseListener(this.searchDialog);
                    this.searchDialog.setVisible(true);
                    break;
                }
                this.searchDialog.setVisible(true);
                this.searchDialog.toFront();
                this.searchDialog.requestFocus();
                break;
            }
            case 7002: {
                if (this.searchObjectDialog == null || !this.searchObjectDialog.isVisible()) {
                    this.searchObjectDialog = new SearchObjectDialog(this, "Objekt suchen");
                    this.searchObjectDialog.setActionCommand("_search_object");
                    this.searchObjectDialog.addActionListener(this);
                    this.searchObjectDialog.setVisible(true);
                    break;
                }
                this.searchObjectDialog.setVisible(true);
                this.searchObjectDialog.toFront();
                this.searchObjectDialog.requestFocus();
                break;
            }
            case 7004: {
                if (this.searchKooDialog == null || !this.searchKooDialog.isVisible()) {
                    this.searchKooDialog = new SearchKooDialog(this, "Koordinate suchen");
                    this.searchKooDialog.setActionCommand("_search_koo");
                    this.searchKooDialog.addActionListener(this);
                    this.searchKooDialog.setVisible(true);
                    break;
                }
                this.searchKooDialog.setVisible(true);
                this.searchKooDialog.toFront();
                this.searchKooDialog.requestFocus();
                break;
            }
            case 900: {
                Object object9 = this.gp.getCommandObject();
                if (object9 instanceof Punkt) {
                    this.doCommand(901, object, n2);
                    break;
                }
                if (object9 instanceof Messung) {
                    this.doCommand(902, object, n2);
                    break;
                }
                if (object9 instanceof Bedingung) {
                    this.doCommand(903, object, n2);
                    break;
                }
                if (object9 instanceof TrafoPunkt) {
                    this.doCommand(904, object, n2);
                    break;
                }
                if (object9 instanceof Linie) {
                    this.doCommand(909, object, n2);
                    break;
                }
                if (object9 instanceof Flurstueck) {
                    this.doCommand(911, object, n2);
                    break;
                }
                if (object9 instanceof Nutzung) {
                    this.doCommand(912, object, n2);
                    break;
                }
                if (object9 instanceof BodenSchaetzung) {
                    this.doCommand(913, object, n2);
                    break;
                }
                if (object9 instanceof Gebaeude) {
                    this.doCommand(914, object, n2);
                    break;
                }
                if (object9 instanceof TopObject) {
                    this.doCommand(915, object, n2);
                    break;
                }
                if (object9 instanceof GeoImage) {
                    this.doCommand(925, object, n2);
                    break;
                }
                if (object9 instanceof OrthoLinie) {
                    this.doCommand(7301, object, n2);
                    break;
                }
                if (!(object9 instanceof PolarAufnahme)) break;
                this.doCommand(7401, object, n2);
                break;
            }
            case 931: {
                Object object10 = this.gp.getCommandObject();
                if (!(object10 instanceof Punkt) || object10 == null) break;
                Punkt punkt = (Punkt)object10;
                if (this.recorderDialog == null || !this.recorderDialog.isVisible()) {
                    this.recorderDialog = new RecorderDialog(this, "Recorder");
                    this.recorderDialog.addElementInfoListener(this);
                    this.recorderDialog.setModal(false);
                    this.recorderDialog.setVisible(true);
                }
                this.recorderDialog.setObject(punkt);
                break;
            }
            case 25: {
                if (this.recorderDialog == null || !this.recorderDialog.isVisible()) {
                    this.recorderDialog = new RecorderDialog(this, "Recorder");
                    this.recorderDialog.addElementInfoListener(this);
                    this.recorderDialog.setModal(false);
                    this.recorderDialog.setVisible(true);
                }
                this.recorderDialog.setObject(new Float(3.0f));
                break;
            }
            case 26: {
                if (this.errorManagerDialog != null && this.errorManagerDialog.isVisible()) break;
                this.errorManagerDialog = new ErrorManagerDialog(this, "FehlerManager");
                this.errorManagerDialog.addElementInfoListener(this);
                this.errorManagerDialog.setActionCommand("_repaint");
                this.errorManagerDialog.addActionListener(this);
                this.errorManagerDialog.setModal(false);
                this.errorManagerDialog.setVisible(true);
                break;
            }
            case 901: {
                Object object11 = this.gp.getCommandObject();
                if (!(object11 instanceof Punkt) || object11 == null) break;
                Punkt punkt = (Punkt)object11;
                if (this.punktInfoDialog == null || !this.punktInfoDialog.isVisible()) {
                    this.punktInfoDialog = new PunktInfoDialog((IFrame)this, "Punktinfo", punkt);
                    this.punktInfoDialog.setModal(false);
                    this.punktInfoDialog.setVisible(true);
                    break;
                }
                this.punktInfoDialog.setPunkt(punkt);
                break;
            }
            case 902: {
                Object object12 = this.gp.getCommandObject();
                if (!(object12 instanceof Messung) || object12 == null) break;
                Messung messung = (Messung)object12;
                if (this.messungInfoDialog == null || !this.messungInfoDialog.isVisible()) {
                    this.messungInfoDialog = new MessungInfoDialog((IFrame)this, "Messunginfo", messung);
                    this.messungInfoDialog.setModal(false);
                    this.messungInfoDialog.setVisible(true);
                    break;
                }
                this.messungInfoDialog.setObject(messung);
                break;
            }
            case 903: {
                Object object13 = this.gp.getCommandObject();
                if (!(object13 instanceof Bedingung) || object13 == null) break;
                Bedingung bedingung = (Bedingung)object13;
                if (this.bedingungInfoDialog == null || !this.bedingungInfoDialog.isVisible()) {
                    this.bedingungInfoDialog = new BedingungInfoDialog((IFrame)this, "Bedingunginfo", bedingung);
                    this.bedingungInfoDialog.setModal(false);
                    this.bedingungInfoDialog.setVisible(true);
                    break;
                }
                this.bedingungInfoDialog.setObject(bedingung);
                break;
            }
            case 904: {
                Object object14 = this.gp.getCommandObject();
                if (object14 == null || !(object14 instanceof Punkt) && !(object14 instanceof TrafoPunkt)) break;
                if (this.trafoInfoDialog == null || !this.trafoInfoDialog.isVisible()) {
                    this.trafoInfoDialog = new TrafoInfoDialog((IFrame)this, "TrafoInfo", (Object)null);
                    this.trafoInfoDialog.setModal(false);
                    this.trafoInfoDialog.setVisible(true);
                }
                this.trafoInfoDialog.setObject(object14);
                break;
            }
            case 909: {
                Object object15 = this.gp.getCommandObject();
                if (!(object15 instanceof Linie) || object15 == null) break;
                Linie linie = (Linie)object15;
                if (this.linieInfoDialog == null || !this.linieInfoDialog.isVisible()) {
                    this.linieInfoDialog = new LinieInfoDialog((IFrame)this, "Linieinfo", linie);
                    this.linieInfoDialog.setModal(false);
                    this.linieInfoDialog.setVisible(true);
                    break;
                }
                this.linieInfoDialog.setLinie(linie);
                break;
            }
            case 911: {
                Object object16 = this.gp.getCommandObject();
                if (!(object16 instanceof Flurstueck) || object16 == null) break;
                Flurstueck flurstueck = (Flurstueck)object16;
                if (this.flstInfoDialog == null || !this.flstInfoDialog.isVisible()) {
                    this.flstInfoDialog = KafPlotProperties.getColorSwitch() == 1003 ? new GrundstueckInfoDialog((IFrame)this, "Grundst\u00fcckinfo", flurstueck) : new FlurstueckInfoDialog((IFrame)this, "Flurst\u00fcckinfo", flurstueck);
                    this.flstInfoDialog.addActionListener(this);
                    this.flstInfoDialog.setActionCommand("_flst_command");
                    this.flstInfoDialog.addElementInfoListener(this);
                    this.flstInfoDialog.setModal(false);
                    this.flstInfoDialog.setVisible(true);
                    break;
                }
                this.flstInfoDialog.setObject(flurstueck);
                break;
            }
            case 8931: {
                if (!(object instanceof ObjectListSource)) break;
                if (this.flstInfoDialog == null || !this.flstInfoDialog.isVisible()) {
                    this.flstInfoDialog = new FlurstueckInfoDialog((IFrame)this, "Flurst\u00fcckinfo", null);
                    this.flstInfoDialog.addActionListener(this);
                    this.flstInfoDialog.setActionCommand("_flst_command");
                    this.flstInfoDialog.addElementInfoListener(this);
                    this.flstInfoDialog.setModal(false);
                    this.flstInfoDialog.setVisible(true);
                }
                this.flstInfoDialog.setObjects(((ObjectListSource)object).getObjects());
                break;
            }
            case 912: {
                Object object17 = this.gp.getCommandObject();
                if (!(object17 instanceof Nutzung) || object17 == null) break;
                Nutzung nutzung = (Nutzung)object17;
                if (this.nutzInfoDialog == null || !this.nutzInfoDialog.isVisible()) {
                    this.nutzInfoDialog = new NutzungInfoDialog((IFrame)this, "Nutzungsinfo", nutzung);
                    this.nutzInfoDialog.setActionCommand("_nutz_command");
                    this.nutzInfoDialog.addElementInfoListener(this);
                    this.nutzInfoDialog.setModal(false);
                    this.nutzInfoDialog.setVisible(true);
                    break;
                }
                this.nutzInfoDialog.setObject(nutzung);
                break;
            }
            case 8932: {
                if (!(object instanceof ObjectListSource)) break;
                if (this.nutzInfoDialog == null || !this.nutzInfoDialog.isVisible()) {
                    this.nutzInfoDialog = new NutzungInfoDialog((IFrame)this, "Nutzungsinfo", null);
                    this.nutzInfoDialog.addActionListener(this);
                    this.nutzInfoDialog.setActionCommand("_nutz_command");
                    this.nutzInfoDialog.addElementInfoListener(this);
                    this.nutzInfoDialog.setModal(false);
                    this.nutzInfoDialog.setVisible(true);
                }
                this.nutzInfoDialog.setObjects(((ObjectListSource)object).getObjects());
                break;
            }
            case 913: {
                Object object18 = this.gp.getCommandObject();
                if (!(object18 instanceof BodenSchaetzung) || object18 == null) break;
                BodenSchaetzung bodenSchaetzung = (BodenSchaetzung)object18;
                if (this.bodenInfoDialog == null || !this.bodenInfoDialog.isVisible()) {
                    this.bodenInfoDialog = new BodenInfoDialog((IFrame)this, "Bodeninfo", bodenSchaetzung);
                    this.bodenInfoDialog.setActionCommand("_boden_command");
                    this.bodenInfoDialog.addElementInfoListener(this);
                    this.bodenInfoDialog.setModal(false);
                    this.bodenInfoDialog.setVisible(true);
                    break;
                }
                this.bodenInfoDialog.setObject(bodenSchaetzung);
                break;
            }
            case 914: {
                Object object19 = this.gp.getCommandObject();
                if (!(object19 instanceof Gebaeude) || object19 == null) break;
                Gebaeude gebaeude = (Gebaeude)object19;
                if (this.gebInfoDialog == null || !this.gebInfoDialog.isVisible()) {
                    this.gebInfoDialog = new GebaeudeInfoDialog((IFrame)this, "Geb\u00e4udeinfo", gebaeude);
                    this.gebInfoDialog.setActionCommand("_geb_command");
                    this.gebInfoDialog.addElementInfoListener(this);
                    this.gebInfoDialog.setModal(false);
                    this.gebInfoDialog.setVisible(true);
                    break;
                }
                this.gebInfoDialog.setObject(gebaeude);
                break;
            }
            case 8933: {
                if (!(object instanceof ObjectListSource)) break;
                if (this.gebInfoDialog == null || !this.gebInfoDialog.isVisible()) {
                    this.gebInfoDialog = new GebaeudeInfoDialog((IFrame)this, "Geb\u00e4udeinfo", null);
                    this.gebInfoDialog.addActionListener(this);
                    this.gebInfoDialog.setActionCommand("_geb_command");
                    this.gebInfoDialog.addElementInfoListener(this);
                    this.gebInfoDialog.setModal(false);
                    this.gebInfoDialog.setVisible(true);
                }
                this.gebInfoDialog.setObjects(((ObjectListSource)object).getObjects());
                break;
            }
            case 915: {
                Object object20 = this.gp.getCommandObject();
                if (!(object20 instanceof TopObject) || object20 == null) break;
                TopObject topObject = (TopObject)object20;
                if (this.topInfoDialog == null || !this.topInfoDialog.isVisible()) {
                    this.topInfoDialog = new TopObjectInfoDialog((IFrame)this, "Topographieinfo", topObject);
                    this.topInfoDialog.setActionCommand("_top_command");
                    this.topInfoDialog.addElementInfoListener(this);
                    this.topInfoDialog.setModal(false);
                    this.topInfoDialog.setVisible(true);
                    break;
                }
                this.topInfoDialog.setObject(topObject);
                break;
            }
            case 925: {
                Object object21 = this.gp.getCommandObject();
                if (!(object21 instanceof GeoImage) || object21 == null) break;
                GeoImage geoImage = (GeoImage)object21;
                if (this.imgInfoDialog == null || !this.imgInfoDialog.isVisible()) {
                    this.imgInfoDialog = new ImageInfoDialog((IFrame)this, "Imageinfo", geoImage);
                    this.imgInfoDialog.addElementInfoListener(this);
                    this.imgInfoDialog.setModal(false);
                    this.imgInfoDialog.setVisible(true);
                    break;
                }
                this.imgInfoDialog.setObject(geoImage);
                break;
            }
            case 8934: {
                if (!(object instanceof ObjectListSource)) break;
                if (this.topInfoDialog == null || !this.topInfoDialog.isVisible()) {
                    this.topInfoDialog = new TopObjectInfoDialog((IFrame)this, "Topographieinfo", null);
                    this.topInfoDialog.addActionListener(this);
                    this.topInfoDialog.setActionCommand("_top_command");
                    this.topInfoDialog.addElementInfoListener(this);
                    this.topInfoDialog.setModal(false);
                    this.topInfoDialog.setVisible(true);
                }
                this.topInfoDialog.setObjects(((ObjectListSource)object).getObjects());
                break;
            }
            case 8935: {
                if (!(object instanceof ObjectListSource)) break;
                if (this.buchInfoDialog == null || !this.buchInfoDialog.isVisible()) {
                    this.buchInfoDialog = new GrundbuchInfoDialog((IFrame)this, "Grundbuch", null);
                    this.buchInfoDialog.addActionListener(this);
                    this.buchInfoDialog.setActionCommand("_list_flst");
                    this.buchInfoDialog.setModal(false);
                    this.buchInfoDialog.setVisible(true);
                }
                this.buchInfoDialog.setObjects(((ObjectListSource)object).getObjects());
                break;
            }
            case 920: {
                if (this.gemeindeInfoDialog != null && this.gemeindeInfoDialog.isVisible()) break;
                this.gemeindeInfoDialog = new GemeindeInfoDialog(this, "Gemeinden");
                this.gemeindeInfoDialog.setModal(false);
                this.gemeindeInfoDialog.setVisible(true);
                break;
            }
            case 921: {
                if (this.gemarkungInfoDialog != null && this.gemarkungInfoDialog.isVisible()) break;
                this.gemarkungInfoDialog = new GemarkungInfoDialog(this, "Gemarkungen");
                this.gemarkungInfoDialog.setModal(false);
                this.gemarkungInfoDialog.setVisible(true);
                break;
            }
            case 922: {
                if (this.strasseInfoDialog != null && this.strasseInfoDialog.isVisible()) break;
                this.strasseInfoDialog = new StrasseInfoDialog(this, "Stra\u00dfen");
                this.strasseInfoDialog.setModal(false);
                this.strasseInfoDialog.setVisible(true);
                break;
            }
            case 923: {
                if (this.nutzungInfoDialog != null && this.nutzungInfoDialog.isVisible()) break;
                this.nutzungInfoDialog = new NutzungsArtInfoDialog(this, "Nutzungsarten");
                this.nutzungInfoDialog.setModal(false);
                this.nutzungInfoDialog.setVisible(true);
                break;
            }
            case 924: {
                if (this.rissInfoDialog != null && this.rissInfoDialog.isVisible()) break;
                this.rissInfoDialog = new RissInfoDialog(this, "Risse");
                this.rissInfoDialog.setModal(false);
                this.rissInfoDialog.setVisible(true);
                break;
            }
            case 1011: {
                Object object22 = this.gp.getCommandObject();
                Bemerkung bemerkung = null;
                if (object22 instanceof Punkt) {
                    bemerkung = new Bemerkung((Punkt)object22, null, "");
                } else if (object22 instanceof Linie) {
                    bemerkung = new Bemerkung(((Linie)object22).pa, ((Linie)object22).pe, "");
                }
                if (bemerkung == null) break;
                DataBase.BEM.addElement(bemerkung);
                DataBase.isSaved = false;
                this.gp.drawObject(bemerkung);
                break;
            }
            case 1001: {
                Object object23 = this.gp.getCommandObject();
                Vector vector = null;
                if (object23 instanceof Messung) {
                    vector = DataBase.getRequiredObjects((Messung)object23, true);
                } else if (object23 instanceof Bedingung) {
                    vector = DataBase.getRequiredObjects((Bedingung)object23, true);
                }
                if (vector == null) break;
                this.gp.deleteMarkObject();
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    ((Control)enumeration.nextElement()).setOn(true);
                }
                DataBase.isSaved = false;
                this.gp.drawObjects(vector.elements());
                break;
            }
            case 1002: {
                Object object24 = this.gp.getCommandObject();
                Vector vector = null;
                if (object24 instanceof Messung) {
                    vector = DataBase.getRequiredObjects((Messung)object24, false);
                } else if (object24 instanceof Bedingung) {
                    vector = DataBase.getRequiredObjects((Bedingung)object24, false);
                }
                if (vector == null) break;
                this.gp.deleteMarkObject();
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    ((Control)enumeration.nextElement()).setOn(false);
                }
                DataBase.isSaved = false;
                this.gp.drawObjects(vector.elements());
                break;
            }
            case 1052: {
                Object object25 = this.gp.getCommandObject();
                if (!(object25 instanceof GObject)) break;
                this.gp.deleteCommandObject();
                GObject gObject = (GObject)object25;
                try {
                    if (gObject instanceof Flurstueck) {
                        DataBase.FLST.remove(gObject);
                        DataBase.isSaved = false;
                        gObject.deleteName();
                        DataBase.FLST.put(gObject);
                        this.gp.repaint(gObject.getBounds());
                        break;
                    }
                    if (gObject instanceof Gebaeude) {
                        DataBase.GEB.remove(gObject);
                        DataBase.isSaved = false;
                        gObject.deleteName();
                        DataBase.GEB.put(gObject);
                        this.gp.repaint(gObject.getBounds());
                        break;
                    }
                    if (!(gObject instanceof TopObject)) break;
                    DataBase.TOP.remove(gObject);
                    DataBase.isSaved = false;
                    gObject.deleteName();
                    DataBase.TOP.put(gObject);
                    this.gp.repaint(gObject.getBounds());
                }
                catch (GeomException geomException) {}
                break;
            }
            case 1053: {
                Object object26 = this.gp.getCommandObject();
                if (!(object26 instanceof GObject)) break;
                this.gp.deleteCommandObject();
                ((GObject)object26).deleteArea();
                DataBase.isSaved = false;
                this.gp.repaint(((GObject)object26).getBounds());
                break;
            }
            case 1054: {
                Object object27 = this.gp.getCommandObject();
                if (!(object27 instanceof GObject)) break;
                this.gp.deleteCommandObject();
                DataBase.isSaved = false;
                DRectangle dRectangle = ((GObject)object27).getBounds();
                ((GObject)object27).deleteGeom();
                this.gp.repaint(dRectangle);
                break;
            }
            case 1055: {
                Object object28 = this.gp.getCommandObject();
                if (!(object28 instanceof GObject)) break;
                this.gp.deleteCommandObject();
                GObject gObject = (GObject)object28;
                if (gObject instanceof Flurstueck) {
                    DataBase.FLST.remove(gObject);
                    DataBase.isSaved = false;
                } else if (gObject instanceof Gebaeude) {
                    DataBase.GEB.remove(gObject);
                    DataBase.isSaved = false;
                } else if (gObject instanceof TopObject) {
                    DataBase.TOP.remove(gObject);
                    DataBase.isSaved = false;
                }
                this.gp.repaint(gObject.getBounds());
                break;
            }
            case 1056: {
                Object object29 = this.gp.getCommandObject();
                if (!(object29 instanceof GObject)) break;
                this.gp.deleteCommandObject();
                GObject gObject = (GObject)object29;
                DataBase.removeBestimmungen(gObject.getPunkte());
                DataBase.isSaved = false;
                this.gp.repaint(gObject.getBounds());
                break;
            }
            case 1061: {
                Object object30 = this.gp.getCommandObject();
                if (!(object30 instanceof GObject)) break;
                this.gp.deleteCommandObject();
                GObject gObject = (GObject)object30;
                GObjectManipulator gObjectManipulator = new GObjectManipulator(gObject);
                try {
                    gObjectManipulator.repair();
                }
                catch (Exception exception) {
                    this.sb.messagePerformed(new IMessageEvent(this, 1001, exception.getMessage()));
                }
                this.gp.repaint(gObject.getBounds());
                break;
            }
            case 1062: {
                Object object31 = this.gp.getCommandObject();
                if (!(object31 instanceof GObject)) break;
                this.gp.deleteCommandObject();
                GObject gObject = (GObject)object31;
                DRectangle dRectangle = gObject.getBounds();
                GObjectManipulator gObjectManipulator = new GObjectManipulator(gObject);
                try {
                    gObjectManipulator.split();
                }
                catch (Exception exception) {
                    this.sb.messagePerformed(new IMessageEvent(this, 1001, exception.getMessage()));
                }
                this.gp.repaint(dRectangle);
                break;
            }
            case 1063: {
                Object object32 = this.gp.getCommandObject();
                if (!(object32 instanceof GObject)) break;
                this.gp.deleteCommandObject();
                GObject gObject = (GObject)object32;
                DRectangle dRectangle = gObject.getBounds();
                GObjectManipulator gObjectManipulator = new GObjectManipulator(gObject);
                try {
                    gObjectManipulator.concatenate();
                }
                catch (Exception exception) {
                    this.sb.messagePerformed(new IMessageEvent(this, 1001, exception.getMessage()));
                }
                this.gp.repaint(dRectangle);
                break;
            }
            case 14: {
                Object object33 = this.gp.getCommandObject();
                if (!(object33 instanceof GeoImage)) break;
                this.gp.deleteCommandObject();
                GeoImage geoImage = (GeoImage)object33;
                ImageLoader imageLoader = new ImageLoader((IFrame)this, "Bild laden", new File(geoImage.getFilePath()), geoImage);
                imageLoader.setVisible(true);
                this.gp.repaint(geoImage.getBounds());
                break;
            }
            case 15: {
                Object object34 = this.gp.getCommandObject();
                if (!(object34 instanceof GeoImage)) break;
                this.gp.deleteCommandObject();
                GeoImage geoImage = (GeoImage)object34;
                geoImage.removeImageData();
                this.gp.repaint(geoImage.getBounds());
                break;
            }
            case 16: {
                Object object35 = this.gp.getCommandObject();
                if (!(object35 instanceof GeoImage)) break;
                this.gp.deleteCommandObject();
                GeoImage geoImage = (GeoImage)object35;
                geoImage.setVisible(true);
                this.gp.repaint(geoImage.getBounds());
                break;
            }
            case 17: {
                Object object36 = this.gp.getCommandObject();
                if (!(object36 instanceof GeoImage)) break;
                this.gp.deleteCommandObject();
                GeoImage geoImage = (GeoImage)object36;
                geoImage.setVisible(false);
                this.gp.repaint(geoImage.getBounds());
                break;
            }
            case 18: {
                Object object37 = this.gp.getCommandObject();
                if (!(object37 instanceof GeoImage)) break;
                GeoImage geoImage = (GeoImage)object37;
                if (this.imgDialog == null || !this.imgDialog.isVisible()) {
                    this.imgDialog = new ImageObjectDialog((IFrame)this, "Imageoptionen", geoImage);
                    this.imgDialog.setActionCommand("_repaint");
                    this.imgDialog.addActionListener(this);
                    this.imgDialog.setModal(false);
                    this.imgDialog.setVisible(true);
                    DataBase.addDataBaseListener(this.imgDialog);
                    break;
                }
                this.imgDialog.setImage(geoImage);
                this.imgDialog.setVisible(true);
                this.imgDialog.toFront();
                this.imgDialog.requestFocus();
                break;
            }
            case 19: {
                if (this.imgObjectsDialog == null || !this.imgObjectsDialog.isVisible()) {
                    this.imgObjectsDialog = new ImageObjectsDialog((IFrame)this, "Images", DataBase.IMG);
                    this.imgObjectsDialog.setActionCommand("_repaint");
                    this.imgObjectsDialog.addActionListener(this);
                    this.imgObjectsDialog.setModal(false);
                    this.imgObjectsDialog.setVisible(true);
                    DataBase.addDataBaseListener(this.imgObjectsDialog);
                    break;
                }
                this.imgObjectsDialog.setVisible(true);
                this.imgObjectsDialog.toFront();
                this.imgObjectsDialog.requestFocus();
                break;
            }
            case 7301: {
                if (!(this.gp.getCommandObject() instanceof OrthoLinie)) break;
                OrthoLinie orthoLinie = (OrthoLinie)this.gp.getCommandObject();
                if (this.orthoLinieDialog == null || !this.orthoLinieDialog.isVisible()) {
                    this.orthoLinieDialog = new OrthoLinieDialog((IFrame)this, "Orthogonale Linie", orthoLinie);
                    this.orthoLinieDialog.setActionCommand("_ortho_linie");
                    this.orthoLinieDialog.addActionListener(this);
                    this.orthoLinieDialog.setModal(false);
                    this.orthoLinieDialog.setVisible(true);
                    break;
                }
                this.orthoLinieDialog.setOrthoLinie(orthoLinie);
                break;
            }
            case 7401: {
                if (!(this.gp.getCommandObject() instanceof PolarAufnahme)) break;
                PolarAufnahme polarAufnahme = (PolarAufnahme)this.gp.getCommandObject();
                if (this.polaraufnahmeDialog == null || !this.polaraufnahmeDialog.isVisible()) {
                    this.polaraufnahmeDialog = new PolarAufnahmeDialog((IFrame)this, "polare Aufnahme", polarAufnahme);
                    this.polaraufnahmeDialog.setActionCommand("_polaraufnahme");
                    this.polaraufnahmeDialog.addActionListener(this);
                    this.polaraufnahmeDialog.setModal(false);
                    this.polaraufnahmeDialog.setVisible(true);
                    break;
                }
                this.polaraufnahmeDialog.setPolarAufnahme(polarAufnahme);
                break;
            }
            case 8900: {
                if (this.gp == null) break;
                this.gp.repaint();
                break;
            }
            case 8901: {
                KafPlotFrame kafPlotFrame = this;
                if (kafPlotFrame.db.isEmpty()) break;
                KafPlotFrame kafPlotFrame4 = this;
                if (!kafPlotFrame4.db.hasMenge()) break;
                this.gp.drawMenge(DataBase.MENGE);
                break;
            }
            case 8911: {
                KafPlotFrame kafPlotFrame = this;
                kafPlotFrame.db.sendUpdateEvent();
                break;
            }
            case 8804: {
                Punkt punkt;
                if (!(object instanceof PunktSupplier) || (punkt = ((PunktSupplier)object).getPunkt()) == null) break;
                this.gp.centerOfPunkt(punkt);
                this.gp.setMarkedPunkt(punkt);
                break;
            }
            case 8801: {
                InputObject inputObject;
                if (!(object instanceof ObjectSupplier) || (inputObject = (InputObject)((ObjectSupplier)object).getObject()) == null) break;
                this.gp.setInputObject(inputObject);
                break;
            }
            case 8802: {
                this.gp.setInputObject(null);
                break;
            }
            case 8921: {
                KafPlotFrame kafPlotFrame = this;
                if (kafPlotFrame.db.isEmpty() || this.searchDialog == null) break;
                PunktTable.SearchResult searchResult = DataBase.P.searchNumber(this.searchDialog.getSearchString(), this.searchDialog.getSearchAction());
                Punkt punkt = searchResult.getPunkt();
                this.gp.centerOfPunkt(punkt);
                this.gp.setMarkedPunkt(punkt);
                this.searchDialog.setSearchResult(searchResult);
                break;
            }
            case 8922: {
                KafPlotFrame kafPlotFrame = this;
                if (kafPlotFrame.db.isEmpty() || this.searchObjectDialog == null) break;
                GObject gObject = this.searchObjectDialog.getResult();
                if (gObject != null) {
                    this.gp.centerOfPunkt(gObject.y, gObject.x);
                }
                this.gp.setMarkObject(gObject);
                break;
            }
            case 8924: {
                KafPlotFrame kafPlotFrame = this;
                if (kafPlotFrame.db.isEmpty() || this.searchKooDialog == null) break;
                DPoint dPoint = this.searchKooDialog.getPoint();
                if (dPoint != null) {
                    this.gp.centerOfPunkt(dPoint.y, dPoint.x);
                }
                this.gp.setMarkObject(dPoint);
                break;
            }
            case 8941: {
                KafPlotFrame kafPlotFrame = this;
                if (kafPlotFrame.db.isEmpty() || object == null || !(object instanceof ObjectInfoDialog)) break;
                this.gp.deleteMarkObject();
                GObject gObject = (GObject)((ObjectInfoDialog)object).getObject();
                if (gObject == null) break;
                if (gObject.hasLocation()) {
                    this.gp.centerOfPunkt(gObject.y, gObject.x);
                }
                this.gp.setMarkObject(gObject);
                break;
            }
            case 8944: {
                KafPlotFrame kafPlotFrame = this;
                if (kafPlotFrame.db.isEmpty() || this.gebInfoDialog == null) break;
                this.gp.deleteMarkObject();
                Object object38 = this.gebInfoDialog.getObject();
                Gebaeude gebaeude = null;
                if (object38 instanceof Gebaeude) {
                    gebaeude = (Gebaeude)object38;
                    if (gebaeude.hasLocation()) {
                        this.gp.centerOfPunkt(gebaeude.y, gebaeude.x);
                    }
                } else if (object38 instanceof GebaeudeKennzeichen) {
                    GebaeudeKennzeichen gebaeudeKennzeichen = (GebaeudeKennzeichen)object38;
                    gebaeude = gebaeudeKennzeichen.getGebaeude();
                    if (gebaeudeKennzeichen.hasLocation()) {
                        this.gp.centerOfPunkt(gebaeudeKennzeichen.y, gebaeudeKennzeichen.x);
                    } else if (gebaeude.hasLocation()) {
                        this.gp.centerOfPunkt(gebaeude.y, gebaeude.x);
                    }
                }
                if (gebaeude == null) break;
                this.gp.setMarkObject(gebaeude);
                break;
            }
            case 8945: {
                KafPlotFrame kafPlotFrame = this;
                if (kafPlotFrame.db.isEmpty() || this.topInfoDialog == null) break;
                this.gp.deleteMarkObject();
                TopObject topObject = (TopObject)this.topInfoDialog.getObject();
                if (topObject == null) break;
                if (topObject.hasLocation()) {
                    this.gp.centerOfPunkt(topObject.y, topObject.x);
                }
                this.gp.setMarkObject(topObject);
                break;
            }
            case 8951: {
                KafPlotFrame kafPlotFrame = this;
                if (kafPlotFrame.db.isEmpty() || this.orthoLinieDialog == null) break;
                if (this.gp.getMarkObject() instanceof OrthoLinie) {
                    this.gp.deleteMarkObject();
                }
                this.gp.setMarkObject(this.orthoLinieDialog.getUpdatedOrthoLinie());
                break;
            }
            case 8952: {
                KafPlotFrame kafPlotFrame = this;
                if (kafPlotFrame.db.isEmpty() || this.polaraufnahmeDialog == null) break;
                if (this.gp.getMarkObject() instanceof PolarAufnahme) {
                    this.gp.deleteMarkObject();
                }
                this.gp.setMarkObject(this.polaraufnahmeDialog.getUpdatedPolarAufnahme());
                break;
            }
            case 9900: {
                this.gp.repaint();
                break;
            }
            case 9901: {
                IInfoDialog iInfoDialog = new IInfoDialog((IFrame)this, "Info ", KafPlotVersion.getLicenceName(), 1);
                iInfoDialog.setVisible(true);
                break;
            }
            case 9902: {
                TextDialog textDialog = new TextDialog(this, "Info ");
                Properties properties = System.getProperties();
                Enumeration<?> enumeration = properties.propertyNames();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    textDialog.appendText(string + " = " + System.getProperty(string) + "\n");
                }
                textDialog.setEditable(false);
                textDialog.setModal(false);
                textDialog.setVisible(true);
                break;
            }
            case 9903: {
                konsole.setVisible(true);
            }
        }
    }

    @Override
    public void objectUpdated(IObjectEvent iObjectEvent) {
        Object object = iObjectEvent.getObject();
        if (object instanceof Drawable) {
            Drawable drawable = (Drawable)object;
            DRectangle dRectangle = drawable.getBounds();
            this.gp.repaint(dRectangle);
        }
    }

    protected String parseProjektName(String string) {
        int n = string.lastIndexOf(46);
        if (n < 0) {
            return new String(string.trim());
        }
        return string.substring(0, n).trim();
    }

    protected void setLayoutOfProperties() {
        if (this.mainBar != null) {
            this.mainBar.setLayoutOfProperties();
        }
        this.gp.setCursor();
    }

    protected abstract void loadProperties() throws IOException;

    protected abstract void setTitle();

    protected void createLayout() {
        this.setTitle();
        this.loadIconSet("KafPlot");
        this.setForeground(SystemColor.controlText);
        this.setBackground(SystemColor.control);
        this.addMainMenu();
        this.setLayout(new BorderLayout());
        this.add("North", this.createSymbolBar());
        this.add("West", this.createToolBar());
        this.sb = new StatusBar();
        this.sb.addKeyListener(this);
        this.add("South", this.sb);
        this.gp = new GraphicPanel(this.db);
        this.gp.addKeyListener(this);
        this.gp.addMessageListener(this.sb);
        this.gp.addQuestionListener(this.sb);
        this.gp.addActionListener(this);
        this.gp.setInfoObjectCommand("Info");
        this.gp.addGraphicListener(this);
        GraphicPanelPopupMenu graphicPanelPopupMenu = new GraphicPanelPopupMenu();
        graphicPanelPopupMenu.addActionListener(this);
        this.gp.addPopupMenu(graphicPanelPopupMenu);
        this.add("Center", this.gp);
        this.addKeyListener(this);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                KafPlotFrame.this.endSession();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                KafPlotFrame.this.setDialogWindow(KafPlotFrame.this.gp.getBounds());
            }
        });
        this.setLocation(FRAME_X, FRAME_Y);
        this.setSize(FRAME_B, FRAME_H);
        this.setVisible(true);
        this.setDialogWindow(this.gp.getBounds());
        this.requestFocus();
    }

    protected abstract void addMainMenu();

    protected abstract Panel createSymbolBar();

    protected IToolBar createToolBar() {
        IToolBar iToolBar = new IToolBar(1);
        iToolBar.addKeyListener(this);
        this.toolGroup = new ICheckboxButtonGroup();
        iToolBar.add(new ISeparator(0));
        this.markButton = this.createICheckboxButton(1, "Markieren", this.toolGroup);
        iToolBar.add(this.markButton);
        this.centerButton = this.createICheckboxButton(2, "Zentrieren", this.toolGroup);
        iToolBar.add(this.centerButton);
        this.zoomButton = this.createICheckboxButton(3, "Zoomen", this.toolGroup);
        iToolBar.add(this.zoomButton);
        this.ezoomButton = this.createICheckboxButton(4, "Ellipsen zoomen", this.toolGroup);
        iToolBar.add(this.ezoomButton);
        this.rulerButton = this.createICheckboxButton(6, "Messen", this.toolGroup);
        iToolBar.add(this.rulerButton);
        iToolBar.add(new ISeparator(0));
        return iToolBar;
    }

    protected IButton createIButton(int n, String string) {
        IButton iButton = new IButton(n, string);
        iButton.addActionListener(this);
        iButton.addKeyListener(this);
        return iButton;
    }

    protected ICheckboxButton createICheckboxButton(int n, String string, boolean bl) {
        ICheckboxButton iCheckboxButton = new ICheckboxButton(n, string);
        iCheckboxButton.addActionListener(this);
        iCheckboxButton.addKeyListener(this);
        iCheckboxButton.setState(bl);
        return iCheckboxButton;
    }

    protected ICheckboxButton createICheckboxButton(int n, String string, ICheckboxButtonGroup iCheckboxButtonGroup) {
        ICheckboxButton iCheckboxButton = new ICheckboxButton(n, string, iCheckboxButtonGroup);
        iCheckboxButton.addActionListener(this);
        iCheckboxButton.addKeyListener(this);
        return iCheckboxButton;
    }

    protected abstract void endSession();

    protected abstract void setCommandInput();

    public static Konsole getKonsole() {
        return konsole;
    }

    public static boolean isKonsoleVisible() {
        return konsole.isVisible();
    }

    static {
        commands.put("Neues Projekt", 1);
        commands.put("\u00d6ffnen", 2);
        commands.put("Speichern", 3);
        commands.put("Speichern unter", 4);
        commands.put("Nachladen", 5);
        commands.put("Importieren", 6);
        commands.put("Importieren...", 10006);
        commands.put("Exportieren", 7);
        commands.put("Bild laden", 8);
        commands.put("Bilddaten laden", 14);
        commands.put("Bilddaten entfernen", 15);
        commands.put("Bilddaten einblenden", 16);
        commands.put("Bilddaten ausblenden", 17);
        commands.put("Bildoptionen", 18);
        commands.put("Bildspeicheroptionen", 19);
        commands.put("Pr\u00fcfen", 10);
        commands.put("DateiInfo", 9);
        commands.put("Drucken", 11);
        commands.put("Schlie\u00dfen", 12);
        commands.put("Beenden", 13);
        commands.put("Bearbeiten", 28);
        commands.put("Kopieren", 20);
        commands.put("Punktnummer kopieren", 10020);
        commands.put("Einf\u00fcgen", 21);
        commands.put("Etrs-Transformation", 23);
        commands.put("Transformation", 24);
        commands.put("Recorder", 25);
        commands.put("Fehlermanager", 26);
        commands.put("Punktattribute \u00e4ndern", 27);
        commands.put("Kataster-Nachweis", 30);
        commands.put("Fortf\u00fchrungsbeleg", 31);
        commands.put("NAS-Export", 32);
        commands.put("Ver\u00e4nderungsliste", 33);
        commands.put("Einrechnungsliste", 34);
        commands.put("Fl\u00e4chenbeleg", 35);
        commands.put("Eigent\u00fcmernachweis", 36);
        commands.put("Statistikbeleg", 37);
        commands.put("Objektliste", 38);
        commands.put("Fehlerstapel", 39);
        commands.put("Viewer-Daten", 40);
        commands.put("Systra-Projekt", 41);
        commands.put("Neu Zeichnen", 50);
        commands.put("Drehen", 51);
        commands.put("Optionen", 55);
        commands.put("Punktpr\u00fcfung", 56);
        commands.put("WMS verbinden", 70);
        commands.put("WMS erzeugen", 71);
        commands.put("WMS entfernen", 72);
        commands.put("WMS anfragen", 73);
        commands.put("WMS speichern", 74);
        commands.put("KafPlotService verbinden", 80);
        commands.put("KafPlotService erzeugen", 81);
        commands.put("KafPlotService entfernen", 82);
        commands.put("Punktstatus erzeugen", 60);
        commands.put("Digitalisierung erzeugen", 61);
        commands.put("Bedingungen erzeugen", 62);
        commands.put("Lagegenauigkeitsstufe erzeugen", 63);
        commands.put("Katasternachweis umgewichten", 64);
        commands.put("Doppelte Punkte suchen", 65);
        commands.put("Punktraster erzeugen", 66);
        commands.put("Punkte umnummerieren", 67);
        commands.put("Info ", 90);
        commands.put("Hilfe", 91);
        commands.put("Punktarten", 101);
        commands.put("Aufnahmepfeile", 102);
        commands.put("Messungslinien", 103);
        commands.put("Objekte", 105);
        commands.put("Punktbeschriftung", 106);
        commands.put("Punktnummern", 107);
        commands.put("Ellipsen", 108);
        commands.put("Ma\u00dfzahlen", 109);
        commands.put("Gitternetz", 110);
        commands.put("Bemerkungen", 111);
        commands.put("Images", 112);
        commands.put("lokale Punkte", 121);
        commands.put("unbenutzte", 122);
        commands.put("Gps-Messungen", 151);
        commands.put("Polare Messungen", 152);
        commands.put("Messbandmessungen", 153);
        commands.put("Katasternachweis", 154);
        commands.put("Einrechnungen", 155);
        commands.put("Vorgaben", 156);
        commands.put("Transformationen", 157);
        commands.put("Bedingungen", 104);
        commands.put("Bedingungen ", 158);
        commands.put("Homogenisierung", 159);
        commands.put("Urgeometrie", 123);
        commands.put("Punkte ohne Linien", 124);
        commands.put("Punkte", 161);
        commands.put("Linien", 162);
        commands.put("Fl\u00e4chen", 163);
        commands.put("Texte", 164);
        commands.put("H\u00f6hen", 165);
        commands.put("L\u00e4ngen", 166);
        commands.put("Linienmuster", 167);
        commands.put("Urgeomatrie", 168);
        commands.put("Freistellung", 169);
        commands.put("Vermarkung", 170);
        commands.put("Eigent\u00fcmer", 171);
        commands.put("Offline", 172);
        commands.put("Markieren", 201);
        commands.put("Zentrieren", 202);
        commands.put("Zoomen", 203);
        commands.put("Ellipsen zoomen", 204);
        commands.put("Messen", 205);
        commands.put("Menge bilden", 206);
        commands.put("Plotbox erzeugen", 207);
        commands.put("Objekte erzeugen", 208);
        commands.put("alte Punktnummern", 301);
        commands.put("neue Punktnummern", 302);
        commands.put("beide Punktnummern", 303);
        commands.put("nur alte Punktnummern", 304);
        commands.put("nur neue Punktnummern", 305);
        commands.put("alte Flstnummern", 311);
        commands.put("neue Flstnummern", 312);
        commands.put("Nutzungstext", 321);
        commands.put("Nutzungsnummer", 322);
        commands.put("Angaben zur Bodensch\u00e4tzung", 329);
        commands.put("Grundbuchblatt", 331);
        commands.put("Eigent\u00fcmername", 332);
        commands.put("Eigent\u00fcmerdetails", 333);
        commands.put("Buchfl\u00e4che", 341);
        commands.put("Koordinatenfl\u00e4che", 342);
        commands.put("Fl\u00e4chendifferenz", 343);
        commands.put("Fl\u00e4chenabweichung", 344);
        commands.put("Punkte markieren", 401);
        commands.put("Linien markieren", 402);
        commands.put("Messungen markieren", 403);
        commands.put("Bedingungen markieren", 404);
        commands.put("Flurst\u00fccke markieren", 405);
        commands.put("Nutzung markieren", 406);
        commands.put("Bodensch\u00e4tzung markieren", 407);
        commands.put("Geb\u00e4ude markieren", 408);
        commands.put("Topographie markieren", 409);
        commands.put("Bemerkungen markieren", 410);
        commands.put("Bilder markieren", 411);
        commands.put("Orthogonal", 501);
        commands.put("Polar", 502);
        commands.put("Bogen", 503);
        commands.put("Fl\u00e4che", 504);
        commands.put("Linienzug", 505);
        commands.put("frei", 599);
        commands.put("Linie teilen", 611);
        commands.put("Linien verbinden", 612);
        commands.put("Objekt teilen", 631);
        commands.put("Objekt verbinden", 632);
        commands.put("GPS-Basislinie eingeben", 621);
        commands.put("Polarmessung eingeben", 622);
        commands.put("Orthogonale Linie eingeben", 623);
        commands.put("Messbandstrecke eingeben", 625);
        commands.put("Bogenschlag eingeben", 626);
        commands.put("Punktverschiebung eingeben", 661);
        commands.put("Punktidentit\u00e4t eingeben", 662);
        commands.put("Gerade eingeben", 663);
        commands.put("Rechten Winkel eingeben", 664);
        commands.put("Parallele eingeben", 665);
        commands.put("Abstand zur einer Geraden eingeben", 666);
        commands.put("Abstand zu einem Punkt eingeben", 667);
        commands.put("Kreisbogen eingeben", 668);
        commands.put("Passpunkte angeben", 671);
        commands.put("Passpunkte w\u00e4hlen", 672);
        commands.put("Ausschnitt angeben", 673);
        commands.put("Bild verschieben", 674);
        commands.put("Bildgr\u00f6\u00dfe \u00e4ndern", 675);
        commands.put("Transformation einf\u00fcgen", 680);
        commands.put("Flurst\u00fccke eingeben", 651);
        commands.put("Geb\u00e4ude eingeben", 652);
        commands.put("Topographie eingeben", 653);
        commands.put("Flurst\u00fccke bearbeiten", 701);
        commands.put("Geb\u00e4ude bearbeiten", 702);
        commands.put("Topographie bearbeiten", 703);
        commands.put("Nutzung bearbeiten", 704);
        commands.put("Bodensch\u00e4tzung bearbeiten", 705);
        commands.put("Punktnummer eingeben", 683);
        commands.put("Punkte fangen", 684);
        commands.put("Linien fangen", 685);
        commands.put("Riss", 691);
        commands.put("Linienart", 692);
        commands.put("Eingabe mit Maus", 699);
        commands.put("Flurst\u00fccke fangen", 7501);
        commands.put("Geb\u00e4ude fangen", 7502);
        commands.put("Topographie fangen", 7503);
        commands.put("Nutzung fangen", 7504);
        commands.put("Bodensch\u00e4tzung fangen", 7505);
        commands.put("Info", 900);
        commands.put("Punktinfo", 901);
        commands.put("Messunginfo", 902);
        commands.put("Bedingunginfo", 903);
        commands.put("Trafoinfo", 904);
        commands.put("Bestimmungen", 931);
        commands.put("Linieinfo", 909);
        commands.put("Flurst\u00fcckinfo", 911);
        commands.put("Nutzingsinfo", 912);
        commands.put("Geb\u00e4udeinfo", 914);
        commands.put("Topographieinfo", 915);
        commands.put("Gemeinden", 920);
        commands.put("Gemarkungen", 921);
        commands.put("Stra\u00dfen", 922);
        commands.put("Nutzungsarten", 923);
        commands.put("Risse", 924);
        commands.put("Imageinfo", 925);
        commands.put("Punktattribute setzen", 949);
        commands.put("Punktstatus fest Altkoordinate", 941);
        commands.put("Punktstatus fest Neukoordinate", 942);
        commands.put("Punktstatus beweglich Altkoordinate", 943);
        commands.put("Punktstatus beweglich Neukoordinate", 944);
        commands.put("Punktstatus frei", 940);
        commands.put("Punktstatus H\u00f6he", 945);
        commands.put("Punktstatus ung\u00fcltig", 946);
        commands.put("Fehlertyp Fehler", 951);
        commands.put("Fehlertyp Warnung", 952);
        commands.put("Fehlertyp Meldung", 953);
        commands.put("Fehlertyp bearbeitet", 954);
        commands.put("Punkte kopieren", 960);
        commands.put("zur Menge hinzuf\u00fcgen", 961);
        commands.put("aus Menge entfernen", 962);
        commands.put("Einblenden", 963);
        commands.put("Ausblenden", 964);
        commands.put("ausschlie\u00dflich anzeigen", 965);
        commands.put("alle anzeigen", 966);
        commands.put("Markierung setzen", 1011);
        commands.put("anschalten", 1001);
        commands.put("ausschalten", 1002);
        commands.put("L\u00f6schen", 1050);
        commands.put("Zur\u00fccksetzen", 1051);
        commands.put("L\u00f6sche Objektname", 1052);
        commands.put("L\u00f6sche Objektfl\u00e4che", 1053);
        commands.put("L\u00f6sche Objektgeometrie", 1054);
        commands.put("L\u00f6sche vollst\u00e4ndig", 1055);
        commands.put("L\u00f6sche Bestimung", 1056);
        commands.put("Repariere Geometrie", 1061);
        commands.put("Zerlege Geometrie", 1062);
        commands.put("Anker generieren", 1063);
        commands.put("suche Punkt", 7001);
        commands.put("suche Objekt", 7002);
        commands.put("suche im WWW", 7003);
        commands.put("suche Koordinate", 7004);
        commands.put("Menge erzeugen", 7101);
        commands.put("Menge aus Datei", 7102);
        commands.put("Menge umkehren", 7103);
        commands.put("Menge aufl\u00f6sen", 7104);
        commands.put("Plotbox aufl\u00f6sen", 7201);
        commands.put("Orthogonale Linie", 7301);
        commands.put("Polaraufnahme", 7401);
        commands.put("_send_inputobject", 8801);
        commands.put("_destroy_inputobject", 8802);
        commands.put("_update_plotbox", 8803);
        commands.put("_view_punkt", 8804);
        commands.put("_repaint", 8900);
        commands.put("_repaint_menge", 8901);
        commands.put("_repaint_object", 8902);
        commands.put("_data_update", 8911);
        commands.put("_search_punkt", 8921);
        commands.put("_search_object", 8922);
        commands.put("_search_www", 8923);
        commands.put("_search_koo", 8924);
        commands.put("_list_flst", 8931);
        commands.put("_list_nutz", 8932);
        commands.put("_list_geb", 8933);
        commands.put("_list_top", 8934);
        commands.put("_list_buch", 8935);
        commands.put("_flst_command", 8941);
        commands.put("_nutz_command", 8942);
        commands.put("_boden_command", 8943);
        commands.put("_geb_command", 8944);
        commands.put("_top_command", 8945);
        commands.put("_buch_command", 8946);
        commands.put("_ortho_linie", 8951);
        commands.put("_polaraufnahme", 8952);
        commands.put("?debug", 9900);
        commands.put("?licence", 9901);
        commands.put("?systeminfo", 9902);
        commands.put("?konsole", 9903);
    }
}

