/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.kafplot.KafPlotProperties;
import de.geocalc.kafplot.KafPlotService;
import de.geocalc.kafplot.KafPlotServiceMessage;
import de.geocalc.kafplot.event.ServiceEvent;
import de.geocalc.kafplot.event.ServiceListener;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;

public class KafPlotServiceClient
extends Thread
implements KafPlotService {
    protected MulticastSocket socket = null;
    protected InetAddress address = null;
    protected ServiceListener serviceListener = null;
    protected boolean state = true;
    protected int port = 0;

    public KafPlotServiceClient(String string, int n, ServiceListener serviceListener) throws IOException {
        try {
            this.addServiceListener(serviceListener);
            this.socket = new MulticastSocket(n);
            this.address = InetAddress.getByName(string);
            this.port = n;
            this.socket.joinGroup(this.address);
            this.start();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw iOException;
        }
    }

    public void addServiceListener(ServiceListener serviceListener) {
        this.serviceListener = serviceListener;
    }

    public void removeServiceListener(ServiceListener serviceListener) {
        if (this.serviceListener == serviceListener) {
            this.serviceListener = null;
        }
    }

    public void setState(boolean bl) {
        this.state = bl;
    }

    @Override
    public String toString() {
        return this.address.getHostAddress() + ":" + this.port;
    }

    @Override
    public void run() {
        if (this.serviceListener != null) {
            this.serviceListener.serviceStarted(new ServiceEvent(this, 1001, null));
        }
        while (this.state) {
            if (KafPlotProperties.getKpsPort() < 0) {
                this.state = false;
                break;
            }
            if (this.serviceListener == null) continue;
            try {
                byte[] byArray = new byte[1024];
                DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
                this.socket.receive(datagramPacket);
                String string = new String(datagramPacket.getData(), 0, datagramPacket.getLength());
                KafPlotServiceMessage kafPlotServiceMessage = new KafPlotServiceMessage(string);
                if (kafPlotServiceMessage.hasValue("TRANSMIT")) {
                    this.serviceListener.packetSended(new ServiceEvent(this, 1003, kafPlotServiceMessage));
                    continue;
                }
                if (kafPlotServiceMessage.hasValue("REQUEST")) {
                    this.serviceListener.packetRequested(new ServiceEvent(this, 1004, kafPlotServiceMessage));
                    continue;
                }
                if (!kafPlotServiceMessage.hasValue("CONNECTION")) continue;
                String string2 = kafPlotServiceMessage.getValue("CONNECTION");
                if (string2.equals("Start")) {
                    this.serviceListener.serviceStarted(new ServiceEvent(this, 1001, null));
                    continue;
                }
                if (!string2.equals("End")) continue;
                KafPlotProperties.setKpsPort(-1);
                break;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        try {
            this.socket.leaveGroup(this.address);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.socket.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this.serviceListener != null) {
            this.serviceListener.serviceAborted(new ServiceEvent(this, 1002, null));
        }
    }
}

