/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.kafplot.KafPlotProperties;
import de.geocalc.kafplot.KafPlotService;
import de.geocalc.kafplot.KafPlotServiceMessage;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.util.Vector;

public class KafPlotServiceServer
extends Thread
implements KafPlotService {
    protected MulticastSocket socket = null;
    protected InetAddress group = null;
    protected boolean state = true;
    protected int port = 0;
    protected Vector<KafPlotServiceMessage> queue = null;

    public KafPlotServiceServer(String string, int n) throws IOException {
        this.port = n;
        this.socket = new MulticastSocket(n);
        this.group = InetAddress.getByName(string);
        this.queue = new Vector();
        this.start();
    }

    @Override
    public void run() {
        while (this.state) {
            try {
                if (this.queue.size() > 0) {
                    KafPlotServiceMessage kafPlotServiceMessage = this.queue.elementAt(0);
                    this.queue.removeElementAt(0);
                    byte[] byArray = kafPlotServiceMessage.toString().getBytes();
                    this.socket.send(new DatagramPacket(byArray, byArray.length, this.group, this.port), (byte)1);
                } else if (KafPlotProperties.getKpsPort() < 0) {
                    this.state = false;
                    break;
                }
                try {
                    KafPlotServiceServer.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        this.socket.close();
    }

    public void addMessage(KafPlotServiceMessage kafPlotServiceMessage) {
        this.queue.addElement(kafPlotServiceMessage);
    }

    public void setState(boolean bl) {
        this.state = bl;
    }
}

