/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.kafplot.DataBase;
import de.geocalc.util.Variable;
import de.geocalc.util.VariableNotFoundException;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class KafPlotVariableTable {
    protected static final Hashtable TABLE = new Hashtable();
    private static final int PROJEKT_FILE_NAME = 1001;
    private static final int PROJEKT_TITEL = 1002;
    private static final int PROJEKT_VERM_STELLE = 1003;
    private static final int PROJEKT_ADRESSE1 = 1004;
    private static final int PROJEKT_ADRESSE2 = 1005;
    private static final int PROJEKT_ADRESSE3 = 1006;
    private static final int PROJEKT_BEARBEITER = 1007;
    private static final int PROJEKT_GEMEINDE_NAME = 1010;
    private static final int PROJEKT_GEMARKUNG_NAME = 1020;
    private static final int PROJEKT_FLUR = 1031;
    private static final int PROJEKT_FLURSTUECK = 1032;
    private static final int PROJEKT_KATAMT_NAME = 1040;
    private static final int PROJEKT_HOEHE = 1051;
    private static final int PROJEKT_KOO_SYSTEM = 1052;
    private static DataBase db;

    protected static String getVariableValue(int n) {
        switch (n) {
            case 1001: {
                return db.getSourceName();
            }
            case 1002: {
                return DataBase.projekt;
            }
            case 1003: {
                return DataBase.vermStelle;
            }
            case 1004: {
                return DataBase.adresse_1;
            }
            case 1005: {
                return DataBase.adresse_2;
            }
            case 1006: {
                return DataBase.adresse_3;
            }
            case 1007: {
                return DataBase.bearbeiter;
            }
            case 1010: {
                return DataBase.gemeinde;
            }
            case 1020: {
                return DataBase.gemarkung;
            }
            case 1031: {
                return DataBase.flur;
            }
            case 1032: {
                return DataBase.flurstueck;
            }
            case 1040: {
                return DataBase.katasterAmt;
            }
        }
        return null;
    }

    public static void setSource(DataBase dataBase) {
        db = dataBase;
    }

    public static String getValue(Variable variable) throws VariableNotFoundException {
        StringTokenizer stringTokenizer = new StringTokenizer(variable.getString(), "%", true);
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            if (string.equals("%")) {
                ++n;
                continue;
            }
            if (n % 2 == 1) {
                String string2 = KafPlotVariableTable.getValue(string);
                if (string2 != null) {
                    stringBuffer.append(string2);
                    continue;
                }
                stringBuffer.append("-?-");
                continue;
            }
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    private static String getValue(String string) throws VariableNotFoundException {
        Integer n = (Integer)TABLE.get(string);
        if (n == null) {
            throw new VariableNotFoundException("Variable " + string + " nicht definiert");
        }
        return KafPlotVariableTable.getVariableValue(n);
    }

    static {
        TABLE.put("ProjektFileName", new Integer(1001));
        TABLE.put("ProjektTitel", new Integer(1002));
        TABLE.put("ProjektVermStelle", new Integer(1003));
        TABLE.put("ProjektAdresse1", new Integer(1004));
        TABLE.put("ProjektAdresse2", new Integer(1005));
        TABLE.put("ProjektAdresse3", new Integer(1006));
        TABLE.put("ProjektBearbeiter", new Integer(1007));
        TABLE.put("ProjektGemeindeName", new Integer(1010));
        TABLE.put("ProjektGemarkungName", new Integer(1020));
        TABLE.put("ProjektFlur", new Integer(1031));
        TABLE.put("ProjektFlurst\u00fcck", new Integer(1032));
        TABLE.put("ProjektKatamtName", new Integer(1040));
        TABLE.put("ProjektH\u00f6he", new Integer(1051));
        TABLE.put("ProjektKooSystem", new Integer(1052));
    }
}

