/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.event.IMessageEvent;
import de.geocalc.awt.event.IMessageListener;
import de.geocalc.kafplot.KafPlot;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.StringTokenizer;

public class KafPlotVersion {
    public static final long LC_WAIT_TIME = 120000L;
    public static final int KAFPLOT = 1;
    public static final int KAFPLOTREADER = 5;
    public static final int KAFPLOTVIEWER = 10;
    public static final int KAFDAT = 50;
    public static int progVersion = 1;
    public static final String VERSION = "2.1.011";
    public static final String VERSION_DATE = "27.05.2025";
    public static final String HOME = "www.geocalc.de";
    public static final String MAIL = "kafplot@geocalc.de";
    public static final String AUTOR = "Dipl.- Ing. J\u00f6rg Schr\u00f6der";
    private static String provider_version = null;
    private static String provider_date = null;
    private static String provider_version_info_link = "http://geocalc.de/kafplot/hilfe/vers2/ver.html#last";
    private static final int _TEST_POINTS = 100;
    private static final String _KAFPLOT = "KafPlot A\u00b3";
    private static final String _VIEWER = "Viewer";
    private static final String _READER = "Reader";
    private static final String _KAFDAT = "KafDat";
    private static final String _TESTVERSION = "TestVersion";
    private static final String _TESTVERSION_DATE = "01.06.2025";
    public static long LIZENZ_NR = 0L;
    public static long DATA_NR = 0L;
    private static int TEST_POINTS = 100;
    private static boolean READER_VERSION = false;
    private static boolean PLUS_VERSION = false;
    private static boolean NACHW_VERSION = false;
    private static boolean BELEG_VERSION = false;
    public static String LIZENZ_NM = null;
    public static String LIZENZ_LC = null;
    public static String LIZENZ_AD = null;
    private static final String VERSION_INFO_URL = "http://www.geocalc.de/kafplot/KafPlotVersion.info";

    public static boolean hasProviderUpdate() {
        return provider_version != null && !provider_version.equals(VERSION);
    }

    public static String getProviderUpdateInfo() {
        if (provider_version == null) {
            return "keine Updateinformationen verf\u00fcgbar";
        }
        if (provider_version.equals(VERSION)) {
            return "die Version ist aktuell";
        }
        if (provider_date != null) {
            return "Version " + provider_version + " vom " + provider_date + " verf\u00fcgbar";
        }
        return "Version " + provider_version + " verf\u00fcgbar";
    }

    public static String getProviderUpdateInfoLink() {
        return provider_version_info_link;
    }

    public static String getTitle(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        switch (n) {
            case 1: {
                stringBuffer.append(_KAFPLOT);
                break;
            }
            case 10: {
                stringBuffer.append(_KAFPLOT);
                stringBuffer.append(_VIEWER);
                break;
            }
            case 5: {
                stringBuffer.append(_KAFPLOT);
                stringBuffer.append(_READER);
                break;
            }
            case 50: {
                stringBuffer.append(_KAFDAT);
                break;
            }
            default: {
                stringBuffer.append("unknown");
            }
        }
        return stringBuffer.toString();
    }

    public static String getName(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(KafPlotVersion.getTitle(n));
        stringBuffer.append("\n\n");
        stringBuffer.append("Version: ");
        stringBuffer.append(VERSION);
        if (KafPlotVersion.isReaderVersion()) {
            stringBuffer.append(" Reader");
        }
        stringBuffer.append("\n");
        if (n == 10) {
            stringBuffer.append("\nFreeware");
        } else if (!KafPlotVersion.isTestVersion()) {
            stringBuffer.append("\nLizenz-Nr.: ");
            stringBuffer.append(LIZENZ_NR);
        } else {
            stringBuffer.append("\n(");
            stringBuffer.append(_TESTVERSION);
            stringBuffer.append(")\n");
            stringBuffer.append("g\u00fcltig bis: ");
            stringBuffer.append(_TESTVERSION_DATE);
        }
        stringBuffer.append("\n\nWWW: ");
        stringBuffer.append(HOME);
        stringBuffer.append("  EMAIL: ");
        stringBuffer.append(MAIL);
        stringBuffer.append("\n\n");
        if (n != 10) {
            stringBuffer.append("\u00a9 ");
        }
        stringBuffer.append(AUTOR);
        return stringBuffer.toString();
    }

    public static String getUserAgent() {
        return "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:19.0) Gecko/20100101 Firefox/19.0";
    }

    public static String getLicenceName() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("P: " + LIZENZ_NR + "\n");
        stringBuffer.append("D: " + DATA_NR + "\n");
        if (!KafPlotVersion.isTestVersion()) {
            if (LIZENZ_NM != null) {
                stringBuffer.append(LIZENZ_NM + "\n");
            }
            if (LIZENZ_LC != null) {
                stringBuffer.append(LIZENZ_LC + "\n");
            }
            if (LIZENZ_AD != null) {
                stringBuffer.append(LIZENZ_AD + "\n");
            }
        }
        return stringBuffer.toString();
    }

    public static long getLizenzNummer() {
        return LIZENZ_NR;
    }

    private static void setLizenzNummer(long l) {
        LIZENZ_NR = l;
        DATA_NR = l;
    }

    public static long getDataLizenzNummer() {
        return DATA_NR;
    }

    public static void setDataLizenzNummer(long l) {
        DATA_NR = l;
    }

    public static boolean isSigned(String string) {
        if (string.equals("XmlWriter.class")) {
            return KafPlotVersion.isPlusVersion() || KafPlotVersion.isTestVersion();
        }
        if (string.equals("GeografUmnumWriter.class")) {
            return KafPlotVersion.isPlusVersion() || KafPlotVersion.isTestVersion();
        }
        if (string.equals("KplWriter.class")) {
            return KafPlotVersion.isPlusVersion() || KafPlotVersion.isTestVersion();
        }
        if (string.equals("KpdWriter.class")) {
            return KafPlotVersion.isPlusVersion() || KafPlotVersion.isTestVersion();
        }
        if (string.equals("LtaWriter.class")) {
            return KafPlotVersion.isPlusVersion() || KafPlotVersion.isTestVersion();
        }
        if (string.equals("LtaReader.class")) {
            return KafPlotVersion.isPlusVersion() || KafPlotVersion.isTestVersion();
        }
        if (string.equals("WldgeReader.class")) {
            return KafPlotVersion.isPlusVersion() || KafPlotVersion.isTestVersion();
        }
        if (string.equals("AlkReader.class")) {
            return KafPlotVersion.isPlusVersion() || KafPlotVersion.isTestVersion();
        }
        if (string.equals("Hoehe.class")) {
            return KafPlotVersion.isPlusVersion() || KafPlotVersion.isTestVersion();
        }
        if (string.equals("GeoImage.class")) {
            return KafPlotVersion.isPlusVersion() || KafPlotVersion.isTestVersion();
        }
        if (string.equals("HomWriter.class")) {
            return LIZENZ_NR == 1203843L;
        }
        if (string.equals("GeografHomWriter.class")) {
            return LIZENZ_NR == 1203843L;
        }
        if (string.equals("SystraReader.class")) {
            return KafPlotVersion.isPlusVersion() || KafPlotVersion.isTestVersion();
        }
        if (string.equals("SystraWriter.class")) {
            return (KafPlotVersion.isPlusVersion() || KafPlotVersion.isTestVersion()) && !KafPlotVersion.isReaderVersion();
        }
        if (string.equals("StatistikbelegWriter.class")) {
            return KafPlotVersion.isPlusVersion() || KafPlotVersion.isTestVersion();
        }
        if (string.equals("CreateLgaDialog.class")) {
            return KafPlotVersion.isPlusVersion() || KafPlotVersion.isTestVersion();
        }
        if (string.equals("ReweightMessungDialog.class")) {
            return LIZENZ_NR == 1203843L;
        }
        if (string.equals("WebService.class")) {
            return KafPlotVersion.isPlusVersion() || KafPlotVersion.isTestVersion();
        }
        if (string.equals("KafPlotService.class")) {
            return KafPlotVersion.isPlusVersion() || KafPlotVersion.isTestVersion();
        }
        if (string.equals("WfsgService.class")) {
            return KafPlotVersion.isPlusVersion() || KafPlotVersion.isTestVersion();
        }
        if (string.equals("EsriDigitWriter.class")) {
            return LIZENZ_NR == 1203843L;
        }
        if (string.equals("KafkaWriter.class")) {
            return true;
        }
        if (string.equals("DatWriter.class")) {
            return !KafPlotVersion.isReaderVersion();
        }
        if (string.equals("NasFFWriter.class")) {
            return !KafPlotVersion.isReaderVersion() && (KafPlotVersion.isPlusVersion() || KafPlotVersion.isTestVersion());
        }
        return true;
    }

    public static boolean isTestVersion() {
        return TEST_POINTS != 0;
    }

    public static boolean isReaderVersion() {
        return READER_VERSION;
    }

    public static boolean isPlusVersion() {
        return PLUS_VERSION;
    }

    public static boolean isKatasterNachweisVersion() {
        return NACHW_VERSION;
    }

    public static boolean isKatasterBelegVersion() {
        return BELEG_VERSION;
    }

    public static int testPoints() {
        return TEST_POINTS;
    }

    public static void load(InputStream inputStream) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        try {
            int n;
            int n2;
            int n3;
            int n4;
            int n5 = 0;
            int[] nArray = new int[7];
            for (n4 = 0; n4 < 7; ++n4) {
                nArray[n4] = dataInputStream.readByte();
                n5 += nArray[n4];
                int n6 = n4;
                nArray[n6] = nArray[n6] - 13 % (n4 + 1);
            }
            if (dataInputStream.readByte() + 72 != n5) {
                throw new IOException();
            }
            n4 = 1;
            LIZENZ_NR = 0L;
            for (n3 = 6; n3 >= 0; --n3) {
                LIZENZ_NR += (long)(nArray[n3] * n4);
                n4 *= 10;
            }
            DATA_NR = LIZENZ_NR;
            TEST_POINTS = dataInputStream.readShort() + 11358;
            if (dataInputStream.readShort() != TEST_POINTS % 357 + 981) {
                throw new IOException();
            }
            n3 = dataInputStream.readByte();
            if (n3 == nArray[4] * nArray[6] - 13) {
                NACHW_VERSION = true;
            } else if (n3 == nArray[3] + nArray[5] + 79) {
                NACHW_VERSION = false;
            } else {
                throw new IOException();
            }
            n3 = dataInputStream.readByte();
            if (n3 == nArray[3] + nArray[6] * 5) {
                BELEG_VERSION = true;
            } else if (n3 == nArray[4] - nArray[5] + 46) {
                BELEG_VERSION = false;
            } else {
                throw new IOException();
            }
            n3 = dataInputStream.readByte();
            if (n3 == nArray[4] * nArray[5] - 54) {
                PLUS_VERSION = true;
            } else if (n3 == nArray[3] * nArray[5] + 16) {
                PLUS_VERSION = false;
            } else {
                throw new IOException();
            }
            n5 = 0;
            int n7 = dataInputStream.readByte() - nArray[5] + 56;
            StringBuffer stringBuffer = new StringBuffer(n7);
            for (n2 = 0; n2 < n7; ++n2) {
                n = dataInputStream.readShort() - n2 + 11;
                stringBuffer.append((char)n);
                n5 += n;
            }
            LIZENZ_NM = stringBuffer.toString();
            if (dataInputStream.readShort() != n5 + (nArray[4] * 1000 + nArray[3] * 100 + nArray[6] * 10 + nArray[4])) {
                throw new IOException();
            }
            for (n2 = 0; n2 < nArray[3]; ++n2) {
                dataInputStream.readByte();
            }
            n5 = 0;
            n7 = dataInputStream.readByte() + nArray[6] - 23;
            stringBuffer = new StringBuffer(n7);
            for (n2 = 0; n2 < n7; ++n2) {
                n = dataInputStream.readShort() + n2 - 34;
                stringBuffer.append((char)n);
                n5 += n;
            }
            LIZENZ_LC = stringBuffer.toString();
            if (dataInputStream.readShort() != n5 + (nArray[6] * 1000 + nArray[5] * 100 + nArray[3] * 10 + nArray[4])) {
                throw new IOException();
            }
            for (n2 = 0; n2 < (int)(1.3 * (double)nArray[4]); ++n2) {
                dataInputStream.readByte();
            }
            n5 = 0;
            n7 = dataInputStream.readByte() + nArray[4] - 19;
            stringBuffer = new StringBuffer(n7);
            for (n2 = 0; n2 < n7; ++n2) {
                n = dataInputStream.readShort() + n2 + 13;
                stringBuffer.append((char)n);
                n5 += n;
            }
            LIZENZ_AD = stringBuffer.toString();
            if (dataInputStream.readShort() != n5 + (nArray[5] * 1000 + nArray[3] * 100 + nArray[4] * 10 + nArray[6])) {
                throw new IOException();
            }
            switch ((int)LIZENZ_NR) {
                case 1203963: 
                case 1203974: 
                case 1204112: {
                    throw new IOException();
                }
                case 1206182: 
                case 1207293: 
                case 1207312: {
                    READER_VERSION = true;
                }
            }
            try {
                dataInputStream.readByte();
            }
            catch (Exception exception) {
                return;
            }
            throw new IOException();
        }
        catch (IOException iOException) {
            KafPlotVersion.remove();
            throw new IOException("Ung\u00fcltige Lizenz");
        }
    }

    private static void remove() {
        LIZENZ_NR = 0L;
        DATA_NR = 0L;
        TEST_POINTS = 100;
        PLUS_VERSION = false;
        NACHW_VERSION = false;
        BELEG_VERSION = false;
        LIZENZ_NM = null;
        LIZENZ_LC = null;
        LIZENZ_AD = null;
    }

    private static String readCodedString(DataInputStream dataInputStream, int n) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        short s = 0;
        while ((s = dataInputStream.readShort()) != 1) {
            stringBuffer.append((char)(s / n));
        }
        return stringBuffer.toString();
    }

    public static void loadProviderVersionInfo(IMessageListener iMessageListener) {
        new ProviderVersionInfoLoader(VERSION_INFO_URL, iMessageListener).start();
    }

    private static class ProviderVersionInfoLoader
    extends Thread {
        private String url;
        private IMessageListener listener;

        public ProviderVersionInfoLoader(String string, IMessageListener iMessageListener) {
            this.url = string;
            this.listener = iMessageListener;
            this.setPriority(1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            HttpURLConnection httpURLConnection = null;
            BufferedReader bufferedReader = null;
            try {
                URL uRL = new URL(this.url);
                httpURLConnection = (HttpURLConnection)uRL.openConnection();
                httpURLConnection.setRequestMethod("GET");
                httpURLConnection.setRequestProperty("Content-Type", "text/plain");
                httpURLConnection.setRequestProperty("User-Agent", "KafPlot/2.1.011/" + LIZENZ_NR);
                httpURLConnection.connect();
                int n = httpURLConnection.getResponseCode();
                if (n == 200) {
                    Object object;
                    String string;
                    bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));
                    while ((string = bufferedReader.readLine()) != null) {
                        object = new StringTokenizer(string, ",");
                        if (!((StringTokenizer)object).hasMoreTokens() || !((StringTokenizer)object).nextToken().equals("KafPlot")) continue;
                        if (((StringTokenizer)object).hasMoreTokens()) {
                            provider_version = ((StringTokenizer)object).nextToken().trim();
                        }
                        if (!((StringTokenizer)object).hasMoreTokens()) continue;
                        provider_date = ((StringTokenizer)object).nextToken().trim();
                    }
                    bufferedReader.close();
                    if (this.listener != null && provider_version != null && !KafPlotVersion.VERSION.equals(provider_version)) {
                        object = "Neue Version " + provider_version + " verf\u00fcgbar!";
                        this.listener.messagePerformed(new IMessageEvent(this, 1003, (String)object));
                        Thread.sleep(5000L);
                        this.listener.messagePerformed(new IMessageEvent(this, 1009, (String)object));
                    }
                } else if (KafPlot.debug()) {
                    System.out.println("KafPlotVersion.loadProviderVersionInfo.responseCode: " + n);
                }
            }
            catch (Exception exception) {
                if (KafPlot.debug()) {
                    exception.printStackTrace();
                }
            }
            finally {
                if (httpURLConnection != null) {
                    try {
                        httpURLConnection.disconnect();
                    }
                    catch (Exception exception) {}
                }
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }
}

