/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.IFrame;
import de.geocalc.awt.event.ElementInfoListener;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.GeoImage;
import de.geocalc.kafplot.ImageLoader;
import de.geocalc.kafplot.InfoDialog;
import de.geocalc.kafplot.KafPlotCommand;
import de.geocalc.kafplot.KafPlotFrame;
import de.geocalc.kafplot.KafPlotProperties;
import de.geocalc.kafplot.KafPlotSymbolBar;
import de.geocalc.kafplot.KafPlotVersion;
import de.geocalc.kafplot.ViewerMainMenu;
import de.geocalc.kafplot.ViewerReader;
import de.geocalc.kafplot.io.ErrorReader;
import de.geocalc.kafplot.io.KpvReader;
import de.geocalc.kafplot.io.TflReader;
import java.awt.Panel;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;

public class KafPlotViewer
extends KafPlotFrame
implements KafPlotCommand,
ActionListener,
KeyListener,
ElementInfoListener {
    private ViewerMainMenu mainMenu;
    private Hashtable urls = new Hashtable();

    public static void main(String[] stringArray) {
        KafPlotVersion.progVersion = 10;
        if (stringArray != null && stringArray.length > 0) {
            boolean bl = false;
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                if (string.startsWith("-")) {
                    // empty if block
                }
                System.out.println(string);
            }
        }
        KafPlotViewer kafPlotViewer = new KafPlotViewer();
        kafPlotViewer.setVisible(true);
        kafPlotViewer.requestFocus();
    }

    public KafPlotViewer() {
        this.setToolTipsEnabled(true);
        this.gp.addGraphicListener(this);
        try {
            ClassLoader classLoader = this.getClass().getClassLoader();
            InputStream inputStream = classLoader.getResourceAsStream("data.kpv");
            if (inputStream != null) {
                KpvReader kpvReader = new KpvReader(inputStream, this.db, null);
                kpvReader.read();
                inputStream.close();
                KafPlotViewer kafPlotViewer = this;
                kafPlotViewer.db.init();
                this.gp.setView(this.db);
                this.sb.setText();
                this.setTitle(this.createTitle());
                this.setCommandInput();
                this.mainMenu.removeThemes();
                KafPlotProperties.initColors();
                KafPlotProperties.init(this.db);
                Enumeration enumeration = KafPlotProperties.getThemesNames();
                while (enumeration.hasMoreElements()) {
                    this.mainMenu.addTheme((String)enumeration.nextElement());
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private String createTitle() {
        StringBuffer stringBuffer = new StringBuffer(KafPlotVersion.getTitle(10));
        stringBuffer.append("  -  ");
        if (DataBase.gemarkung != null) {
            stringBuffer.append(DataBase.gemarkung);
        }
        if (DataBase.flur != null) {
            stringBuffer.append("  Flur " + DataBase.flur);
        }
        if (DataBase.flurstueck != null) {
            stringBuffer.append("  Flst. " + DataBase.flurstueck);
        }
        stringBuffer.append("  -  ");
        stringBuffer.append(DataBase.vermStelle);
        return stringBuffer.toString();
    }

    protected void putURL(String string, URL uRL) {
        this.urls.put(string, uRL);
    }

    protected void loadUrl(URL uRL) {
        if (uRL != null) {
            ViewerReader viewerReader = new ViewerReader((IFrame)this, "\u00d6ffnen", this.db, uRL);
            viewerReader.setVisible(true);
            KafPlotViewer kafPlotViewer = this;
            kafPlotViewer.db.init();
            this.gp.setView(this.db);
            this.sb.setText();
            DataBase.projektFileName = this.parseProjektName(uRL.getFile());
            this.setCommandInput();
            this.mainMenu.removeThemes();
            KafPlotProperties.initColors();
            KafPlotProperties.init(this.db);
            Enumeration enumeration = KafPlotProperties.getThemesNames();
            while (enumeration.hasMoreElements()) {
                this.mainMenu.addTheme((String)enumeration.nextElement());
            }
        }
    }

    protected void loadErrors(URL uRL) throws Exception {
        ErrorReader errorReader = new ErrorReader(uRL, DataBase.ERR, null);
        errorReader.read();
    }

    protected void loadImgs(URL uRL) throws Exception {
        TflReader tflReader = new TflReader(uRL, this.db, null);
        tflReader.read();
    }

    @Override
    protected void doCommand(int n, Object object, int n2) {
        switch (n) {
            case 90: {
                InfoDialog infoDialog = new InfoDialog(this, "Info ");
                infoDialog.setVisible(true);
                break;
            }
            case 14: {
                Object object2 = this.gp.getCommandObject();
                if (!(object2 instanceof GeoImage)) break;
                this.gp.deleteCommandObject();
                GeoImage geoImage = (GeoImage)object2;
                try {
                    ImageLoader imageLoader = new ImageLoader((IFrame)this, "Bild laden", (URL)this.urls.get(geoImage.getPathName()), geoImage);
                    imageLoader.setVisible(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.gp.repaint(geoImage.getBounds());
                break;
            }
            default: {
                super.doCommand(n, object, n2);
            }
        }
    }

    @Override
    protected void endSession() {
        System.exit(0);
    }

    @Override
    protected void loadProperties() throws IOException {
        KafPlotProperties.setNummerSwitch(102);
        KafPlotProperties.setVermarkungVisible(true);
        KafPlotProperties.setMaszeVisible(true);
        KafPlotProperties.setEigeneVisible(false);
        KafPlotProperties.setNachweisVisible(true);
        KafPlotProperties.setEinrechnungVisible(false);
        KafPlotProperties.setVorgabenVisible(false);
    }

    @Override
    protected void setTitle() {
        StringBuffer stringBuffer = new StringBuffer(KafPlotVersion.getTitle(10));
        if (DataBase.projektFileName != null) {
            stringBuffer.append(" [" + DataBase.projektFileName + "] ");
        }
        this.setTitle(stringBuffer.toString());
    }

    @Override
    protected void addMainMenu() {
        this.mainMenu = new ViewerMainMenu();
        this.mainMenu.addActionListener(this);
        this.setMenuBar(this.mainMenu);
    }

    @Override
    protected Panel createSymbolBar() {
        this.mainBar = new KafPlotSymbolBar();
        this.mainBar.addActionListener(this);
        this.mainBar.addKeyListener(this);
        return this.mainBar;
    }

    @Override
    protected void setCommandInput() {
        KafPlotViewer kafPlotViewer = this;
        int n = kafPlotViewer.db.getState();
        switch (n) {
            case -1: {
                this.mainMenu.setState(-1);
                break;
            }
            case 0: {
                this.mainMenu.setState(0);
                break;
            }
            case 2: {
                this.mainMenu.setState(1);
                break;
            }
            case 3: {
                this.mainMenu.setState(2);
            }
        }
        KafPlotViewer kafPlotViewer2 = this;
        this.mainMenu.setDataOutEnabled(kafPlotViewer2.db.hasMenge());
        KafPlotViewer kafPlotViewer3 = this;
        this.mainMenu.setPlotboxEnabled(kafPlotViewer3.db.hasPlotbox());
        this.markButton.setEnabled(n > 0);
        this.centerButton.setEnabled(n >= 0);
        this.zoomButton.setEnabled(n >= 0);
        this.ezoomButton.setEnabled(n >= 0);
        this.rulerButton.setEnabled(n >= 0);
        this.setLayoutOfProperties();
    }
}

