/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.ErrorDialog;
import de.geocalc.awt.IException;
import de.geocalc.awt.IFrame;
import de.geocalc.awt.IProgressViewer;
import de.geocalc.io.IFileInputException;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.FileReaderDialog;
import de.geocalc.kafplot.Gemeinde;
import de.geocalc.kafplot.PropertyLoader;
import de.geocalc.kafplot.io.DatReader;
import de.geocalc.kafplot.io.IFileReader;
import de.geocalc.kafplot.io.IPunktReader;
import de.geocalc.kafplot.io.KpvReader;
import de.geocalc.kafplot.io.KpzReader;
import de.geocalc.kafplot.io.Lt2Reader;
import de.geocalc.kafplot.io.Lt3Reader;
import de.geocalc.kafplot.io.Lt5Reader;
import de.geocalc.kafplot.io.Lt6Reader;
import de.geocalc.kafplot.io.Lt7Reader;
import de.geocalc.kafplot.io.Lt8Reader;
import de.geocalc.kafplot.io.Lt9Reader;
import de.geocalc.kafplot.io.LtaReader;
import de.geocalc.kafplot.io.MessungParser;
import de.geocalc.kafplot.io.dat.KafkaIOProperties;
import java.io.File;
import java.util.Vector;

public class KafkaReader
extends FileReaderDialog
implements Runnable {
    public static final boolean isKafkaFile(File file) {
        String string = file.getAbsolutePath().toLowerCase();
        return string.endsWith(".dat") || string.endsWith(".lt3");
    }

    public static final boolean isProjektFile(File file) {
        String string = file.getAbsolutePath().toLowerCase();
        if (string.endsWith(".kpv") || string.endsWith(".kpz")) {
            return file.exists();
        }
        if (string.endsWith(".lt3") || string.endsWith(".dat")) {
            return KafkaReader.isProjektName(string.substring(0, string.length() - 4));
        }
        return false;
    }

    public static final boolean isProjektName(String string) {
        return new File(string + ".lt3").exists() && new File(string + ".dat").exists();
    }

    public KafkaReader(IFrame iFrame, String string, DataBase dataBase, File file) {
        super(iFrame, string, dataBase, file);
    }

    @Override
    public void run() {
        KafkaIOProperties.init();
        try {
            String string = this.inFile.getAbsolutePath().toLowerCase();
            if (string.endsWith(".kpv")) {
                this.readKpv();
            } else if (string.endsWith(".kpz")) {
                this.readKpz();
            } else {
                this.readDat();
            }
        }
        catch (IFileInputException iFileInputException) {
            ErrorDialog errorDialog = new ErrorDialog(this.parent, iFileInputException);
            errorDialog.setVisible(true);
        }
        catch (IException iException) {
            ErrorDialog errorDialog = new ErrorDialog(this.parent, iException);
            errorDialog.setVisible(true);
        }
        this.endDialog();
    }

    private void readKpv() throws IException {
        KpvReader kpvReader = new KpvReader(this.inFile, this.db, (IProgressViewer)this.progressBar);
        kpvReader.read();
        this.db.setArea(-1);
    }

    private void readKpz() throws IException {
        KpzReader kpzReader = new KpzReader(this.inFile, this.db, (IProgressViewer)this.progressBar);
        kpzReader.read();
        this.db.setArea(-1);
    }

    private void readDat() throws IException {
        IFileReader iFileReader;
        String string = this.inFile.getAbsolutePath().substring(0, this.inFile.getAbsolutePath().lastIndexOf("."));
        File file = new File(string + ".lt3");
        if (file.exists()) {
            this.setInFile(file);
            iFileReader = new Lt3Reader(this.inFile, DataBase.P, (IProgressViewer)this.progressBar);
            iFileReader.setExceptionList(this.exceptions);
            ((IPunktReader)iFileReader).read();
            this.db.setArea(-1);
        }
        if ((file = new File(string + ".dat")).exists()) {
            this.setInFile(file);
            this.progressBar.setValue(0);
            iFileReader = new DatReader(this.inFile, this.db, this.progressBar);
            iFileReader.setExceptionList(this.exceptions);
            ((DatReader)iFileReader).read();
        }
        if ((file = new File(string + ".lt2")).exists() && KafkaIOProperties.isLT2Read()) {
            this.setInFile(file);
            this.progressBar.setValue(0);
            iFileReader = new Lt2Reader(this.inFile, this.db, this.progressBar);
            iFileReader.setExceptionList(this.exceptions);
            ((Lt2Reader)iFileReader).read();
        }
        if ((file = new File(string + ".lt5")).exists() && KafkaIOProperties.isLT5Read()) {
            this.setInFile(file);
            this.progressBar.setValue(0);
            iFileReader = new Lt5Reader(this.inFile, this.db, this.progressBar);
            iFileReader.setExceptionList(this.exceptions);
            ((Lt5Reader)iFileReader).read();
        }
        if ((file = new File(string + ".lt6")).exists() && KafkaIOProperties.isLT6Read()) {
            this.setInFile(file);
            this.progressBar.setValue(0);
            iFileReader = new Lt6Reader(this.inFile, DataBase.ERR, DataBase.P, this.progressBar);
            iFileReader.setExceptionList(this.exceptions);
            ((Lt6Reader)iFileReader).read();
        }
        if ((file = new File(string + ".lt7")).exists() && KafkaIOProperties.isLT7Read()) {
            this.setInFile(file);
            this.progressBar.setValue(0);
            iFileReader = new Lt7Reader(this.inFile, DataBase.P, (IProgressViewer)this.progressBar);
            Vector<Integer> vector = new Vector<Integer>();
            vector.addElement(new Integer(303));
            vector.addElement(new Integer(411));
            vector.addElement(new Integer(412));
            iFileReader.setMode(2082);
            iFileReader.setParameterList(vector);
            ((IPunktReader)iFileReader).read();
        }
        if ((file = new File(string + ".lt8")).exists() && KafkaIOProperties.isLT8Read()) {
            this.setInFile(file);
            this.progressBar.setValue(0);
            iFileReader = new Lt8Reader(this.inFile, DataBase.T, this.progressBar);
            iFileReader.setExceptionList(this.exceptions);
            ((Lt8Reader)iFileReader).read();
        }
        if ((file = new File(string + ".lt9")).exists() && KafkaIOProperties.isLT9Read()) {
            this.setInFile(file);
            this.progressBar.setValue(0);
            iFileReader = new Lt9Reader(this.inFile, DataBase.T, this.progressBar);
            iFileReader.setExceptionList(this.exceptions);
            ((Lt8Reader)iFileReader).read();
        }
        if ((file = new File(string + ".lta")).exists() && KafkaIOProperties.isLTARead()) {
            this.setInFile(file);
            this.progressBar.setValue(0);
            iFileReader = new LtaReader(this.inFile, DataBase.P, (IProgressViewer)this.progressBar);
            iFileReader.setExceptionList(this.exceptions);
            iFileReader.setMode(546);
            ((IPunktReader)iFileReader).read();
        }
        this.db.setArea(-1);
        if (DataBase.model.getModel() == 1 && Gemeinde.count() == 0) {
            new PropertyLoader().loadKatalogData();
        }
        this.progressBar.setValue(0);
        super.setTitle("Messungen auswerten");
        iFileReader = new MessungParser(this.db, (IProgressViewer)this.progressBar);
        iFileReader.setExceptionList(this.exceptions);
        ((MessungParser)iFileReader).parse();
    }
}

