/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.IBorder;
import de.geocalc.awt.IFrame;
import de.geocalc.awt.IInfoPanel;
import de.geocalc.awt.IPanel;
import de.geocalc.kafplot.PropertyLoader;
import de.geocalc.kafplot.io.IFileWriter;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.util.StringTokenizer;

public class KafkaRunner
extends IFrame
implements Runnable,
ActionListener {
    private static String TITLE = "KafkaR";
    private static String VERSION = "1.00";
    private static String KAV_COMMAND = "Kafka-V";
    private static String KAG_COMMAND = "Kafka-G";
    private static String KAB_COMMAND = "Kafka-V und Kafka-G";
    private static String KAH_COMMAND = "H\u00f6henausgleichung";
    private static String ABT_COMMAND = "Abbruch";
    private static String DAT_COMMAND = "DAT";
    private static String LT1_COMMAND = "LT1";
    private static String LT2_COMMAND = "LT2";
    private static String LT4_COMMAND = "LT4";
    private static String LT5_COMMAND = "LT5";
    private static String LT6_COMMAND = "LT6";
    private static String LT8_COMMAND = "LT8";
    private static String LT9_COMMAND = "LT9";
    private static String LTK_COMMAND = "LTK";
    private static String S0_CHOICE = " ";
    private static String S1_CHOICE = "freie Ausgleichung";
    private static String S2_CHOICE = "dynamische Ausgleichung";
    private static String S3_CHOICE = "feste Ausgleichung";
    private static String S4_CHOICE = "halbdynamische Ausgleichung";
    private static String KAV_NAME = "c:\\programme\\winkafka\\winkav.exe";
    private static String KAG_NAME = "c:\\programme\\winkafka\\winkag.exe";
    private static String KAH_NAME = null;
    private static String EDIT_NAME = "notepad.exe";
    private static String PRJ_FILE = null;
    private static String PRJ_NAME = null;
    private static final Color COLOR_ERR = Color.red;
    private static final Color COLOR_WARN = new Color(54, 102, 161);
    private static long lastModified = 0L;
    private static boolean runKav = false;
    private static boolean runKag = false;
    private static boolean runKah = false;
    private static boolean abort = false;
    private Button kavButton;
    private Button kagButton;
    private Button kabButton;
    private Button kahButton;
    private Button abtButton;
    private Button datButton;
    private Button lt1Button;
    private Button lt2Button;
    private Button lt4Button;
    private Button lt5Button;
    private Button lt6Button;
    private Button lt8Button;
    private Button lt9Button;
    private Button ltkButton;
    private Label kavWrnLabel;
    private Label kavErrLabel;
    private Label kagWrnLabel;
    private Label kagErrLabel;
    private Label kahWrnLabel;
    private Label kahErrLabel;
    private Label kagFrtLabel;
    private Checkbox rCheckbox;
    private Choice sChoice;
    private IInfoPanel infPanel;
    private Thread runner;

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            KafkaRunner.exitHelp();
        } else {
            KafkaRunner kafkaRunner = new KafkaRunner(stringArray);
        }
    }

    private static void exitHelp() {
        System.out.println("  " + TITLE + " " + VERSION);
        System.out.println("    (c) 2007 Joerg Schroeder info@geocalc.de");
        System.out.println("    Aufruf: KafkaRunner [projekt]");
        System.exit(0);
    }

    KafkaRunner(String[] stringArray) {
        String string = stringArray[0].trim();
        int n = string.lastIndexOf(".");
        PRJ_NAME = n <= 0 ? string : string.substring(0, n);
        PRJ_FILE = (n <= 0 ? string : string.substring(0, n)) + ".dat";
        this.setTitle(TITLE + " [" + PRJ_NAME + "]");
        this.loadIcon(this.getClass().getResource("KafkaRunner.gif"));
        this.addWindowListener(new WindowAdapter(this){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        String string2 = null;
        try {
            KafkaRunner.load(this.getClass().getResourceAsStream("/Kafka.properties"));
        }
        catch (IOException iOException) {
            string2 = "Fehler beim Laden der 'Kafka.properties', " + iOException.getMessage();
        }
        this.setLayout(new BorderLayout());
        this.setForeground(SystemColor.controlText);
        this.setBackground(SystemColor.control);
        this.add("Center", this.createPanel());
        this.infPanel = new IInfoPanel();
        this.add("South", this.infPanel);
        this.pack();
        this.setVisible(true);
        if (string2 != null) {
            this.showError(string2);
        }
        new FileLooker().start();
    }

    private void showError(String string) {
        this.infPanel.setForeground(Color.red);
        this.infPanel.setText(string);
        this.infPanel.repaint();
    }

    private void showMessage(String string) {
        this.infPanel.setForeground(SystemColor.controlText);
        this.infPanel.setText(string);
        this.infPanel.repaint();
    }

    private Panel createPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        Panel panel = new Panel(gridBagLayout);
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        Panel panel2 = this.createCmdPanel();
        panel.add(panel2);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(panel2, gridBagConstraints);
        panel2 = this.createEditPanel();
        panel.add(panel2);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagLayout.setConstraints(panel2, gridBagConstraints);
        panel2 = this.createOptPanel();
        panel.add(panel2);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 1;
        gridBagLayout.setConstraints(panel2, gridBagConstraints);
        panel2 = this.createErgPanel();
        panel.add(panel2);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.3;
        gridBagConstraints.weighty = 0.3;
        gridBagConstraints.gridwidth = 2;
        gridBagLayout.setConstraints(panel2, gridBagConstraints);
        this.refreshRunButtons();
        this.refreshFileButtons();
        return panel;
    }

    private Panel createCmdPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.ipadx = 20;
        gridBagConstraints.ipady = 10;
        IPanel iPanel = new IPanel(gridBagLayout);
        iPanel.setBorder(new IBorder());
        this.kavButton = new Button(KAV_COMMAND);
        iPanel.add(this.kavButton);
        this.kavButton.addActionListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(this.kavButton, gridBagConstraints);
        this.kagButton = new Button(KAG_COMMAND);
        iPanel.add(this.kagButton);
        this.kagButton.addActionListener(this);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(this.kagButton, gridBagConstraints);
        this.kabButton = new Button(KAB_COMMAND);
        iPanel.add(this.kabButton);
        this.kabButton.addActionListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagLayout.setConstraints(this.kabButton, gridBagConstraints);
        if (KAH_NAME != null) {
            this.kahButton = new Button(KAH_COMMAND);
            iPanel.add(this.kahButton);
            this.kahButton.addActionListener(this);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridwidth = 2;
            gridBagLayout.setConstraints(this.kahButton, gridBagConstraints);
        }
        this.abtButton = new Button(ABT_COMMAND);
        iPanel.add(this.abtButton);
        this.abtButton.addActionListener(this);
        this.abtButton.setEnabled(false);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagLayout.setConstraints(this.abtButton, gridBagConstraints);
        return iPanel;
    }

    private Panel createEditPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.ipadx = 20;
        gridBagConstraints.ipady = 10;
        IPanel iPanel = new IPanel(gridBagLayout);
        iPanel.setBorder(new IBorder());
        gridBagConstraints.gridwidth = 2;
        this.datButton = new Button(DAT_COMMAND);
        iPanel.add(this.datButton);
        this.datButton.addActionListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(this.datButton, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        this.lt1Button = new Button(LT1_COMMAND);
        iPanel.add(this.lt1Button);
        this.lt1Button.addActionListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.lt1Button, gridBagConstraints);
        this.lt2Button = new Button(LT2_COMMAND);
        iPanel.add(this.lt2Button);
        this.lt2Button.addActionListener(this);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.lt2Button, gridBagConstraints);
        this.lt4Button = new Button(LT4_COMMAND);
        iPanel.add(this.lt4Button);
        this.lt4Button.addActionListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(this.lt4Button, gridBagConstraints);
        this.lt5Button = new Button(LT5_COMMAND);
        iPanel.add(this.lt5Button);
        this.lt5Button.addActionListener(this);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(this.lt5Button, gridBagConstraints);
        this.lt8Button = new Button(LT8_COMMAND);
        iPanel.add(this.lt8Button);
        this.lt8Button.addActionListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagLayout.setConstraints(this.lt8Button, gridBagConstraints);
        this.lt9Button = new Button(LT9_COMMAND);
        iPanel.add(this.lt9Button);
        this.lt5Button.addActionListener(this);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagLayout.setConstraints(this.lt9Button, gridBagConstraints);
        gridBagConstraints.gridwidth = 2;
        this.lt6Button = new Button(LT6_COMMAND);
        iPanel.add(this.lt6Button);
        this.lt6Button.addActionListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagLayout.setConstraints(this.lt6Button, gridBagConstraints);
        this.ltkButton = new Button(LTK_COMMAND);
        iPanel.add(this.ltkButton);
        this.ltkButton.addActionListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagLayout.setConstraints(this.ltkButton, gridBagConstraints);
        return iPanel;
    }

    private Panel createOptPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        IPanel iPanel = new IPanel(gridBagLayout);
        iPanel.setBorder(new IBorder());
        this.rCheckbox = new Checkbox("Robuste Sch\u00e4tzung", false);
        iPanel.add(this.rCheckbox);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(this.rCheckbox, gridBagConstraints);
        this.sChoice = new Choice();
        iPanel.add(this.sChoice);
        this.sChoice.addItem(S0_CHOICE);
        this.sChoice.addItem(S1_CHOICE);
        this.sChoice.addItem(S2_CHOICE);
        this.sChoice.addItem(S3_CHOICE);
        this.sChoice.addItem(S4_CHOICE);
        this.sChoice.select(0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.sChoice, gridBagConstraints);
        return iPanel;
    }

    private Panel createErgPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        IPanel iPanel = new IPanel(gridBagLayout);
        iPanel.setBorder(new IBorder(1));
        Label label = new Label("Kav: ");
        iPanel.add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.kavWrnLabel = new Label("          ", 2);
        iPanel.add(this.kavWrnLabel);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagLayout.setConstraints(this.kavWrnLabel, gridBagConstraints);
        label = new Label("Warnungen");
        iPanel.add(label);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.kavErrLabel = new Label("          ", 2);
        iPanel.add(this.kavErrLabel);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagLayout.setConstraints(this.kavErrLabel, gridBagConstraints);
        label = new Label("Fehler");
        iPanel.add(label);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        label = new Label("Kag: ");
        iPanel.add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.kagWrnLabel = new Label("          ", 2);
        iPanel.add(this.kagWrnLabel);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagLayout.setConstraints(this.kagWrnLabel, gridBagConstraints);
        label = new Label("Warnungen");
        iPanel.add(label);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.kagErrLabel = new Label("          ", 2);
        iPanel.add(this.kagErrLabel);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagLayout.setConstraints(this.kagErrLabel, gridBagConstraints);
        label = new Label("Fehler");
        iPanel.add(label);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 4;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        if (KAH_NAME != null) {
            label = new Label("Kah: ");
            iPanel.add(label);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 5;
            gridBagLayout.setConstraints(label, gridBagConstraints);
            this.kahWrnLabel = new Label("          ", 2);
            iPanel.add(this.kahWrnLabel);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 5;
            gridBagLayout.setConstraints(this.kahWrnLabel, gridBagConstraints);
            label = new Label("Warnungen");
            iPanel.add(label);
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 5;
            gridBagLayout.setConstraints(label, gridBagConstraints);
            this.kahErrLabel = new Label("          ", 2);
            iPanel.add(this.kahErrLabel);
            gridBagConstraints.gridx = 3;
            gridBagConstraints.gridy = 5;
            gridBagLayout.setConstraints(this.kahErrLabel, gridBagConstraints);
            label = new Label("Fehler");
            iPanel.add(label);
            gridBagConstraints.gridx = 4;
            gridBagConstraints.gridy = 5;
            gridBagLayout.setConstraints(label, gridBagConstraints);
        }
        return iPanel;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(KAV_COMMAND)) {
            if (!this.testProjektFile()) {
                return;
            }
            abort = false;
            runKav = true;
            runKag = false;
            runKah = false;
            new Thread(this).start();
        } else if (string.equals(KAG_COMMAND)) {
            if (!this.testProjektFile()) {
                return;
            }
            abort = false;
            runKav = new File(PRJ_FILE).lastModified() != lastModified;
            runKag = true;
            runKah = false;
            new Thread(this).start();
        } else if (string.equals(KAB_COMMAND)) {
            if (!this.testProjektFile()) {
                return;
            }
            abort = false;
            runKav = true;
            runKag = true;
            runKah = false;
            new Thread(this).start();
        } else if (string.equals(KAH_COMMAND)) {
            if (!this.testProjektFile()) {
                return;
            }
            abort = false;
            runKav = false;
            runKag = false;
            runKah = true;
            new Thread(this).start();
        } else if (string.equals(ABT_COMMAND)) {
            abort = true;
        } else if (string.equals(DAT_COMMAND)) {
            this.edit(PRJ_NAME + ".dat");
        } else if (string.equals(LT1_COMMAND)) {
            this.edit(PRJ_NAME + ".lt1");
        } else if (string.equals(LT2_COMMAND)) {
            this.edit(PRJ_NAME + ".lt2");
        } else if (string.equals(LT4_COMMAND)) {
            this.edit(PRJ_NAME + ".lt4");
        } else if (string.equals(LT5_COMMAND)) {
            this.edit(PRJ_NAME + ".lt5");
        } else if (string.equals(LT6_COMMAND)) {
            this.edit(PRJ_NAME + ".lt6");
        } else if (string.equals(LT8_COMMAND)) {
            this.edit(PRJ_NAME + ".lt8");
        } else if (string.equals(LT9_COMMAND)) {
            this.edit(PRJ_NAME + ".lt9");
        } else if (string.equals(LTK_COMMAND)) {
            this.edit(PRJ_NAME + ".ltk");
        }
    }

    private boolean testProjektFile() {
        File file = new File(PRJ_FILE);
        if (file.exists()) {
            return true;
        }
        this.showError("Projektdatei " + file.getName() + " ist nicht vorhanden!");
        return false;
    }

    private void refreshRunButtons() {
        boolean bl = new File(PRJ_NAME + ".dat").exists();
        this.kavButton.setEnabled(bl);
        this.kagButton.setEnabled(bl);
        this.kabButton.setEnabled(bl);
        if (this.kahButton != null) {
            this.kahButton.setEnabled(bl);
        }
    }

    private void refreshFileButtons() {
        this.datButton.setEnabled(new File(PRJ_NAME + ".dat").exists());
        this.lt1Button.setEnabled(new File(PRJ_NAME + ".lt1").exists());
        this.lt2Button.setEnabled(new File(PRJ_NAME + ".lt2").exists());
        this.lt4Button.setEnabled(new File(PRJ_NAME + ".lt4").exists());
        this.lt5Button.setEnabled(new File(PRJ_NAME + ".lt5").exists());
        this.lt6Button.setEnabled(new File(PRJ_NAME + ".lt6").exists());
        this.lt8Button.setEnabled(new File(PRJ_NAME + ".lt8").exists());
        this.lt9Button.setEnabled(new File(PRJ_NAME + ".lt9").exists());
        this.ltkButton.setEnabled(new File(PRJ_NAME + ".ltk").exists());
    }

    public void edit(String string) {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(EDIT_NAME);
            int n = stringTokenizer.countTokens();
            String[] stringArray = new String[n + 1];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = stringTokenizer.nextToken();
            }
            stringArray[n] = new File(string).getAbsolutePath();
            Process process = Runtime.getRuntime().exec(stringArray);
        }
        catch (Exception exception) {
            this.showError("Fehler: " + exception.getMessage());
        }
    }

    @Override
    public void run() {
        block56: {
            this.kavButton.setEnabled(false);
            this.kagButton.setEnabled(false);
            this.kabButton.setEnabled(false);
            if (this.kahButton != null) {
                this.kahButton.setEnabled(false);
            }
            this.abtButton.setEnabled(true);
            String string = null;
            LineNumberReader lineNumberReader = null;
            PrintWriter printWriter = null;
            try {
                Process process;
                String[] stringArray;
                int n;
                Object object;
                printWriter = IFileWriter.createFileWriter(new File(PRJ_NAME + ".ltk"));
                if (runKav) {
                    this.kavWrnLabel.setForeground(SystemColor.controlText);
                    this.kavErrLabel.setForeground(SystemColor.controlText);
                    this.kavWrnLabel.setText("  -  ");
                    this.kavErrLabel.setText("  -  ");
                }
                if (runKag) {
                    this.kagWrnLabel.setForeground(SystemColor.controlText);
                    this.kagErrLabel.setForeground(SystemColor.controlText);
                    this.kagWrnLabel.setText("  -  ");
                    this.kagErrLabel.setText("  -  ");
                }
                if (runKah) {
                    this.kahWrnLabel.setForeground(SystemColor.controlText);
                    this.kahErrLabel.setForeground(SystemColor.controlText);
                    this.kahWrnLabel.setText("  -  ");
                    this.kahErrLabel.setText("  -  ");
                }
                if (runKav) {
                    int n2;
                    object = new StringTokenizer(KAV_NAME);
                    n = ((StringTokenizer)object).countTokens();
                    stringArray = new String[n + 1];
                    for (n2 = 0; n2 < n; ++n2) {
                        stringArray[n2] = ((StringTokenizer)object).nextToken();
                    }
                    stringArray[n] = this.regularFileString(PRJ_NAME);
                    this.writeStringArray(printWriter, stringArray);
                    process = Runtime.getRuntime().exec(stringArray);
                    this.showMessage("Vorausgleichung gestartet");
                    lineNumberReader = new LineNumberReader(new InputStreamReader(process.getInputStream()));
                    while ((string = lineNumberReader.readLine()) != null) {
                        int n3;
                        n2 = string.indexOf("FEHLER");
                        if (n2 > 0) {
                            try {
                                n3 = Integer.parseInt(string.substring(n2 - 10, n2).trim());
                                this.kavErrLabel.setForeground(n3 == 0 ? SystemColor.controlText : COLOR_ERR);
                                this.kavErrLabel.setText(Integer.toString(n3));
                            }
                            catch (Exception exception) {
                                this.kavErrLabel.setForeground(COLOR_ERR);
                                this.kavErrLabel.setText("?");
                            }
                        }
                        if ((n2 = string.indexOf("WARNUNG")) > 0) {
                            try {
                                n3 = Integer.parseInt(string.substring(n2 - 10, n2).trim());
                                this.kavWrnLabel.setForeground(n3 == 0 ? SystemColor.controlText : COLOR_WARN);
                                this.kavWrnLabel.setText(Integer.toString(n3));
                            }
                            catch (Exception exception) {
                                this.kavWrnLabel.setForeground(COLOR_WARN);
                                this.kavWrnLabel.setText("?");
                            }
                        }
                        printWriter.println(string);
                        System.out.println(string);
                        if (!abort) continue;
                        process.destroy();
                        break;
                    }
                    if (abort) {
                        this.showError("Vorausgleichung abgebrochen");
                    } else {
                        process.waitFor();
                        this.showMessage("Vorausgleichung beendet");
                    }
                    lastModified = new File(PRJ_FILE).lastModified();
                }
                if (runKag) {
                    object = this.sChoice.getSelectedItem();
                    StringTokenizer stringTokenizer = new StringTokenizer(KAG_NAME);
                    int n4 = stringTokenizer.countTokens();
                    if (this.rCheckbox.getState()) {
                        ++n4;
                    }
                    if (!((String)object).equals(S0_CHOICE)) {
                        ++n4;
                    }
                    String[] stringArray2 = new String[n4 + 1];
                    int n5 = 0;
                    while (stringTokenizer.hasMoreTokens()) {
                        stringArray2[n5++] = stringTokenizer.nextToken();
                    }
                    if (this.rCheckbox.getState()) {
                        stringArray2[n5++] = "-R";
                    }
                    if (((String)object).equals(S1_CHOICE)) {
                        stringArray2[n5++] = "-S1";
                    } else if (((String)object).equals(S2_CHOICE)) {
                        stringArray2[n5++] = "-S2";
                    } else if (((String)object).equals(S3_CHOICE)) {
                        stringArray2[n5++] = "-S3";
                    } else if (((String)object).equals(S4_CHOICE)) {
                        stringArray2[n5++] = "-S4";
                    }
                    stringArray2[n5++] = this.regularFileString(PRJ_NAME);
                    this.writeStringArray(printWriter, stringArray2);
                    process = Runtime.getRuntime().exec(stringArray2);
                    this.showMessage("Ausgleichung gestartet");
                    lineNumberReader = new LineNumberReader(new InputStreamReader(process.getInputStream()));
                    String string2 = "Ausgleichung: ";
                    while ((string = lineNumberReader.readLine()) != null) {
                        if (string.indexOf("Konvergenz") >= 0) {
                            var11_24 = string.indexOf("=");
                            if (var11_24 > 0) {
                                this.showMessage(string2 + string.substring(var11_24 + 1).trim());
                            }
                        } else if (string.indexOf("Restklaffen") > 0) {
                            string2 = "Restklaffenverteilung: ";
                        } else {
                            int n6;
                            var11_24 = string.indexOf("FEHLER");
                            if (var11_24 > 0) {
                                try {
                                    n6 = Integer.parseInt(string.substring(var11_24 - 10, var11_24).trim());
                                    this.kagErrLabel.setForeground(n6 == 0 ? SystemColor.controlText : COLOR_ERR);
                                    this.kagErrLabel.setText(Integer.toString(n6));
                                }
                                catch (Exception exception) {
                                    this.kagErrLabel.setForeground(COLOR_ERR);
                                    this.kagErrLabel.setText("?");
                                }
                            }
                            if ((var11_24 = string.indexOf("WARNUNG")) > 0) {
                                try {
                                    n6 = Integer.parseInt(string.substring(var11_24 - 10, var11_24).trim());
                                    this.kagWrnLabel.setForeground(n6 == 0 ? SystemColor.controlText : COLOR_WARN);
                                    this.kagWrnLabel.setText(Integer.toString(n6));
                                }
                                catch (Exception exception) {
                                    this.kagWrnLabel.setForeground(COLOR_WARN);
                                    this.kagWrnLabel.setText("?");
                                }
                            }
                        }
                        printWriter.println(string);
                        System.out.println(string);
                        if (!abort) continue;
                        process.destroy();
                        break;
                    }
                    if (abort) {
                        this.showError("Ausgleichung abgebrochen");
                    } else {
                        process.waitFor();
                        this.showMessage("Ausgleichung beendet");
                    }
                }
                if (runKah) {
                    int n7;
                    object = new StringTokenizer(KAH_NAME);
                    n = ((StringTokenizer)object).countTokens();
                    stringArray = new String[n + 1];
                    for (n7 = 0; n7 < n; ++n7) {
                        stringArray[n7] = ((StringTokenizer)object).nextToken();
                    }
                    stringArray[n] = this.regularFileString(PRJ_NAME);
                    this.writeStringArray(printWriter, stringArray);
                    process = Runtime.getRuntime().exec(stringArray);
                    this.showMessage("H\u00f6henausgleichung gestartet");
                    lineNumberReader = new LineNumberReader(new InputStreamReader(process.getInputStream()));
                    while ((string = lineNumberReader.readLine()) != null) {
                        n7 = string.indexOf("FEHLER");
                        if (n7 > 0) {
                            try {
                                int n8 = Integer.parseInt(string.substring(n7 - 10, n7).trim());
                                this.kahErrLabel.setForeground(n8 == 0 ? SystemColor.controlText : COLOR_ERR);
                                this.kahErrLabel.setText(Integer.toString(n8));
                            }
                            catch (Exception exception) {
                                this.kahErrLabel.setForeground(COLOR_ERR);
                                this.kahErrLabel.setText("?");
                            }
                        }
                        if ((n7 = string.indexOf("WARNUNG")) > 0) {
                            try {
                                int n9 = Integer.parseInt(string.substring(n7 - 10, n7).trim());
                                this.kahWrnLabel.setForeground(n9 == 0 ? SystemColor.controlText : COLOR_WARN);
                                this.kahWrnLabel.setText(Integer.toString(n9));
                            }
                            catch (Exception exception) {
                                this.kahWrnLabel.setForeground(COLOR_WARN);
                                this.kahWrnLabel.setText("?");
                            }
                        }
                        printWriter.println(string);
                        System.out.println(string);
                        if (!abort) continue;
                        process.destroy();
                        break;
                    }
                    if (abort) {
                        this.showError("H\u00f6henausgleichung abgebrochen");
                    } else {
                        process.waitFor();
                        this.showMessage("H\u00f6henausgleichung beendet");
                    }
                    lastModified = new File(PRJ_FILE).lastModified();
                }
                printWriter.close();
            }
            catch (NullPointerException nullPointerException) {
                this.showMessage("Keine Angabe der Fehler m\u00f6glich");
                this.kahWrnLabel.setText("?");
                this.kahErrLabel.setText("?");
                if (printWriter != null) {
                    printWriter.close();
                }
            }
            catch (Exception exception) {
                this.showError("Fehler: " + exception.getMessage());
                exception.printStackTrace();
                if (printWriter == null) break block56;
                printWriter.close();
            }
        }
        this.abtButton.setEnabled(false);
        this.refreshRunButtons();
        this.refreshFileButtons();
    }

    private void writeStringArray(PrintWriter printWriter, String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            printWriter.print(stringArray[i] + " ");
        }
        printWriter.println("");
    }

    private String regularFileString(String object) {
        int n = ((String)object).indexOf(" ");
        if (n > 0) {
            object = "\"" + (String)object + "\"";
        }
        return object;
    }

    private static void load(InputStream inputStream) throws IOException {
        LineNumberReader lineNumberReader = null;
        try {
            String string;
            lineNumberReader = PropertyLoader.createReader(inputStream);
            while ((string = lineNumberReader.readLine()) != null) {
                int n = string.indexOf("=");
                if (string.length() == 0 || string.startsWith("#") || n <= 0) continue;
                String string2 = string.substring(0, n).trim();
                String string3 = string.substring(n + 1).trim();
                if (string2.equalsIgnoreCase("KAV")) {
                    KAV_NAME = string3;
                    continue;
                }
                if (string2.equalsIgnoreCase("KAG")) {
                    KAG_NAME = string3;
                    continue;
                }
                if (string2.equalsIgnoreCase("KAH")) {
                    KAH_NAME = string3;
                    continue;
                }
                if (string2.equalsIgnoreCase("EDIT")) {
                    EDIT_NAME = string3;
                    continue;
                }
                throw new IOException("Unbekanntes Property: " + string2);
            }
            lineNumberReader.close();
        }
        catch (Exception exception) {
            if (lineNumberReader != null) {
                lineNumberReader.close();
            }
            throw new IOException("Fehler in Zeile: " + (lineNumberReader != null ? lineNumberReader.getLineNumber() : 0) + "\n" + exception.getMessage());
        }
    }

    private class FileLooker
    extends Thread {
        public FileLooker() {
            this.setPriority(1);
        }

        @Override
        public void run() {
            while (true) {
                KafkaRunner.this.refreshFileButtons();
                try {
                    FileLooker.sleep(1000L);
                }
                catch (Exception exception) {
                }
            }
        }
    }
}

