/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.ErrorDialog;
import de.geocalc.awt.ExceptionList;
import de.geocalc.awt.IBorder;
import de.geocalc.awt.IDialog;
import de.geocalc.awt.IException;
import de.geocalc.awt.IFrame;
import de.geocalc.awt.ILabel;
import de.geocalc.awt.IPanel;
import de.geocalc.awt.IProgressBar;
import de.geocalc.awt.IProgressElement;
import de.geocalc.awt.IQuestionDialog;
import de.geocalc.io.FileCopier;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.PunktNummer;
import de.geocalc.kafplot.io.DatWriter;
import de.geocalc.kafplot.io.dat.KafkaIOProperties;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;

public class KafkaWriterDialog
extends IDialog
implements ActionListener,
ItemListener {
    protected DataBase db;
    protected File outFile;
    protected IProgressBar progressBar;
    protected ExceptionList exceptions;
    private String fileName;
    private static final String FILE_NAME_COMMAND = "...";
    private static final String OK_COMMAND = "OK";
    private static final String ABORT_COMMAND = "Abbrechen";
    private TextField fileNameTextField;
    private Checkbox writeOfflineCheckbox;
    private Checkbox write3DCheckbox;
    private Checkbox writeFullObjectCheckbox;
    private Checkbox writeNeupunkteCheckbox;
    private Checkbox writeUmnumCheckbox;
    private Checkbox changeKatCheckbox;
    private Choice punktNummerChoice;
    private Button fileNameButton;
    private Button okButton;
    private Button abortButton;
    private Label fileNameLabel;
    private Label progressLabel;
    private boolean isCorrectSaved = false;

    public KafkaWriterDialog(IFrame iFrame, String string, DataBase dataBase, String string2) {
        super(iFrame, string, true);
        this.db = dataBase;
        this.fileName = string2;
        this.exceptions = new ExceptionList();
        this.setLayout(new BorderLayout());
        Panel panel = new Panel(new BorderLayout());
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.ipady = 2;
        gridBagConstraints.anchor = 17;
        IPanel iPanel = new IPanel(gridBagLayout);
        iPanel.setBorder(new IBorder(1, "Datei"));
        this.fileNameLabel = new Label("Datei: ");
        iPanel.add(this.fileNameLabel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagLayout.setConstraints(this.fileNameLabel, gridBagConstraints);
        this.fileNameTextField = new TextField(string2, 20);
        iPanel.add(this.fileNameTextField);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(this.fileNameTextField, gridBagConstraints);
        this.fileNameButton = new Button(FILE_NAME_COMMAND);
        iPanel.add(this.fileNameButton);
        this.fileNameButton.addActionListener(this);
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(this.fileNameButton, gridBagConstraints);
        panel.add("North", iPanel);
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.fill = 1;
        IPanel iPanel2 = new IPanel(gridBagLayout2);
        iPanel2.setBorder(new IBorder(1, "Optionen"));
        ILabel iLabel = new ILabel("Punktnummernbildung f\u00fcr amtliche Punkte: ");
        iPanel2.add(iLabel);
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagLayout2.setConstraints(iLabel, gridBagConstraints2);
        this.punktNummerChoice = new Choice();
        iPanel2.add(this.punktNummerChoice);
        int n = DataBase.model.getModel();
        this.punktNummerChoice.addItem(PunktNummer.getLengthAsString(0, n));
        String[] stringArray = PunktNummer.getNames(n);
        for (int i = 0; i < stringArray.length; ++i) {
            this.punktNummerChoice.addItem(stringArray[i]);
        }
        this.punktNummerChoice.select(PunktNummer.getLengthAsString(KafkaIOProperties.pnrModus, n));
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.fill = 0;
        gridBagLayout2.setConstraints(this.punktNummerChoice, gridBagConstraints2);
        this.writeOfflineCheckbox = new Checkbox("nicht benutzte Punkte und Werte schreiben");
        iPanel2.add(this.writeOfflineCheckbox);
        this.writeOfflineCheckbox.addItemListener(this);
        this.writeOfflineCheckbox.setState(KafkaIOProperties.writeOffline);
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 2;
        gridBagLayout2.setConstraints(this.writeOfflineCheckbox, gridBagConstraints2);
        this.write3DCheckbox = new Checkbox("H\u00f6hen");
        iPanel2.add(this.write3DCheckbox);
        this.write3DCheckbox.addItemListener(this);
        this.write3DCheckbox.setState(KafkaIOProperties.writeHoehe);
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 3;
        gridBagLayout2.setConstraints(this.write3DCheckbox, gridBagConstraints2);
        this.writeFullObjectCheckbox = new Checkbox("Nur vollst\u00e4ndig markierte Objekte \u00fcbernehmen");
        iPanel2.add(this.writeFullObjectCheckbox);
        this.writeFullObjectCheckbox.setState(KafkaIOProperties.writeFullMengeObjects);
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 4;
        gridBagLayout2.setConstraints(this.writeFullObjectCheckbox, gridBagConstraints2);
        this.writeNeupunkteCheckbox = new Checkbox("Neupunkte in das Koordinatenverzeichnis \u00fcbernehmen");
        iPanel2.add(this.writeNeupunkteCheckbox);
        this.writeNeupunkteCheckbox.addItemListener(this);
        this.writeNeupunkteCheckbox.setState(KafkaIOProperties.writeNeupunkte);
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 5;
        gridBagLayout2.setConstraints(this.writeNeupunkteCheckbox, gridBagConstraints2);
        this.writeUmnumCheckbox = new Checkbox("Punktnummern entsprechend Umnummerierungsliste schreiben");
        iPanel2.add(this.writeUmnumCheckbox);
        this.writeUmnumCheckbox.addItemListener(this);
        this.writeUmnumCheckbox.setState(KafkaIOProperties.writeUmnum);
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 6;
        gridBagLayout2.setConstraints(this.writeUmnumCheckbox, gridBagConstraints2);
        this.changeKatCheckbox = new Checkbox("neues Kataster als Altkataster umschreiben");
        iPanel2.add(this.changeKatCheckbox);
        this.changeKatCheckbox.addItemListener(this);
        this.writeUmnumCheckbox.setState(KafkaIOProperties.changeKat);
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 7;
        gridBagLayout2.setConstraints(this.changeKatCheckbox, gridBagConstraints2);
        panel.add("Center", iPanel2);
        Panel panel2 = new Panel(new BorderLayout());
        Panel panel3 = new Panel(new FlowLayout());
        this.progressBar = new IProgressBar();
        panel3.add(this.progressBar);
        panel2.add("North", panel3);
        Panel panel4 = new Panel(new GridLayout(1, 1));
        this.progressLabel = new Label("", 1);
        panel4.add(this.progressLabel);
        panel2.add("South", panel4);
        this.add("Center", panel2);
        this.add("North", panel);
        Panel panel5 = new Panel(new FlowLayout(2));
        this.okButton = new Button(OK_COMMAND);
        this.okButton.addActionListener(this);
        panel5.add(this.okButton);
        this.abortButton = new Button(ABORT_COMMAND);
        this.abortButton.addActionListener(this);
        panel5.add(this.abortButton);
        this.add("South", panel5);
        this.resetLayout();
        this.pack();
        this.setLocationOfParent(iFrame);
        this.setResizable(false);
    }

    private void resetLayout() {
        if (this.changeKatCheckbox.getState()) {
            this.writeUmnumCheckbox.setState(true);
            this.writeUmnumCheckbox.setEnabled(false);
        } else {
            this.writeUmnumCheckbox.setEnabled(true);
        }
        if (DataBase.hasMenge()) {
            this.writeNeupunkteCheckbox.setState(true);
            this.writeNeupunkteCheckbox.setEnabled(false);
            this.writeFullObjectCheckbox.setEnabled(true);
        } else {
            this.writeFullObjectCheckbox.setEnabled(false);
        }
    }

    public void write() throws IException {
        Object object;
        this.isCorrectSaved = false;
        File file = new File(this.fileNameTextField.getText());
        try {
            if (file != null && file.exists()) {
                object = new File(file.getName().substring(0, file.getName().lastIndexOf(46)) + ".bak");
                FileCopier fileCopier = new FileCopier(file, (File)object);
            }
        }
        catch (Exception exception) {
            throw new IException("Die Datei " + file.getName() + " konnte nicht gesichert werden.\nDas Schreiben der Datei wurde abgebrochen");
        }
        try {
            Thread.sleep(100L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.progressBar.setValue(5);
        object = new DatWriter(file, this.db);
        KafkaIOProperties.writeOffline = this.writeOfflineCheckbox.getState();
        KafkaIOProperties.writeHoehe = this.write3DCheckbox.getState();
        KafkaIOProperties.writeFullMengeObjects = this.writeFullObjectCheckbox.getState();
        KafkaIOProperties.writeNeupunkte = this.writeNeupunkteCheckbox.getState();
        KafkaIOProperties.writeUmnum = this.writeUmnumCheckbox.getState();
        KafkaIOProperties.changeKat = this.changeKatCheckbox.getState();
        KafkaIOProperties.pnrModus = PunktNummer.getLength(this.punktNummerChoice.getSelectedItem());
        KafkaIOProperties.writeMenge = DataBase.hasMenge();
        ((IProgressElement)object).setProgressBar(this.progressBar);
        ((IProgressElement)object).setProgressLabel(this.progressLabel);
        ((DatWriter)object).write();
        this.isCorrectSaved = ((DatWriter)object).isCorrectSaved();
    }

    public boolean isCorrectSaved() {
        return this.isCorrectSaved;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(OK_COMMAND)) {
            this.doStandardAction();
        } else if (string.equals(ABORT_COMMAND)) {
            this.endDialog();
        } else if (string.equals(FILE_NAME_COMMAND)) {
            FileDialog fileDialog = new FileDialog((Frame)this.parent, "Speichern", 0);
            fileDialog.setFile("*.dat");
            fileDialog.setVisible(true);
            if (fileDialog.getFile() != null) {
                this.fileNameTextField.setText(fileDialog.getDirectory() + fileDialog.getFile());
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object instanceof Checkbox) {
            this.resetLayout();
        }
    }

    protected void setOutFile(File file) {
        this.outFile = file;
    }

    @Override
    protected void endDialog() {
        if (!this.exceptions.isEmpty()) {
            ErrorDialog errorDialog = new ErrorDialog(this.parent, "Es sind Fehler beim Schreiben der Daten aufgetreten, \ndie fehlerhafte Daten wurden ignoriert.", this.exceptions);
            errorDialog.setVisible(true);
        }
        super.endDialog();
    }

    @Override
    protected void doStandardAction() {
        if (new File(this.fileNameTextField.getText()).exists()) {
            IQuestionDialog iQuestionDialog = new IQuestionDialog(this.parent, this.getTitle(), "Die Datei " + this.fileNameTextField.getText() + " besteht bereits!\nM\u00f6chten Sie sie ersetzen?");
            iQuestionDialog.setVisible(true);
            if (iQuestionDialog.getAnswer() != 3) {
                this.setVisible(true);
                this.fileNameTextField.requestFocus();
                return;
            }
        }
        try {
            this.write();
        }
        catch (IException iException) {
            ErrorDialog errorDialog = new ErrorDialog(this.parent, iException);
            errorDialog.setVisible(true);
            return;
        }
        this.endDialog();
    }

    @Override
    protected void doAbortAction() {
        this.endDialog();
    }
}

