/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.PropertyLoader;
import de.geocalc.kafplot.io.FortfuehrungIOProperties;
import de.geocalc.kafplot.io.GgRissWriter;
import de.geocalc.kafplot.io.KafPlotIOConstants;
import de.geocalc.kafplot.io.KatasternachweisIOProperties;
import de.geocalc.kafplot.io.edbs.EdbsIOProperties;
import de.geocalc.kafplot.io.xml.XmlIOProperties;
import de.geocalc.text.IFormat;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class KatAmt {
    private static final int MAX_ALKIS_NR = 999999;
    private static final Hashtable aemter = new Hashtable();
    private int nr;
    private String name;
    public boolean withGrenzen = KatasternachweisIOProperties.WRITE_WITH_GRENZEN;
    public boolean withGebaeude = KatasternachweisIOProperties.WRITE_WITH_GEBAEUDE;
    public boolean shortRissFormat = KatasternachweisIOProperties.WRITE_SHORT_LINES;
    public boolean withRissBemerkung = KatasternachweisIOProperties.WRITE_RISS_BEMERKUNG;
    public boolean withRissBestimmung = KatasternachweisIOProperties.WRITE_RISS_BESTIMMUNG;
    public boolean withRissKontrolle = KatasternachweisIOProperties.WRITE_RISS_KONTROLLE;
    public boolean withRissKombiMess = KatasternachweisIOProperties.WRITE_RISS_KOMBI_MESS;
    public boolean writeIdentTitel = KatasternachweisIOProperties.WRITE_IDENT_TITEL;
    public boolean writeLokalPunkt = KatasternachweisIOProperties.WRITE_LOKAL_PUNKT;
    public boolean writeSapLsp = KatasternachweisIOProperties.WRITE_SAP_LSP;
    public boolean useGewichte = KatasternachweisIOProperties.USE_GEWICHTE;
    public boolean formatMM = KatasternachweisIOProperties.FORMAT_MM;
    public boolean parsePointNumber = KatasternachweisIOProperties.PARSE_POINT_NUMBER;
    public boolean testLsp = KatasternachweisIOProperties.TEST_LSP;
    public boolean testSp = KatasternachweisIOProperties.TEST_SP;
    public boolean testLga = KatasternachweisIOProperties.TEST_LGA;
    public boolean testLzk = KatasternachweisIOProperties.TEST_LZK;
    public boolean withEdbsOska = false;
    public boolean withFortfEndNr = FortfuehrungIOProperties.WRITE_END_NUMMER;
    public boolean withFortfEndArea = FortfuehrungIOProperties.WRITE_END_AREA;
    public boolean withVoidLine = FortfuehrungIOProperties.WRITE_VOID_LINE;
    public boolean differPnr = GgRissWriter.DIFFER_PNR;
    public boolean differLen = GgRissWriter.DIFFER_LEN;
    public boolean differGre = GgRissWriter.DIFFER_GRE;
    public double diffDoku = FortfuehrungIOProperties.DIFF_DOKU;
    public int outLga = 0;
    public int maxAnschlussStatus = KatasternachweisIOProperties.MAX_ANSCHLUSS_STATUS;
    public String altpunktKennung = KatasternachweisIOProperties.ALTPUNKT_KENNUNG;
    public String vatProperties = null;

    public KatAmt() {
        this(0, null);
    }

    public KatAmt(int n, String string) {
        this.withEdbsOska = EdbsIOProperties.isOutStandardOska();
        this.nr = n;
        this.name = string;
    }

    public void setNummer(int n) {
        this.nr = n;
    }

    public int getNummer() {
        return this.nr;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public String toXmlLine() {
        String[] stringArray = new String[]{XmlIOProperties.att("id", Integer.toString(this.nr)), XmlIOProperties.att("name", this.name)};
        return XmlIOProperties.data("amt", stringArray);
    }

    public static void load(InputStream inputStream) throws IOException {
        LineNumberReader lineNumberReader = null;
        try {
            String string;
            lineNumberReader = PropertyLoader.createReader(inputStream);
            KatAmt katAmt = null;
            while ((string = lineNumberReader.readLine()) != null) {
                String string2;
                StringTokenizer stringTokenizer;
                if (string.length() == 0 || string.startsWith("#")) continue;
                if (Character.isDigit((string = string.trim()).charAt(0))) {
                    stringTokenizer = new StringTokenizer(string, "=");
                    int n = 0;
                    if (!stringTokenizer.hasMoreElements()) {
                        throw new IOException("fehlende Werte");
                    }
                    try {
                        n = Integer.parseInt(stringTokenizer.nextToken().trim());
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IOException("nicht numerischer Schl\u00fcssel");
                    }
                    if (!stringTokenizer.hasMoreElements()) {
                        throw new IOException("fehlender Wert");
                    }
                    string2 = stringTokenizer.nextToken().trim();
                    string2 = string2.replace('_', ' ');
                    katAmt = new KatAmt(n, string2);
                    aemter.put(new Integer(n), katAmt);
                    continue;
                }
                stringTokenizer = new StringTokenizer(string, "=");
                String string3 = null;
                string2 = null;
                String string4 = null;
                try {
                    String string5 = stringTokenizer.nextToken().trim();
                    int n = string5.indexOf(".");
                    if (n >= 0) {
                        string3 = string5.substring(0, n);
                        string2 = string5.substring(n + 1);
                    } else {
                        string3 = string5;
                        string2 = string5;
                    }
                    string4 = stringTokenizer.nextToken().trim();
                }
                catch (Exception exception) {
                    throw new IOException("ung\u00fcltige Variablendefinition");
                }
                int n = 0;
                try {
                    n = Integer.parseInt(string4);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (katAmt == null) {
                    throw new IOException("Variablendefinition ohne vorherige Angabe eines Amtes");
                }
                if (string3.equalsIgnoreCase("KatasternachweisWriter")) {
                    if (string2.equalsIgnoreCase("mitGrenzen")) {
                        katAmt.withGrenzen = n > 0;
                        continue;
                    }
                    if (string2.equalsIgnoreCase("mitGebaeude")) {
                        katAmt.withGebaeude = n > 0;
                        continue;
                    }
                    if (string2.equalsIgnoreCase("mitRissBemerkungen")) {
                        katAmt.withRissBemerkung = n > 0;
                        continue;
                    }
                    if (string2.equalsIgnoreCase("mitBestimmung")) {
                        katAmt.withRissBestimmung = n > 0;
                        continue;
                    }
                    if (string2.equalsIgnoreCase("mitKontrollBestimmung")) {
                        katAmt.withRissKontrolle = n > 0;
                        continue;
                    }
                    if (string2.equalsIgnoreCase("mitMessungKombiniert")) {
                        katAmt.withRissKombiMess = n > 0;
                        continue;
                    }
                    if (string2.equalsIgnoreCase("kurzLaenge")) {
                        katAmt.shortRissFormat = n > 0;
                        continue;
                    }
                    if (string2.equalsIgnoreCase("identTitel")) {
                        katAmt.writeIdentTitel = n > 0;
                        continue;
                    }
                    if (string2.equalsIgnoreCase("mitLokalPunkt")) {
                        katAmt.writeLokalPunkt = n > 0;
                        continue;
                    }
                    if (string2.equalsIgnoreCase("mitSapLsp")) {
                        katAmt.writeSapLsp = n > 0;
                        continue;
                    }
                    if (string2.equalsIgnoreCase("mitGewichte")) {
                        katAmt.useGewichte = n > 0;
                        continue;
                    }
                    if (string2.equalsIgnoreCase("formatMM")) {
                        katAmt.formatMM = n > 0;
                        continue;
                    }
                    if (string2.equalsIgnoreCase("parsePointNumber")) {
                        katAmt.parsePointNumber = n > 0;
                        continue;
                    }
                    if (string2.equalsIgnoreCase("maxAnschlussStatus")) {
                        katAmt.maxAnschlussStatus = n;
                        continue;
                    }
                    if (string2.equals("altpunktKennung")) {
                        katAmt.altpunktKennung = string4;
                        continue;
                    }
                    if (string2.equals("testLsp")) {
                        katAmt.testLsp = n > 0;
                        continue;
                    }
                    if (string2.equals("testSp")) {
                        katAmt.testSp = n > 0;
                        continue;
                    }
                    if (string2.equals("testLga")) {
                        katAmt.testLga = n > 0;
                        continue;
                    }
                    if (string2.equals("testLzk")) {
                        katAmt.testLzk = n > 0;
                        continue;
                    }
                    throw new IOException("unbekannte Variable: " + string2);
                }
                if (string3.equalsIgnoreCase("EdbsWriter")) {
                    if (string2.equalsIgnoreCase("lsp")) {
                        katAmt.outLga = n;
                        continue;
                    }
                    if (string2.equalsIgnoreCase("oska")) {
                        katAmt.withEdbsOska = n > 0;
                        continue;
                    }
                    throw new IOException("unbekannte Variable: " + string2);
                }
                if (string3.equalsIgnoreCase("FortfuehrungWriter")) {
                    if (string2.equalsIgnoreCase("endNummer")) {
                        katAmt.withFortfEndNr = n > 0;
                        continue;
                    }
                    if (string2.equalsIgnoreCase("endArea")) {
                        katAmt.withFortfEndArea = n > 0;
                        continue;
                    }
                    if (string2.equalsIgnoreCase("voidLine")) {
                        katAmt.withVoidLine = n > 0;
                        continue;
                    }
                    if (string2.equalsIgnoreCase("diffDoku")) {
                        try {
                            katAmt.diffDoku = new Double(string4);
                            continue;
                        }
                        catch (Exception exception) {
                            throw new IOException("ung\u00fcltiger Wert: " + string4);
                        }
                    }
                    throw new IOException("unbekannte Variable: " + string2);
                }
                if (string3.equalsIgnoreCase("PropertyLoader")) {
                    if (string2.equalsIgnoreCase("vat")) {
                        katAmt.vatProperties = string4;
                        continue;
                    }
                    throw new IOException("unbekannte Variable: " + string2);
                }
                if (string3.equalsIgnoreCase("GgRissWriter")) {
                    if (string2.equalsIgnoreCase("differPnr")) {
                        katAmt.differPnr = n > 0;
                        continue;
                    }
                    if (string2.equalsIgnoreCase("differLen")) {
                        katAmt.differLen = n > 0;
                        continue;
                    }
                    if (string2.equalsIgnoreCase("differGre")) {
                        katAmt.differGre = n > 0;
                        continue;
                    }
                    throw new IOException("unbekannte Variable: " + string2);
                }
                throw new IOException("unbekannte Variable: " + string3);
            }
        }
        catch (IOException iOException) {
            throw new IOException("Fehler in Zeile: " + (lineNumberReader != null ? lineNumberReader.getLineNumber() : 0) + "\n" + iOException.getMessage());
        }
    }

    public static KatAmt getKatAmt(int n) {
        return (KatAmt)aemter.get(new Integer(n));
    }

    public static KatAmt getKatAmt(String string) {
        if (string == null) {
            return null;
        }
        if (IFormat.isNumber(string)) {
            int n = Integer.parseInt(string);
            if (n < 100000) {
                n += 120000;
            }
            return (KatAmt)aemter.get(n);
        }
        boolean bl = DataBase.model.getModel() == 2;
        Enumeration enumeration = aemter.elements();
        while (enumeration.hasMoreElements()) {
            KatAmt katAmt = (KatAmt)enumeration.nextElement();
            if (bl && katAmt.nr > 999999 || !string.equals(katAmt.name)) continue;
            return katAmt;
        }
        return null;
    }

    public static Hashtable getKatAmtList() {
        return aemter;
    }

    public static Enumeration elements() {
        return aemter.elements();
    }

    public void writeObject(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.nr);
        KafPlotIOConstants.writeString(dataOutput, this.name);
    }

    public static KatAmt readObject(DataInput dataInput) throws IOException {
        KatAmt katAmt = new KatAmt();
        katAmt.nr = dataInput.readInt();
        katAmt.name = KafPlotIOConstants.readString(dataInput);
        return katAmt;
    }

    public static void saveObject(KatAmt katAmt) {
        if (katAmt == null) {
            throw new NullPointerException("KatAmt");
        }
        aemter.put(new Integer(katAmt.nr), katAmt);
    }

    public String toString() {
        return this.getClass().getName() + "[" + IFormat.i.format(this.nr).toString() + "=" + this.name + "]";
    }
}

