/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.kafplot.Punkt;
import de.geocalc.text.IFormat;
import java.io.IOException;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class KatasterParameter {
    public static double A1 = 0.05;
    public static double A2 = 3.0E-4;
    public static double A3 = 0.008;
    public static double AF = 1.5;
    public static double E1 = 0.04;
    public static double E2 = 0.0;
    public static double E3 = 0.0;
    public static double EF = 1.0;
    public static double LSP = 0.03;
    public static boolean USE_GEWICHTE = false;
    private static final Hashtable params = new Hashtable();
    private String name;
    private KatasterParameterSet set = null;

    public static double getKatasterStreckengenauigkeit(double d) {
        return (A1 + A2 * d + A3 * Math.sqrt(d)) * AF;
    }

    public static double getEigeneStreckengenauigkeit(double d) {
        return (E1 + E2 * d + E3 * Math.sqrt(d)) * EF;
    }

    public static void parse(String string) throws IOException {
        int n = string.indexOf("=");
        if (n <= 0) {
            throw new IOException("ung\u00fcltige Angabe, Wertzuweisung '=' fehlt");
        }
        String string2 = string.substring(0, n).trim();
        String string3 = string.substring(n + 1).trim();
        KatasterParameter katasterParameter = new KatasterParameter(string2);
        StringTokenizer stringTokenizer = new StringTokenizer(string3, " ,");
        if (!stringTokenizer.hasMoreTokens()) {
            throw new IOException("ung\u00fcltige Angabe, Setname fehlt");
        }
        KatasterParameterSet katasterParameterSet = katasterParameter.createSet(stringTokenizer.nextToken());
        double[] dArray = new double[katasterParameterSet.parCount()];
        String string4 = null;
        for (int i = 0; i < katasterParameterSet.parCount(); ++i) {
            try {
                string4 = stringTokenizer.nextToken();
                dArray[i] = new Double(string4);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                throw new IOException("ung\u00fcltiges Argument '" + string4 + "' im Set");
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new IOException("ung\u00fcltige Anzahl von Argumenten im Set, Soll: " + katasterParameterSet.parCount());
            }
        }
        katasterParameterSet.setPar(dArray);
    }

    public KatasterParameter(String string) {
        this.name = string;
    }

    private KatasterParameterSet createSet(String string) throws IOException {
        if (string.equalsIgnoreCase("STANDARD")) {
            this.set = new Standard(this);
            return this.set;
        }
        if (string.equalsIgnoreCase("ANW8")) {
            this.set = new Anw8(this);
            return this.set;
        }
        throw new IOException("unbekannter Parameteransatz '" + string + "'");
    }

    protected abstract class KatasterParameterSet {
        protected KatasterParameterSet(KatasterParameter katasterParameter) {
        }

        public abstract int parCount();

        public abstract void setPar(double[] var1);

        public abstract double getD(double var1, Punkt var3, Punkt var4);

        public abstract String getSetName();
    }

    private class Standard
    extends KatasterParameterSet {
        double a1;
        double a2;
        double a3;
        double af;

        private Standard(KatasterParameter katasterParameter) {
            super(katasterParameter);
        }

        @Override
        public String getSetName() {
            return "STANDARD";
        }

        @Override
        public int parCount() {
            return 4;
        }

        @Override
        public void setPar(double[] dArray) {
            this.af = dArray[0];
            this.a1 = dArray[1];
            this.a2 = dArray[2];
            this.a3 = dArray[3];
        }

        @Override
        public double getD(double d, Punkt punkt, Punkt punkt2) {
            return (this.a1 + this.a2 * d + this.a3 * Math.sqrt(d)) * this.af;
        }

        public String toString() {
            return IFormat.f0_5.format(this.af) + " * ( " + IFormat.f0_5.format(this.a1) + " + " + IFormat.f0_5.format(this.a2) + "*s + " + IFormat.f0_5.format(this.a3) + "*sqr(s) )";
        }
    }

    private class Anw8
    extends KatasterParameterSet {
        double a1;
        double a2;
        double a3;
        double af;
        double ak;

        private Anw8(KatasterParameter katasterParameter) {
            super(katasterParameter);
        }

        @Override
        public String getSetName() {
            return "ANW8";
        }

        @Override
        public int parCount() {
            return 5;
        }

        @Override
        public void setPar(double[] dArray) {
            this.af = dArray[0];
            this.a1 = dArray[1];
            this.a2 = dArray[2];
            this.a3 = dArray[3];
            this.ak = dArray[4];
        }

        @Override
        public double getD(double d, Punkt punkt, Punkt punkt2) {
            return this.af * Math.max(this.a1 * Math.sqrt(this.a2 * d + this.a3 * d * d), this.ak);
        }

        public String toString() {
            return IFormat.f0_5.format(this.af) + " * Max( " + IFormat.f0_5.format(this.a1) + " * sqr(" + IFormat.f0_5.format(this.a2) + "*s + " + IFormat.f0_5.format(this.a3) + "*s\u02db ), " + IFormat.f0_5.format(this.ak) + ")";
        }
    }

    private class VPErl
    extends KatasterParameterSet {
        double a1;
        double a2;

        private VPErl(KatasterParameter katasterParameter) {
            super(katasterParameter);
        }

        @Override
        public String getSetName() {
            return "VPErl";
        }

        @Override
        public int parCount() {
            return 2;
        }

        @Override
        public void setPar(double[] dArray) {
        }

        @Override
        public double getD(double d, Punkt punkt, Punkt punkt2) {
            return 0.0;
        }
    }
}

