/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import java.awt.Color;
import java.util.Enumeration;
import java.util.Vector;

public class KatasterPunktStatus {
    private static final String UNDEF_STRING = "";
    private static final String AMTL_NACHWEIS_STRING = "Punkt amtl. Nachweis";
    private static final String UNTERG_HIST_NACHWEIS_STRING = "untergeg. m.h.N";
    private static final String UNTERG_OHNE_NACHWEIS_STRING = "untergeg. o.h.N.";
    private static final String FP_LV_STRING = "FP, nur LV";
    private static final String UNTERG_FP_LV_STRING = "untergeg. FP, nur LV";
    private static final String RESERV_PUNKT_STRING = "reservierter Punkt";
    private static final String NICHT_LV_STRING = "kein Punkt der LV";
    public static final int UNDEF = -1;
    public static final int AMTL_NACHWEIS = 0;
    public static final int UNTERG_HIST_NACHWEIS = 1;
    public static final int UNTERG_OHNE_NACHWEIS = 2;
    public static final int FP_LV = 6;
    public static final int UNTERG_FP_LV = 7;
    public static final int RESERV_PUNKT = 8;
    public static final int NICHT_LV = 9;
    public static final int MAX_ALK = 9;
    private static final Vector arten = new Vector();
    private int ks;
    private String name;
    private Color color;

    public static int AlkisToAlk(int n) {
        if (n == 14 || n == 12) {
            return 0;
        }
        if (n == 13) {
            return 1;
        }
        return -1;
    }

    public KatasterPunktStatus(int n, String string, Color color) {
        this.ks = n;
        this.name = string;
        this.color = color;
    }

    public int getValue() {
        return this.ks;
    }

    public String getName() {
        return this.name;
    }

    public Color getColor() {
        return this.color;
    }

    public int getModel() {
        if (this.ks <= -1) {
            return 0;
        }
        if (this.ks <= 9) {
            return 1;
        }
        return 2;
    }

    public static Enumeration elements() {
        return arten.elements();
    }

    public static String toString(int n) {
        switch (n) {
            case 0: {
                return AMTL_NACHWEIS_STRING;
            }
            case 1: {
                return UNTERG_HIST_NACHWEIS_STRING;
            }
            case 2: {
                return UNTERG_OHNE_NACHWEIS_STRING;
            }
            case 6: {
                return FP_LV_STRING;
            }
            case 7: {
                return UNTERG_FP_LV_STRING;
            }
            case 8: {
                return RESERV_PUNKT_STRING;
            }
            case 9: {
                return NICHT_LV_STRING;
            }
        }
        return UNDEF_STRING;
    }

    public static String getString(int n) {
        return KatasterPunktStatus.toString(n);
    }

    public static String getItem(int n) {
        return n + "  " + KatasterPunktStatus.toString(n);
    }

    public static int getStatus(String string) {
        if (string.equals(AMTL_NACHWEIS_STRING)) {
            return 0;
        }
        if (string.equals(UNTERG_HIST_NACHWEIS_STRING)) {
            return 1;
        }
        if (string.equals(UNTERG_OHNE_NACHWEIS_STRING)) {
            return 2;
        }
        if (string.equals(FP_LV_STRING)) {
            return 6;
        }
        if (string.equals(UNTERG_FP_LV_STRING)) {
            return 7;
        }
        if (string.equals(RESERV_PUNKT_STRING)) {
            return 8;
        }
        if (string.equals(NICHT_LV_STRING)) {
            return 9;
        }
        return -1;
    }

    static {
        arten.addElement(new KatasterPunktStatus(0, AMTL_NACHWEIS_STRING, Color.green));
        arten.addElement(new KatasterPunktStatus(1, UNTERG_HIST_NACHWEIS_STRING, new Color(128, 128, 255)));
        arten.addElement(new KatasterPunktStatus(2, UNTERG_OHNE_NACHWEIS_STRING, new Color(192, 192, 255)));
        arten.addElement(new KatasterPunktStatus(6, FP_LV_STRING, new Color(0, 170, 0)));
        arten.addElement(new KatasterPunktStatus(7, UNTERG_FP_LV_STRING, new Color(225, 75, 0)));
        arten.addElement(new KatasterPunktStatus(8, RESERV_PUNKT_STRING, new Color(0, 0, 255)));
        arten.addElement(new KatasterPunktStatus(9, NICHT_LV_STRING, new Color(255, 50, 255)));
        arten.addElement(new KatasterPunktStatus(10, "Katasternachweis", new Color(128, 255, 154)));
        arten.addElement(new KatasterPunktStatus(11, "Best\u00e4tigen des Nachweises", new Color(0, 180, 0)));
        arten.addElement(new KatasterPunktStatus(12, "\u00c4ndern im Nachweis", new Color(255, 200, 25)));
        arten.addElement(new KatasterPunktStatus(13, "Untergang im Nachweis", new Color(0, 128, 255)));
        arten.addElement(new KatasterPunktStatus(14, "Einf\u00fchren in den Nachweis", new Color(255, 128, 128)));
        arten.addElement(new KatasterPunktStatus(15, "Ohne Fortf\u00fchrung", Color.gray));
    }
}

