/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.ErrorDialog;
import de.geocalc.awt.ExceptionList;
import de.geocalc.awt.IBorder;
import de.geocalc.awt.IDialog;
import de.geocalc.awt.IFrame;
import de.geocalc.awt.IPanel;
import de.geocalc.awt.IProgressBar;
import de.geocalc.io.IFileOutputException;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.KafPlotProperties;
import de.geocalc.kafplot.KatAmt;
import de.geocalc.kafplot.KatasternachweisOptionDialog;
import de.geocalc.kafplot.io.KatasternachweisBrbAlkisWriter;
import de.geocalc.kafplot.io.KatasternachweisBrbWriter;
import de.geocalc.kafplot.io.KatasternachweisIOProperties;
import de.geocalc.kafplot.io.KatasternachweisNrwWriter;
import de.geocalc.kafplot.io.KatasternachweisWriter;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;

public class KatasternachweisDialog
extends IDialog
implements ActionListener {
    DataBase db;
    String rissOutPath;
    String identOutPath;
    protected ExceptionList exceptions;
    private static final String FILE_NAME_BUTTON_TEXT = "...";
    private static final String RISS_FILE_NAME_COMMAND = "Riss";
    private static final String IDENT_FILE_NAME_COMMAND = "Ident";
    private static final String OK_COMMAND = "OK";
    private static final String OPTION_COMMAND = "Optionen";
    private static final String ABORT_COMMAND = "Abbrechen";
    private static final String RISS_FILE_DEFAULT_NAME = "Riss";
    private static final String IDENT_FILE_DEFAULT_NAME = "Ident";
    private TextField rissFileNameTextField;
    private TextField rissPageCountTextField;
    private TextField identFileNameTextField;
    private TextField identPageCountTextField;
    private Button rissFileNameButton;
    private Button identFileNameButton;
    private Button okButton;
    private Button optionButton;
    private Button abortButton;
    private Label progressLabel;
    private IProgressBar progressBar;
    private String fileName;

    public KatasternachweisDialog(IFrame iFrame, String string, DataBase dataBase, String string2) {
        super(iFrame, string, true);
        this.db = dataBase;
        this.fileName = string2;
        this.exceptions = new ExceptionList();
        KatAmt katAmt = KatAmt.getKatAmt(DataBase.katasterAmt);
        if (katAmt != null) {
            KatasternachweisIOProperties.writeWithGrenzen(katAmt.withGrenzen);
            KatasternachweisIOProperties.writeWithGebaeude(katAmt.withGebaeude);
            KatasternachweisIOProperties.writeShortLines(katAmt.shortRissFormat);
            KatasternachweisIOProperties.writeRissBemerkung(katAmt.withRissBemerkung);
            KatasternachweisIOProperties.writeRissBestimmung(katAmt.withRissBestimmung);
            KatasternachweisIOProperties.writeRissKontrolle(katAmt.withRissKontrolle);
            KatasternachweisIOProperties.writeRissKombiMess(katAmt.withRissKombiMess);
            KatasternachweisIOProperties.writeIdentTitel(katAmt.writeIdentTitel);
            KatasternachweisIOProperties.writeLokalPunkt(katAmt.writeLokalPunkt);
            KatasternachweisIOProperties.writeSapLsp(katAmt.writeSapLsp);
            KatasternachweisIOProperties.useGewichte(katAmt.useGewichte);
            KatasternachweisIOProperties.formatMM(katAmt.formatMM);
            KatasternachweisIOProperties.setMaxAnschlussStatus(katAmt.maxAnschlussStatus);
            KatasternachweisIOProperties.parsePointNumber(katAmt.parsePointNumber);
            KatasternachweisIOProperties.setAltpunktKennung(katAmt.altpunktKennung);
            KatasternachweisIOProperties.testLSP(katAmt.testLsp);
            KatasternachweisIOProperties.testSP(katAmt.testSp);
            KatasternachweisIOProperties.testLGA(katAmt.testLga);
        } else {
            KatasternachweisIOProperties.writeWithGrenzen(KatasternachweisIOProperties.WRITE_WITH_GRENZEN);
            KatasternachweisIOProperties.writeWithGebaeude(KatasternachweisIOProperties.WRITE_WITH_GEBAEUDE);
            KatasternachweisIOProperties.writeShortLines(KatasternachweisIOProperties.WRITE_SHORT_LINES);
            KatasternachweisIOProperties.writeRissBemerkung(KatasternachweisIOProperties.WRITE_RISS_BEMERKUNG);
            KatasternachweisIOProperties.writeRissBestimmung(KatasternachweisIOProperties.WRITE_RISS_BESTIMMUNG);
            KatasternachweisIOProperties.writeRissKontrolle(KatasternachweisIOProperties.WRITE_RISS_KONTROLLE);
            KatasternachweisIOProperties.writeRissKombiMess(KatasternachweisIOProperties.WRITE_RISS_KOMBI_MESS);
            KatasternachweisIOProperties.writeIdentTitel(KatasternachweisIOProperties.WRITE_IDENT_TITEL);
            KatasternachweisIOProperties.writeLokalPunkt(KatasternachweisIOProperties.WRITE_LOKAL_PUNKT);
            KatasternachweisIOProperties.writeSapLsp(KatasternachweisIOProperties.WRITE_SAP_LSP);
            KatasternachweisIOProperties.useGewichte(KatasternachweisIOProperties.USE_GEWICHTE);
            KatasternachweisIOProperties.formatMM(KatasternachweisIOProperties.FORMAT_MM);
            KatasternachweisIOProperties.setMaxAnschlussStatus(KatasternachweisIOProperties.MAX_ANSCHLUSS_STATUS);
            KatasternachweisIOProperties.parsePointNumber(KatasternachweisIOProperties.PARSE_POINT_NUMBER);
            KatasternachweisIOProperties.setAltpunktKennung(KatasternachweisIOProperties.ALTPUNKT_KENNUNG);
            KatasternachweisIOProperties.testLSP(KatasternachweisIOProperties.TEST_LSP);
            KatasternachweisIOProperties.testSP(KatasternachweisIOProperties.TEST_SP);
            KatasternachweisIOProperties.testLGA(KatasternachweisIOProperties.TEST_LGA);
        }
        KatasternachweisIOProperties.writeIdentAllMessung(KatasternachweisIOProperties.WRITE_IDENT_ALL_MESSUNG);
        KatasternachweisIOProperties.writeIdentMapPoints(KatasternachweisIOProperties.WRITE_IDENT_MAP_POINTS);
        KatasternachweisIOProperties.writeWithVPraefix(KatasternachweisIOProperties.WRITE_WITH_V_PRAEFIX);
        KatasternachweisIOProperties.hideErrorMessages(KatasternachweisIOProperties.HIDE_ERROR_MESSAGES);
        KatasternachweisIOProperties.abmAsText(KatasternachweisIOProperties.ABM_AS_TEXT);
        if (DataBase.steuerDaten != null) {
            if (DataBase.steuerDaten.getIGON() < 20) {
                if (DataBase.T.size() > 0) {
                    KatasternachweisIOProperties.testLSP(false);
                }
            }
        }
        this.setLayout(new BorderLayout());
        Panel panel = new Panel(new BorderLayout());
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.ipady = 2;
        gridBagConstraints.anchor = 17;
        IPanel iPanel = new IPanel(gridBagLayout);
        iPanel.setBorder(new IBorder(1, "Dateien"));
        Label label = new Label("Riss:");
        iPanel.add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.rissFileNameTextField = new TextField(KafPlotProperties.getRisslisteFileName() + ".rtf", 20);
        iPanel.add(this.rissFileNameTextField);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(this.rissFileNameTextField, gridBagConstraints);
        this.rissFileNameButton = new Button(FILE_NAME_BUTTON_TEXT);
        iPanel.add(this.rissFileNameButton);
        this.rissFileNameButton.setActionCommand("Riss");
        this.rissFileNameButton.addActionListener(this);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(this.rissFileNameButton, gridBagConstraints);
        if (DataBase.model.getModel() == 2) {
            this.rissPageCountTextField = new TextField("1", 1);
            iPanel.add(this.rissPageCountTextField);
            gridBagConstraints.gridx = 3;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.fill = 2;
            gridBagLayout.setConstraints(this.rissPageCountTextField, gridBagConstraints);
            label = new Label("Vorbl\u00e4tter");
            iPanel.add(label);
            gridBagConstraints.gridx = 4;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagLayout.setConstraints(label, gridBagConstraints);
        }
        label = new Label("Punktidentit\u00e4t:");
        iPanel.add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.identFileNameTextField = new TextField(KafPlotProperties.getNachweisFileName() + ".rtf", 20);
        iPanel.add(this.identFileNameTextField);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(this.identFileNameTextField, gridBagConstraints);
        this.identFileNameButton = new Button(FILE_NAME_BUTTON_TEXT);
        iPanel.add(this.identFileNameButton);
        this.identFileNameButton.setActionCommand("Ident");
        this.identFileNameButton.addActionListener(this);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(this.identFileNameButton, gridBagConstraints);
        if (DataBase.model.getModel() == 2) {
            this.identPageCountTextField = new TextField("0", 1);
            iPanel.add(this.identPageCountTextField);
            gridBagConstraints.gridx = 3;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.fill = 2;
            gridBagLayout.setConstraints(this.identPageCountTextField, gridBagConstraints);
            label = new Label("Vorbl\u00e4tter");
            iPanel.add(label);
            gridBagConstraints.gridx = 4;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagLayout.setConstraints(label, gridBagConstraints);
        }
        panel.add("North", iPanel);
        IPanel iPanel2 = new IPanel(new BorderLayout());
        IBorder iBorder = new IBorder(1);
        iPanel2.setBorder(iBorder);
        Panel panel2 = new Panel(new FlowLayout());
        this.progressBar = new IProgressBar();
        panel2.add(this.progressBar);
        iPanel2.add("North", panel2);
        Panel panel3 = new Panel(new GridLayout(1, 1));
        this.progressLabel = new Label();
        panel3.add(this.progressLabel);
        iPanel2.add("South", panel3);
        panel.add("South", iPanel2);
        this.add("North", panel);
        Panel panel4 = new Panel(new FlowLayout(2));
        this.okButton = new Button(OK_COMMAND);
        this.okButton.addActionListener(this);
        panel4.add(this.okButton);
        this.optionButton = new Button(OPTION_COMMAND);
        this.optionButton.addActionListener(this);
        panel4.add(this.optionButton);
        this.abortButton = new Button(ABORT_COMMAND);
        this.abortButton.addActionListener(this);
        panel4.add(this.abortButton);
        this.add("South", panel4);
        this.pack();
        this.setLocationOfParent(iFrame);
    }

    public void write() {
        try {
            KatasternachweisWriter katasternachweisWriter;
            if (KatasternachweisIOProperties.getBundesland() == 1) {
                katasternachweisWriter = new KatasternachweisNrwWriter(new File(this.rissFileNameTextField.getText()), new File(this.identFileNameTextField.getText()), this.db);
            } else if (DataBase.model.getModel() == 2) {
                int n = 1;
                int n2 = 0;
                try {
                    n = Integer.parseInt(this.rissPageCountTextField.getText().trim());
                }
                catch (Exception exception) {
                    throw new IFileOutputException("Ung\u00fcltige Eingabe der Rissvorbl\u00e4tter");
                }
                try {
                    n2 = Integer.parseInt(this.identPageCountTextField.getText().trim());
                }
                catch (Exception exception) {
                    throw new IFileOutputException("Ung\u00fcltige Eingabe der Identvorbl\u00e4tter");
                }
                katasternachweisWriter = new KatasternachweisBrbAlkisWriter(new File(this.rissFileNameTextField.getText()), new File(this.identFileNameTextField.getText()), this.db, n, n2);
            } else {
                katasternachweisWriter = new KatasternachweisBrbWriter(new File(this.rissFileNameTextField.getText()), new File(this.identFileNameTextField.getText()), this.db);
            }
            katasternachweisWriter.setExceptionList(this.exceptions);
            katasternachweisWriter.setProgressBar(this.progressBar);
            katasternachweisWriter.setProgressLabel(this.progressLabel);
            katasternachweisWriter.write();
        }
        catch (IFileOutputException iFileOutputException) {
            ErrorDialog errorDialog = new ErrorDialog(this.parent, iFileOutputException);
            errorDialog.setVisible(true);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(OK_COMMAND)) {
            this.write();
            this.endDialog();
        } else if (string.equals(ABORT_COMMAND)) {
            this.endDialog();
        } else if (string.equals("Riss")) {
            FileDialog fileDialog = new FileDialog((Frame)this.parent, "Speichern", 1);
            fileDialog.setFile("*.rtf");
            fileDialog.setVisible(true);
            if (fileDialog.getFile() != null) {
                this.rissFileNameTextField.setText(fileDialog.getDirectory() + fileDialog.getFile());
            }
        } else if (string.equals("Ident")) {
            FileDialog fileDialog = new FileDialog((Frame)this.parent, "Speichern", 1);
            fileDialog.setFile("*.rtf");
            fileDialog.setVisible(true);
            if (fileDialog.getFile() != null) {
                this.identFileNameTextField.setText(fileDialog.getDirectory() + fileDialog.getFile());
            }
        } else if (string.equals(OPTION_COMMAND)) {
            KatasternachweisOptionDialog katasternachweisOptionDialog = new KatasternachweisOptionDialog(this.parent, OPTION_COMMAND);
            katasternachweisOptionDialog.setVisible(true);
        }
    }

    @Override
    protected void endDialog() {
        if (!this.exceptions.isEmpty()) {
            ErrorDialog errorDialog = new ErrorDialog(this.parent, "Es sind Fehler beim Schreiben der Daten aufgetreten, \ndie fehlerhafte Daten wurden markiert.", this.exceptions);
            errorDialog.setVisible(true);
        }
        super.endDialog();
    }

    @Override
    protected void doStandardAction() {
        this.write();
        this.endDialog();
    }

    @Override
    protected void doAbortAction() {
        this.endDialog();
    }
}

