/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.IException;
import de.geocalc.kafplot.Punkt;
import java.util.Enumeration;
import java.util.Hashtable;

public class KoordinatenSystem {
    public static final int OHNE = -9;
    public static final int UNDEF = -1;
    public static final int LOKAL = 0;
    public static final int GK = 150;
    public static final int ETRS = 489;
    private static final String OHNE_NAME = "ohne";
    private static final String UNDEF_NAME = "undef";
    private static final String LOKAL_NAME = "lokal";
    private static final String GK_NAME = "GK";
    private static final String ETRS_NAME = "Etrs";
    private static double etrs_min_y;
    private static double etrs_max_y;
    private static double gk_min_y;
    private static double gk_max_y;
    private static Hashtable systems;
    private int system;
    private static final double sm_a = 6378137.0;
    private static final double sm_b = 6356752.314;
    private static final double sm_EccSquared = 0.00669437999013;
    private static final double UTMScaleFactor = 0.9996;

    public KoordinatenSystem(int n) {
        this.system = n;
    }

    public static String getSystemName(int n) {
        return (String)systems.get(new Integer(n));
    }

    public static void setArea(int n, double d, double d2) {
        switch (n) {
            case 489: {
                etrs_min_y = d;
                etrs_max_y = d2;
                break;
            }
            case 150: {
                gk_min_y = d;
                gk_max_y = d2;
            }
        }
    }

    public static double getMinimumArea(int n) {
        switch (n) {
            case 489: {
                return etrs_min_y;
            }
            case 150: {
                return gk_min_y;
            }
        }
        return 0.0;
    }

    public static double getMaximumArea(int n) {
        switch (n) {
            case 489: {
                return etrs_max_y;
            }
            case 150: {
                return gk_max_y;
            }
        }
        return 0.0;
    }

    public static int getSystemOf(double d, double d2) {
        if (d > etrs_min_y && d2 < etrs_max_y) {
            return 489;
        }
        if (d > gk_min_y && d2 < gk_max_y) {
            return 150;
        }
        return 0;
    }

    public static int getSystemOf(Punkt punkt) {
        if (punkt.y > etrs_min_y && punkt.y < etrs_max_y) {
            return 489;
        }
        if (punkt.y > gk_min_y && punkt.y < gk_max_y) {
            return 150;
        }
        return 0;
    }

    public void setSystem(int n) {
        this.system = n;
    }

    public void setSystem(String string) throws IException {
        Enumeration enumeration = systems.keys();
        while (enumeration.hasMoreElements()) {
            Integer n = (Integer)enumeration.nextElement();
            if (!((String)systems.get(n)).equalsIgnoreCase(string)) continue;
            this.system = n;
            return;
        }
        throw new IException("kein g\u00fcltiges KoordinatenSystem: " + string);
    }

    public int getSystem() {
        return this.system;
    }

    public String getSystemName() {
        return (String)systems.get(new Integer(this.system));
    }

    public int getKafkaSystemNummer() {
        switch (this.system) {
            case 150: {
                return 1;
            }
            case 489: {
                return 2;
            }
        }
        return 0;
    }

    public static int getSystemFromKafka(int n) {
        switch (n) {
            case 0: {
                return 0;
            }
            case 1: {
                return 150;
            }
            case 2: {
                return 489;
            }
        }
        return -1;
    }

    public static double getYOffset(int n) {
        if (n == 489) {
            return (double)((int)(etrs_min_y / 1000000.0)) * 1000000.0;
        }
        if (n == 150) {
            return (double)((int)(gk_min_y / 1000000.0)) * 1000000.0;
        }
        return 0.0;
    }

    public static double regularY(double d, int n) {
        if (d < 1000000.0 || d >= 1.0E7) {
            if (n == 489) {
                return d < 1000000.0 ? d + (double)((int)(etrs_min_y / 1000000.0)) * 1000000.0 : d % 1.0E7;
            }
            if (n == 150) {
                return d < 1000000.0 ? d + (double)((int)(gk_min_y / 1000000.0)) * 1000000.0 : d % 1.0E7;
            }
        }
        return d;
    }

    private static double DegToRad(double d) {
        return d / 180.0 * Math.PI;
    }

    private static double RadToDeg(double d) {
        return d / Math.PI * 180.0;
    }

    private static double ArcLengthOfMeridian(double d) {
        double d2 = 0.0016792204056685965;
        double d3 = 6367444.657 * (1.0 + Math.pow(d2, 2.0) / 4.0 + Math.pow(d2, 4.0) / 64.0);
        double d4 = -3.0 * d2 / 2.0 + 9.0 * Math.pow(d2, 3.0) / 16.0 + -3.0 * Math.pow(d2, 5.0) / 32.0;
        double d5 = 15.0 * Math.pow(d2, 2.0) / 16.0 + -15.0 * Math.pow(d2, 4.0) / 32.0;
        double d6 = -35.0 * Math.pow(d2, 3.0) / 48.0 + 105.0 * Math.pow(d2, 5.0) / 256.0;
        double d7 = 315.0 * Math.pow(d2, 4.0) / 512.0;
        return d3 * (d + d4 * Math.sin(2.0 * d) + d5 * Math.sin(4.0 * d) + d6 * Math.sin(6.0 * d) + d7 * Math.sin(8.0 * d));
    }

    private static double UTMCentralMeridian(int n) {
        return KoordinatenSystem.DegToRad(-183.0 + (double)n * 6.0);
    }

    private static double FootpointLatitude(double d) {
        double d2 = 0.0016792204056685965;
        double d3 = 6367444.657 * (1.0 + Math.pow(d2, 2.0) / 4.0 + Math.pow(d2, 4.0) / 64.0);
        double d4 = d / d3;
        double d5 = 3.0 * d2 / 2.0 + -27.0 * Math.pow(d2, 3.0) / 32.0 + 269.0 * Math.pow(d2, 5.0) / 512.0;
        double d6 = 21.0 * Math.pow(d2, 2.0) / 16.0 + -55.0 * Math.pow(d2, 4.0) / 32.0;
        double d7 = 151.0 * Math.pow(d2, 3.0) / 96.0 + -417.0 * Math.pow(d2, 5.0) / 128.0;
        double d8 = 1097.0 * Math.pow(d2, 4.0) / 512.0;
        return d4 + d5 * Math.sin(2.0 * d4) + d6 * Math.sin(4.0 * d4) + d7 * Math.sin(6.0 * d4) + d8 * Math.sin(8.0 * d4);
    }

    private static void MapLatLonToXY(double d, double d2, double d3, double[] dArray) {
        double d4 = (Math.pow(6378137.0, 2.0) - Math.pow(6356752.314, 2.0)) / Math.pow(6356752.314, 2.0);
        double d5 = d4 * Math.pow(Math.cos(d), 2.0);
        double d6 = Math.pow(6378137.0, 2.0) / (6356752.314 * Math.sqrt(1.0 + d5));
        double d7 = Math.tan(d);
        double d8 = d7 * d7;
        double d9 = d8 * d8 * d8 - Math.pow(d7, 6.0);
        double d10 = d2 - d3;
        double d11 = 1.0 - d8 + d5;
        double d12 = 5.0 - d8 + 9.0 * d5 + 4.0 * (d5 * d5);
        double d13 = 5.0 - 18.0 * d8 + d8 * d8 + 14.0 * d5 - 58.0 * d8 * d5;
        double d14 = 61.0 - 58.0 * d8 + d8 * d8 + 270.0 * d5 - 330.0 * d8 * d5;
        double d15 = 61.0 - 479.0 * d8 + 179.0 * (d8 * d8) - d8 * d8 * d8;
        double d16 = 1385.0 - 3111.0 * d8 + 543.0 * (d8 * d8) - d8 * d8 * d8;
        dArray[0] = d6 * Math.cos(d) * d10 + d6 / 6.0 * Math.pow(Math.cos(d), 3.0) * d11 * Math.pow(d10, 3.0) + d6 / 120.0 * Math.pow(Math.cos(d), 5.0) * d13 * Math.pow(d10, 5.0) + d6 / 5040.0 * Math.pow(Math.cos(d), 7.0) * d15 * Math.pow(d10, 7.0);
        dArray[1] = KoordinatenSystem.ArcLengthOfMeridian(d) + d7 / 2.0 * d6 * Math.pow(Math.cos(d), 2.0) * Math.pow(d10, 2.0) + d7 / 24.0 * d6 * Math.pow(Math.cos(d), 4.0) * d12 * Math.pow(d10, 4.0) + d7 / 720.0 * d6 * Math.pow(Math.cos(d), 6.0) * d14 * Math.pow(d10, 6.0) + d7 / 40320.0 * d6 * Math.pow(Math.cos(d), 8.0) * d16 * Math.pow(d10, 8.0);
    }

    private static void MapXYToLatLon(double d, double d2, double d3, double[] dArray) {
        double d4;
        double d5 = KoordinatenSystem.FootpointLatitude(d2);
        double d6 = (Math.pow(6378137.0, 2.0) - Math.pow(6356752.314, 2.0)) / Math.pow(6356752.314, 2.0);
        double d7 = Math.cos(d5);
        double d8 = d6 * Math.pow(d7, 2.0);
        double d9 = d4 = Math.pow(6378137.0, 2.0) / (6356752.314 * Math.sqrt(1.0 + d8));
        double d10 = Math.tan(d5);
        double d11 = d10 * d10;
        double d12 = d11 * d11;
        double d13 = 1.0 / (d9 * d7);
        double d14 = d10 / (2.0 * (d9 *= d4));
        double d15 = 1.0 / (6.0 * (d9 *= d4) * d7);
        double d16 = d10 / (24.0 * (d9 *= d4));
        double d17 = 1.0 / (120.0 * (d9 *= d4) * d7);
        double d18 = d10 / (720.0 * (d9 *= d4));
        double d19 = 1.0 / (5040.0 * (d9 *= d4) * d7);
        double d20 = d10 / (40320.0 * (d9 *= d4));
        double d21 = -1.0 - d8;
        double d22 = -1.0 - 2.0 * d11 - d8;
        double d23 = 5.0 + 3.0 * d11 + 6.0 * d8 - 6.0 * d11 * d8 - 3.0 * (d8 * d8) - 9.0 * d11 * (d8 * d8);
        double d24 = 5.0 + 28.0 * d11 + 24.0 * d12 + 6.0 * d8 + 8.0 * d11 * d8;
        double d25 = -61.0 - 90.0 * d11 - 45.0 * d12 - 107.0 * d8 + 162.0 * d11 * d8;
        double d26 = -61.0 - 662.0 * d11 - 1320.0 * d12 - 720.0 * (d12 * d11);
        double d27 = 1385.0 + 3633.0 * d11 + 4095.0 * d12 + 1575.0 * (d12 * d11);
        dArray[0] = KoordinatenSystem.RadToDeg(d5 + d14 * d21 * (d * d) + d16 * d23 * Math.pow(d, 4.0) + d18 * d25 * Math.pow(d, 6.0) + d20 * d27 * Math.pow(d, 8.0));
        dArray[1] = KoordinatenSystem.RadToDeg(d3 + d13 * d + d15 * d22 * Math.pow(d, 3.0) + d17 * d24 * Math.pow(d, 5.0) + d19 * d26 * Math.pow(d, 7.0));
    }

    public static int LatLonToUTMXY(double d, double d2, int n, double[] dArray) {
        KoordinatenSystem.MapLatLonToXY(d, d2, KoordinatenSystem.UTMCentralMeridian(n), dArray);
        dArray[0] = dArray[0] * 0.9996 + 500000.0;
        dArray[1] = dArray[1] * 0.9996;
        if (dArray[1] < 0.0) {
            dArray[1] = dArray[1] + 1.0E7;
        }
        return n;
    }

    public static void UTMXYToLatLon(double d, double d2, int n, boolean bl, double[] dArray) {
        d %= 1000000.0;
        d -= 500000.0;
        d /= 0.9996;
        if (bl) {
            d2 -= 1.0E7;
        }
        KoordinatenSystem.MapXYToLatLon(d, d2 /= 0.9996, KoordinatenSystem.UTMCentralMeridian(n), dArray);
    }

    public static int getZone(double d) {
        return 30 + (int)(d / 1000000.0);
    }

    static {
        systems = new Hashtable();
        systems.put(new Integer(-9), OHNE_NAME);
        systems.put(new Integer(-1), UNDEF_NAME);
        systems.put(new Integer(0), LOKAL_NAME);
        systems.put(new Integer(150), GK_NAME);
        systems.put(new Integer(489), ETRS_NAME);
    }
}

