/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.IException;
import de.geocalc.geodata.AbstractLage;
import de.geocalc.geodata.AbstractLageEntry;
import de.geocalc.geom.Koordinate2D;
import de.geocalc.kafplot.AngleElement;
import de.geocalc.kafplot.GebaeudeKennzeichen;
import de.geocalc.kafplot.Gemeinde;
import de.geocalc.kafplot.LageEntry;
import de.geocalc.kafplot.Strasse;
import de.geocalc.kafplot.io.KafPlotIOConstants;
import de.geocalc.text.IFormat;
import de.geocalc.xml.Node;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public final class Lage
implements AbstractLage,
Koordinate2D,
AngleElement {
    private String bezeichnung = null;
    private LageEntry entry = null;
    double y;
    double x;
    float w;

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public void setX(double d) {
        this.x = d;
    }

    @Override
    public double getY() {
        return this.y;
    }

    @Override
    public void setY(double d) {
        this.y = d;
    }

    @Override
    public void setAngle(double d) {
        this.w = (float)d;
    }

    @Override
    public float getAngle() {
        return this.w;
    }

    public GebaeudeKennzeichen toGebaeudeKennzeichen() {
        if (this.entry == null) {
            return null;
        }
        GebaeudeKennzeichen gebaeudeKennzeichen = new GebaeudeKennzeichen(this.entry.getGemeinde(), this.entry.getStrasse(), this.entry.getHausNummer(), this.entry.getAdressenZusatz(), this.entry.getLfdNummer(), this.entry.isPseudoNummer());
        gebaeudeKennzeichen.setY(this.y);
        gebaeudeKennzeichen.setX(this.x);
        gebaeudeKennzeichen.setAngle(this.w);
        return gebaeudeKennzeichen;
    }

    @Override
    public int getAdresseKey() {
        if (this.entry == null) {
            return 0;
        }
        int n = this.entry.getStrasse();
        int n2 = this.entry.hasHausNummer() ? this.entry.getHausNummer() : 0;
        int n3 = this.entry.hasAdressenZusatz() ? Character.toUpperCase(this.entry.getAdressenZusatz().charAt(0)) - 65 + 1 : 0;
        try {
            if (n != 0 && n2 == 0 && this.bezeichnung != null) {
                int n4 = 0;
                int n5 = 0;
                int n6 = this.bezeichnung.length();
                for (int i = 0; i < n6; ++i) {
                    char c = this.bezeichnung.charAt(i);
                    if (n5 > 0) {
                        if (c == ' ') continue;
                        if (!Character.isLetter(c) || i + 1 < n6 && Character.isLetter(this.bezeichnung.charAt(i + 1))) break;
                        n3 = Character.toUpperCase(c) - 65 + 1;
                        break;
                    }
                    if (Character.isDigit(c)) {
                        if (n4 != 0) continue;
                        n4 = i;
                        continue;
                    }
                    if (n4 <= 0 || n5 != 0) continue;
                    n5 = i--;
                    n2 = Integer.parseInt(this.bezeichnung.substring(n4, n5));
                }
                if (n2 == 0 && n4 > 0) {
                    n2 = Integer.parseInt(this.bezeichnung.substring(n4));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n * 10000 + n2 * 100 + n3;
    }

    @Override
    public boolean hasBezeichnung() {
        return this.bezeichnung != null;
    }

    @Override
    public void setBezeichnung(String string) {
        this.bezeichnung = string;
    }

    @Override
    public String getBezeichnung() {
        return this.bezeichnung;
    }

    public String getBezeichnungAsString() {
        return this.bezeichnung != null ? this.bezeichnung : this.createEntLage(null);
    }

    @Override
    public String getStrasseAsString() {
        if (this.entry == null) {
            return IFormat.i05.format(0L);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.entry.getStrasseAsString());
        LageEntry lageEntry = this.entry;
        while (lageEntry.hasNext()) {
            lageEntry = (LageEntry)lageEntry.getNext();
            String string = lageEntry.getStrasseAsString();
            if (stringBuffer.toString().indexOf(string) >= 0) continue;
            stringBuffer.append(", ");
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    @Override
    public AbstractLageEntry getEntry() {
        return this.entry;
    }

    @Override
    public void setEntry(AbstractLageEntry abstractLageEntry) {
        this.entry = (LageEntry)abstractLageEntry;
    }

    @Override
    public void addEntry(AbstractLageEntry abstractLageEntry) {
        abstractLageEntry.setNext(null);
        if (this.entry == null) {
            this.entry = (LageEntry)abstractLageEntry;
        } else {
            if (abstractLageEntry.isLt(this.entry)) {
                abstractLageEntry.setNext(this.entry);
                this.entry = (LageEntry)abstractLageEntry;
                return;
            }
            LageEntry lageEntry = this.entry;
            while (lageEntry.hasNext()) {
                if (abstractLageEntry.isLt(lageEntry.getNext())) {
                    abstractLageEntry.setNext(lageEntry.getNext());
                    lageEntry.setNext(abstractLageEntry);
                    return;
                }
                lageEntry = (LageEntry)lageEntry.getNext();
            }
            lageEntry.setNext(abstractLageEntry);
        }
    }

    @Override
    public boolean hasEntries() {
        return this.entry != null;
    }

    @Override
    public int getGemeindeKey() {
        return this.entry != null ? this.entry.getGemeinde() : 0;
    }

    @Override
    public int getStrasseKey() {
        return this.entry != null ? this.entry.getStrasse() : 0;
    }

    @Override
    public boolean hasStrasse(int n) {
        for (LageEntry lageEntry = this.entry; lageEntry != null; lageEntry = (LageEntry)lageEntry.getNext()) {
            if (lageEntry.getStrasse() != n) continue;
            return true;
        }
        return false;
    }

    public boolean hasAdresse(int n, int n2, String string) {
        for (LageEntry lageEntry = this.entry; lageEntry != null; lageEntry = (LageEntry)lageEntry.getNext()) {
            if (n != lageEntry.getStrasse() || n2 != lageEntry.getHausNummer()) continue;
            if (string == null) {
                return lageEntry.getAdressenZusatz() == null;
            }
            return string.equals(lageEntry.getAdressenZusatz());
        }
        return false;
    }

    public boolean isComplete() {
        if (this.entry == null) {
            return false;
        }
        for (LageEntry lageEntry = this.entry; lageEntry != null; lageEntry = (LageEntry)lageEntry.getNext()) {
            if (!lageEntry.isComplete()) continue;
            return true;
        }
        return false;
    }

    public boolean checkEntLage(Gemeinde gemeinde) throws Exception {
        Object object;
        Object object2;
        LageEntry lageEntry;
        for (lageEntry = this.entry; lageEntry != null; lageEntry = (LageEntry)lageEntry.getNext()) {
            int n = lageEntry.getGemeinde();
            object2 = Gemeinde.getGemeinde(n);
            if (object2 == null) {
                object2 = gemeinde;
            }
            if (object2 == null || (object = ((Gemeinde)object2).getStrasse(lageEntry.getStrasse())) != null) continue;
            throw new Exception("Stra\u00dfenschl\u00fcssel " + lageEntry.getStrasseAsString() + " nicht in Gemeinde " + ((Gemeinde)object2).getNummer() + " gefunden");
        }
        if (this.bezeichnung == null) {
            throw new Exception("fehlende Lagebezeichnung");
        }
        if (this.entry == null) {
            return true;
        }
        if (this.entry.getNext() == null) {
            Strasse strasse = gemeinde.getStrasse(this.entry.getStrasse());
            if (strasse == null) {
                throw new Exception("Stra\u00dfenschl\u00fcssel " + this.entry.getStrasseAsString() + " nicht in Gemeinde " + gemeinde.getNummer() + " gefunden");
            }
            if (this.entry.isComplete()) {
                if (!this.entry.createEntLage(strasse.getName()).equals(this.bezeichnung)) {
                    throw new Exception("entschl\u00fcsselte Stra\u00dfe " + this.entry.toDatString() + " stimmt nicht mit der Lagebezeichnung '" + this.bezeichnung + "' \u00fcberein");
                }
                return true;
            }
            if (this.bezeichnung.indexOf(strasse.getName()) < 0) {
                throw new Exception("entschl\u00fcsselte Stra\u00dfe " + this.entry.toDatString() + " ist nicht in der Lagebezeichnung '" + this.bezeichnung + "' enthalten");
            }
            return true;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(this.bezeichnung, ",");
        object2 = new Hashtable();
        while (stringTokenizer.hasMoreElements()) {
            object = stringTokenizer.nextToken().trim();
            ((Hashtable)object2).put(object, object);
        }
        for (lageEntry = this.entry; lageEntry != null; lageEntry = (LageEntry)lageEntry.getNext()) {
            object = gemeinde.getStrasse(lageEntry.getStrasse());
            if (object == null) {
                throw new Exception("Stra\u00dfenschl\u00fcssel " + lageEntry.getStrasseAsString() + " nicht in Gemeinde " + gemeinde.getNummer() + " gefunden");
            }
            if (lageEntry.isComplete()) {
                if (((Hashtable)object2).get(lageEntry.createEntLage(((Strasse)object).getName())) == null) {
                    throw new Exception("entschl\u00fcsselte Stra\u00dfe " + this.entry.toDatString() + " stimmt nicht mit der Lagebezeichnung '" + this.bezeichnung + "' \u00fcberein");
                }
                return true;
            }
            String string = ((Strasse)object).getName();
            boolean bl = false;
            Enumeration enumeration = ((Hashtable)object2).keys();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                if (string2.indexOf(string) < 0) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            throw new Exception("entschl\u00fcsselte Stra\u00dfe " + this.entry.toDatString() + " ist nicht in der Lagebezeichnung '" + this.bezeichnung + "' enthalten");
        }
        return true;
    }

    private String createEntLage(Gemeinde gemeinde) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        for (LageEntry lageEntry = this.entry; lageEntry != null; lageEntry = (LageEntry)lageEntry.getNext()) {
            int n2;
            Gemeinde gemeinde2;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            if ((gemeinde2 = Gemeinde.getGemeinde(n2 = lageEntry.getGemeinde())) == null) {
                gemeinde2 = gemeinde;
            }
            if (gemeinde2 == null) continue;
            int n3 = lageEntry.getStrasse();
            if (n3 != n) {
                Strasse strasse = gemeinde2.getStrasse(n3);
                stringBuffer.append(lageEntry.createEntLage(strasse != null ? strasse.getName() : "Nr."));
            } else {
                stringBuffer.append(lageEntry.createEntLage());
            }
            n = n3;
        }
        return stringBuffer.toString();
    }

    @Override
    public int countEntries() {
        if (this.entry == null) {
            return 0;
        }
        int n = 1;
        LageEntry lageEntry = this.entry;
        while ((lageEntry = (LageEntry)lageEntry.getNext()) != null) {
            ++n;
        }
        return n;
    }

    public static Lage parseDatString(String string) throws IException {
        Lage lage = new Lage();
        if (string.indexOf(44) < 0) {
            lage.addEntry(LageEntry.parseDatString(string));
        } else {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                lage.addEntry(LageEntry.parseDatString(string2));
            }
        }
        return lage;
    }

    public String toDatString() {
        if (this.entry == null) {
            return IFormat.i05.format(0L);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.entry.toDatString());
        LageEntry lageEntry = this.entry;
        while (lageEntry.hasNext()) {
            stringBuffer.append(",");
            lageEntry = (LageEntry)lageEntry.getNext();
            stringBuffer.append(lageEntry.toDatString());
        }
        return stringBuffer.toString();
    }

    public Node toGml() throws Exception {
        Node node = new Node("kafplot:lage");
        if (this.bezeichnung != null) {
            node.addNode(new Node("kafplot:lage_bezeichnung", this.bezeichnung));
        }
        for (LageEntry lageEntry = this.entry; lageEntry != null; lageEntry = (LageEntry)lageEntry.getNext()) {
            node.addNode(lageEntry.toGml());
        }
        return node;
    }

    public void writeObject(DataOutput dataOutput) throws IOException {
        dataOutput.writeByte(81);
        for (LageEntry lageEntry = this.entry; lageEntry != null; lageEntry = (LageEntry)lageEntry.getNext()) {
            lageEntry.writeObject(dataOutput);
        }
        dataOutput.writeByte(0);
        KafPlotIOConstants.writeString(dataOutput, this.bezeichnung);
    }

    public static Lage readObject(DataInput dataInput) throws IOException {
        Lage lage = new Lage();
        byte by = 0;
        while ((by = dataInput.readByte()) == 82) {
            lage.addEntry(LageEntry.readObject(dataInput));
        }
        lage.bezeichnung = KafPlotIOConstants.readString(dataInput);
        return lage;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.toDatString());
        if (this.bezeichnung != null) {
            stringBuffer.append(" ");
            stringBuffer.append(this.bezeichnung);
        }
        return stringBuffer.toString();
    }
}

