/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.IException;
import de.geocalc.geodata.AbstractLageEntry;
import de.geocalc.kafplot.Gemeinde;
import de.geocalc.kafplot.Strasse;
import de.geocalc.text.IFormat;
import de.geocalc.util.Comparable;
import de.geocalc.util.Sortable;
import de.geocalc.xml.Node;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public final class LageEntry
implements AbstractLageEntry,
Comparable,
Sortable {
    private int gemeinde;
    private int strasse;
    private int hausNummer;
    private int lfdNummer;
    private String adrZusatz = null;
    private boolean isPseudoNr;
    private LageEntry next = null;

    public LageEntry() {
    }

    public LageEntry(int n) {
        this.strasse = n;
    }

    @Override
    public boolean isLt(Sortable sortable) {
        return this.compareTo(sortable) < 0;
    }

    @Override
    public int compareTo(Object object) {
        LageEntry lageEntry = (LageEntry)object;
        if (this.gemeinde != lageEntry.gemeinde) {
            return this.gemeinde - lageEntry.gemeinde;
        }
        if (this.strasse != lageEntry.strasse) {
            return this.strasse - lageEntry.strasse;
        }
        if (this.hausNummer != lageEntry.hausNummer) {
            return this.hausNummer - lageEntry.hausNummer;
        }
        if (this.adrZusatz != null || lageEntry.adrZusatz != null) {
            if (this.adrZusatz != null && lageEntry.adrZusatz != null) {
                return this.adrZusatz.compareTo(lageEntry.adrZusatz);
            }
            return this.adrZusatz != null ? 1 : -1;
        }
        if (this.lfdNummer != lageEntry.lfdNummer) {
            return this.lfdNummer - lageEntry.lfdNummer;
        }
        return 0;
    }

    @Override
    public void setGemeinde(int n) {
        this.gemeinde = n;
    }

    @Override
    public int getGemeinde() {
        return this.gemeinde;
    }

    @Override
    public boolean hasStrasse() {
        return this.strasse != 0;
    }

    @Override
    public void setStrasse(int n) {
        this.strasse = n;
    }

    public void setStrasse(int n, String string) throws NumberFormatException {
        this.gemeinde = n;
        this.strasse = Strasse.parseKey(n, string);
    }

    @Override
    public int getStrasse() {
        return this.strasse;
    }

    public String getStrasseAsString() {
        return Strasse.toKeyString(this.gemeinde, this.strasse);
    }

    @Override
    public boolean hasHausNummer() {
        return this.hausNummer > 0;
    }

    @Override
    public void setHausNummer(int n) {
        this.hausNummer = n;
    }

    @Override
    public int getHausNummer() {
        return this.hausNummer;
    }

    @Override
    public boolean hasAdressenZusatz() {
        return this.adrZusatz != null;
    }

    @Override
    public void setAdressenZusatz(String string) {
        this.adrZusatz = string;
    }

    @Override
    public String getAdressenZusatz() {
        return this.adrZusatz;
    }

    public void setLfdNummer(int n) {
        this.lfdNummer = n;
    }

    public int getLfdNummer() {
        return this.lfdNummer;
    }

    public void setPseudoNummer(boolean bl) {
        this.isPseudoNr = bl;
    }

    public boolean isPseudoNummer() {
        return this.isPseudoNr;
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public void setNext(AbstractLageEntry abstractLageEntry) {
        this.next = (LageEntry)abstractLageEntry;
    }

    @Override
    public AbstractLageEntry getNext() {
        return this.next;
    }

    public boolean isComplete() {
        return this.hasHausNummer() || this.hasAdressenZusatz();
    }

    public String createEntLage(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        if (this.hasHausNummer()) {
            stringBuffer.append(" ");
            stringBuffer.append(this.getHausNummer());
        }
        if (this.hasAdressenZusatz()) {
            stringBuffer.append(this.getAdressenZusatz());
        }
        return stringBuffer.toString();
    }

    public String createEntLage() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.hasHausNummer()) {
            stringBuffer.append(this.getHausNummer());
        }
        if (this.hasAdressenZusatz()) {
            stringBuffer.append(this.getAdressenZusatz());
        }
        return stringBuffer.toString();
    }

    public static LageEntry parseDatString(String string) throws IException {
        try {
            LageEntry lageEntry = new LageEntry();
            int n = string.indexOf(58);
            if (n >= 0) {
                lageEntry.gemeinde = Integer.parseInt(string.substring(0, n));
                string = string.substring(n + 1);
            }
            if ((n = string.indexOf(47)) > 0) {
                lageEntry.strasse = Strasse.parseKey(lageEntry.gemeinde, string.substring(0, n));
                LageEntry.parseHaus(string.substring(n + 1), lageEntry);
            } else {
                lageEntry.strasse = Strasse.parseKey(lageEntry.gemeinde, string);
            }
            return lageEntry;
        }
        catch (Exception exception) {
            throw new IException("Ung\u00fcltiger Stra\u00dfenschl\u00fcssel: " + string);
        }
    }

    private static void parseHaus(String string, LageEntry lageEntry) {
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (Character.isDigit(string.charAt(i))) continue;
            n = 1;
            break;
        }
        if (n >= 0) {
            lageEntry.hausNummer = Integer.parseInt(string.substring(0, n));
            lageEntry.adrZusatz = string.substring(n);
        } else {
            lageEntry.hausNummer = Integer.parseInt(string);
        }
    }

    public String toDatString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.gemeinde != 0) {
            stringBuffer.append(this.gemeinde);
            stringBuffer.append(":");
        }
        stringBuffer.append(Strasse.toKeyString(this.gemeinde, this.strasse));
        if (this.hausNummer > 0) {
            stringBuffer.append('/');
            stringBuffer.append(this.hausNummer);
            if (this.adrZusatz != null) {
                stringBuffer.append(this.adrZusatz);
            }
        }
        return stringBuffer.toString();
    }

    public Node toGml() throws Exception {
        Node node = new Node("kafplot:lage_adresse");
        Gemeinde gemeinde = null;
        if (this.gemeinde != 0) {
            node.addNode(new Node("kafplot:gemeinde", Integer.toString(this.gemeinde)));
            gemeinde = Gemeinde.getGemeinde(this.gemeinde);
            if (gemeinde != null) {
                node.addNode(new Node("kafplot:gemeinde_name", gemeinde.getName()));
            }
        }
        if (this.strasse != 0) {
            node.addNode(new Node("kafplot:strasse", Integer.toString(this.strasse)));
            if (gemeinde != null) {
                Strasse strasse = gemeinde.getStrasse(this.strasse);
                if (gemeinde != null) {
                    node.addNode(new Node("kafplot:strasse_name", strasse.getName()));
                }
            }
        }
        if (this.hausNummer != 0) {
            node.addNode(new Node("kafplot:gebaeude_nummer", Integer.toString(this.hausNummer) + (this.adrZusatz != null ? this.adrZusatz : "")));
        }
        return node;
    }

    public static LageEntry parseWldgeString(String string) throws IException {
        int n = string.length();
        LageEntry lageEntry = new LageEntry();
        String string2 = null;
        try {
            if (n > 0) {
                lageEntry.setGemeinde(Integer.parseInt(string.substring(0, Math.min(11, n)).trim()));
            }
        }
        catch (Exception exception) {
            throw new IException("ung\u00fcltiger Gemeindeschl\u00fcssel: " + string2);
        }
        try {
            if (n > 11) {
                lageEntry.setStrasse(Strasse.parseKey(lageEntry.gemeinde, string.substring(11, Math.min(17, n))));
            }
        }
        catch (Exception exception) {
            throw new IException("ung\u00fcltiger Stra\u00dfenschl\u00fcssel: " + string2);
        }
        try {
            if (n > 18) {
                lageEntry.setHausNummer(Integer.parseInt(string.substring(18, Math.min(22, n)).trim()));
            }
        }
        catch (Exception exception) {
            throw new IException("ung\u00fcltiger Hausnummer: " + string2);
        }
        try {
            if (n > 22) {
                lageEntry.setAdressenZusatz(string.substring(22, Math.min(24, n)).trim());
            }
        }
        catch (Exception exception) {
            throw new IException("ung\u00fcltiger Adressenzusatz: " + string2);
        }
        return lageEntry;
    }

    public void writeObject(DataOutput dataOutput) throws IOException {
        dataOutput.writeByte(82);
        dataOutput.writeInt(this.strasse);
    }

    public static LageEntry readObject(DataInput dataInput) throws IOException {
        LageEntry lageEntry = new LageEntry();
        lageEntry.strasse = dataInput.readInt();
        return lageEntry;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(IFormat.i05.format(this.strasse));
        if (this.next != null) {
            stringBuffer.append(" +");
        } else {
            stringBuffer.append(" -");
        }
        return stringBuffer.toString();
    }
}

