/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.kafplot.io.KafPlotIOConstants;
import de.geocalc.kafplot.io.xml.XmlIOProperties;
import de.geocalc.text.IFormat;
import de.geocalc.util.Comparable;
import de.geocalc.util.SortableVector;
import java.awt.Color;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;

public class Lagegenauigkeit
implements Comparable {
    public static final int KAF_UNDEF = 0;
    public static final int KAF_0003 = 1;
    public static final int KAF_0006 = 2;
    public static final int KAF_0010 = 3;
    public static final int KAF_0030 = 4;
    public static final int KAF_0060 = 5;
    public static final int KAF_0100 = 6;
    public static final int KAF_0500 = 7;
    public static final int KAF_9999 = 8;
    public static final int KAF_NUMERIC = 99;
    public static final char SY_SX = 'K';
    public static final char LSP = 'P';
    public static final char SP_ME = 'Z';
    private static final Lagegenauigkeit _LG_0003 = new Lagegenauigkeit(1, "Standardabweichung S kleiner gleich 3 cm", "S <= 3cm", 0.03, new Color(0, 180, 0));
    private static final Lagegenauigkeit _LG_0006 = new Lagegenauigkeit(2, "Standardabweichung S kleiner gleich 6 cm", "S <= 6cm", 0.06, new Color(255, 226, 0));
    private static final Lagegenauigkeit _LG_0010 = new Lagegenauigkeit(3, "Standardabweichung S kleiner gleich 10 cm", "S <= 10cm", 0.1, new Color(255, 156, 0));
    private static final Lagegenauigkeit _LG_0030 = new Lagegenauigkeit(4, "Standardabweichung S kleiner gleich 30 cm", "S <= 30cm", 0.3, new Color(255, 66, 8));
    private static final Lagegenauigkeit _LG_0060 = new Lagegenauigkeit(5, "Standardabweichung S kleiner gleich 60 cm", "S <= 60cm", 0.6, new Color(220, 9, 98));
    private static final Lagegenauigkeit _LG_0100 = new Lagegenauigkeit(6, "Standardabweichung S kleiner gleich 100 cm", "S <= 100cm", 1.0, new Color(141, 120, 195));
    private static final Lagegenauigkeit _LG_0500 = new Lagegenauigkeit(7, "Standardabweichung S kleiner gleich 500 cm", "S <= 500cm", 5.0, new Color(20, 103, 241));
    private static final Lagegenauigkeit _LG_9999 = new Lagegenauigkeit(8, "Standardabweichung S gr\u00f6\u00dfer 500 cm", "S >  500cm", 99.0, new Color(170, 120, 120));
    private static final Lagegenauigkeit _UNDEF = new Lagegenauigkeit(0, "Standardabweichung nicht zu spezifizieren", "unbekannt", 0.0, new Color(255, 255, 255));
    private static final Lagegenauigkeit _UNBEK = new Lagegenauigkeit(0, "ohne Lagegenauigkeit", "", 0.0, new Color(255, 255, 255));
    private static final Lagegenauigkeit _NUMERIC = new Lagegenauigkeit(99, "Standardabweichung aus Punktgenauigkeit", "numerisch", 0.0, new Color(255, 255, 255));
    private static final Hashtable keys = new Hashtable();
    private int lg;
    private String name;
    private String abk;
    private double grzw;
    private Color color;

    public static int AlkisToAlk(int n) {
        switch (n) {
            case 2100: {
                return 49;
            }
            case 2200: {
                return 50;
            }
            case 2300: {
                return 51;
            }
            case 3000: {
                return 55;
            }
            case 3100: {
                return 56;
            }
            case 3200: {
                return 57;
            }
            case 3300: {
                return 65;
            }
        }
        return 48;
    }

    public static boolean isValidFortfuehrung(int n, int n2) {
        if (n2 == 1) {
            return n == 49 || n == 50;
        }
        if (n2 == 2) {
            return n == 2100;
        }
        return false;
    }

    public Lagegenauigkeit() {
    }

    public Lagegenauigkeit(int n, String string, String string2, double d, Color color) {
        this.lg = n;
        this.name = string;
        this.abk = string2;
        this.grzw = d;
        this.color = color;
    }

    @Override
    public int compareTo(Object object) {
        return this.lg - ((Lagegenauigkeit)object).getValue();
    }

    public void setValue(int n) {
        this.lg = n;
    }

    public int getValue() {
        return this.lg;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Color getColor() {
        return this.color;
    }

    public String toXmlLine() {
        String[] stringArray = new String[]{XmlIOProperties.att("id", new Character((char)this.lg).toString()), XmlIOProperties.att("name", this.name)};
        return XmlIOProperties.data("lagegenauigkeit", stringArray);
    }

    public static String getItem(int n) {
        return n + "  " + Lagegenauigkeit.toString(n);
    }

    public static String toString(int n) {
        Lagegenauigkeit lagegenauigkeit = (Lagegenauigkeit)keys.get(new Integer(n));
        if (lagegenauigkeit != null) {
            return lagegenauigkeit.abk;
        }
        return "";
    }

    public static String toString(float f) {
        return "S = " + IFormat.f3_1.format(f * 100.0f) + " cm";
    }

    public static int createFromLl(float f) {
        if (f <= 0.0f) {
            return 0;
        }
        if (f <= 0.03f) {
            return 1;
        }
        if (f <= 0.06f) {
            return 2;
        }
        if (f <= 0.1f) {
            return 3;
        }
        if (f <= 0.3f) {
            return 4;
        }
        if (f <= 0.6f) {
            return 5;
        }
        if (f <= 1.0f) {
            return 6;
        }
        if (f <= 5.0f) {
            return 7;
        }
        return 8;
    }

    public static final float createLl(int n) {
        switch (n) {
            case 1: {
                return 0.03f;
            }
            case 2: {
                return 0.06f;
            }
            case 3: {
                return 0.1f;
            }
            case 4: {
                return 0.3f;
            }
            case 5: {
                return 0.6f;
            }
            case 6: {
                return 1.0f;
            }
            case 7: {
                return 5.0f;
            }
        }
        return Float.MAX_VALUE;
    }

    public static int createFromLl(float f, int n) {
        if (n == 1) {
            if (f <= 0.0f) {
                return 0;
            }
            if (f <= 0.03f) {
                return 49;
            }
            if (f <= 0.06f) {
                return 50;
            }
            if (f <= 0.1f) {
                return 51;
            }
            if (f <= 0.3f) {
                return 55;
            }
            if (f <= 0.6f) {
                return 56;
            }
            if (f <= 1.0f) {
                return 57;
            }
            if (f <= 5.0f) {
                return 65;
            }
            return 0;
        }
        if (n == 2) {
            if (f <= 0.0f) {
                return 0;
            }
            if (f <= 0.03f) {
                return 2100;
            }
            if (f <= 0.06f) {
                return 2200;
            }
            if (f <= 0.1f) {
                return 2300;
            }
            if (f <= 0.3f) {
                return 3000;
            }
            if (f <= 0.6f) {
                return 3100;
            }
            if (f <= 1.0f) {
                return 3200;
            }
            if (f <= 5.0f) {
                return 3300;
            }
            return 5000;
        }
        return 0;
    }

    public static Enumeration elements() {
        return keys.elements();
    }

    public static Enumeration sortedElements() {
        SortableVector sortableVector = new SortableVector(keys.elements());
        sortableVector.sort();
        return sortableVector.elements();
    }

    public void writeObject(DataOutput dataOutput) throws IOException {
        dataOutput.writeChar(this.lg);
        KafPlotIOConstants.writeString(dataOutput, this.name);
        KafPlotIOConstants.writeString(dataOutput, this.abk);
        dataOutput.writeFloat((float)this.grzw);
        dataOutput.writeBoolean(true);
        dataOutput.writeInt(this.color.getRGB());
    }

    public static Lagegenauigkeit readObject(DataInput dataInput) throws IOException {
        Lagegenauigkeit lagegenauigkeit = new Lagegenauigkeit();
        lagegenauigkeit.lg = dataInput.readChar();
        lagegenauigkeit.name = KafPlotIOConstants.readString(dataInput);
        lagegenauigkeit.abk = KafPlotIOConstants.readString(dataInput);
        lagegenauigkeit.grzw = dataInput.readFloat();
        dataInput.readBoolean();
        lagegenauigkeit.color = new Color(dataInput.readInt());
        return lagegenauigkeit;
    }

    public static void put(Lagegenauigkeit lagegenauigkeit) {
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Lagegenauigkeit: ");
        if (this.lg == 0) {
            stringBuffer.append("ohne");
        } else {
            stringBuffer.append(this.lg);
        }
        return stringBuffer.toString();
    }

    static {
        keys.put(new Integer(32), _UNDEF);
        keys.put(new Integer(48), _UNBEK);
        keys.put(new Integer(80), _NUMERIC);
        keys.put(new Integer(49), _LG_0003);
        keys.put(new Integer(50), _LG_0006);
        keys.put(new Integer(51), _LG_0010);
        keys.put(new Integer(55), _LG_0030);
        keys.put(new Integer(56), _LG_0060);
        keys.put(new Integer(57), _LG_0100);
        keys.put(new Integer(65), _LG_0500);
        keys.put(new Integer(2100), _LG_0003);
        keys.put(new Integer(2200), _LG_0006);
        keys.put(new Integer(2300), _LG_0010);
        keys.put(new Integer(3000), _LG_0030);
        keys.put(new Integer(3100), _LG_0060);
        keys.put(new Integer(3200), _LG_0100);
        keys.put(new Integer(3300), _LG_0500);
        keys.put(new Integer(5000), _LG_9999);
    }
}

