/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.kafplot.Koostatus;
import de.geocalc.kafplot.io.xml.XmlIOProperties;
import de.geocalc.text.IFormat;
import de.geocalc.util.Sortable;
import java.util.Enumeration;
import java.util.Vector;

public class Lagestatus
extends Koostatus
implements Sortable {
    public static final int UNDEF = 0;
    public static final int GK_V = 50;
    public static final int GK = 150;
    public static final int ETRS_V = 89;
    public static final int ETRS = 489;
    private static final String UNDEF_STRING = "unbekannt";
    private static final String GK_V_STRING = "vorl\u00e4ufige Gau\u00df-Kr\u00fcger";
    private static final String GK_STRING = "endg\u00fcltige Gau\u00df-Kr\u00fcger";
    private static final String ETRS_V_STRING = "vorl\u00e4ufige ETRS";
    private static final String ETRS_STRING = "endg\u00fcltige ETRS";
    private static final Vector arten = new Vector();
    private int ls;
    private String name;

    public Lagestatus() {
        this(0, null);
    }

    public Lagestatus(int n) {
        this(n, null);
    }

    public Lagestatus(int n, String string) {
        this.ls = n;
        this.name = string;
    }

    @Override
    public void setValue(int n) {
        this.ls = n;
    }

    @Override
    public int getValue() {
        return this.ls;
    }

    @Override
    public boolean isLt(Sortable sortable) {
        return this.ls < ((Lagestatus)sortable).ls;
    }

    public boolean equals(Object object) {
        if (object instanceof Lagestatus) {
            Lagestatus lagestatus = (Lagestatus)object;
            return this.ls == lagestatus.ls;
        }
        return false;
    }

    public String toXmlLine() {
        String[] stringArray = new String[]{XmlIOProperties.att("id", Integer.toString(this.ls)), XmlIOProperties.att("name", this.name)};
        return XmlIOProperties.data("lagestatus", stringArray);
    }

    public int hashCode() {
        return this.ls;
    }

    public static Enumeration elements() {
        return arten.elements();
    }

    public static String getItem(int n) {
        return IFormat.i03.format(n) + "  " + Lagestatus.toString(n);
    }

    static String toString(int n) {
        switch (n) {
            case 50: {
                return GK_V_STRING;
            }
            case 150: {
                return GK_STRING;
            }
            case 89: {
                return ETRS_V_STRING;
            }
            case 489: {
                return ETRS_STRING;
            }
        }
        return UNDEF_STRING;
    }

    public String toString() {
        return Lagestatus.toString(this.ls);
    }

    static {
        arten.addElement(new Lagestatus(0, UNDEF_STRING));
        arten.addElement(new Lagestatus(50, GK_V_STRING));
        arten.addElement(new Lagestatus(150, GK_STRING));
        arten.addElement(new Lagestatus(89, ETRS_V_STRING));
        arten.addElement(new Lagestatus(489, ETRS_STRING));
    }
}

