/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.DrawField;
import de.geocalc.awt.IColor;
import de.geocalc.awt.IGraphics;
import de.geocalc.awt.IViewport;
import de.geocalc.geom.DArc;
import de.geocalc.geom.DDimension;
import de.geocalc.geom.DLine;
import de.geocalc.geom.DPoint;
import de.geocalc.geom.DRectangle;
import de.geocalc.kafplot.DatObject;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.Drawable;
import de.geocalc.kafplot.Ebene;
import de.geocalc.kafplot.GeografProperties;
import de.geocalc.kafplot.Identitaet;
import de.geocalc.kafplot.IdentitaetUtil;
import de.geocalc.kafplot.KafPlotColor;
import de.geocalc.kafplot.KafPlotProperties;
import de.geocalc.kafplot.KatasterElement;
import de.geocalc.kafplot.LineDisplayProp;
import de.geocalc.kafplot.LinieForm;
import de.geocalc.kafplot.LinieParameter;
import de.geocalc.kafplot.Message;
import de.geocalc.kafplot.Messager;
import de.geocalc.kafplot.Punkt;
import de.geocalc.kafplot.PunktContainer;
import de.geocalc.kafplot.PunktMove;
import de.geocalc.kafplot.PunktNummer;
import de.geocalc.kafplot.PunktTable;
import de.geocalc.kafplot.TagObject;
import de.geocalc.kafplot.io.dat.KafkaIOProperties;
import de.geocalc.kafplot.io.kpv.KpvIOProperties;
import de.geocalc.kafplot.io.xml.XmlIOProperties;
import de.geocalc.kataster.model.Alkis;
import de.geocalc.lang.Exceptionable;
import de.geocalc.text.GeoNumberFormat;
import de.geocalc.text.IFormat;
import de.geocalc.util.sml.Tag;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class Linie
implements PunktContainer,
KatasterElement,
Cloneable,
DatObject,
Exceptionable,
Drawable,
Messager,
TagObject {
    public static final byte POLY_START = 1;
    public static final byte POLY_MITTE = 0;
    public static final byte POLY_ENDE = 9;
    public static final byte LINIE = 2;
    private static final int LS_MASK = 3;
    private static final int LS_DEL = -4;
    private static final int FLAG_LINIE = 0;
    private static final int FLAG_START = 1;
    private static final int FLAG_MITTE = 2;
    private static final int FLAG_ENDE = 3;
    private static final int FLAG_UNTERGANG = 2048;
    private static final int FLAG_ON = 4096;
    private static final int FLAG_GRDST_GRENZE = 8192;
    private static final int FLAG_NOT_GRDST_GRENZE = 16384;
    private static final int FLAG_NUTZ_GRENZE = 32768;
    private static final int FLAG_LAGE_GRENZE = 65536;
    private static final int FLAG_ADR_GRENZE = 131072;
    private static final int FLAG_ANCHOR_LINE = 262144;
    private static final int FLAG_BOK = 524288;
    private static final int FLAG_BUK = 0x100000;
    private static final int FLAG_BTK = 0x200000;
    private static final int FLAG_RADIUS_KOO = 0x400000;
    private static final int FLAG_TEMP1 = 0x40000000;
    private static final int FLAG_TEMP2 = Integer.MIN_VALUE;
    public Punkt pa;
    public Punkt pe;
    public double l2;
    private int flags;
    private String bemerkung;
    private LinieParameter param = LinieParameter.VOID;
    public static LineDisplayProp objectDisplayProp = null;
    public static LineDisplayProp displayProp = null;
    private static final double KREUZ_ABSTAND = 50.0;
    private static final double KREUZ_BREITE = 4.0;

    public Linie() {
        this(2, null, null);
    }

    public Linie(Punkt punkt, Punkt punkt2) {
        this(2, punkt, punkt2);
    }

    public Linie(int n, Punkt punkt, Punkt punkt2) {
        this.setLs(n);
        this.pa = punkt;
        this.pe = punkt2;
    }

    public Linie(int n, Punkt punkt, Punkt punkt2, double d) {
        this.setLs(n);
        this.pa = punkt;
        this.pe = punkt2;
        this.l2 = d;
    }

    public Linie(int n, int n2, int n3, Punkt punkt, Punkt punkt2) {
        this(n, n2, n3, 0, punkt, punkt2, 0.0, 0.0);
    }

    public Linie(int n, int n2, int n3, int n4, Punkt punkt, Punkt punkt2) {
        this(n, n2, n3, n4, punkt, punkt2, 0.0, 0.0);
    }

    public Linie(int n, int n2, int n3, Punkt punkt, Punkt punkt2, double d, double d2) {
        this(n, n2, n3, 0, punkt, punkt2, d, d2);
    }

    public Linie(int n, int n2, int n3, int n4, Punkt punkt, Punkt punkt2, double d, double d2) {
        LinieParameter linieParameter = new LinieParameter();
        this.setLs(n);
        linieParameter.setLa(n2);
        linieParameter.setEb(n3);
        linieParameter.setOska(n4);
        this.pa = punkt;
        this.pe = punkt2;
        this.l2 = d2;
        this.setParameter(linieParameter);
    }

    @Override
    public int getModel() {
        return 0;
    }

    public byte getLs() {
        if (this.isStart()) {
            return 1;
        }
        if (this.isMitte()) {
            return 0;
        }
        if (this.isEnde()) {
            return 9;
        }
        return 2;
    }

    public void setLs(int n) {
        if (n == 1) {
            this.setStart();
        } else if (n == 0) {
            this.setMitte();
        } else if (n == 9) {
            this.setEnde();
        } else {
            this.setLinie();
        }
    }

    public int getLa() {
        return this.param.getLa();
    }

    public int getEb() {
        return this.param.getEb();
    }

    public int getOska() {
        return this.param.getOska();
    }

    public int getFolie() {
        return this.param.getFolie();
    }

    public LinieParameter getParameter() {
        return (LinieParameter)this.param.clone();
    }

    public void setParameter(LinieParameter linieParameter) {
        this.param = LinieParameter.intern(linieParameter);
    }

    public void setDefaultParameter(LinieParameter linieParameter) {
        this.param = linieParameter;
    }

    @Override
    public final boolean hasBemerkung() {
        return this.bemerkung != null;
    }

    @Override
    public final void setBemerkung(String string) {
        this.bemerkung = string;
    }

    @Override
    public final void addBemerkung(String string) {
        this.bemerkung = this.bemerkung == null ? string : this.bemerkung + string;
    }

    @Override
    public final void addTag(String string) {
        this.bemerkung = this.bemerkung == null ? string : string + this.bemerkung;
    }

    @Override
    public final boolean hasTag(String string) {
        return this.bemerkung != null && Tag.hasTag(this.bemerkung, string);
    }

    @Override
    public final String getBemerkung() {
        return this.bemerkung;
    }

    @Override
    public final String getBemerkungText() {
        if (this.bemerkung == null) {
            return null;
        }
        if (Tag.hasTag(this.bemerkung)) {
            return Tag.parseText(this.bemerkung);
        }
        return this.bemerkung;
    }

    public Punkt getPa() {
        return this.pa;
    }

    public void setPa(Punkt punkt) {
        this.pa = punkt;
    }

    public Punkt getPe() {
        return this.pe;
    }

    public void setPe(Punkt punkt) {
        this.pe = punkt;
    }

    public void setLinie() {
        this.flags &= 0xFFFFFFFC;
        this.flags |= 0;
    }

    public boolean isLinie() {
        return (this.flags & 3) == 0;
    }

    public void setStart() {
        this.flags &= 0xFFFFFFFC;
        this.flags |= 1;
    }

    public boolean isStart() {
        return (this.flags & 3) == 1;
    }

    public void setMitte() {
        this.flags &= 0xFFFFFFFC;
        this.flags |= 2;
    }

    public boolean isMitte() {
        return (this.flags & 3) == 2;
    }

    public void setEnde() {
        this.flags &= 0xFFFFFFFC;
        this.flags |= 3;
    }

    public boolean isEnde() {
        return (this.flags & 3) == 3;
    }

    public void setUntergang(boolean bl) {
        this.flags = bl ? (this.flags |= 0x800) : (this.flags &= 0xFFFFF7FF);
    }

    public boolean isUntergang() {
        return (this.flags & 0x800) != 0;
    }

    public void setOn(boolean bl) {
        this.flags = bl ? (this.flags |= 0x1000) : (this.flags &= 0xFFFFEFFF);
    }

    @Override
    public boolean isOn() {
        return (this.flags & 0x1000) != 0;
    }

    public void setAnchorLine(boolean bl) {
        this.flags = bl ? (this.flags |= 0x40000) : (this.flags &= 0xFFFBFFFF);
    }

    public boolean isAnchorLine() {
        return (this.flags & 0x40000) != 0;
    }

    public void setGrundstuecksgrenze(boolean bl) {
        this.flags = bl ? (this.flags |= 0x2000) : (this.flags &= 0xFFFFDFFF);
    }

    public boolean isGrundstuecksgrenze() {
        return (this.flags & 0x2000) != 0;
    }

    public void setNotGrundstuecksgrenze(boolean bl) {
        this.flags = bl ? (this.flags |= 0x4000) : (this.flags &= 0xFFFFBFFF);
    }

    public boolean isNotGrundstuecksgrenze() {
        return (this.flags & 0x4000) != 0;
    }

    public void setNutzunggrenze(boolean bl) {
        this.flags = bl ? (this.flags |= 0x8000) : (this.flags &= 0xFFFF7FFF);
    }

    public boolean isNutzunggrenze() {
        return (this.flags & 0x8000) != 0;
    }

    public void setLagegrenze(boolean bl) {
        this.flags = bl ? (this.flags |= 0x10000) : (this.flags &= 0xFFFEFFFF);
    }

    public boolean isLagegrenze() {
        return (this.flags & 0x10000) != 0;
    }

    public void setAdressegrenze(boolean bl) {
        this.flags = bl ? (this.flags |= 0x20000) : (this.flags &= 0xFFFDFFFF);
    }

    public boolean isAdressegrenze() {
        return (this.flags & 0x20000) != 0;
    }

    public void setRadiusKoo(boolean bl) {
        this.flags = bl ? (this.flags |= 0x400000) : (this.flags &= 0xFFBFFFFF);
    }

    public boolean isRadiusKoo() {
        return (this.flags & 0x400000) != 0;
    }

    public void setBOK(boolean bl) {
        this.flags = bl ? (this.flags |= 0x80000) : (this.flags &= 0xFFF7FFFF);
    }

    public boolean isBOK() {
        return (this.flags & 0x80000) != 0;
    }

    public void setBUK(boolean bl) {
        this.flags = bl ? (this.flags |= 0x100000) : (this.flags &= 0xFFEFFFFF);
    }

    public boolean isBUK() {
        return (this.flags & 0x100000) != 0;
    }

    public void setBTK(boolean bl) {
        this.flags = bl ? (this.flags |= 0x200000) : (this.flags &= 0xFFDFFFFF);
    }

    public boolean isBTK() {
        return (this.flags & 0x200000) != 0;
    }

    public void setTempFlag1(boolean bl) {
        this.flags = bl ? (this.flags |= 0x40000000) : (this.flags &= 0xBFFFFFFF);
    }

    public boolean isTempFlag1() {
        return (this.flags & 0x40000000) != 0;
    }

    public void setTempFlag2(boolean bl) {
        this.flags = bl ? (this.flags |= Integer.MIN_VALUE) : (this.flags &= Integer.MAX_VALUE);
    }

    public boolean isTempFlag2() {
        return (this.flags & Integer.MIN_VALUE) != 0;
    }

    public final Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public final Linie skip() {
        Punkt punkt = this.pe;
        this.pe = this.pa;
        this.pa = punkt;
        if (this.l2 != 0.0) {
            this.l2 = -this.l2;
        }
        return this;
    }

    public int getArt() {
        return this.getLa();
    }

    public int getEbene() {
        return this.getEb();
    }

    public void getParameter(Linie linie) {
        this.param = linie.param;
    }

    public Object getHashKey() {
        return new HashKey(this, this);
    }

    public Object getArtHashKey() {
        return new ArtHashKey(this, this);
    }

    public Object getArtEbeneHashKey() {
        return new ArtEbeneHashKey(this, this);
    }

    public Object getArtEbeneOskaHashKey() {
        return new ArtEbeneOskaHashKey(this, this);
    }

    public boolean isBogen() {
        return this.l2 != 0.0;
    }

    public void setRadius(double d) {
        this.l2 = d;
    }

    public double getRadius() {
        return this.l2;
    }

    public double getKooRadius() {
        return this.l2 / DataBase.getStreckeMasstab((this.pa.y + this.pe.y) / 2.0);
    }

    public double getPfeilHoehe() {
        return this.getRadius() - Math.sqrt(this.getRadius() * this.getRadius() - this.getLaenge() * this.getLaenge() / 4.0) * (this.l2 > 0.0 ? 1.0 : -1.0);
    }

    public double getBogenLaenge() {
        return this.getRadius() * this.getZentriWinkel();
    }

    public double getZentriWinkel() {
        return 2.0 * Math.asin(this.getLaenge() / 2.0 / this.getRadius());
    }

    public double getBogenFlaeche() {
        if (this.pa == this.pe) {
            return this.getRadius() * this.getRadius() * Math.PI;
        }
        double d = this.getZentriWinkel();
        return this.l2 * this.l2 * (d - Math.sin(d)) / 2.0 / DataBase.getFlaecheMasstab((this.pa.y + this.pe.y) / 2.0);
    }

    public double getLaenge() {
        if (this.pa == null || this.pe == null) {
            return 0.0;
        }
        return Math.sqrt(this.getS2()) * DataBase.getStreckeMasstab((this.pa.y + this.pe.y) / 2.0);
    }

    protected double getS2() {
        if (this.pe == null) {
            return 0.0;
        }
        return (this.pe.x - this.pa.x) * (this.pe.x - this.pa.x) + (this.pe.y - this.pa.y) * (this.pe.y - this.pa.y);
    }

    protected double getS() {
        if (this.pe == null) {
            return 0.0;
        }
        return Math.sqrt((this.pe.x - this.pa.x) * (this.pe.x - this.pa.x) + (this.pe.y - this.pa.y) * (this.pe.y - this.pa.y));
    }

    public int hashCode() {
        return Double.hashCode(this.pa.x + this.pa.y + (this.pe != null ? this.pe.x + this.pe.y : 0.0));
    }

    public boolean equals(Object object) {
        if (!(object instanceof Linie)) {
            return false;
        }
        Linie linie = (Linie)object;
        return (linie.pa == this.pa && linie.pe == this.pe && linie.l2 == this.l2 || linie.pe == this.pa && linie.pa == this.pe && linie.l2 == -this.l2) && linie.getLa() == this.getLa();
    }

    public boolean equalsIgnoreArt(Linie linie) {
        return linie.pa == this.pa && linie.pe == this.pe && linie.l2 == this.l2 || linie.pe == this.pa && linie.pa == this.pe && linie.l2 == -this.l2;
    }

    public boolean equalsParameter(Linie linie) {
        return this.param.equals(linie.getParameter());
    }

    public double getRichtung() {
        return Math.atan2(this.pe.y - this.pa.y, this.pe.x - this.pa.x);
    }

    public double getRichtungVonPunkt(Punkt punkt) {
        double d = this.getRichtung();
        if (punkt != this.pa) {
            d += d < 0.0 ? Math.PI : -Math.PI;
        }
        return d;
    }

    public double getDistance(DPoint dPoint) {
        if (this.pa == null || this.pe == null) {
            return Double.NaN;
        }
        double d = Math.atan2(this.pe.y - this.pa.y, this.pe.x - this.pa.x);
        return -Math.sin(d) * (dPoint.x - this.pa.x) + Math.cos(d) * (dPoint.y - this.pa.y);
    }

    public double getInnerDistance(DPoint dPoint) {
        if (this.pa == null || this.pe == null) {
            return Double.NaN;
        }
        double d = Math.atan2(this.pe.y - this.pa.y, this.pe.x - this.pa.x);
        double d2 = -Math.sin(d);
        double d3 = Math.cos(d);
        double d4 = d3 * (dPoint.x - this.pa.x) - d2 * (dPoint.y - this.pa.y);
        if (d4 < 0.0 || d4 * d4 > this.getS2()) {
            return Double.NaN;
        }
        return d2 * (dPoint.x - this.pa.x) + d3 * (dPoint.y - this.pa.y);
    }

    public double getOuterDistance(DPoint dPoint) {
        if (this.pa == null || this.pe == null) {
            return Double.NaN;
        }
        double d = Math.atan2(this.pe.y - this.pa.y, this.pe.x - this.pa.x);
        double d2 = -Math.sin(d);
        double d3 = Math.cos(d);
        double d4 = d3 * (dPoint.x - this.pa.x) - d2 * (dPoint.y - this.pa.y);
        if (d4 < 0.0) {
            return this.pa.getDistance(dPoint);
        }
        if (d4 * d4 > this.getS2()) {
            return this.pe.getDistance(dPoint);
        }
        return d2 * (dPoint.x - this.pa.x) + d3 * (dPoint.y - this.pa.y);
    }

    @Override
    public boolean contains(Punkt punkt) {
        return this.pa.nr == punkt.nr || this.pe != null && this.pe.nr == punkt.nr;
    }

    @Override
    public PunktTable getPunkte() {
        PunktTable punktTable = new PunktTable();
        if (this.pa != null) {
            punktTable.put(this.pa);
        }
        if (this.pe != null) {
            punktTable.put(this.pe);
        }
        return punktTable;
    }

    public boolean isFlurstuecksLinie(boolean bl) {
        switch (this.getEb()) {
            case 0: {
                if (this.getLa() != 0) break;
                return true;
            }
            case 1: 
            case 41: 
            case 48: 
            case 49: {
                if (this.getLa() != 2) break;
                return true;
            }
            case 47: {
                if (!bl || this.getLa() != 4) break;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isKatasterElement() {
        switch (this.getEb()) {
            case 1: 
            case 2: 
            case 41: 
            case 42: 
            case 47: 
            case 48: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isKatasterNachweisElement() {
        return this.getLa() == 2 && (this.getEb() == 1 || this.getEb() == 48 || this.getEb() == 41);
    }

    @Override
    public boolean isKatasterNeuElement() {
        return this.getLa() == 2 && this.getEb() == 48;
    }

    @Override
    public DatObject createKatasterElement() {
        Linie linie = (Linie)this.clone();
        switch (linie.getEb()) {
            case 41: 
            case 48: {
                LinieParameter linieParameter = linie.getParameter();
                linieParameter.setEb(1);
                linie.setParameter(linieParameter);
                break;
            }
            case 42: {
                LinieParameter linieParameter = linie.getParameter();
                linieParameter.setEb(2);
                linie.setParameter(linieParameter);
                break;
            }
        }
        return linie;
    }

    @Override
    public Message getMessage() {
        String string = this.getExceptionableName();
        StringBuffer stringBuffer = new StringBuffer(string);
        if (this.l2 != 0.0) {
            stringBuffer.append("  R=");
            stringBuffer.append(IFormat.f_3.format(this.getRadius()).toString());
        }
        StringBuffer stringBuffer2 = new StringBuffer(string);
        stringBuffer2.append("  A=");
        stringBuffer2.append(IFormat.i.format(this.getLa()).toString());
        stringBuffer2.append("  Eb=");
        stringBuffer2.append(IFormat.i.format(this.getEb()).toString());
        stringBuffer2.append("  Os=");
        stringBuffer2.append(IFormat.i04.format(this.getOska()).toString());
        if (this.l2 != 0.0) {
            stringBuffer2.append("  R=");
            stringBuffer2.append(IFormat.f_3.format(this.l2).toString());
            stringBuffer2.append("  L=");
            stringBuffer2.append(IFormat.f_3.format(this.getBogenLaenge()).toString());
        } else {
            stringBuffer2.append("  L=");
            stringBuffer2.append(IFormat.f_3.format(this.getLaenge()).toString());
        }
        return new Message(this, stringBuffer.toString(), stringBuffer2.toString());
    }

    @Override
    public String getClassName() {
        return "Linie";
    }

    @Override
    public String getObjectName() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(IFormat.i.format(this.pa.nr).toString());
        if (this.pe != null) {
            stringBuffer.append("-");
            stringBuffer.append(IFormat.i.format(this.pe.nr).toString());
        }
        return stringBuffer.toString();
    }

    @Override
    public String getExceptionableName() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClassName());
        stringBuffer.append(": ");
        stringBuffer.append(this.getObjectName());
        return stringBuffer.toString();
    }

    @Override
    public String toDebugString() {
        return this.getExceptionableName();
    }

    public String toGeografLine(int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(GeoNumberFormat.nr04.format(n).toString());
        stringBuffer.append(GeoNumberFormat.nr04n.format(n2).toString());
        stringBuffer.append(" (  ");
        if (this.isBogen()) {
            stringBuffer.append(GeoNumberFormat.getRightString(GeografProperties.getPunktNummer(this.l2 > 0.0 ? this.pa : this.pe), 15));
            stringBuffer.append(" R    ");
            stringBuffer.append(GeoNumberFormat.m43.format(Math.abs(this.l2) / DataBase.getStreckeMasstab((this.pa.y + this.pe.y) / 2.0)).toString());
            stringBuffer.append("    ");
            stringBuffer.append(GeoNumberFormat.getRightString(GeografProperties.getPunktNummer(this.l2 > 0.0 ? this.pe : this.pa), 15));
        } else {
            stringBuffer.append(GeoNumberFormat.getRightString(GeografProperties.getPunktNummer(this.pa), 15));
            stringBuffer.append("  ");
            stringBuffer.append(GeoNumberFormat.getRightString(GeografProperties.getPunktNummer(this.pe), 15));
        }
        stringBuffer.append(" ");
        stringBuffer.append(" )");
        return stringBuffer.toString();
    }

    public String toGeografOutLine(int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer("LI" + n + ": ");
        if (this.isBogen()) {
            stringBuffer.append(GeografProperties.getPunktNummer(this.l2 > 0.0 ? this.pa : this.pe));
            stringBuffer.append(",");
            stringBuffer.append(GeografProperties.getPunktNummer(this.l2 > 0.0 ? this.pe : this.pa));
        } else {
            stringBuffer.append(GeografProperties.getPunktNummer(this.pa));
            stringBuffer.append(",");
            stringBuffer.append(GeografProperties.getPunktNummer(this.pe));
        }
        stringBuffer.append(",");
        stringBuffer.append(GeoNumberFormat.nr.format(n2));
        stringBuffer.append(",");
        stringBuffer.append(GeoNumberFormat.koo04.format(Math.abs(this.l2) / DataBase.getStreckeMasstab((this.pa.y + this.pe.y) / 2.0)).toString());
        stringBuffer.append(",");
        stringBuffer.append(GeoNumberFormat.koo04.format(0.0).toString());
        stringBuffer.append(",");
        stringBuffer.append(GeoNumberFormat.koo04.format(0.0).toString());
        stringBuffer.append(",");
        stringBuffer.append("0,0,0.0000,,0.000");
        return stringBuffer.toString();
    }

    @Override
    public String toDatLine() {
        if (KafkaIOProperties.datVersion >= 2) {
            Punkt punkt;
            IdentitaetUtil identitaetUtil;
            String string = this.bemerkung;
            StringBuffer stringBuffer = new StringBuffer(70);
            stringBuffer.append(IFormat.i1.format(this.getLs()));
            stringBuffer.append("  ");
            if (this.pa != null) {
                identitaetUtil = new IdentitaetUtil(this.pa, string, 1, !KafkaIOProperties.writeOffline);
                punkt = identitaetUtil.getPunkt();
                string = identitaetUtil.getBem();
                stringBuffer.append(IFormat.i14.format(punkt.buildKatNr(KafkaIOProperties.pnrModus, KafkaIOProperties.writeUmnum ? punkt.getNr() : punkt.nr)));
            } else {
                stringBuffer.append("              ");
            }
            stringBuffer.append(" ");
            if (this.isLinie() && this.pe != null) {
                identitaetUtil = new IdentitaetUtil(this.pe, string, 2, !KafkaIOProperties.writeOffline);
                punkt = identitaetUtil.getPunkt();
                string = identitaetUtil.getBem();
                stringBuffer.append(IFormat.i14.format(punkt.buildKatNr(KafkaIOProperties.pnrModus, KafkaIOProperties.writeUmnum ? punkt.getNr() : punkt.nr)));
            } else {
                stringBuffer.append("              ");
                if (string != null && Tag.hasTag(string, "PI2")) {
                    string = Tag.removeTag(string, "PI2");
                }
            }
            stringBuffer.append("           ");
            stringBuffer.append(this.isBogen() ? IFormat.f6_3.format(this.l2) : "          ");
            if (DataBase.model.getModel() == 2) {
                stringBuffer.append("  ");
                if (this.isBOK()) {
                    stringBuffer.append("BOK");
                } else if (this.isBUK()) {
                    stringBuffer.append("BUK");
                }
            } else {
                stringBuffer.append("  ");
                stringBuffer.append(this.getLa() >= 0 ? IFormat.i1.format(this.getLa()) : " ");
                stringBuffer.append(" ");
                int n = KafkaIOProperties.changeKat ? Ebene.getChangeKatEbene(this.getEb()) : this.getEb();
                stringBuffer.append(n >= 0 ? IFormat.i02.format(n) : "  ");
                stringBuffer.append(" ");
                stringBuffer.append(this.getOska() >= 0 ? IFormat.i04.format(this.getOska()) : "    ");
            }
            if (string != null) {
                stringBuffer.append(IFormat.getSpaces(100 - stringBuffer.length()));
                stringBuffer.append(string);
            }
            return stringBuffer.toString();
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getLs());
        stringBuffer.append(" ");
        stringBuffer.append(GeoNumberFormat.nr13.format(this.pa.nr).toString());
        stringBuffer.append(" ");
        if (this.isLinie()) {
            stringBuffer.append(GeoNumberFormat.nr13.format(this.pe.nr).toString());
        } else {
            stringBuffer.append("             ");
        }
        stringBuffer.append("             ");
        if (this.isBogen()) {
            stringBuffer.append(GeoNumberFormat.m52.format(this.l2).toString());
        } else {
            stringBuffer.append("        ");
        }
        stringBuffer.append(" ");
        if (this.getLa() >= 0) {
            stringBuffer.append(GeoNumberFormat.nr02.format(this.getLa()).toString());
        } else {
            stringBuffer.append("  ");
        }
        stringBuffer.append("  ");
        if (this.getEb() >= 0) {
            stringBuffer.append(GeoNumberFormat.nr02.format(this.getEb()).toString());
        } else {
            stringBuffer.append("  ");
        }
        stringBuffer.append("  ");
        if (this.getOska() > 0) {
            stringBuffer.append(GeoNumberFormat.nr04.format(this.getOska()).toString());
        }
        return stringBuffer.toString();
    }

    public String toXmlLine() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(XmlIOProperties.openln("linie"));
        if (this.pa != null && this.pa.nr != 0L) {
            stringBuffer.append(XmlIOProperties.dataln("nr1", Long.toString(this.pa.nr)));
        }
        if (this.pe != null && this.pe.nr != 0L) {
            stringBuffer.append(XmlIOProperties.dataln("nr2", Long.toString(this.pe.nr)));
        }
        stringBuffer.append(XmlIOProperties.dataln("lf", Integer.toString(this.getLs())));
        stringBuffer.append(XmlIOProperties.dataln("la", Integer.toString(this.getLa())));
        stringBuffer.append(XmlIOProperties.dataln("eb", Integer.toString(this.getEb())));
        stringBuffer.append(XmlIOProperties.dataln("os", IFormat.i04.format(this.getOska()).toString()));
        if (this.l2 != 0.0) {
            stringBuffer.append(XmlIOProperties.dataln("l2", IFormat.f_3.format(this.l2).toString()));
        }
        stringBuffer.append(XmlIOProperties.close("linie"));
        return stringBuffer.toString();
    }

    public void writeObject(DataOutput dataOutput) throws IOException {
        dataOutput.writeByte(15);
        dataOutput.writeShort(KpvIOProperties.getLinieParameterId(this.getParameter()));
        dataOutput.writeInt(this.flags);
        PunktNummer.writeObject(this.pa != null ? this.pa.nr : 0L, dataOutput);
        PunktNummer.writeObject(this.pe != null ? this.pe.nr : 0L, dataOutput);
        if (this.l2 != 0.0) {
            dataOutput.writeByte(7);
            dataOutput.writeFloat((float)this.l2);
        } else {
            dataOutput.writeByte(0);
        }
    }

    public static Linie readObject(DataInput dataInput) throws IOException {
        int n;
        Linie linie = new Linie();
        int n2 = n = KpvIOProperties.RVER < 204 ? dataInput.readByte() / 10 : 0;
        if (KpvIOProperties.RVER < 110) {
            LinieParameter linieParameter = new LinieParameter();
            linieParameter.setLa(dataInput.readByte());
            linieParameter.setEb(dataInput.readByte());
            linieParameter.setFolie(dataInput.readShort());
            linieParameter.setOska(dataInput.readShort());
            linie.setParameter(linieParameter);
        } else {
            linie.setParameter(KpvIOProperties.getLinieParameterVal(dataInput.readShort()));
        }
        linie.flags = dataInput.readInt();
        linie.pa = new Punkt(PunktNummer.readObject(dataInput));
        linie.pe = new Punkt(PunktNummer.readObject(dataInput));
        if (dataInput.readByte() != 0) {
            linie.l2 = dataInput.readFloat();
        }
        if (KpvIOProperties.RVER < 204) {
            linie.setLs(n);
        }
        return linie;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getLs());
        stringBuffer.append(" ");
        if (this.pa != null) {
            stringBuffer.append(GeoNumberFormat.nr.format(this.pa.nr).toString());
            stringBuffer.append(" ");
        }
        if (this.pe != null) {
            stringBuffer.append("- ");
            stringBuffer.append(GeoNumberFormat.nr.format(this.pe.nr).toString());
            stringBuffer.append(" ");
        }
        if (this.isBogen()) {
            stringBuffer.append("R=");
            stringBuffer.append(GeoNumberFormat.m43.format(this.l2).toString());
            stringBuffer.append(" ");
        }
        stringBuffer.append("A=");
        stringBuffer.append(GeoNumberFormat.nr.format(this.getLa()).toString());
        stringBuffer.append(" EB=");
        stringBuffer.append(GeoNumberFormat.nr.format(this.getEb()).toString());
        stringBuffer.append(" OS=");
        stringBuffer.append(GeoNumberFormat.nr.format(this.getOska()).toString());
        return stringBuffer.toString();
    }

    @Override
    public DRectangle getBounds() {
        if (this.pe == null) {
            return new DRectangle(this.pa.y, this.pa.x, 0.0, 0.0);
        }
        double d = Math.min(this.pa.y, this.pe.y);
        double d2 = Math.min(this.pa.x, this.pe.x);
        double d3 = Math.max(this.pa.y, this.pe.y);
        double d4 = Math.max(this.pa.x, this.pe.x);
        if (this.isBogen()) {
            if (this.pa == this.pe) {
                double d5 = Math.abs(this.l2);
                d = this.pa.y - d5;
                d3 = this.pa.y + d5;
                d2 = this.pa.x - d5;
                d4 = this.pa.x + d5;
            } else {
                double d6;
                DPoint dPoint = DArc.getCenter(this.pa.y, this.pa.x, this.pe.y, this.pe.x, this.l2);
                double d7 = this.l2 > 0.0 ? Math.atan2(this.pa.y - dPoint.y, this.pa.x - dPoint.x) : Math.atan2(this.pe.y - dPoint.y, this.pe.x - dPoint.x);
                double d8 = d6 = this.l2 > 0.0 ? Math.atan2(this.pe.y - dPoint.y, this.pe.x - dPoint.x) : Math.atan2(this.pa.y - dPoint.y, this.pa.x - dPoint.x);
                if (DArc.containsAngle(0.0, d7, d6)) {
                    d4 = dPoint.x + Math.abs(this.l2);
                }
                if (DArc.containsAngle(1.5707963267948966, d7, d6)) {
                    d3 = dPoint.y + Math.abs(this.l2);
                }
                if (DArc.containsAngle(Math.PI, d7, d6)) {
                    d2 = dPoint.x - Math.abs(this.l2);
                }
                if (DArc.containsAngle(-1.5707963267948966, d7, d6)) {
                    d = dPoint.y - Math.abs(this.l2);
                }
            }
        }
        return new DRectangle(d, d2, d3 - d, d4 - d2);
    }

    @Override
    public DDimension getSize() {
        DRectangle dRectangle = this.getBounds();
        return new DDimension(dRectangle.width, dRectangle.height);
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    @Override
    public boolean isViewable(IViewport iViewport) {
        return iViewport.intersects(this.getBounds());
    }

    @Override
    public DPoint getHashPoint() {
        if (this.pa != null && this.pe != null) {
            if (this.isBogen()) {
                DPoint dPoint = DArc.getCenter(this.pa.y, this.pa.x, this.pe.y, this.pe.x, this.l2);
                double d = Math.abs(this.l2);
                double d2 = Math.atan2(this.pa.y - dPoint.y, this.pa.x - dPoint.x);
                double d3 = Math.atan2(this.pe.y - dPoint.y, this.pe.x - dPoint.x);
                double d4 = (d2 + d3) / 2.0;
                if (d3 - d2 > Math.PI || d3 - d2 < -Math.PI) {
                    d4 += Math.PI;
                }
                return new DPoint(dPoint.y + Math.sin(d4) * d, dPoint.x + Math.cos(d4) * d);
            }
            return DPoint.getMiddle(this.pa, this.pe);
        }
        if (this.pa != null) {
            return this.pa;
        }
        if (this.pe != null) {
            return this.pe;
        }
        return null;
    }

    @Override
    public void drawObject(IGraphics iGraphics, boolean bl, boolean bl2) {
        if (this.isAnchorLine()) {
            return;
        }
        if (!this.isViewable(iGraphics.getViewport())) {
            return;
        }
        this.drawForeground(iGraphics, bl, bl2);
        if (bl2) {
            if (this.pa != null) {
                this.pa.drawObject(iGraphics, KafPlotProperties.isPunktArtVisible, bl2);
            }
            if (this.pe != null) {
                this.pe.drawObject(iGraphics, KafPlotProperties.isPunktArtVisible, bl2);
            }
        }
    }

    @Override
    public void drawBackground(IGraphics iGraphics, boolean bl, boolean bl2) {
    }

    @Override
    public void drawForeground(IGraphics iGraphics, boolean bl, boolean bl2) {
        DPoint dPoint;
        Object object;
        if (this.isAnchorLine()) {
            return;
        }
        if (this.pe == null) {
            return;
        }
        Graphics graphics = iGraphics.getGraphics();
        Color color = null;
        Color color2 = null;
        if (!(KafPlotProperties.isFlaechePolyPointsVisible || this.pa.isVisible() && this.pe.isVisible())) {
            return;
        }
        int n = KafPlotProperties.getColorSwitch();
        int n2 = this.getLa();
        if (bl2) {
            graphics.setColor(Color.white);
            graphics.setXORMode(Color.magenta);
        } else {
            graphics.setPaintMode();
            if (n2 == 3) {
                if (n == 1001) {
                    color = Ebene.getColor(this.getEb());
                } else if (n == 1004) {
                    color = this.getEb() == 42 ? IColor.getDarker(KafPlotProperties.aFoColor.getColor("G2"), 0.9f) : IColor.getDarker(KafPlotProperties.aFoColor.getColor("G1"), 0.5f);
                    color2 = IColor.getDarker(KafPlotProperties.aFoColor.getColor("G0"), 0.85f);
                } else {
                    color = n == 1006 ? (DataBase.model.getModel() == 2 ? Color.black : (this.getFolie() == 0 || this.getFolie() == 11 ? Color.black : Color.gray)) : Color.black;
                }
                if (objectDisplayProp != null) {
                    displayProp = objectDisplayProp;
                }
            } else if (n2 == 2) {
                if (n == 1004) {
                    color = Ebene.getColor(this.getEb());
                    color2 = IColor.getDarker(KafPlotProperties.aFoColor.getColor("F0"), 0.85f);
                } else {
                    color = Ebene.getColor(this.getEb());
                }
            } else if (n2 == 5) {
                color = this.getEb() == 61 ? (n == 1012 || n == 1013 || n == 1014 ? Alkis.COLOR_BODEN_GREEN.darker() : Alkis.COLOR_BODEN_GREEN) : (n == 1012 || n == 1013 || n == 1014 ? Color.black : KafPlotColor.NUTZUNG_FG);
                if (n == 1004) {
                    color2 = IColor.getDarker(KafPlotProperties.aBgColor.getColor("T"), 0.85f);
                }
            } else if (n == 1004) {
                color = Color.black;
                color2 = IColor.getDarker(KafPlotProperties.aBgColor.getColor("T"), 0.85f);
            } else if (DataBase.model.getModel() == 2) {
                color = objectDisplayProp != null ? objectDisplayProp.getColor() : (n == 1001 ? KafPlotColor.TOP_FG : (n == 1006 && this.getEb() == 5 ? Ebene.getColor(this.getEb()) : Color.black));
            } else {
                object = LineDisplayProp.getLineProp(this.getOska());
                displayProp = object != null ? object : objectDisplayProp;
                color = displayProp != null ? displayProp.getColor() : Ebene.getColor(this.getEb());
            }
        }
        if (KafPlotProperties.isInputShadowVisible()) {
            if (n == 1009) {
                if (this.pa.isMoved() || this.pe.isMoved()) {
                    color = KafPlotProperties.aBgColor.getColor("N");
                    graphics.setColor(KafPlotProperties.aBgColor.getColor("A"));
                } else {
                    color = KafPlotProperties.aBgColor.getColor("U");
                }
            } else {
                graphics.setColor(Color.lightGray);
            }
            if (this.pa.isMoved() || this.pe.isMoved()) {
                object = this.getOriginal(this.pa, 1);
                dPoint = this.getOriginal(this.pe, 2);
                if (n == 1009) {
                    this.drawLinie(iGraphics, (DPoint)object, dPoint, false, false);
                } else {
                    this.drawLinie(iGraphics, (DPoint)object, dPoint, bl, false);
                }
            }
        }
        graphics.setColor(color);
        object = KafPlotProperties.isPunktMoveStrukturVisible ? this.getMoveKoo(this.pa) : this.pa;
        DPoint dPoint2 = dPoint = KafPlotProperties.isPunktMoveStrukturVisible ? this.getMoveKoo(this.pe) : this.pe;
        if (KafPlotProperties.isLineOfPointColorize) {
            Color color3 = this.pa.getBackgroundColor();
            Color color4 = this.pe.getBackgroundColor();
            if (color3.equals(Color.white)) {
                Color color5 = color3 = KafPlotProperties.isOldAttPointColorize && this.pa.isKatasterNeupunkt() && !this.pe.isKatasterNeupunkt() ? color4 : KafPlotColor.OFFLINE_BG;
            }
            if (color4.equals(Color.white)) {
                Color color6 = color4 = KafPlotProperties.isOldAttPointColorize && this.pe.isKatasterNeupunkt() && !this.pa.isKatasterNeupunkt() ? color3 : KafPlotColor.OFFLINE_BG;
            }
            if (n == 1004) {
                if (!this.pa.isFortfuehrung()) {
                    color3 = color2;
                }
                if (!this.pe.isFortfuehrung()) {
                    color4 = color2;
                }
            }
            if (color3.equals(color4)) {
                graphics.setColor(color3);
                this.drawLinie(iGraphics, this.pa, this.pe, bl, bl2);
            } else {
                DPoint dPoint3 = this.getHashPoint();
                graphics.setColor(color3);
                this.drawLinie(iGraphics, (DPoint)object, dPoint3, bl, bl2);
                graphics.setColor(color4);
                this.drawLinie(iGraphics, dPoint3, dPoint, bl, bl2);
            }
        } else if (n == 1004) {
            boolean bl3;
            boolean bl4 = this.pa.isFortfuehrung();
            if (bl4 == (bl3 = this.pe.isFortfuehrung())) {
                if (!bl4) {
                    graphics.setColor(color2);
                }
                this.drawLinie(iGraphics, (DPoint)object, dPoint, bl, bl2);
            } else {
                DPoint dPoint4 = this.getHashPoint();
                this.drawLinie(iGraphics, (DPoint)(bl4 ? object : dPoint4), bl4 ? dPoint4 : dPoint, bl, bl2);
                graphics.setColor(color2);
                this.drawLinie(iGraphics, (DPoint)(bl4 ? dPoint4 : object), bl4 ? dPoint : dPoint4, bl, bl2);
            }
        } else if (n == 1009 && !KafPlotProperties.isInputShadowVisible()) {
            if (this.pa.isMoved() || this.pe.isMoved()) {
                graphics.setColor(KafPlotProperties.aBgColor.getColor("N"));
                this.drawLinie(iGraphics, this.pa, this.pe, bl, bl2);
            } else {
                boolean bl5;
                boolean bl6 = this.pa.isOn();
                if (bl6 == (bl5 = this.pe.isOn())) {
                    graphics.setColor(KafPlotProperties.aBgColor.getColor(bl6 ? "A" : "U"));
                    this.drawLinie(iGraphics, this.pa, this.pe, bl, bl2);
                } else {
                    DPoint dPoint5 = this.getHashPoint();
                    graphics.setColor(KafPlotProperties.aBgColor.getColor("A"));
                    this.drawLinie(iGraphics, (DPoint)(bl6 ? object : dPoint5), bl6 ? dPoint5 : dPoint, bl, bl2);
                    graphics.setColor(KafPlotProperties.aBgColor.getColor("U"));
                    this.drawLinie(iGraphics, (DPoint)(bl6 ? dPoint5 : object), bl6 ? dPoint : dPoint5, bl, bl2);
                }
            }
        } else {
            this.drawLinie(iGraphics, this.pa, this.pe, bl, bl2);
        }
        displayProp = null;
    }

    private DPoint getMoveKoo(Punkt punkt) {
        PunktMove punktMove = (PunktMove)DataBase.PM.get(punkt.nr);
        if (punktMove != null && punktMove.getOperation() == 1) {
            return new DPoint(punkt.y + (double)punktMove.getMoveY(), punkt.x + (double)punktMove.getMoveX());
        }
        Identitaet identitaet = (Identitaet)DataBase.PI.get(punkt.nr);
        if (identitaet != null && identitaet.getOperation() == 1) {
            return identitaet.getP2();
        }
        return punkt;
    }

    private void drawLinie(IGraphics iGraphics, DPoint dPoint, DPoint dPoint2, boolean bl, boolean bl2) {
        Graphics graphics = iGraphics.getGraphics();
        if (this.isBogen()) {
            if (!iGraphics.intersects(this.getBounds())) {
                return;
            }
            Polygon polygon = this.printSkip() ? iGraphics.getGraphicBogenPolygon(dPoint2, dPoint, -this.l2) : iGraphics.getGraphicBogenPolygon(dPoint, dPoint2, this.l2);
            if (bl) {
                this.drawPatternPolyLine(iGraphics, polygon.xpoints, polygon.ypoints, polygon.npoints, this.param, bl2);
            } else if (bl2) {
                this.drawPatternPolyLine(iGraphics, polygon.xpoints, polygon.ypoints, polygon.npoints, LinieParameter.VOID, bl2);
            } else {
                graphics.drawPolyline(polygon.xpoints, polygon.ypoints, polygon.npoints);
            }
            if (this.isUntergang()) {
                this.drawUntergangPolyLine(graphics, polygon.xpoints, polygon.ypoints, polygon.npoints);
            }
        } else {
            DLine dLine = iGraphics.getViewport().intersectLine(dPoint.y, dPoint.x, dPoint2.y, dPoint2.x);
            if (dLine == null) {
                return;
            }
            Point point = new Point();
            Point point2 = new Point();
            point = iGraphics.getGraphicPoint(dLine.getP1(), point);
            point2 = iGraphics.getGraphicPoint(dLine.getP2(), point2);
            if (bl) {
                this.drawPatternLine(iGraphics, point.x, point.y, point2.x, point2.y, this.param, bl2);
            } else if (bl2) {
                this.drawPatternLine(iGraphics, point.x, point.y, point2.x, point2.y, LinieParameter.VOID, bl2);
            } else {
                graphics.drawLine(point.x, point.y, point2.x, point2.y);
            }
            if (this.isUntergang()) {
                if (this.printSkip()) {
                    this.drawUntergangLine(graphics, point2.x, point2.y, point.x, point.y);
                } else {
                    this.drawUntergangLine(graphics, point.x, point.y, point2.x, point2.y);
                }
            }
        }
    }

    private DPoint getOriginal(Punkt punkt, int n) {
        if (DataBase.PM.get(punkt.nr) != null) {
            PunktMove punktMove = (PunktMove)DataBase.PM.get(punkt.nr);
            if (punktMove.getOperation() != 1) {
                return new DPoint(punkt.y + (double)punktMove.getMoveY(), punkt.x + (double)punktMove.getMoveX());
            }
        } else {
            String string = n == 2 ? "PI2" : "PI1";
            try {
                long l;
                Punkt punkt2;
                if (this.hasTag(string) && (punkt2 = (Punkt)DataBase.P.get(l = Long.parseLong(Tag.parseTag(this.bemerkung, string).getValue()))) != null) {
                    return punkt2;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return punkt.getDisplayOriginal();
    }

    @Override
    public void drawInscription(IGraphics iGraphics, boolean bl, boolean bl2) {
    }

    public void drawSymbol(IGraphics iGraphics, DrawField drawField, boolean bl) {
        Point point = new Point();
        Point point2 = new Point();
        if (this.isEnde()) {
            return;
        }
        drawField.setFill((byte)10);
        if (this.isBogen()) {
            Polygon polygon = iGraphics.getGraphicBogenPolygon(this.pa, this.pe, this.l2);
            drawField.drawPolyline(polygon.xpoints, polygon.ypoints, polygon.npoints);
        } else {
            point = iGraphics.getGraphicPoint(this.pa, point);
            point2 = iGraphics.getGraphicPoint(this.pe, point2);
            drawField.drawLine(point.x, point.y, point2.x, point2.y);
        }
    }

    private final void drawPatternLine(IGraphics iGraphics, int n, int n2, int n3, int n4, LinieParameter linieParameter, boolean bl) {
        int n5 = linieParameter.getOska();
        int n6 = linieParameter.getSig2();
        int n7 = KafPlotProperties.getColorSwitch();
        if (this.getLa() == 2) {
            if (n7 == 1003) {
                if (this.isGrundstuecksgrenze()) {
                    iGraphics.drawLine(n, n2, n3, n4, bl ? 7 : 5);
                } else if (this.isNotGrundstuecksgrenze()) {
                    iGraphics.drawLine(n, n2, n3, n4, bl ? 3 : 1);
                } else {
                    iGraphics.drawLine(n, n2, n3, n4, bl ? 3 : 1, LinieForm.LINIENFORM_STRICH_STRICH_LANG, this.printSkip());
                }
            } else if (n7 == 1004) {
                if (this.isKatasterNachweisElement()) {
                    if (this.isGrundstuecksgrenze()) {
                        iGraphics.drawLine(n, n2, n3, n4, bl ? 7 : 5);
                    } else if (this.isNotGrundstuecksgrenze()) {
                        iGraphics.drawLine(n, n2, n3, n4, bl ? 4 : 2);
                    } else {
                        iGraphics.drawLine(n, n2, n3, n4, bl ? 5 : 3);
                    }
                } else {
                    iGraphics.drawLine(n, n2, n3, n4, bl ? 3 : 1, LinieForm.LINIENFORM_STRICH_STRICH_LANG, this.printSkip());
                }
            } else if (n7 == 1005) {
                if (this.isLagegrenze()) {
                    iGraphics.drawLine(n, n2, n3, n4, bl ? 7 : 5);
                } else {
                    iGraphics.drawLine(n, n2, n3, n4, bl ? 2 : 1);
                }
            } else if (n7 == 1010) {
                if (this.isAdressegrenze()) {
                    iGraphics.drawLine(n, n2, n3, n4, bl ? 7 : 5);
                } else {
                    iGraphics.drawLine(n, n2, n3, n4, bl ? 2 : 1);
                }
            } else {
                iGraphics.drawLine(n, n2, n3, n4, Alkis.STROKE_FLST, bl);
            }
        } else if (displayProp != null) {
            int n8 = displayProp.getWidth();
            int n9 = displayProp.getPattern();
            if (n9 > 0) {
                iGraphics.drawLine(n, n2, n3, n4, n8 + (bl ? 2 : 0), LinieForm.getForm(n9), 0, this.printSkip());
            } else {
                iGraphics.drawLine(n, n2, n3, n4, n8 + (bl ? 2 : 0));
            }
        } else {
            block0 : switch (n5) {
                case 242: 
                case 243: {
                    if (n7 != 1001) {
                        return;
                    }
                    iGraphics.drawLine(n, n2, n3, n4, bl ? 3 : 1, LinieForm.LINIEFORM_PUNKT_PUNKT, this.printSkip());
                    break;
                }
                case 211: {
                    iGraphics.drawLine(n, n2, n3, n4, bl ? 5 : 3);
                    iGraphics.drawLine(n, n2, n3, n4, bl ? 9 : 7, LinieForm.LINIENFORM_STAAT, 9, this.printSkip());
                    break;
                }
                case 212: {
                    iGraphics.drawLine(n, n2, n3, n4, bl ? 5 : 3);
                    iGraphics.drawLine(n, n2, n3, n4, bl ? 9 : 7, LinieForm.LINIENFORM_LAND, 9, this.printSkip());
                    break;
                }
                case 214: {
                    iGraphics.drawLine(n, n2, n3, n4, bl ? 5 : 3);
                    iGraphics.drawLine(n, n2, n3, n4, bl ? 7 : 5, LinieForm.LINIENFORM_KREIS, 7, this.printSkip());
                    break;
                }
                case 215: {
                    iGraphics.drawLine(n, n2, n3, n4, bl ? 5 : 3);
                    iGraphics.drawLine(n, n2, n3, n4, bl ? 7 : 5, LinieForm.LINIENFORM_GEMEINDE, 7, this.printSkip());
                    break;
                }
                case 223: {
                    iGraphics.drawLine(n, n2, n3, n4, bl ? 5 : 3);
                    iGraphics.drawLine(n, n2, n3, n4, bl ? 7 : 5, LinieForm.LINIENFORM_AMT, 7, this.printSkip());
                    break;
                }
                case 224: {
                    iGraphics.drawLine(n, n2, n3, n4, bl ? 5 : 3);
                    iGraphics.drawLine(n, n2, n3, n4, bl ? 5 : 3, LinieForm.LINIENFORM_GEMEINDETEIL, 5, this.printSkip());
                    break;
                }
                case 231: {
                    iGraphics.drawLine(n, n2, n3, n4, bl ? 5 : 3);
                    iGraphics.drawLine(n, n2, n3, n4, bl ? 5 : 3, LinieForm.LINIENFORM_GEMARKUNG, 5, this.printSkip());
                    break;
                }
                case 232: {
                    iGraphics.drawLine(n, n2, n3, n4, bl ? 5 : 3);
                    iGraphics.drawLine(n, n2, n3, n4, bl ? 5 : 3, LinieForm.LINIENFORM_FLUR, 5, this.printSkip());
                    break;
                }
                case 233: {
                    iGraphics.drawLine(n, n2, n3, n4, Alkis.STROKE_FLST, bl);
                    break;
                }
                case 1011: 
                case 1012: {
                    iGraphics.drawLine(n, n2, n3, n4, Alkis.STROKE_GEB_HHS, bl);
                    break;
                }
                case 241: {
                    if (n7 == 1004) {
                        this.drawTopLine(iGraphics.getGraphics(), n, n2, n3, n4);
                        break;
                    }
                    iGraphics.drawLine(n, n2, n3, n4, bl ? 3 : 1, LinieForm.LINIENFORM_STRICH_STRICH, this.printSkip());
                    break;
                }
                case 1014: 
                case 1047: {
                    iGraphics.drawLine(n, n2, n3, n4, bl ? 3 : 1, LinieForm.LINIENFORM_STRICH_STRICH, this.printSkip());
                    break;
                }
                case 1041: 
                case 1042: 
                case 1043: {
                    iGraphics.drawLine(n, n2, n3, n4, bl ? 3 : 1, LinieForm.LINIENFORM_STRICH0_STRICH0, this.printSkip());
                    break;
                }
                case 1016: {
                    iGraphics.drawLine(n, n2, n3, n4, bl ? 3 : 1, LinieForm.LINIENFORM_STRICH2_STRICH2, this.printSkip());
                    break;
                }
                case 915: {
                    if (n7 == 1006) {
                        iGraphics.drawLine(n, n2, n3, n4, bl ? 3 : 1, LinieForm.LINIENFORM_STRICH2_STRICH, this.printSkip());
                        break;
                    }
                    iGraphics.drawLine(n, n2, n3, n4, bl ? 3 : 1);
                    break;
                }
                case 31001: {
                    if (n7 == 1001 && (this.pa.getPa() < 0 || this.pa.getEq() > 1000 || this.pe.getPa() < 0 || this.pe.getEq() > 1000)) {
                        iGraphics.drawLine(n, n2, n3, n4, Alkis.STROKE_GEB_UNGENAU, bl, this.printSkip());
                        break;
                    }
                    switch (linieParameter.getSig1()) {
                        case 2001: {
                            iGraphics.drawLine(n, n2, n3, n4, Alkis.STROKE_GEB, bl);
                            break block0;
                        }
                        case 2002: {
                            iGraphics.drawLine(n, n2, n3, n4, Alkis.STROKE_GEB_HHS, bl);
                            break block0;
                        }
                        case 2003: {
                            iGraphics.drawLine(n, n2, n3, n4, Alkis.STROKE_GEB_HHS_OIRD, bl, this.printSkip());
                            break block0;
                        }
                        case 2004: {
                            iGraphics.drawLine(n, n2, n3, n4, Alkis.STROKE_GEB_OIRD, bl, this.printSkip());
                            break block0;
                        }
                        case 2005: {
                            iGraphics.drawLine(n, n2, n3, n4, Alkis.STROKE_GEB_UIRD, bl, this.printSkip());
                            break block0;
                        }
                        case 2006: {
                            iGraphics.drawLine(n, n2, n3, n4, Alkis.STROKE_GEB_ABBR, bl, this.printSkip());
                            break block0;
                        }
                    }
                    iGraphics.drawLine(n, n2, n3, n4, Alkis.STROKE_GEB, bl);
                    break;
                }
                case 31002: {
                    switch (linieParameter.getSig1()) {
                        case 2011: {
                            iGraphics.drawLine(n, n2, n3, n4, Alkis.STROKE_GEBT, bl);
                            break block0;
                        }
                        case 2012: {
                            iGraphics.drawLine(n, n2, n3, n4, Alkis.STROKE_GEBT_HHS, bl);
                            break block0;
                        }
                        case 2013: {
                            iGraphics.drawLine(n, n2, n3, n4, Alkis.STROKE_GEBT_HHS_OIRD, bl, this.printSkip());
                            break block0;
                        }
                        case 2014: {
                            iGraphics.drawLine(n, n2, n3, n4, Alkis.STROKE_GEBT_OIRD, bl, this.printSkip());
                            break block0;
                        }
                        case 2015: {
                            iGraphics.drawLine(n, n2, n3, n4, Alkis.STROKE_GEBT_UIRD, bl, this.printSkip());
                            break block0;
                        }
                    }
                    iGraphics.drawLine(n, n2, n3, n4, Alkis.STROKE_GEBT, bl);
                    break;
                }
                case 31003: {
                    iGraphics.drawLine(n, n2, n3, n4, Alkis.STROKE_GEB_BLIN, bl);
                    break;
                }
                case 31004: {
                    iGraphics.drawLine(n, n2, n3, n4, Alkis.STROKE_GEB_FLIN, bl);
                    break;
                }
                case 40001: {
                    if (n7 == 1004) {
                        iGraphics.drawLine(n, n2, n3, n4, bl ? 3 : 1);
                        break;
                    }
                    iGraphics.drawLine(n, n2, n3, n4, Alkis.STROKE_NUTZUNG, bl, this.printSkip());
                    break;
                }
                case 72001: {
                    if (n7 == 1004) break;
                    int n10 = linieParameter.getSig1();
                    BasicStroke basicStroke = n10 == 3103 ? Alkis.STROKE_BODEN_SFG : (n10 == 3102 ? Alkis.STROKE_BODEN_KAG : Alkis.STROKE_BODEN_KFG);
                    if (n7 != 1006 && n7 != 1012 && n7 != 1013 && n7 != 1014) {
                        basicStroke = new BasicStroke(1.0f, basicStroke.getEndCap(), basicStroke.getLineJoin(), basicStroke.getMiterLimit(), basicStroke.getDashArray(), basicStroke.getDashPhase());
                    }
                    iGraphics.drawLine(n, n2, n3, n4, basicStroke, bl);
                    break;
                }
                case 51001: {
                    iGraphics.drawLine(n, n2, n3, n4, Alkis.STROKE_GEB, bl);
                    break;
                }
                case 61001: {
                    if (!this.isBOK() && !this.isBUK() && this.isBTK()) break;
                    iGraphics.drawLine(n, n2, n3, n4, Alkis.STROKE_GEL, bl);
                    break;
                }
                default: {
                    int n11 = linieParameter.getSig1();
                    switch (n11) {
                        case 4001: {
                            iGraphics.drawLine(n, n2, n3, n4, Alkis.STROKE_BW1, bl);
                            break block0;
                        }
                        case 4002: {
                            iGraphics.drawLine(n, n2, n3, n4, Alkis.STROKE_BW2, bl);
                            break block0;
                        }
                        case 4004: {
                            iGraphics.drawLine(n, n2, n3, n4, Alkis.STROKE_BW1, bl);
                            iGraphics.drawLine(n, n2, n3, n4, -3.0f, Alkis.STROKE_BW_ZAUN1, bl);
                            iGraphics.drawLine(n, n2, n3, n4, 3.0f, Alkis.STROKE_BW_ZAUN2, bl);
                            break block0;
                        }
                        case 4005: {
                            iGraphics.drawLine(n, n2, n3, n4, -3.0f, Alkis.STROKE_BW1, bl);
                            iGraphics.drawLine(n, n2, n3, n4, 3.0f, Alkis.STROKE_BW1, bl);
                            iGraphics.drawLine(n, n2, n3, n4, Alkis.STROKE_BW_MAUER, bl);
                            break block0;
                        }
                        case 4006: {
                            iGraphics.drawLine(n, n2, n3, n4, -6.0f, Alkis.STROKE_BW1, bl);
                            iGraphics.drawLine(n, n2, n3, n4, Alkis.STROKE_BW1, bl);
                            iGraphics.drawLine(n, n2, n3, n4, -3.0f, Alkis.STROKE_BW_MAUER, bl);
                            break block0;
                        }
                        case 4007: {
                            iGraphics.drawLine(n, n2, n3, n4, 6.0f, Alkis.STROKE_BW1, bl);
                            iGraphics.drawLine(n, n2, n3, n4, Alkis.STROKE_BW1, bl);
                            iGraphics.drawLine(n, n2, n3, n4, 3.0f, Alkis.STROKE_BW_MAUER, bl);
                            break block0;
                        }
                        case 4008: {
                            iGraphics.drawLine(n, n2, n3, n4, -3.0f, Alkis.STROKE_BW1, bl);
                            iGraphics.drawLine(n, n2, n3, n4, 3.0f, Alkis.STROKE_BW1, bl);
                            iGraphics.drawLine(n, n2, n3, n4, Alkis.STROKE_BW_SMAUER, bl);
                            break block0;
                        }
                        case 4009: {
                            iGraphics.drawLine(n, n2, n3, n4, -6.0f, Alkis.STROKE_BW1, bl);
                            iGraphics.drawLine(n, n2, n3, n4, Alkis.STROKE_BW1, bl);
                            iGraphics.drawLine(n, n2, n3, n4, -3.0f, Alkis.STROKE_BW_SMAUER, bl);
                            break block0;
                        }
                        case 4010: {
                            iGraphics.drawLine(n, n2, n3, n4, 6.0f, Alkis.STROKE_BW1, bl);
                            iGraphics.drawLine(n, n2, n3, n4, Alkis.STROKE_BW1, bl);
                            iGraphics.drawLine(n, n2, n3, n4, 3.0f, Alkis.STROKE_BW_SMAUER, bl);
                            break block0;
                        }
                    }
                    iGraphics.drawLine(n, n2, n3, n4, Alkis.STROKE_BW1, bl);
                    break;
                }
            }
        }
        if (n6 != 0) {
            if (n7 == 1006 || n7 == 1005 || n7 == 1010) {
                iGraphics.getGraphics().setColor(Alkis.COLOR_GRENZE);
            }
            this.drawAlkisPattern(iGraphics, n, n2, n3, n4, n6, bl);
        }
    }

    private final void drawAlkisPattern(IGraphics iGraphics, int n, int n2, int n3, int n4, int n5, boolean bl) {
        int n6 = (int)Math.rint(Alkis.STROKE_FLST.getLineWidth()) * 2;
        if (n5 == 1101) {
            iGraphics.drawLine(n, n2, n3, n4, (float)n6, Alkis.STROKE_GRENZE_KREIS, true, bl);
        } else if (n5 == 1102) {
            iGraphics.drawLine(n, n2, n3, n4, (float)n6, Alkis.STROKE_GRENZE_FLUR, true, bl);
        } else if (n5 == 1103) {
            iGraphics.drawLine(n, n2, n3, n4, (float)n6, Alkis.STROKE_GRENZE_GMK, true, bl);
        } else if (n5 == 1104) {
            iGraphics.drawLine(n, n2, n3, n4, (float)n6, Alkis.STROKE_GRENZE_STAAT, true, bl);
        } else if (n5 == 1105) {
            iGraphics.drawLine(n, n2, n3, n4, (float)n6, Alkis.STROKE_GRENZE_LAND, true, bl);
        } else if (n5 == 1106) {
            iGraphics.drawLine(n, n2, n3, n4, (float)n6, Alkis.STROKE_GRENZE_BEZ, true, bl);
        } else if (n5 == 1107) {
            iGraphics.drawLine(n, n2, n3, n4, (float)n6, Alkis.STROKE_GRENZE_GMD, true, bl);
        }
    }

    private final void drawPatternPolyLine(IGraphics iGraphics, int[] nArray, int[] nArray2, int n, LinieParameter linieParameter, boolean bl) {
        for (int i = 0; i < n - 1; ++i) {
            this.drawPatternLine(iGraphics, nArray[i], nArray2[i], nArray[i + 1], nArray2[i + 1], linieParameter, bl);
        }
    }

    private final boolean printSkip() {
        return this.pe == null || this.pa.x - this.pe.x > this.pa.y - this.pe.y;
    }

    private final void drawTopLine(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.drawLine(n, n2, n3, n4);
        double d = Math.sqrt((n3 - n) * (n3 - n) + (n4 - n2) * (n4 - n2));
        double d2 = (double)(n4 - n2) / d;
        double d3 = (double)(n3 - n) / d;
        int[] nArray = new int[4];
        int[] nArray2 = new int[4];
        int n5 = (n + n3) / 2;
        int n6 = (n2 + n4) / 2;
        int n7 = (int)(8.0 * d3 + 10.0 * d2);
        int n8 = (int)(11.0 * d3 + 7.0 * d2);
        int n9 = (int)(8.0 * d2 - 10.0 * d3);
        int n10 = (int)(11.0 * d2 - 7.0 * d3);
        nArray[0] = n5 + n8;
        nArray2[0] = n6 + n10;
        nArray[1] = n5 + n7;
        nArray2[1] = n6 + n9;
        nArray[2] = n5 - n7;
        nArray2[2] = n6 - n9;
        nArray[3] = n5 - n8;
        nArray2[3] = n6 - n10;
        graphics.drawPolyline(nArray, nArray2, 4);
    }

    private final void drawUntergangLine(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.setColor(Ebene.getColor(48));
        double d = Math.sqrt((n3 - n) * (n3 - n) + (n4 - n2) * (n4 - n2));
        double d2 = (double)(n4 - n2) / d;
        double d3 = (double)(n3 - n) / d;
        double d4 = 4.0 * d3 + 4.0 * d2;
        double d5 = 4.0 * d2 - 4.0 * d3;
        for (double d6 = 25.0; d6 < d; d6 += 50.0) {
            double d7 = d6 * d3;
            double d8 = d6 * d2;
            graphics.drawLine(n + (int)(d7 - d4), n2 + (int)(d8 - d5), n + (int)(d7 + d4), n2 + (int)(d8 + d5));
            graphics.drawLine(n + (int)(d7 + d5), n2 + (int)(d8 - d4), n + (int)(d7 - d5), n2 + (int)(d8 + d4));
        }
    }

    private final void drawUntergangPolyLine(Graphics graphics, int[] nArray, int[] nArray2, int n) {
        graphics.setColor(Ebene.getColor(48));
        double d = 0.0;
        for (int i = 0; i < n - 1; ++i) {
            double d2 = Math.sqrt((nArray[i + 1] - nArray[i]) * (nArray[i + 1] - nArray[i]) + (nArray2[i + 1] - nArray2[i]) * (nArray2[i + 1] - nArray2[i]));
            if (d + d2 > 50.0) {
                double d3 = (double)(nArray2[i + 1] - nArray2[i]) / d2;
                double d4 = (double)(nArray[i + 1] - nArray[i]) / d2;
                double d5 = 4.0 * d4 + 4.0 * d3;
                double d6 = 4.0 * d3 - 4.0 * d4;
                for (d = 50.0 - d; d < d2; d += 50.0) {
                    double d7 = d * d4;
                    double d8 = d * d3;
                    graphics.drawLine(nArray[i] + (int)Math.rint(d7 - d5), nArray2[i] + (int)Math.rint(d8 - d6), nArray[i] + (int)Math.rint(d7 + d5), nArray2[i] + (int)Math.rint(d8 + d6));
                    graphics.drawLine(nArray[i] + (int)Math.rint(d7 + d6), nArray2[i] + (int)Math.rint(d8 - d5), nArray[i] + (int)Math.rint(d7 - d6), nArray2[i] + (int)Math.rint(d8 + d5));
                }
                d = d2 - (d - 50.0);
                continue;
            }
            d += d2;
        }
    }

    class HashKey {
        protected Punkt pa;
        protected Punkt pe;
        protected double l2;
        protected Linie l;

        HashKey(Linie linie, Linie linie2) {
            this.l = linie2;
            this.pa = linie2.pa;
            this.pe = linie2.pe;
            this.l2 = linie2.l2;
        }

        public Linie getLinie() {
            return this.l;
        }

        public int hashCode() {
            return (int)(this.pa.nr % 10000L) + (this.pe != null ? (int)(this.pe.nr % 10000L) : 0);
        }

        public boolean equals(Object object) {
            HashKey hashKey = (HashKey)object;
            return hashKey.pa == this.pa && hashKey.pe == this.pe && hashKey.l2 == this.l2 || hashKey.pe == this.pa && hashKey.pa == this.pe && hashKey.l2 == -this.l2;
        }
    }

    class ArtHashKey
    extends HashKey {
        protected int la;

        ArtHashKey(Linie linie, Linie linie2) {
            super(linie, linie2);
            this.la = linie2.getLa();
        }

        @Override
        public boolean equals(Object object) {
            ArtHashKey artHashKey = (ArtHashKey)object;
            return super.equals(object) && artHashKey.la == this.la;
        }
    }

    class ArtEbeneHashKey
    extends HashKey {
        protected int la;
        protected int eb;

        ArtEbeneHashKey(Linie linie, Linie linie2) {
            super(linie, linie2);
            this.la = linie2.getLa();
            this.eb = linie2.getEb();
        }

        @Override
        public boolean equals(Object object) {
            ArtEbeneHashKey artEbeneHashKey = (ArtEbeneHashKey)object;
            return super.equals(object) && artEbeneHashKey.la == this.la && artEbeneHashKey.eb == this.eb;
        }
    }

    class ArtEbeneOskaHashKey
    extends HashKey {
        protected int la;
        protected int eb;
        protected int oska;

        ArtEbeneOskaHashKey(Linie linie, Linie linie2) {
            super(linie, linie2);
            this.la = linie2.getLa();
            this.eb = linie2.getEb();
            this.oska = linie2.getOska();
        }

        @Override
        public boolean equals(Object object) {
            ArtEbeneOskaHashKey artEbeneOskaHashKey = (ArtEbeneOskaHashKey)object;
            return super.equals(object) && artEbeneOskaHashKey.la == this.la && artEbeneOskaHashKey.eb == this.eb && artEbeneOskaHashKey.oska == this.oska;
        }
    }
}

