/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.kafplot.Linie;
import de.geocalc.kafplot.io.xml.XmlIOProperties;
import java.util.Enumeration;
import java.util.Vector;

public class LinieArt {
    public static final String UNDEF_STRING = "ohne";
    public static final String OBJEKT_STRING = "Objekt-Linie";
    public static final String AP_STRING = "AP-Linie";
    public static final String GRENZE_STRING = "Grenze";
    public static final String GEBAEUDE_STRING = "Geb\u00e4ude";
    public static final String TOPOGRAPHIE_STRING = "topographische Linie";
    public static final String NUTZUNG_STRING = "Nutzungsartengrenze";
    public static final String KP_STRING = "Kleinpunkt-Linie";
    public static final String SP_STRING = "Schwere-Linie";
    public static final String NP_STRING = "Nivellementslinie";
    public static final int OHNE = -2;
    public static final int UNDEF = -1;
    public static final int OBJEKT = 0;
    public static final int AP = 1;
    public static final int GRENZE = 2;
    public static final int GEBAEUDE = 3;
    public static final int TOPOGRAPHIE = 4;
    public static final int NUTZUNG = 5;
    public static final int KP = 7;
    public static final int SP = 8;
    public static final int NP = 9;
    private static int GG_UNDEF = 0;
    private static int GG_TL = 1;
    private static int GG_AL = 4;
    private static int GG_GL = 0;
    private static int GG_HL = 0;
    private static int GG_ZL = 0;
    private static int GG_KL = 0;
    private static int GG_SL = 0;
    private static int GG_NL = 0;
    private static final Vector arten = new Vector();
    private int art;
    private String name;

    public LinieArt() {
        this(-1, UNDEF_STRING);
    }

    public LinieArt(int n, String string) {
        this.art = n;
        this.name = string;
    }

    public String toXmlLine() {
        String[] stringArray = new String[]{XmlIOProperties.att("id", Integer.toString(this.art)), XmlIOProperties.att("name", this.name)};
        return XmlIOProperties.data("linienart", stringArray);
    }

    public static Enumeration arten() {
        return arten.elements();
    }

    public static int getArt(String string) {
        if (string == null) {
            return -1;
        }
        if (string.equals(OBJEKT_STRING)) {
            return 0;
        }
        if (string.equals(AP_STRING)) {
            return 1;
        }
        if (string.equals(GRENZE_STRING)) {
            return 2;
        }
        if (string.equals(GEBAEUDE_STRING)) {
            return 3;
        }
        if (string.equals(TOPOGRAPHIE_STRING)) {
            return 4;
        }
        if (string.equals(NUTZUNG_STRING)) {
            return 5;
        }
        if (string.equals(KP_STRING)) {
            return 7;
        }
        if (string.equals(SP_STRING)) {
            return 8;
        }
        if (string.equals(NP_STRING)) {
            return 9;
        }
        return -1;
    }

    public static String getArtName(int n) {
        switch (n) {
            case 0: {
                return OBJEKT_STRING;
            }
            case 1: {
                return AP_STRING;
            }
            case 2: {
                return GRENZE_STRING;
            }
            case 3: {
                return GEBAEUDE_STRING;
            }
            case 4: {
                return TOPOGRAPHIE_STRING;
            }
            case 5: {
                return NUTZUNG_STRING;
            }
            case 7: {
                return KP_STRING;
            }
            case 8: {
                return SP_STRING;
            }
            case 9: {
                return NP_STRING;
            }
        }
        return UNDEF_STRING;
    }

    public static int getGeografLinieArt(Linie linie) {
        if (linie.getEb() == 0) {
            return GG_UNDEF;
        }
        int n = linie.getEb() * 100;
        switch (linie.getLa()) {
            case 0: {
                return GG_UNDEF;
            }
            case 1: {
                return n + GG_AL;
            }
            case 2: {
                return n + GG_GL;
            }
            case 3: {
                return n + GG_HL;
            }
            case 4: {
                return n + GG_ZL;
            }
            case 5: {
                return n + GG_ZL;
            }
            case 7: {
                return n + GG_KL;
            }
            case 8: {
                return n + GG_SL;
            }
            case 9: {
                return n + GG_NL;
            }
        }
        return GG_UNDEF;
    }

    static {
        arten.addElement(new LinieArt(-1, UNDEF_STRING));
        arten.addElement(new LinieArt(0, OBJEKT_STRING));
        arten.addElement(new LinieArt(1, AP_STRING));
        arten.addElement(new LinieArt(2, GRENZE_STRING));
        arten.addElement(new LinieArt(3, GEBAEUDE_STRING));
        arten.addElement(new LinieArt(4, TOPOGRAPHIE_STRING));
        arten.addElement(new LinieArt(5, NUTZUNG_STRING));
        arten.addElement(new LinieArt(7, KP_STRING));
        arten.addElement(new LinieArt(8, SP_STRING));
        arten.addElement(new LinieArt(9, NP_STRING));
    }
}

