/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.IBorder;
import de.geocalc.awt.IDialog;
import de.geocalc.awt.IFrame;
import de.geocalc.awt.IInfoField;
import de.geocalc.awt.IPanel;
import de.geocalc.kafplot.Ebene;
import de.geocalc.kafplot.Linie;
import de.geocalc.kafplot.LinieArt;
import de.geocalc.kafplot.Oska;
import de.geocalc.text.IFormat;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class LinieInfoDialog
extends IDialog
implements ActionListener {
    private static final String OK_COMMAND = "OK";
    private static final String VOID = " ";
    private Linie l;
    private IInfoField paNrInfoField;
    private IInfoField peNrInfoField;
    private IInfoField paUmNrInfoField;
    private IInfoField peUmNrInfoField;
    private IInfoField paNbNrInfoField;
    private IInfoField peNbNrInfoField;
    private IInfoField paPaNrInfoField;
    private IInfoField pePaNrInfoField;
    private IInfoField paKatNrInfoField;
    private IInfoField peKatNrInfoField;
    private IInfoField paYInfoField;
    private IInfoField peYInfoField;
    private IInfoField paXInfoField;
    private IInfoField peXInfoField;
    private IInfoField paHInfoField;
    private IInfoField peHInfoField;
    private IInfoField rInfoField;
    private IInfoField dyInfoField;
    private IInfoField dxInfoField;
    private IInfoField dsInfoField;
    private IInfoField dtInfoField;
    private IInfoField laInfoField;
    private IInfoField laDetailInfoField;
    private IInfoField ebInfoField;
    private IInfoField ebDetailInfoField;
    private IInfoField osInfoField;
    private IInfoField osDetailInfoField;

    public LinieInfoDialog(IFrame iFrame, String string) {
        this(iFrame, string, null);
    }

    public LinieInfoDialog(IFrame iFrame, String string, Linie linie) {
        super(iFrame, string, true);
        this.l = linie;
        this.setLayout(new BorderLayout());
        this.add("Center", this.createLinieInfoPanel());
        this.add("South", this.createButtonPanel());
        this.pack();
        this.setLinie(linie);
        this.setLocationOfParent(iFrame, -11);
        this.setResizable(false);
    }

    private Panel createLinieInfoPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        Panel panel = new Panel(gridBagLayout);
        IPanel iPanel = this.createNrPanel();
        panel.add(iPanel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(iPanel, gridBagConstraints);
        iPanel = this.createKooPanel();
        panel.add(iPanel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(iPanel, gridBagConstraints);
        iPanel = this.createParPanel();
        panel.add(iPanel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(iPanel, gridBagConstraints);
        return panel;
    }

    private IPanel createParPanel() {
        IPanel iPanel = new IPanel(new BorderLayout());
        iPanel.setBorder(new IBorder(1, "Parameter"));
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        Panel panel = new Panel(gridBagLayout);
        Label label = new Label("Linienart:");
        panel.add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.laInfoField = new IInfoField(1);
        panel.add(this.laInfoField);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagLayout.setConstraints(this.laInfoField, gridBagConstraints);
        this.laDetailInfoField = new IInfoField(30);
        panel.add(this.laDetailInfoField);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagLayout.setConstraints(this.laDetailInfoField, gridBagConstraints);
        label = new Label("Ebene:");
        panel.add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.ebInfoField = new IInfoField(2);
        panel.add(this.ebInfoField);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagLayout.setConstraints(this.ebInfoField, gridBagConstraints);
        this.ebDetailInfoField = new IInfoField(30);
        panel.add(this.ebDetailInfoField);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagLayout.setConstraints(this.ebDetailInfoField, gridBagConstraints);
        label = new Label("Objektschl\u00fcssel:");
        panel.add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.osInfoField = new IInfoField(8);
        panel.add(this.osInfoField);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagLayout.setConstraints(this.osInfoField, gridBagConstraints);
        this.osDetailInfoField = new IInfoField(30);
        panel.add(this.osDetailInfoField);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagLayout.setConstraints(this.osDetailInfoField, gridBagConstraints);
        iPanel.add("West", panel);
        return iPanel;
    }

    private IPanel createKooPanel() {
        IPanel iPanel = new IPanel(new BorderLayout());
        iPanel.setBorder(new IBorder(1, "Koordinaten"));
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.fill = 0;
        Panel panel = new Panel(gridBagLayout);
        Label label = new Label("Rechtswert:");
        panel.add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.paYInfoField = new IInfoField(11, 2);
        panel.add(this.paYInfoField);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(this.paYInfoField, gridBagConstraints);
        this.peYInfoField = new IInfoField(11, 2);
        panel.add(this.peYInfoField);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(this.peYInfoField, gridBagConstraints);
        label = new Label("dy:");
        panel.add(label);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.dyInfoField = new IInfoField(11, 2);
        panel.add(this.dyInfoField);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(this.dyInfoField, gridBagConstraints);
        label = new Label("Hochwert:");
        panel.add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.paXInfoField = new IInfoField(11, 2);
        panel.add(this.paXInfoField);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(this.paXInfoField, gridBagConstraints);
        this.peXInfoField = new IInfoField(11, 2);
        panel.add(this.peXInfoField);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(this.peXInfoField, gridBagConstraints);
        label = new Label("dx:");
        panel.add(label);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.dxInfoField = new IInfoField(11, 2);
        panel.add(this.dxInfoField);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(this.dxInfoField, gridBagConstraints);
        label = new Label("Radius:");
        panel.add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.rInfoField = new IInfoField(11, 2);
        panel.add(this.rInfoField);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(this.rInfoField, gridBagConstraints);
        label = new Label("Strecke:");
        panel.add(label);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.dsInfoField = new IInfoField(11, 2);
        panel.add(this.dsInfoField);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(this.dsInfoField, gridBagConstraints);
        label = new Label("Richtung:");
        panel.add(label);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.dtInfoField = new IInfoField(11, 2);
        panel.add(this.dtInfoField);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(this.dtInfoField, gridBagConstraints);
        iPanel.add("West", panel);
        return iPanel;
    }

    private IPanel createNrPanel() {
        IPanel iPanel = new IPanel(new BorderLayout());
        iPanel.setBorder(new IBorder(1, "Punktnummer"));
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        Panel panel = new Panel(gridBagLayout);
        Label label = new Label("Lokale Nummer:");
        panel.add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.paNrInfoField = new IInfoField(12, 2);
        panel.add(this.paNrInfoField);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(this.paNrInfoField, gridBagConstraints);
        label = new Label("umnumerierte Nummer:");
        panel.add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.paUmNrInfoField = new IInfoField(12, 2);
        panel.add(this.paUmNrInfoField);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(this.paUmNrInfoField, gridBagConstraints);
        label = new Label("Ausgabenummer:");
        panel.add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.paNbNrInfoField = new IInfoField(8, 2);
        panel.add(this.paNbNrInfoField);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagLayout.setConstraints(this.paNbNrInfoField, gridBagConstraints);
        this.paPaNrInfoField = new IInfoField(1, 2);
        panel.add(this.paPaNrInfoField);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagLayout.setConstraints(this.paPaNrInfoField, gridBagConstraints);
        this.paKatNrInfoField = new IInfoField(5, 2);
        panel.add(this.paKatNrInfoField);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagLayout.setConstraints(this.paKatNrInfoField, gridBagConstraints);
        this.peNrInfoField = new IInfoField(12, 2);
        panel.add(this.peNrInfoField);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(this.peNrInfoField, gridBagConstraints);
        this.peUmNrInfoField = new IInfoField(12, 2);
        panel.add(this.peUmNrInfoField);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(this.peUmNrInfoField, gridBagConstraints);
        this.peNbNrInfoField = new IInfoField(8, 2);
        panel.add(this.peNbNrInfoField);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagLayout.setConstraints(this.peNbNrInfoField, gridBagConstraints);
        this.pePaNrInfoField = new IInfoField(1, 2);
        panel.add(this.pePaNrInfoField);
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagLayout.setConstraints(this.pePaNrInfoField, gridBagConstraints);
        this.peKatNrInfoField = new IInfoField(5, 2);
        panel.add(this.peKatNrInfoField);
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagLayout.setConstraints(this.peKatNrInfoField, gridBagConstraints);
        iPanel.add("West", panel);
        return iPanel;
    }

    private Panel createButtonPanel() {
        Panel panel = new Panel(new FlowLayout(1));
        Button button = new Button(OK_COMMAND);
        button.addActionListener(this);
        panel.add(button);
        return panel;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals(OK_COMMAND)) {
            this.endDialog();
        }
    }

    public void setLinie(Linie linie) {
        this.l = linie;
        if (linie == null) {
            return;
        }
        this.paNrInfoField.setText(Long.toString(linie.pa.nr));
        if (linie.pa.getUmnum() > 0L) {
            this.paUmNrInfoField.setText(new Long(linie.pa.getUmnum()).toString());
        } else if (linie.pa.getUmnum() == -9L) {
            this.paUmNrInfoField.setText("#");
        } else {
            this.paUmNrInfoField.setText(VOID);
        }
        this.paNbNrInfoField.setText(linie.pa.isKatasterPunkt() ? Long.toString(linie.pa.createNb()) : VOID);
        this.paNbNrInfoField.setForeground(linie.pa.createNb() != linie.pa.createNb(linie.pa.getNr()) ? Color.red : Color.black);
        this.paPaNrInfoField.setText(linie.pa.isKatasterPunkt() ? new Long(linie.pa.getNumPa()).toString() : VOID);
        this.paKatNrInfoField.setForeground(linie.pa.getNr() != linie.pa.getKatNr() ? Color.red : Color.black);
        this.paKatNrInfoField.setText(linie.pa.isKatasterPunkt() ? new Long(linie.pa.getKatNr()).toString() : VOID);
        this.peNrInfoField.setText(Long.toString(linie.pe.nr).toString());
        if (linie.pe.getUmnum() > 0L) {
            this.peUmNrInfoField.setText(new Long(linie.pe.getUmnum()).toString());
        } else if (linie.pe.getUmnum() == -9L) {
            this.peUmNrInfoField.setText("#");
        } else {
            this.peUmNrInfoField.setText(VOID);
        }
        this.peNbNrInfoField.setText(linie.pe.isKatasterPunkt() ? Long.toString(linie.pe.createNb()) : VOID);
        this.peNbNrInfoField.setForeground(linie.pe.createNb() != linie.pe.createNb(linie.pe.getNr()) ? Color.red : Color.black);
        this.pePaNrInfoField.setText(linie.pe.isKatasterPunkt() ? new Long(linie.pe.getNumPa()).toString() : VOID);
        this.peKatNrInfoField.setForeground(linie.pe.getNr() != linie.pe.getKatNr() ? Color.red : Color.black);
        this.peKatNrInfoField.setText(linie.pe.isKatasterPunkt() ? new Long(linie.pe.getKatNr()).toString() : VOID);
        this.paYInfoField.setText(IFormat.f_3.format(linie.pa.y).toString());
        this.paXInfoField.setText(IFormat.f_3.format(linie.pa.x).toString());
        this.peYInfoField.setText(IFormat.f_3.format(linie.pe.y).toString());
        this.peXInfoField.setText(IFormat.f_3.format(linie.pe.x).toString());
        this.dyInfoField.setText(IFormat.f_3.format(linie.pe.y - linie.pa.y).toString());
        this.dxInfoField.setText(IFormat.f_3.format(linie.pe.x - linie.pa.x).toString());
        if (linie.isBogen()) {
            this.rInfoField.setText(IFormat.f_3.format(linie.l2).toString());
            this.dsInfoField.setText(IFormat.f_3.format(linie.getBogenLaenge()).toString());
            this.dtInfoField.setText(VOID);
        } else {
            this.rInfoField.setText(VOID);
            this.dsInfoField.setText(IFormat.f_3.format(linie.getLaenge()).toString());
            double d = linie.getRichtung() * 200.0 / Math.PI;
            if (d < 0.0) {
                d += 400.0;
            }
            this.dtInfoField.setText(IFormat.f_4.format(d).toString());
        }
        this.laInfoField.setText(IFormat.i.format(linie.getLa()).toString());
        this.laDetailInfoField.setText(LinieArt.getArtName(linie.getLa()));
        this.ebInfoField.setText(IFormat.i.format(linie.getEb()).toString());
        this.ebDetailInfoField.setText(Ebene.toString(linie.getEb()));
        if (linie.getOska() > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(Integer.toString(linie.getOska()));
            this.osInfoField.setText(stringBuffer.toString());
            String string = Oska.getOskaName(linie.getOska());
            this.osDetailInfoField.setText(string != null ? string : VOID);
        } else {
            this.osInfoField.setText(VOID);
            this.osDetailInfoField.setText(VOID);
        }
    }

    @Override
    protected void doStandardAction() {
        this.endDialog();
    }

    @Override
    protected void doAbortAction() {
        this.endDialog();
    }
}

