/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.kafplot.io.kpv.KpvIOProperties;
import de.geocalc.util.ClearList;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Enumeration;

public final class LinieParameter
implements Cloneable {
    private static final ClearList list = new ClearList(1.0f);
    public static final LinieParameter VOID = new LinieParameter();
    public static final LinieParameter FLST = new LinieParameter(2, 1, 11001, 1001);
    public static final LinieParameter FLST_NEU = new LinieParameter(2, 48, 11001, 1001);
    public static final LinieParameter GEB = new LinieParameter(3, 2, 31001, 2001);
    public static final LinieParameter GEB_NEU = new LinieParameter(3, 42, 31001, 2001);
    public static final LinieParameter GEB_HHS = new LinieParameter(3, 2, 31001, 2002);
    public static final LinieParameter GEB_HHS_OIRD = new LinieParameter(3, 2, 31001, 2003);
    public static final LinieParameter GEB_OIRD = new LinieParameter(3, 2, 31001, 2004);
    public static final LinieParameter GEB_UIRD = new LinieParameter(3, 2, 31001, 2005);
    public static final LinieParameter GEB_ABBR = new LinieParameter(3, 2, 31001, 2006);
    public static final LinieParameter GEBT = new LinieParameter(3, 2, 31002, 2011);
    public static final LinieParameter GEBT_OIRD = new LinieParameter(3, 2, 31002, 2014);
    public static final LinieParameter GEBT_UIRD = new LinieParameter(3, 2, 31002, 2015);
    public static final LinieParameter GEBT_HHS = new LinieParameter(3, 2, 31002, 2012);
    public static final LinieParameter GEBT_HHS_OIRD = new LinieParameter(3, 2, 31002, 2013);
    public static final LinieParameter GEB_BLIN = new LinieParameter(3, 2, 31003, 2001);
    public static final LinieParameter GEB_FLIN = new LinieParameter(3, 2, 31004, 2001);
    public static final LinieParameter NUTZ = new LinieParameter(5, 47, 40001, 3001);
    public static final LinieParameter BODEN = new LinieParameter(5, 61, 72001, 3101);
    public static final LinieParameter TOP = new LinieParameter(4, -1, 0, 0);
    private byte la = (byte)-2;
    private byte eb = (byte)-1;
    private int oska = 0;
    private short sig1;
    private short sig2;

    public static LinieParameter intern(LinieParameter linieParameter) {
        if (linieParameter == null) {
            throw new NullPointerException();
        }
        Object object = list.put(linieParameter);
        return object != null ? (LinieParameter)object : linieParameter;
    }

    public LinieParameter() {
    }

    public LinieParameter(int n, int n2, int n3, int n4) {
        this.setLa(n);
        this.setEb(n2);
        this.setOska(n3);
        this.setSig1(n4);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public void setLa(int n) {
        this.la = (byte)n;
    }

    public int getLa() {
        return this.la;
    }

    public void setEb(int n) {
        this.eb = (byte)n;
    }

    public int getEb() {
        return this.eb;
    }

    public void setOska(int n) {
        this.oska = n;
    }

    public int getOska() {
        return this.oska;
    }

    public void setFolie(int n) {
        this.sig1 = (short)n;
    }

    public int getFolie() {
        return this.sig1;
    }

    public void setSig1(int n) {
        this.sig1 = (short)n;
    }

    public int getSig1() {
        return this.sig1;
    }

    public void setSig2(int n) {
        this.sig2 = (short)n;
    }

    public int getSig2() {
        return this.sig2;
    }

    public int hashCode() {
        return this.oska * 1000000 + this.la * 100 + this.eb + this.sig1 + this.sig2;
    }

    public boolean equals(Object object) {
        if (object instanceof LinieParameter) {
            LinieParameter linieParameter = (LinieParameter)object;
            return this.la == linieParameter.la && this.eb == linieParameter.eb && this.oska == linieParameter.oska && this.sig1 == linieParameter.sig1 && this.sig2 == linieParameter.sig2;
        }
        return false;
    }

    public boolean isVoid() {
        return this.equals(VOID);
    }

    public String toString() {
        return "LinieParameter: la=" + this.la + " eb=" + this.eb + " os=" + this.oska + " sig1=" + this.sig1 + " sig2=" + this.sig2;
    }

    public static void writeObjects(DataOutput dataOutput) throws IOException {
        dataOutput.write(93);
        int n = list.size();
        if (n > Short.MAX_VALUE) {
            throw new IOException("overflow LinieParameter");
        }
        dataOutput.writeShort(n);
        int n2 = 1;
        Enumeration enumeration = list.elements();
        while (enumeration.hasMoreElements()) {
            LinieParameter linieParameter = (LinieParameter)enumeration.nextElement();
            linieParameter.writeObject(dataOutput);
            KpvIOProperties.setLinieParameter(n2, linieParameter);
            ++n2;
        }
    }

    public static void readObjects(DataInput dataInput) throws IOException {
        int n = dataInput.readShort();
        for (int i = 0; i < n; ++i) {
            LinieParameter linieParameter = LinieParameter.readObject(dataInput);
            KpvIOProperties.setLinieParameter(i + 1, linieParameter);
        }
    }

    private void writeObject(DataOutput dataOutput) throws IOException {
        dataOutput.writeByte(this.la);
        dataOutput.writeByte(this.eb);
        dataOutput.writeInt(this.oska);
        dataOutput.writeShort(this.sig1);
        dataOutput.writeShort(this.sig2);
    }

    private static LinieParameter readObject(DataInput dataInput) throws IOException {
        LinieParameter linieParameter = new LinieParameter();
        linieParameter.la = dataInput.readByte();
        linieParameter.eb = dataInput.readByte();
        linieParameter.oska = KpvIOProperties.RVER >= 200 ? dataInput.readInt() : (int)dataInput.readShort();
        linieParameter.sig1 = dataInput.readShort();
        if (KpvIOProperties.RVER >= 200) {
            linieParameter.sig2 = dataInput.readShort();
        }
        return linieParameter;
    }

    static {
        list.put(VOID);
        list.put(FLST);
        list.put(FLST_NEU);
        list.put(GEB);
        list.put(GEB_NEU);
        list.put(GEB_HHS);
        list.put(GEB_HHS_OIRD);
        list.put(GEB_OIRD);
        list.put(GEB_UIRD);
        list.put(GEB_ABBR);
        list.put(GEBT);
        list.put(GEBT_OIRD);
        list.put(GEBT_UIRD);
        list.put(GEBT_HHS);
        list.put(GEBT_HHS_OIRD);
        list.put(GEB_BLIN);
        list.put(GEB_FLIN);
        list.put(NUTZ);
        list.put(BODEN);
        list.put(TOP);
    }
}

