/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.FlowText;
import de.geocalc.awt.IBorder;
import de.geocalc.awt.IDialog;
import de.geocalc.awt.IFrame;
import de.geocalc.awt.IPanel;
import de.geocalc.awt.ITextField;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.KafPlotProperties;
import de.geocalc.kafplot.KafPlotServiceClient;
import de.geocalc.kafplot.event.ServiceListener;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.StringTokenizer;

public class LoadKpsDialog
extends IDialog
implements ActionListener {
    private static final String OK_COMMAND = "Laden";
    private static final String ABORT_COMMAND = "Beenden";
    private DataBase db;
    private ServiceListener serviceListener = null;
    private ITextField urlField;
    private TextArea ergText;
    private Button okButton;
    private Button abortButton;
    private String host;

    public LoadKpsDialog(IFrame iFrame, String string, DataBase dataBase, String string2) {
        super(iFrame, string, true);
        this.db = dataBase;
        this.host = string2;
        this.setLayout(new BorderLayout());
        this.add("North", this.createPortPanel());
        this.add("South", this.createButtonPanel());
        this.pack();
        this.setLocationOfParent(iFrame);
        this.setResizable(false);
    }

    public void addServiceListener(ServiceListener serviceListener) {
        this.serviceListener = serviceListener;
    }

    public void removeServiceListener(ServiceListener serviceListener) {
        if (this.serviceListener == serviceListener) {
            this.serviceListener = null;
        }
    }

    private IPanel createPortPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.anchor = 17;
        IPanel iPanel = new IPanel(gridBagLayout);
        iPanel.setBorder(new IBorder(1));
        FlowText flowText = new FlowText("Adresse des KafPlotServers eingeben, zB.: " + this.host, false);
        iPanel.add(flowText);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagLayout.setConstraints(flowText, gridBagConstraints);
        Label label = new Label("Server Adresse:");
        iPanel.add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.urlField = new ITextField(40);
        iPanel.add(this.urlField);
        this.urlField.setText(this.createAddress(8000));
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.urlField, gridBagConstraints);
        label = new Label("Protokoll:");
        iPanel.add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.ergText = new TextArea(10, 50);
        iPanel.add(this.ergText);
        this.ergText.setEditable(false);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagLayout.setConstraints(this.ergText, gridBagConstraints);
        return iPanel;
    }

    private Panel createButtonPanel() {
        Panel panel = new Panel(new FlowLayout(2));
        this.okButton = new Button(OK_COMMAND);
        this.okButton.addActionListener(this);
        panel.add(this.okButton);
        this.abortButton = new Button(ABORT_COMMAND);
        this.abortButton.addActionListener(this);
        panel.add(this.abortButton);
        return panel;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(OK_COMMAND)) {
            this.okButton.setEnabled(false);
            this.abortButton.setEnabled(false);
            this.doStandardAction();
            this.okButton.setEnabled(true);
            this.abortButton.setEnabled(true);
        } else if (string.equals(ABORT_COMMAND)) {
            this.endDialog();
        }
    }

    @Override
    protected void doStandardAction() {
        String string = this.urlField.getText();
        this.ergText.setText("");
        this.ergText.setForeground(Color.black);
        try {
            String string2;
            StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
            String string3 = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : null;
            String string4 = string2 = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : null;
            if (string3 == null || string2 == null) {
                throw new Exception("Ung\u00fcltige Adresse " + string);
            }
            int n = 0;
            try {
                n = Integer.parseInt(string2);
            }
            catch (Exception exception) {
                throw new Exception("Ung\u00fcltiger Port " + string2);
            }
            KafPlotProperties.setKpsPort(n);
            KafPlotServiceClient kafPlotServiceClient = new KafPlotServiceClient(string3, n, this.serviceListener);
            this.endDialog();
        }
        catch (Exception exception) {
            KafPlotProperties.setKpsPort(-1);
            this.ergText.setForeground(Color.red);
            this.ergText.appendText("Fehler -------------\n");
            this.ergText.appendText(exception.getMessage() + "\n");
        }
    }

    @Override
    protected void doAbortAction() {
        this.endDialog();
    }

    private String createAddress(int n) {
        return this.host + ":" + Integer.toString(n);
    }
}

