/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.FlowText;
import de.geocalc.awt.IBorder;
import de.geocalc.awt.IDialog;
import de.geocalc.awt.IFrame;
import de.geocalc.awt.IPanel;
import de.geocalc.awt.IPasswordDialog;
import de.geocalc.awt.ITextField;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.GeoImage;
import de.geocalc.kafplot.ImageObjectDialog;
import de.geocalc.kafplot.KafPlotProperties;
import de.geocalc.kafplot.KafPlotVersion;
import de.geocalc.kafplot.WmsGeoImage;
import de.geocalc.util.Base64;
import de.geocalc.xml.XMLElement;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URL;
import java.util.Enumeration;
import java.util.StringTokenizer;

public class LoadWmsDialog
extends IDialog
implements ActionListener,
ItemListener {
    private static final String OK_COMMAND = "Laden";
    private static final String ABORT_COMMAND = "Beenden";
    private static final String OPTION_COMMAND = "Optionen";
    private static final String NEW_NAME = "Neuer WebMapService";
    private DataBase db;
    private Choice urlChoice;
    private ITextField urlField;
    private TextArea ergText;
    private Button okButton;
    private Button optionButton;
    private Button abortButton;
    private WmsGeoImage image = null;

    public LoadWmsDialog(IFrame iFrame, String string, DataBase dataBase) {
        super(iFrame, string, true);
        this.db = dataBase;
        this.setLayout(new BorderLayout());
        this.add("North", this.createPortPanel());
        this.add("South", this.createButtonPanel());
        this.pack();
        this.setLocationOfParent(iFrame);
        this.setResizable(false);
    }

    private IPanel createPortPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.anchor = 17;
        IPanel iPanel = new IPanel(gridBagLayout);
        iPanel.setBorder(new IBorder(1));
        FlowText flowText = new FlowText("URL des MapServers eingeben, zB.: http://isk.geoasis-bb.de/ows/alk.php", false);
        iPanel.add(flowText);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagLayout.setConstraints(flowText, gridBagConstraints);
        this.urlChoice = new Choice();
        iPanel.add(this.urlChoice);
        this.urlChoice.add(NEW_NAME);
        Enumeration enumeration = KafPlotProperties.getWmsServerNames();
        while (enumeration.hasMoreElements()) {
            this.urlChoice.add((String)enumeration.nextElement());
        }
        this.urlChoice.addItemListener(this);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.urlChoice, gridBagConstraints);
        Label label = new Label("Server URL:");
        iPanel.add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.urlField = new ITextField(40);
        iPanel.add(this.urlField);
        this.urlField.setText(this.createAddress(8000));
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.urlField, gridBagConstraints);
        label = new Label("Protokoll:");
        iPanel.add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.ergText = new TextArea(10, 50);
        iPanel.add(this.ergText);
        this.ergText.setEditable(false);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagLayout.setConstraints(this.ergText, gridBagConstraints);
        return iPanel;
    }

    private Panel createButtonPanel() {
        Panel panel = new Panel(new FlowLayout(2));
        this.okButton = new Button(OK_COMMAND);
        this.okButton.addActionListener(this);
        panel.add(this.okButton);
        this.optionButton = new Button(OPTION_COMMAND);
        this.optionButton.addActionListener(this);
        this.optionButton.setEnabled(false);
        panel.add(this.optionButton);
        this.abortButton = new Button(ABORT_COMMAND);
        this.abortButton.addActionListener(this);
        panel.add(this.abortButton);
        return panel;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        String string;
        if (itemEvent.getSource() == this.urlChoice && (string = this.urlChoice.getSelectedItem()) != null) {
            String string2 = KafPlotProperties.getWmsServer(string);
            this.urlField.setText(string2 != null ? string2 : "http://");
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(OK_COMMAND)) {
            this.okButton.setEnabled(false);
            this.abortButton.setEnabled(false);
            this.doStandardAction();
            this.okButton.setEnabled(true);
            this.abortButton.setEnabled(true);
            this.optionButton.setEnabled(this.image != null);
        } else if (string.equals(ABORT_COMMAND)) {
            this.endDialog();
        } else if (string.equals(OPTION_COMMAND) && this.image != null) {
            ImageObjectDialog imageObjectDialog = new ImageObjectDialog((IFrame)this.getParent(), "Imageoptionen", this.image);
            imageObjectDialog.setVisible(true);
        }
    }

    @Override
    protected void doStandardAction() {
        String string;
        Object object;
        Object object2;
        Object object3;
        String string2 = this.urlChoice.getSelectedItem();
        String string3 = this.urlField.getText();
        String string4 = null;
        Object object4 = KafPlotProperties.getWmsOption(string2, "pw");
        if (object4 != null) {
            if (((String)object4).startsWith("?") || ((String)object4).indexOf(":?") >= 0) {
                int n = ((String)object4).indexOf(":");
                object3 = null;
                String string5 = null;
                if (n >= 0) {
                    object3 = ((String)object4).substring(0, n);
                    if (((String)object3).startsWith("?")) {
                        object3 = ((String)object3).substring(1);
                    }
                    if ((string5 = ((String)object4).substring(n + 1)).startsWith("?")) {
                        string5 = string5.substring(1);
                    }
                    object2 = new IPasswordDialog(this.getParentFrame(), "ServerPasswort", "Bitte geben Sie Anmeldename und das Passwort f\u00fcr den WMS-Server ein!");
                    ((IPasswordDialog)object2).setUsername((String)object3);
                    ((IPasswordDialog)object2).setPassword(string5);
                    ((IDialog)object2).setVisible(true);
                    object = ((IPasswordDialog)object2).getUsername();
                    string = ((IPasswordDialog)object2).getPassword();
                    if (object != null && string != null) {
                        object4 = ((String)object).trim() + ":" + string.trim();
                    } else {
                        this.ergText.setForeground(Color.red);
                        this.ergText.appendText("Fehler -------------\n");
                        this.ergText.appendText("Passwordeingabe unvollst\u00e4ndig\n");
                        return;
                    }
                }
            }
            object4 = Base64.encode((String)object4);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string3, ";");
        this.ergText.setText("");
        while (stringTokenizer.hasMoreTokens()) {
            object3 = stringTokenizer.nextToken().trim();
            boolean bl = false;
            if (((String)object3).endsWith("@")) {
                bl = true;
                object3 = ((String)object3).substring(0, ((String)object3).length() - 1);
            }
            this.ergText.setForeground(Color.black);
            try {
                Object object5;
                Object object6;
                Object object7;
                Object object8;
                int n;
                Object object9;
                Object object10;
                Object object11;
                this.image = null;
                object2 = new WmsGeoImage((String)object3, string2);
                object = new URL((String)object3);
                string = System.getProperty("proxyPW");
                String string6 = System.getProperty("nonProxyHosts");
                if ("true".equalsIgnoreCase(string)) {
                    boolean bl2 = true;
                    if (string6 != null) {
                        object11 = new StringTokenizer(string6, ", ");
                        while (((StringTokenizer)object11).hasMoreTokens()) {
                            object10 = ((StringTokenizer)object11).nextToken();
                            if (!((String)object10).equalsIgnoreCase(((URL)object).getHost())) continue;
                            bl2 = false;
                            break;
                        }
                    }
                    if (bl2 && string4 == null) {
                        object11 = new IPasswordDialog(this.getParentFrame(), "ProxyPasswort", "Bitte geben Sie das Passwort f\u00fcr den Proxyserver ein!");
                        ((IDialog)object11).setVisible(true);
                        object10 = ((IPasswordDialog)object11).getUsername();
                        object9 = ((IPasswordDialog)object11).getPassword();
                        if (object10 != null && object9 != null) {
                            string4 = Base64.encode(((String)object10).trim() + ":" + ((String)object9).trim());
                        }
                    }
                }
                this.ergText.appendText("Pr\u00fcfe Adresse: " + String.valueOf(object) + "\n");
                HttpURLConnection httpURLConnection = null;
                try {
                    httpURLConnection = (HttpURLConnection)((URL)object).openConnection();
                    httpURLConnection.setRequestProperty("User-Agent", KafPlotVersion.getUserAgent());
                    httpURLConnection.setRequestProperty("Accept-Charset", "UTF-8");
                }
                catch (Exception exception) {
                    throw new Exception("Ung\u00fcltige URL " + String.valueOf(object) + " ," + exception.getMessage());
                }
                try {
                    if (string4 != null) {
                        this.ergText.appendText("Setze Proxy-Authorization\n");
                        ((WmsGeoImage)object2).setProxyAuthorization(string4);
                        httpURLConnection.setRequestProperty("Proxy-Authorization", string4);
                    }
                }
                catch (Exception exception) {
                    throw new Exception("Proxy-Authorization fehlgeschlagen");
                }
                try {
                    if (object4 != null) {
                        this.ergText.appendText("Setze Server-Authorization\n");
                        ((WmsGeoImage)object2).setServerAuthorization((String)object4);
                        httpURLConnection.setRequestProperty("Authorization", "Basic " + (String)object4);
                    }
                }
                catch (Exception exception) {
                    throw new Exception("Server-Authorization fehlgeschlagen");
                }
                this.ergText.appendText("Stelle Verbindung her: " + String.valueOf(object) + "\n");
                try {
                    httpURLConnection.connect();
                    int n2 = httpURLConnection.getResponseCode();
                    if (n2 >= 300) {
                        object10 = null;
                        if (((String)object3).startsWith("http:")) {
                            object10 = "https:" + ((String)object3).substring(5);
                        } else if (((String)object3).startsWith("https:")) {
                            object10 = "http:" + ((String)object3).substring(6);
                        }
                        if (object10 != null) {
                            object = new URL((String)object10);
                            httpURLConnection = (HttpURLConnection)((URL)object).openConnection();
                            httpURLConnection.setRequestProperty("User-Agent", KafPlotVersion.getUserAgent());
                            if (string4 != null) {
                                httpURLConnection.setRequestProperty("Proxy-Authorization", string4);
                            }
                            if (object4 != null) {
                                httpURLConnection.setRequestProperty("Authorization", "Basic " + (String)object4);
                            }
                            httpURLConnection.connect();
                            if (httpURLConnection.getResponseCode() < 300) {
                                this.ergText.appendText("\n  !!! ResponseCode: " + n2 + " --> wechsle auf " + (String)object10 + "\n\n");
                                object3 = object10;
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    throw new Exception("Keine Verbindung zur URL " + String.valueOf(object) + " ," + exception.getMessage());
                }
                this.ergText.appendText("Verbindung hergestellt\n");
                object11 = (String)object3 + "?SERVICE=WMS&REQUEST=GetCapabilities&VERSION=1.1.1";
                object = new URL((String)object11);
                try {
                    httpURLConnection = (HttpURLConnection)((URL)object).openConnection();
                    httpURLConnection.setRequestProperty("User-Agent", KafPlotVersion.getUserAgent());
                    httpURLConnection.setRequestProperty("Accept-Charset", "UTF-8");
                    if (string4 != null) {
                        httpURLConnection.setRequestProperty("Proxy-Authorization", string4);
                    }
                    if (object4 != null) {
                        httpURLConnection.setRequestProperty("Authorization", "Basic " + (String)object4);
                    }
                }
                catch (Exception exception) {
                    throw new Exception("Ung\u00fcltige URL " + String.valueOf(object) + " ," + exception.getMessage());
                }
                try {
                    httpURLConnection.connect();
                }
                catch (Exception exception) {
                    throw new Exception("Keine Verbindung zur URL " + String.valueOf(object) + " ," + exception.getMessage());
                }
                this.ergText.appendText("Rufe Capabilities ab: " + String.valueOf(object) + "\n");
                object10 = httpURLConnection.getContentType();
                if (object10 != null && (n = ((String)object10).indexOf(";")) > 0) {
                    object10 = ((String)object10).substring(0, n);
                }
                if (object10 == null || !((String)object10).equals("application/vnd.ogc.wms_xml") && !((String)object10).equals("text/xml") && !((String)object10).equals("application/xml")) {
                    this.ergText.appendText("----------------------\n");
                    this.ergText.appendText("Ung\u00fcltiger Inhalt: " + (String)object10 + "\n");
                    LineNumberReader lineNumberReader = new LineNumberReader(new InputStreamReader((InputStream)new BufferedInputStream(httpURLConnection.getInputStream()), "UTF-8"));
                    object8 = null;
                    while ((object8 = lineNumberReader.readLine()) != null) {
                        this.ergText.appendText((String)object8 + "\n");
                    }
                    throw new Exception("Ung\u00fcltiger Inhalt: " + (String)object10);
                }
                object9 = new InputStreamReader((InputStream)new BufferedInputStream(httpURLConnection.getInputStream()), "UTF-8");
                object8 = new XMLElement();
                try {
                    ((XMLElement)object8).parseFromReader((Reader)object9);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    throw new Exception("Fehler bei der Auswertung des XML-Dokuments @GetCapability, Struktur nicht valid");
                }
                this.ergText.appendText("Werte Capabilities aus\n");
                XMLElement xMLElement = null;
                try {
                    xMLElement = ((XMLElement)object8).getChildren("Capability/Request/GetMap");
                }
                catch (Exception exception) {
                    throw new Exception("Fehler bei der Auswertung des XML-Dokuments @GetCapability, GetMap nicht gefunden");
                }
                this.ergText.appendText("   ImageFormate:\n");
                Object object12 = xMLElement.enumerateChildren();
                while (object12.hasMoreElements()) {
                    object7 = (XMLElement)object12.nextElement();
                    if (!((XMLElement)object7).getName().equals("Format")) continue;
                    ((WmsGeoImage)object2).addFormat(((XMLElement)object7).getContent());
                    this.ergText.appendText("      " + ((XMLElement)object7).getContent() + "\n");
                }
                if (!bl) {
                    object12 = xMLElement.getChildren("DCPType/HTTP/Get/OnlineResource");
                    this.ergText.appendText("   OnlineResource:\n");
                    if (object12 != null) {
                        object7 = ((XMLElement)object12).getStringAttribute("XLINK:HREF");
                        System.out.println("GMAP: " + (String)object7);
                        ((GeoImage)object2).setPathName((String)object7);
                        this.ergText.appendText("      " + (String)object7 + "\n");
                    }
                }
                object12 = ((XMLElement)object8).getChildren("Capability");
                this.extractLayers((XMLElement)object12, (WmsGeoImage)object2, "");
                this.ergText.appendText("   Systeme:\n");
                object7 = ((WmsGeoImage)object2).systems();
                while (object7.hasMoreElements()) {
                    this.ergText.appendText("      " + String.valueOf(object7.nextElement()) + "\n");
                }
                this.ergText.appendText("   Layer:\n");
                object7 = ((WmsGeoImage)object2).layers();
                while (object7.hasMoreElements()) {
                    this.ergText.appendText("      " + (String)object6 + (((WmsGeoImage)object2).isLayerQueryable((String)(object6 = object7.nextElement().toString())) ? "  (Abfragbar)" : "") + "\n");
                }
                object7 = null;
                try {
                    xMLElement = ((XMLElement)object8).getChildren("Capability/Request/GetFeatureInfo");
                    this.ergText.appendText("   GetFeatureInfoFormate:\n");
                    object6 = xMLElement.enumerateChildren();
                    while (object6.hasMoreElements()) {
                        object5 = (XMLElement)object6.nextElement();
                        if (!((XMLElement)object5).getName().equals("Format")) continue;
                        ((WmsGeoImage)object2).addQueryFormat(((XMLElement)object5).getContent());
                        this.ergText.appendText("      " + ((XMLElement)object5).getContent() + "\n");
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.ergText.appendText("Laden des WebMapService " + string2 + " vollst\u00e4ndig\n");
                ((WmsGeoImage)object2).setPreferedImageFormat(KafPlotProperties.getWmsOption(string2, "format"));
                object6 = KafPlotProperties.getWmsOption(string2, "res");
                try {
                    if (object6 != null) {
                        ((WmsGeoImage)object2).setResolution(Double.parseDouble((String)object6));
                    }
                }
                catch (Exception exception) {
                    throw new Exception("Ung\u00fcltige Angabe der Aufl\u00f6sung: " + (String)object6);
                }
                object5 = KafPlotProperties.getWmsOption(string2, "layer");
                if (object5 != null) {
                    Enumeration enumeration = ((WmsGeoImage)object2).layers();
                    while (enumeration.hasMoreElements()) {
                        ((WmsGeoImage)object2).setLayerVisible((String)enumeration.nextElement(), false);
                    }
                    enumeration = new StringTokenizer((String)object5, ":");
                    while (((StringTokenizer)enumeration).hasMoreTokens()) {
                        ((WmsGeoImage)object2).setLayerVisible(((StringTokenizer)enumeration).nextToken(), true);
                    }
                }
                this.image = object2;
                DataBase.addImage((GeoImage)object2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.ergText.setForeground(Color.red);
                this.ergText.appendText("Fehler -------------\n");
                this.ergText.appendText(exception.getMessage() + "\n");
            }
        }
    }

    private void extractLayers(XMLElement xMLElement, WmsGeoImage wmsGeoImage, String string) {
        if (xMLElement == null) {
            return;
        }
        String string2 = null;
        Object object = null;
        String string3 = null;
        String string4 = null;
        boolean bl = false;
        boolean bl2 = false;
        Enumeration enumeration = xMLElement.enumerateChildren();
        while (enumeration.hasMoreElements()) {
            Object object2;
            XMLElement xMLElement2 = (XMLElement)enumeration.nextElement();
            String string5 = xMLElement.getStringAttribute("queryable");
            if ("1".equals(string5)) {
                bl2 = true;
            }
            if (xMLElement2.getName().equals("SRS") || xMLElement2.getName().equals("CRS")) {
                wmsGeoImage.addSystem(xMLElement2.getContent());
                continue;
            }
            if (xMLElement2.getName().equals("Title")) {
                object = xMLElement2.getContent();
                if (string.length() <= 0) continue;
                object = string + "." + (String)object;
                continue;
            }
            if (xMLElement2.getName().equals("Abstract")) {
                string3 = xMLElement2.getContent();
                continue;
            }
            if (xMLElement2.getName().equals("Name")) {
                string2 = xMLElement2.getContent();
                continue;
            }
            if (xMLElement2.getName().equals("Layer")) {
                this.extractLayers(xMLElement2, wmsGeoImage, (String)(object != null ? object : ""));
                bl = true;
                continue;
            }
            if (xMLElement2.getName().equals("BoundingBox")) {
                if (DataBase.getState() > 0 || (object2 = xMLElement2.getStringAttribute("SRS")) == null) continue;
                if (((String)object2).equals("EPSG:325833")) {
                    DataBase.ymin = xMLElement2.getDoubleAttribute("minx");
                    DataBase.ymax = xMLElement2.getDoubleAttribute("maxx");
                    DataBase.xmin = xMLElement2.getDoubleAttribute("miny");
                    DataBase.xmax = xMLElement2.getDoubleAttribute("maxy");
                } else if (((String)object2).startsWith("EPSG:258")) {
                    int n = ((String)object2).length();
                    double d = (double)Integer.parseInt(((String)object2).substring(n - 1, n)) * 1000000.0;
                    DataBase.ymin = xMLElement2.getDoubleAttribute("minx") + d;
                    DataBase.ymax = xMLElement2.getDoubleAttribute("maxx") + d;
                    DataBase.xmin = xMLElement2.getDoubleAttribute("miny");
                    DataBase.xmax = xMLElement2.getDoubleAttribute("maxy");
                }
                DataBase.setKooSystem(489);
                continue;
            }
            if (!xMLElement2.getName().equals("LegendURL") || (object2 = xMLElement2.getChildren("OnlineResource")) == null) continue;
            string4 = ((XMLElement)object2).getStringAttribute("xlink:href");
        }
        if (string2 != null && !bl) {
            wmsGeoImage.addLayer(string2, (String)object, string3, string4, bl2, true);
        }
    }

    @Override
    protected void doAbortAction() {
        this.endDialog();
    }

    private String createAddress(int n) {
        String string = "127.0.0.1";
        try {
            string = InetAddress.getLocalHost().getHostAddress();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "http://" + string + ":" + Integer.toString(n) + "/";
    }
}

