/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.geom.DPoint;
import de.geocalc.kafplot.PropertyLoader;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class LokalTransform {
    private static Vector systems = new Vector();
    private int nr;
    private String name = null;
    private double dy;
    private double dx;
    private double rot;
    private double m;
    private double sr;
    private double cr;

    private LokalTransform() {
    }

    public LokalTransform(double d, double d2, double d3, double d4) {
        this.dy = d;
        this.dx = d2;
        this.rot = d3;
        this.m = d4;
        this.computeParam();
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public double getDx() {
        return this.dx;
    }

    public double getDy() {
        return this.dy;
    }

    public double getRotation() {
        return this.rot;
    }

    public double getScale() {
        return this.m;
    }

    public void computeParam() {
        this.sr = Math.sin(this.rot);
        this.cr = Math.cos(this.rot);
    }

    public void transform(DPoint dPoint) {
        double d = this.m * (dPoint.x * this.cr + dPoint.y * this.sr) + this.dx;
        double d2 = this.m * (dPoint.y * this.cr - dPoint.x * this.sr) + this.dy;
        dPoint.x = d;
        dPoint.y = d2;
    }

    public void inverse(DPoint dPoint) {
        double d = ((dPoint.x - this.dx) * this.cr - (dPoint.y - this.dy) * this.sr) / this.m;
        double d2 = ((dPoint.y - this.dy) * this.cr + (dPoint.x - this.dx) * this.sr) / this.m;
        dPoint.x = d;
        dPoint.y = d2;
    }

    public String toString() {
        return this.nr + " = " + this.dy + " ; " + this.dx + " ; " + this.rot + " ; " + this.m + " ; " + this.name;
    }

    public static void load(InputStream inputStream) throws IOException {
        LineNumberReader lineNumberReader = null;
        Hashtable<Object, Object> hashtable = new Hashtable<Object, Object>();
        Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
        try {
            String string;
            lineNumberReader = PropertyLoader.createReader(inputStream);
            Object var5_4 = null;
            Object var6_5 = null;
            while ((string = lineNumberReader.readLine()) != null) {
                Object object;
                if (string.length() == 0 || string.charAt(0) == '#') continue;
                LokalTransform lokalTransform = new LokalTransform();
                int n = string.indexOf(61);
                if (n <= 0) {
                    throw new Exception("fehlendes Trennzeichen '='");
                }
                lokalTransform.nr = Integer.parseInt(string.substring(0, n).trim());
                StringTokenizer stringTokenizer = new StringTokenizer(string.substring(n + 1), ";");
                int n2 = 0;
                while (stringTokenizer.hasMoreTokens()) {
                    object = stringTokenizer.nextToken().trim();
                    if (n2 == 0) {
                        lokalTransform.dy = new Double((String)object);
                    } else if (n2 == 1) {
                        lokalTransform.dx = new Double((String)object);
                    } else if (n2 == 2) {
                        lokalTransform.rot = new Double((String)object);
                    } else if (n2 == 3) {
                        lokalTransform.m = new Double((String)object);
                    } else {
                        if (n2 != 4) break;
                        lokalTransform.name = object;
                    }
                    ++n2;
                }
                if (hashtable.get(object = new Integer(lokalTransform.nr)) != null) {
                    throw new Exception("Systemnummer " + (Integer)object + " mehrfach vergeben");
                }
                hashtable.put(object, object);
                String string2 = lokalTransform.name;
                if (hashtable2.get(string2) != null) {
                    throw new Exception("Systemname " + string2 + " mehrfach vergeben");
                }
                hashtable2.put(string2, string2);
                lokalTransform.computeParam();
                systems.addElement(lokalTransform);
            }
        }
        catch (Exception exception) {
            throw new IOException("Fehler in Zeile: " + (lineNumberReader != null ? lineNumberReader.getLineNumber() : 0) + "\n" + exception.getMessage());
        }
    }

    public static Enumeration elements() {
        return systems.elements();
    }

    public static LokalTransform get(String string) {
        Enumeration enumeration = systems.elements();
        while (enumeration.hasMoreElements()) {
            LokalTransform lokalTransform = (LokalTransform)enumeration.nextElement();
            if (!string.equals(lokalTransform.name)) continue;
            return lokalTransform;
        }
        return null;
    }
}

