/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.IButton;
import de.geocalc.awt.ICheckboxButton;
import de.geocalc.awt.ICheckboxButtonGroup;
import de.geocalc.awt.ISeparator;
import de.geocalc.awt.IToolBar;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.KafPlotCommand;
import de.geocalc.kafplot.KafPlotProperties;
import de.geocalc.kafplot.KafPlotVersion;

public class MainToolBar
extends IToolBar
implements KafPlotCommand {
    protected IButton newButton;
    protected IButton openButton;
    protected IButton reloadButton;
    protected IButton closeButton;
    protected IButton importButton;
    protected IButton exportButton;
    protected IButton trafoButton;
    protected ICheckboxButton modPunktartButton;
    protected ICheckboxButton modAufnahmeButton;
    protected ICheckboxButton modOrthoButton;
    protected ICheckboxButton modConditionButton;
    protected ICheckboxButton modFlaecheButton;
    protected ICheckboxButton modPunktnrButton;
    protected ICheckboxButton modMaszeButton;
    protected ICheckboxButton modGitterButton;
    protected ICheckboxButton modBemerkungButton;
    protected ICheckboxButton modImageButton;
    protected ICheckboxButton modEllipseButton;
    protected ICheckboxButtonGroup toolGroup;

    public MainToolBar() {
        this.createLayout();
    }

    protected void createLayout() {
        if (KafPlotVersion.progVersion != 10) {
            this.add(new ISeparator(1));
            this.newButton = this.createIButton(101, "Neues Projekt");
            this.add(this.newButton);
            this.openButton = this.createIButton(102, "\u00d6ffnen");
            this.add(this.openButton);
            this.reloadButton = this.createIButton(103, "Nachladen");
            this.add(this.reloadButton);
            this.closeButton = this.createIButton(107, "Schlie\u00dfen");
            this.add(this.closeButton);
            this.importButton = this.createIButton(104, "Importieren");
            this.add(this.importButton);
            this.exportButton = this.createIButton(105, "Exportieren");
            this.add(this.exportButton);
            if (KafPlotProperties.isTransformerDef()) {
                this.trafoButton = this.createIButton(108, "Etrs-Transformation");
                this.add(this.trafoButton);
            }
        }
        this.add(new ISeparator(1));
        this.modPunktartButton = this.createICheckboxButton(201, "Punktarten", KafPlotProperties.isPunktArtVisible());
        this.add(this.modPunktartButton);
        this.modAufnahmeButton = this.createICheckboxButton(202, "Aufnahmepfeile", KafPlotProperties.isAufnahmeVisible());
        this.add(this.modAufnahmeButton);
        this.modOrthoButton = this.createICheckboxButton(203, "Messungslinien", KafPlotProperties.isOrthoVisible());
        this.add(this.modOrthoButton);
        this.modConditionButton = this.createICheckboxButton(204, "Bedingungen", KafPlotProperties.isConditionVisible());
        this.add(this.modConditionButton);
        this.modFlaecheButton = this.createICheckboxButton(205, "Objekte", KafPlotProperties.isFlaecheVisible());
        this.add(this.modFlaecheButton);
        this.modPunktnrButton = this.createICheckboxButton(206, "Punktbeschriftung", KafPlotProperties.isPunktTextVisible());
        this.add(this.modPunktnrButton);
        this.modMaszeButton = this.createICheckboxButton(207, "Ma\u00dfzahlen", KafPlotProperties.isMaszeVisible());
        this.add(this.modMaszeButton);
        this.modBemerkungButton = this.createICheckboxButton(210, "Bemerkungen", KafPlotProperties.isBemerkungVisible());
        this.add(this.modBemerkungButton);
        if (KafPlotVersion.isSigned("GeoImage.class")) {
            this.modImageButton = this.createICheckboxButton(211, "Images", KafPlotProperties.isImagesVisible());
            this.add(this.modImageButton);
        }
        this.modGitterButton = this.createICheckboxButton(209, "Gitternetz", KafPlotProperties.isGitterVisible());
        this.add(this.modGitterButton);
        this.modEllipseButton = this.createICheckboxButton(208, "Ellipsen", KafPlotProperties.isEllipseVisible());
        this.add(this.modEllipseButton);
    }

    public void setLayoutOfProperties() {
        this.modPunktartButton.setState(KafPlotProperties.isPunktArtVisible());
        this.modAufnahmeButton.setState(KafPlotProperties.isAufnahmeVisible());
        this.modOrthoButton.setState(KafPlotProperties.isOrthoVisible());
        this.modConditionButton.setState(KafPlotProperties.isConditionVisible());
        this.modFlaecheButton.setState(KafPlotProperties.isFlaecheVisible());
        this.modPunktnrButton.setState(KafPlotProperties.isPunktTextVisible());
        this.modEllipseButton.setState(KafPlotProperties.isEllipseVisible());
        this.modMaszeButton.setState(KafPlotProperties.isMaszeVisible());
        this.modGitterButton.setState(KafPlotProperties.isGitterVisible());
        this.modBemerkungButton.setState(KafPlotProperties.isBemerkungVisible());
        if (this.modImageButton != null) {
            this.modImageButton.setState(KafPlotProperties.isImagesVisible());
        }
        int n = DataBase.getState();
        if (this.reloadButton != null) {
            this.reloadButton.setEnabled(n >= 0);
        }
        if (this.closeButton != null) {
            this.closeButton.setEnabled(n >= 0);
        }
        if (this.exportButton != null) {
            this.exportButton.setEnabled(n >= 0);
        }
        if (this.trafoButton != null) {
            this.trafoButton.setEnabled(n >= 0);
        }
        this.modPunktartButton.setEnabled(n >= 0);
        this.modAufnahmeButton.setEnabled(n == 3);
        this.modOrthoButton.setEnabled(n == 3);
        this.modConditionButton.setEnabled(n == 3);
        this.modFlaecheButton.setEnabled(n == 3);
        this.modPunktnrButton.setEnabled(n >= 0);
        this.modEllipseButton.setEnabled(n >= 0);
        this.modMaszeButton.setEnabled(n == 3);
        this.modGitterButton.setEnabled(n >= 0);
        this.modBemerkungButton.setEnabled(n >= 0);
        if (this.modImageButton != null) {
            this.modImageButton.setEnabled(DataBase.hasImages());
        }
    }
}

