/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.IGraphics;
import de.geocalc.awt.IViewport;
import de.geocalc.geom.DDimension;
import de.geocalc.geom.DLine;
import de.geocalc.geom.DPoint;
import de.geocalc.geom.DRectangle;
import de.geocalc.io.DxfConstants;
import de.geocalc.io.DxfFileWriter;
import de.geocalc.kafplot.DatObject;
import de.geocalc.kafplot.Drawable;
import de.geocalc.kafplot.Ebene;
import de.geocalc.kafplot.IdentitaetUtil;
import de.geocalc.kafplot.KafPlotColor;
import de.geocalc.kafplot.KafPlotProperties;
import de.geocalc.kafplot.Message;
import de.geocalc.kafplot.Messager;
import de.geocalc.kafplot.MessungGewicht;
import de.geocalc.kafplot.Punkt;
import de.geocalc.kafplot.PunktArt;
import de.geocalc.kafplot.PunktContainer;
import de.geocalc.kafplot.PunktNummer;
import de.geocalc.kafplot.PunktTable;
import de.geocalc.kafplot.Riss;
import de.geocalc.kafplot.Stat;
import de.geocalc.kafplot.StatElement;
import de.geocalc.kafplot.Symbol;
import de.geocalc.kafplot.TagObject;
import de.geocalc.kafplot.Text;
import de.geocalc.kafplot.TextArt;
import de.geocalc.kafplot.TextSymbol;
import de.geocalc.kafplot.io.KafPlotIOConstants;
import de.geocalc.kafplot.io.dat.KafkaIOProperties;
import de.geocalc.kafplot.io.kpv.KpvIOProperties;
import de.geocalc.kafplot.io.xml.XmlIOProperties;
import de.geocalc.lang.Control;
import de.geocalc.lang.Exceptionable;
import de.geocalc.text.DecimalFormat;
import de.geocalc.text.GeoNumberFormat;
import de.geocalc.text.IFormat;
import de.geocalc.util.sml.Tag;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class Messung
implements Cloneable,
PunktContainer,
Exceptionable,
Drawable,
Control,
Messager,
DatObject,
TagObject,
StatElement {
    public static final BasicStroke STROKE_ORTHO = new BasicStroke(1.0f, 1, 2, 0.0f, new float[]{8.0f, 4.0f}, 0.0f);
    public static final BasicStroke STROKE_POLAR = new BasicStroke(1.0f, 1, 2, 0.0f, new float[]{1.0f, 4.0f, 14.0f, 4.0f}, 0.0f);
    public static final int SYMBOL = -1;
    public static final int LAGE = 2;
    public static final int HOEHE = 3;
    public static final int DIGIT = 4;
    public static final int KOMMENTAR = -500;
    public static final int POLAR_LINIE = -200;
    public static final int ORTHO_LINIE = -100;
    public static final int UNDEF = 0;
    public static final int ORTHO_PUNKT = 200;
    public static final int ORTHO_ANFANG = 210;
    public static final int STRECKE = 220;
    public static final int POLARAUFNAHME = 230;
    public static final int STREBE = 240;
    public static final int FEHLER = 250;
    public static final int BOGENSCHLAG = 260;
    public static final int KOORDINATENDIFFERENZ = 270;
    public static final int ORIENTIERTE_RICHTUNG = 280;
    public static final int ORTHO_ENDE = 290;
    public static final int HOEHE_GEOM = 310;
    public static final int HOEHE_TRIG = 320;
    public static final int HOEHE_ZENIT = 330;
    public static final int DIGIT_SYS = 410;
    public static final int DIGIT_KOO = 420;
    public static final int OHNE = 0;
    public static final int L1 = 1;
    public static final int L2 = 2;
    public static final int BEIDE = 3;
    public static final String TAG_NO = "NO";
    public static final String TAG_NO1 = "NO1";
    public static final String TAG_NO2 = "NO2";
    protected static final DecimalFormat d43 = new DecimalFormat("0000.000");
    protected static final DecimalFormat d52 = new DecimalFormat("00000.00");
    protected static final DecimalFormat d11 = new DecimalFormat("0.0");
    protected static final DecimalFormat d13 = new DecimalFormat("0.000");
    protected static final DecimalFormat d03 = new DecimalFormat("#0.000");
    private static final int FLAG_EINBINDUNG = 2;
    private static final int FLAG_BEFORE = 4;
    private static final int FLAG_AFTER = 8;
    private static final int FLAG_ON = 16;
    private static Color defaultColor;
    public int ma = 0;
    public int eMa = 0;
    public Punkt ps;
    public Punkt pz;
    public double l1;
    public double l2;
    public int mNr;
    public int flags = 0;
    private String bemerkung = null;
    private MessungGewicht gewichte;
    private Stat stat;
    private Messung referenz;
    private Riss riss;
    private static final double S_LIM = 1.0;
    private static final int RW = 5;
    private static final int RW2 = 2;
    private static final int PFT = 10;
    private static final int PFL = 30;
    private static final int PFB = 3;
    private static final int R = 4;
    private static final int PRW = 3;
    private static final int PRW2 = 2;
    private static final int PPFT = 7;
    private static final int PPFL = 20;
    private static final int PPFB = 2;
    private static final int PR = 3;
    private static final Text mass;
    private static final TextArt ta;
    private static final TextSymbol sym;
    private static final Point gpt;
    private static final int GFT = 10;
    private static final int GFB = 4;
    private static final int GRT = 15;
    private static final int GRB = 6;
    private static final int PGFT = 8;
    private static final int PGFB = 3;
    private static final int PGRT = 12;
    private static final int PGRB = 5;

    public static void setDefaultColor(Color color) {
        defaultColor = color;
    }

    public void setEinbindeMass(boolean bl) {
        this.flags = bl ? (this.flags |= 2) : (this.flags &= 0xFFFFFFFD);
    }

    public boolean isEinbindeMass() {
        return (this.flags & 2) != 0;
    }

    public void setBefore(boolean bl) {
        this.flags = bl ? (this.flags |= 4) : (this.flags &= 0xFFFFFFFB);
    }

    public boolean isBefore() {
        return (this.flags & 4) != 0;
    }

    public void setAfter(boolean bl) {
        this.flags = bl ? (this.flags |= 8) : (this.flags &= 0xFFFFFFF7);
    }

    public boolean isAfter() {
        return (this.flags & 8) != 0;
    }

    @Override
    public void setOn(boolean bl) {
        this.flags = bl ? (this.flags |= 0x10) : (this.flags &= 0xFFFFFFEF);
    }

    @Override
    public boolean isOn() {
        return (this.flags & 0x10) != 0;
    }

    public Messung() {
        this(0, null, null, 0.0, 0.0);
    }

    public Messung(int n) {
        this(n, null, null, 0.0, 0.0);
    }

    public Messung(int n, Punkt punkt, Punkt punkt2) {
        this(n, punkt, punkt2, 0.0, 0.0);
    }

    public Messung(Messung messung) {
        this(messung.ma, messung.ps, messung.pz, messung.l1, messung.l2);
    }

    public Messung(int n, Punkt punkt, Punkt punkt2, double d, double d2) {
        this(n, punkt, punkt2, d, d2, 0, null);
    }

    public Messung(int n, Punkt punkt, Punkt punkt2, double d, double d2, int n2) {
        this(n, punkt, punkt2, d, d2, n2, null);
    }

    public Messung(int n, Punkt punkt, Punkt punkt2, double d, double d2, int n2, MessungGewicht messungGewicht) {
        this.setMessungsArt(n);
        this.ps = punkt;
        this.pz = punkt2;
        this.l1 = d;
        this.l2 = d2;
        this.setWerteBelegung(n2);
        this.setGewichte(messungGewicht);
        this.setOn(true);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public Punkt getP1() {
        return this.ps == null ? this.referenz.ps : this.ps;
    }

    public Punkt getP2() {
        return this.pz;
    }

    public int getMessungsGroup() {
        return this.getMessungsArt() / 100;
    }

    public void setArt(int n, int n2) {
        this.ma = n + n2;
    }

    public void setMessungsArt(int n) {
        this.ma = n + this.getWerteBelegung();
    }

    public int getMessungsArt() {
        return this.ma - this.getWerteBelegung();
    }

    public int getMessungsTyp() {
        return this.eMa != 0 ? this.eMa : this.ma - this.getWerteBelegung();
    }

    public boolean hasReferenz() {
        return this.referenz != null;
    }

    public void setReferenz(Messung messung) {
        this.referenz = messung;
    }

    public Messung getReferenz() {
        return this.referenz;
    }

    public boolean hasGewichte() {
        return this.gewichte != null;
    }

    public void setGewichte(MessungGewicht messungGewicht) {
        this.gewichte = messungGewicht;
    }

    public MessungGewicht getGewichte() {
        return this.gewichte;
    }

    public float getAverageGewicht() {
        if (this.gewichte == null) {
            return 1.0f;
        }
        switch (this.getMessungsArt(false)) {
            case -200: 
            case 230: 
            case 270: 
            case 280: {
                return (float)((double)(this.gewichte.getG1() + this.gewichte.getG2()) / 2.0);
            }
            case 220: 
            case 260: {
                return this.gewichte.getG1();
            }
            case 240: {
                return this.gewichte.getG2();
            }
            case -100: 
            case 200: 
            case 210: 
            case 290: {
                return (float)((double)(this.gewichte.getG1() + this.gewichte.getG2() + this.gewichte.getG3() + this.gewichte.getG4()) / 4.0);
            }
        }
        return 1.0f;
    }

    @Override
    public boolean hasStatistik() {
        return this.stat != null;
    }

    @Override
    public void setStatistik(Stat stat) {
        this.stat = stat;
    }

    @Override
    public Stat getStatistik() {
        return this.stat;
    }

    public void setContainer(Riss riss) {
        this.riss = riss;
    }

    public Riss getContainer() {
        return this.riss;
    }

    @Override
    public final boolean hasBemerkung() {
        return this.bemerkung != null;
    }

    @Override
    public final void setBemerkung(String string) {
        this.bemerkung = string;
    }

    @Override
    public final void addBemerkung(String string) {
        this.bemerkung = this.bemerkung == null ? string : this.bemerkung + string;
    }

    @Override
    public final void addTag(String string) {
        this.bemerkung = this.bemerkung == null ? string : string + this.bemerkung;
    }

    @Override
    public final boolean hasTag(String string) {
        return this.bemerkung != null && Tag.hasTag(this.bemerkung, string);
    }

    @Override
    public final String getBemerkung() {
        return this.bemerkung;
    }

    @Override
    public final String getBemerkungText() {
        if (this.bemerkung == null) {
            return null;
        }
        if (Tag.hasTag(this.bemerkung)) {
            return Tag.parseText(this.bemerkung);
        }
        return this.bemerkung;
    }

    public boolean hasText() {
        return this.bemerkung != null && this.getText() != null;
    }

    public String getText() {
        return this.getBemerkungText();
    }

    public int getMessungsArtIgnoreErr() {
        return this.isFehler() ? this.eMa : this.getMessungsArt();
    }

    public int getMessungsArt(boolean bl) {
        if (!this.isFehler()) {
            return this.getMessungsArt();
        }
        if (!bl) {
            return this.eMa;
        }
        switch (this.eMa) {
            case 210: 
            case 290: {
                return 200;
            }
        }
        return this.eMa;
    }

    public void setWerteBelegung(int n) {
        this.ma = this.getMessungsArt() + n;
    }

    public int getWerteBelegung() {
        return this.ma - this.ma / 10 * 10;
    }

    public Punkt getFussPunkt() {
        if (this.pz != null && this.pz.nr != 0L) {
            return this.pz;
        }
        if (this.l2 == 0.0) {
            return this.ps;
        }
        return null;
    }

    public PolarMessungHashKey getPolarMessungHashKey(Punkt punkt) {
        return new PolarMessungHashKey(this, punkt, this.pz);
    }

    public boolean equals(Messung messung) {
        if (messung.getMessungsArt() != this.getMessungsArt()) {
            return false;
        }
        return messung.ps == this.ps && messung.pz == this.pz;
    }

    public boolean equalsIgnoreChange(Messung messung) {
        if (this.equals(messung)) {
            return true;
        }
        return messung.ps == this.pz && messung.pz == this.ps;
    }

    public boolean isFehler() {
        return this.eMa != 0;
    }

    @Override
    public boolean contains(Punkt punkt) {
        return this.ps != null && this.ps.nr == punkt.nr || this.pz != null && this.pz.nr == punkt.nr;
    }

    @Override
    public PunktTable getPunkte() {
        PunktTable punktTable = new PunktTable();
        if (this.ps != null) {
            punktTable.put(this.ps);
        }
        if (this.pz != null) {
            punktTable.put(this.pz);
        }
        return punktTable;
    }

    public DPoint getCatchPoint() {
        return this.getHashPoint();
    }

    @Override
    public DPoint getHashPoint() {
        switch (this.getMessungsArt(false)) {
            case 230: 
            case 270: 
            case 280: {
                Punkt punkt;
                Punkt punkt2 = this.ps != null ? this.ps : (punkt = this.referenz.ps != null ? this.referenz.ps : null);
                if (punkt == null) {
                    return this.pz;
                }
                double d = Math.sqrt((punkt.x - this.pz.x) * (punkt.x - this.pz.x) + (punkt.y - this.pz.y) * (punkt.y - this.pz.y));
                return new DPoint(this.pz.y + (punkt.y - this.pz.y) / d * 0.05 * (double)(this.mNr + 1), this.pz.x + (punkt.x - this.pz.x) / d * 0.05 * (double)(this.mNr + 1));
            }
            case 220: 
            case 240: 
            case 260: {
                return DPoint.getMiddle(this.ps, this.pz);
            }
            case 200: 
            case 210: 
            case 290: {
                if (this.l2 == 0.0) {
                    Punkt punkt = this.referenz.ps != null ? this.referenz.ps : this.referenz.pz;
                    double d = Math.sqrt((punkt.x - this.ps.x) * (punkt.x - this.ps.x) + (punkt.y - this.ps.y) * (punkt.y - this.ps.y));
                    return new DPoint(this.ps.y + (punkt.y - this.ps.y) / d * 0.05, this.ps.x + (punkt.x - this.ps.x) / d * 0.05);
                }
                return this.pz == null ? this.ps : DPoint.getMiddle(this.ps, this.pz);
            }
        }
        return this.ps != null ? this.ps : this.pz;
    }

    @Override
    public Message getMessage() {
        String string = this.getExceptionableName();
        StringBuffer stringBuffer = new StringBuffer(string);
        StringBuffer stringBuffer2 = new StringBuffer(string);
        int n = this.getWerteBelegung();
        switch (this.getMessungsArt(false)) {
            case 230: {
                if (n == 1 || n == 3) {
                    stringBuffer2.append(" r = ");
                    stringBuffer2.append(IFormat.f_4.format(this.l1));
                }
                if (n != 2 && n != 3) break;
                stringBuffer2.append(" s = ");
                stringBuffer2.append(IFormat.f_3.format(this.l2));
                break;
            }
            case 270: {
                stringBuffer2.append(" dy = ");
                stringBuffer2.append(IFormat.f_3.format(this.l1));
                stringBuffer2.append(" dx = ");
                stringBuffer2.append(IFormat.f_3.format(this.l2));
                break;
            }
            case 280: {
                stringBuffer2.append(" t = ");
                stringBuffer2.append(IFormat.f_4.format(this.l1));
                break;
            }
            case 220: {
                stringBuffer2.append(" s = ");
                stringBuffer2.append(IFormat.f_2.format(this.l1));
                break;
            }
            case 260: {
                stringBuffer2.append(" s1 = ");
                stringBuffer2.append(IFormat.f_2.format(this.l1));
                if (!this.hasReferenz()) break;
                stringBuffer2.append(" s2 = ");
                stringBuffer2.append(IFormat.f_2.format(this.referenz.l1));
                break;
            }
            case 240: {
                stringBuffer2.append(" a = ");
                stringBuffer2.append(IFormat.f_2.format(this.l1));
                stringBuffer2.append(" s = ");
                stringBuffer2.append(IFormat.f_2.format(this.l2));
                break;
            }
            case 200: 
            case 210: 
            case 290: {
                if (n == 0) {
                    stringBuffer2.append("  --");
                    break;
                }
                if (n == 1 || n == 3) {
                    stringBuffer2.append(" a = ");
                    stringBuffer2.append(IFormat.f_4.format(this.l1));
                }
                if (n != 2 && n != 3) break;
                stringBuffer2.append(" o = ");
                stringBuffer2.append(IFormat.f_3.format(this.l2));
            }
        }
        if (!this.isOn()) {
            stringBuffer.append(" (aus)");
            stringBuffer2.append(" (aus)");
        }
        String string2 = null;
        int n2 = KafPlotProperties.getColorMessSwitch();
        if (n2 == 2003) {
            string2 = "Riss=" + this.getContainer().getName();
        } else if (n2 == 2004) {
            string2 = "GW=" + IFormat.f_2.format(this.getAverageGewicht());
        } else if (n2 == 2011 && this.stat != null) {
            string2 = "V=" + IFormat.f_3.format((double)this.stat.getSumV() * 0.001) + "m";
        } else if (n2 == 2012 && this.stat != null) {
            string2 = "SaV=" + IFormat.f_3.format((double)this.stat.getMaxSaV() * 0.001) + "m";
        } else if (n2 == 2013 && this.stat != null) {
            string2 = "V-SaV=" + IFormat.f_3.format((double)(this.stat.getSumV() - this.stat.getSumSaV()) * 0.001) + "m";
        } else if (n2 == 2014 && this.stat != null) {
            string2 = "EV=" + this.stat.getMidEv() + "%";
        } else if (n2 == 2015 && this.stat != null) {
            string2 = "EP=" + IFormat.f_3.format((double)this.stat.getSumEp() * 0.001) + "m";
        } else if (n2 == 2016 && this.stat != null) {
            string2 = "NV=" + IFormat.f_1.format((double)this.stat.getMaxNv() * 0.1);
        } else if (n2 == 2017 && this.stat != null) {
            string2 = "GF=" + IFormat.f_3.format((double)this.stat.getSumGf() * 0.001) + "m";
        } else if (n2 == 2018 && this.stat != null) {
            string2 = "GRZW=" + IFormat.f_3.format((double)this.stat.getMaxGrzw() * 0.001) + "m";
        } else if (n2 == 2019 && this.stat != null) {
            string2 = "EGK=" + IFormat.f_3.format((double)this.stat.getMaxEgk() * 0.001) + "m";
        }
        if (string2 != null) {
            stringBuffer.append("   ");
            stringBuffer2.append("   ");
            stringBuffer.append(string2);
            stringBuffer2.append(string2);
        }
        return new Message(this, stringBuffer.toString(), stringBuffer2.toString());
    }

    @Override
    public final String getClassName() {
        switch (this.getMessungsArt(false)) {
            case 230: {
                return "Polaraufnahme";
            }
            case 270: {
                return "Koordinatendifferenz";
            }
            case 280: {
                return "Orientierte Richtung";
            }
            case 220: {
                return "Messbandstrecke";
            }
            case 260: {
                return "Bogenschlag";
            }
            case 240: {
                return "Strebe";
            }
            case 210: {
                return "Linienanfang";
            }
            case 200: {
                switch (this.getWerteBelegung()) {
                    case 0: {
                        return "Durchfluchtung";
                    }
                    case 1: {
                        return "Linienpunkt";
                    }
                }
                return "Aufwinklung";
            }
            case 290: {
                return "Linienende";
            }
        }
        return "Messung";
    }

    @Override
    public final String getObjectName() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.ps != null && this.ps.nr != 0L) {
            stringBuffer.append(IFormat.i.format(this.ps.nr).toString());
        } else if (this.ps == null && this.referenz != null && this.referenz.ps != null) {
            stringBuffer.append(IFormat.i.format(this.referenz.ps.nr));
        }
        if (this.pz != null && this.pz.nr != 0L) {
            stringBuffer.append("-");
            stringBuffer.append(IFormat.i.format(this.pz.nr).toString());
        }
        return stringBuffer.toString();
    }

    @Override
    public String getExceptionableName() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClassName());
        stringBuffer.append(": ");
        stringBuffer.append(this.getObjectName());
        return stringBuffer.toString();
    }

    @Override
    public final String toDebugString() {
        return this.getExceptionableName();
    }

    public final String getFormatedPunktName(int n) {
        switch (this.getMessungsArt(false)) {
            case 230: 
            case 270: 
            case 280: {
                return n == 1 ? "Standpunkt" : "Zielpunkt";
            }
            case 220: {
                return n == 1 ? "1.Punkt" : "2.Punkt";
            }
            case 260: {
                return n == 1 ? "1.Punkt" : "Schnittpunkt";
            }
            case 240: {
                return n == 1 ? "Abzissenpunkt" : "Strebenpunkt";
            }
            case 210: {
                if (n == 1) {
                    return this.l2 == 0.0 ? "Anfangspunkt" : "Kleinpunkt";
                }
                return this.l2 != 0.0 ? "Anfangsfu\u00dfpunkt" : "";
            }
            case 200: {
                if (n == 1) {
                    if (this.l1 == 0.0) {
                        return "Fluchtpunkt";
                    }
                    return "Kleinpunkt";
                }
                return this.l2 != 0.0 ? "Fu\u00dfpunkt" : "";
            }
            case 290: {
                if (n == 1) {
                    return this.l2 == 0.0 ? "Endpunkt" : "Kleinpunkt";
                }
                return this.l2 != 0.0 ? "Endfu\u00dfpunkt" : "";
            }
        }
        return "";
    }

    public final String getFormatedValue(int n) {
        switch (this.getMessungsArt(false)) {
            case 230: {
                return n == 1 ? IFormat.f_4.format(this.l1) : IFormat.f_3.format(this.l2);
            }
            case 270: {
                return IFormat.f_4.format(n == 1 ? this.l1 : this.l2);
            }
            case 280: {
                return n == 1 ? IFormat.f_4.format(this.l1) : "";
            }
            case 220: 
            case 260: {
                return n == 1 ? IFormat.f_2.format(this.l1) : "";
            }
            case 240: {
                return n == 1 ? IFormat.f_2.format(this.l1) : IFormat.f_2.format(this.l2);
            }
            case 200: 
            case 210: 
            case 290: {
                switch (this.getWerteBelegung()) {
                    case 0: {
                        return "";
                    }
                    case 1: {
                        return n == 1 ? IFormat.f_2.format(this.l1) : "";
                    }
                    case 2: {
                        return n == 2 ? IFormat.f_2.format(this.l2) : "";
                    }
                    case 3: {
                        return n == 1 ? IFormat.f_2.format(this.l1) : IFormat.f_2.format(this.l2);
                    }
                }
            }
        }
        return "";
    }

    public final String getFormatedValueName(int n) {
        switch (this.getMessungsArt(false)) {
            case 230: {
                return n == 1 ? "Richtung" : "Strecke";
            }
            case 270: {
                return n == 1 ? "Y-Differenz" : "X-Differenz";
            }
            case 280: {
                return n == 1 ? "orientierte Richtung" : "";
            }
            case 220: 
            case 260: {
                return n == 1 ? "Spannma\u00df" : "";
            }
            case 240: {
                return n == 1 ? "Abszisse" : "Strebe";
            }
            case 200: 
            case 210: 
            case 290: {
                return n == 1 ? "Abzisse" : "Ordinate";
            }
        }
        return "";
    }

    public final String getFormatedDimension(int n) {
        switch (this.getMessungsArt(false)) {
            case 230: {
                return n == 1 ? "gon" : "m";
            }
            case 280: {
                return "gon";
            }
        }
        return "m";
    }

    public final String getFormatedGewichtValue(int n) {
        if (this.gewichte == null) {
            return "";
        }
        switch (this.getMessungsArt(false)) {
            case 230: {
                if (n == 1) {
                    return MessungGewicht.toString(this.gewichte.getG1());
                }
                if (n == 2) {
                    return MessungGewicht.toString(this.gewichte.getG2());
                }
                return "";
            }
            case 270: {
                if (n == 1) {
                    return MessungGewicht.toString(this.gewichte.getG1());
                }
                if (n == 2) {
                    return MessungGewicht.toString(this.gewichte.getG2());
                }
                return "";
            }
            case 220: 
            case 260: 
            case 280: {
                return n == 1 ? MessungGewicht.toString(this.gewichte.getG1()) : "";
            }
            case 200: 
            case 210: 
            case 240: 
            case 290: {
                if (n == 1) {
                    return MessungGewicht.toString(this.gewichte.getG1());
                }
                if (n == 2) {
                    return MessungGewicht.toString(this.gewichte.getG2());
                }
                if (n == 3) {
                    return MessungGewicht.toString(this.gewichte.getG3());
                }
                if (n == 4) {
                    return MessungGewicht.toString(this.gewichte.getG4());
                }
                return "";
            }
        }
        return "";
    }

    public final String getFormatedGewichtName(int n) {
        switch (this.getMessungsArt(false)) {
            case 230: {
                if (n == 1) {
                    return "GR";
                }
                if (n == 2) {
                    return "GS";
                }
                return "";
            }
            case 270: {
                if (n == 1) {
                    return "GY";
                }
                if (n == 2) {
                    return "GX";
                }
                return "";
            }
            case 280: {
                return n == 1 ? "GR" : "";
            }
            case 220: 
            case 260: {
                return n == 1 ? "GS" : "";
            }
            case 200: 
            case 210: 
            case 240: 
            case 290: {
                if (n == 1) {
                    return "GA";
                }
                if (n == 2) {
                    return "GO";
                }
                if (n == 3) {
                    return "GF";
                }
                if (n == 4) {
                    return "GR";
                }
                return "";
            }
        }
        return "";
    }

    public final String getFormatedStatistikName(int n) {
        switch (this.getMessungsArt(false)) {
            case 230: {
                if (n == 1) {
                    return "Richtung";
                }
                if (n == 2) {
                    return "Strecke";
                }
                return "";
            }
            case 270: {
                if (n == 1) {
                    return "Y-Differenz";
                }
                if (n == 2) {
                    return "X-Differenz";
                }
                return "";
            }
            case 280: {
                return n == 1 ? "orientierte Richtung" : "";
            }
            case 220: 
            case 260: {
                return n == 1 ? "Spannma\u00df" : "";
            }
            case 240: {
                if (n == 1) {
                    return "Absz. Fu\u00dfpunkt";
                }
                if (n == 2) {
                    return "Flucht Fu\u00dfpunkt";
                }
                if (n == 3) {
                    return "Strebe";
                }
                return "";
            }
            case 200: 
            case 210: 
            case 290: {
                if (n == 1) {
                    return "Absz. Fu\u00dfpunkt";
                }
                if (n == 2) {
                    return "Flucht Fu\u00dfpunkt";
                }
                if (n == 3) {
                    return "Ordinate";
                }
                if (n == 4) {
                    return "Rechter Winkel";
                }
                return "";
            }
        }
        return "";
    }

    public void cloneErrParam(Messung messung) {
        int n;
        messung.setOn(this.isOn());
        if (this.isOn() && ((n = this.getMessungsArt()) == -500 || n == 250)) {
            messung.eMa = messung.getMessungsArt();
            messung.setMessungsArt(n);
        }
    }

    @Override
    public String toDatLine() {
        if (KafkaIOProperties.datVersion >= 2) {
            Punkt punkt;
            IdentitaetUtil identitaetUtil;
            String string = this.bemerkung;
            StringBuffer stringBuffer = new StringBuffer(100);
            int n = this.getWerteBelegung();
            if (this.isOn()) {
                switch (this.getMessungsArt()) {
                    case -500: {
                        stringBuffer.append('C');
                        stringBuffer.append(this.eMa != 0 ? IFormat.i1.format(this.eMa / 10 % 10) : " ");
                        break;
                    }
                    case 250: {
                        stringBuffer.append('5');
                        stringBuffer.append(this.eMa != 0 ? IFormat.i1.format(this.eMa / 10 % 10) : " ");
                        break;
                    }
                    default: {
                        stringBuffer.append(IFormat.i1.format(this.getMessungsArt() / 10 % 10));
                        stringBuffer.append(" ");
                        break;
                    }
                }
            } else {
                stringBuffer.append('C');
                stringBuffer.append(IFormat.i1.format(this.getMessungsArt() / 10 % 10));
            }
            stringBuffer.append(" ");
            if (this.ps != null && this.ps.nr > 0L) {
                identitaetUtil = new IdentitaetUtil(this.ps, string, 1, !KafkaIOProperties.writeOffline);
                punkt = identitaetUtil.getPunkt();
                string = identitaetUtil.getBem();
                stringBuffer.append(IFormat.i14.format(punkt.buildKatNr(KafkaIOProperties.pnrModus, KafkaIOProperties.writeUmnum ? punkt.getNr() : punkt.nr)));
            } else {
                stringBuffer.append("              ");
            }
            stringBuffer.append(" ");
            if (this.pz != null && this.pz.nr > 0L) {
                identitaetUtil = new IdentitaetUtil(this.pz, string, 2, !KafkaIOProperties.writeOffline);
                punkt = identitaetUtil.getPunkt();
                string = identitaetUtil.getBem();
                stringBuffer.append(IFormat.i14.format(punkt.buildKatNr(KafkaIOProperties.pnrModus, KafkaIOProperties.writeUmnum ? punkt.getNr() : punkt.nr)));
            } else {
                stringBuffer.append("              ");
            }
            switch (this.getMessungsArt()) {
                case 230: 
                case 280: {
                    if (n == 1 || n == 3) {
                        stringBuffer.append(IFormat.f6_4.format(this.l1));
                    } else {
                        stringBuffer.append("           ");
                    }
                    if (n == 2 || n == 3) {
                        stringBuffer.append(IFormat.f6_3.format(this.l2).toString());
                    } else {
                        stringBuffer.append("          ");
                    }
                    stringBuffer.append(" ");
                    break;
                }
                case 270: {
                    stringBuffer.append(IFormat.f6_3.format(this.l1));
                    stringBuffer.append(" ");
                    stringBuffer.append(IFormat.f6_3.format(this.l2));
                    stringBuffer.append(" ");
                    break;
                }
                default: {
                    if (n == 1 || n == 3) {
                        stringBuffer.append(IFormat.f6_2.format(this.l1));
                    } else {
                        stringBuffer.append("         ");
                    }
                    stringBuffer.append("  ");
                    if (n == 2 || n == 3) {
                        stringBuffer.append(IFormat.f6_2.format(this.l2));
                    } else {
                        stringBuffer.append("         ");
                    }
                    stringBuffer.append("  ");
                }
            }
            if (!this.hasGewichte()) {
                if (KafkaIOProperties.lastMessungGewicht == null) {
                    KafkaIOProperties.lastMessungGewicht = MessungGewicht.DEFAULT;
                    stringBuffer.append(KafkaIOProperties.lastMessungGewicht.toDatString());
                } else if (string != null) {
                    stringBuffer.append("                        ");
                }
            } else if (!this.gewichte.equals(KafkaIOProperties.lastMessungGewicht)) {
                KafkaIOProperties.lastMessungGewicht = this.gewichte;
                stringBuffer.append(KafkaIOProperties.lastMessungGewicht.toDatString());
            } else if (string != null) {
                stringBuffer.append("                        ");
            }
            if (string != null) {
                stringBuffer.append("                     ");
                stringBuffer.append(string);
            }
            return stringBuffer.toString();
        }
        return this.toDatLine(1.0, 1.0);
    }

    public String toDatLine(double d, double d2) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getMessungsArt() == -500) {
            stringBuffer.append("C");
        } else {
            stringBuffer.append(GeoNumberFormat.nr01n.format(this.getMessungsArt() / 10 % 10).toString());
        }
        stringBuffer.append(" ");
        if (this.ps.nr != 0L) {
            stringBuffer.append(GeoNumberFormat.nr13.format(this.ps.nr).toString());
        } else {
            stringBuffer.append("             ");
        }
        stringBuffer.append(" ");
        if (this.pz.nr != 0L) {
            stringBuffer.append(GeoNumberFormat.nr13.format(this.pz.nr).toString());
        } else {
            stringBuffer.append("             ");
        }
        stringBuffer.append("   ");
        int n = this.getWerteBelegung();
        switch (this.getMessungsArt()) {
            case 230: 
            case 280: {
                if (n == 1 || n == 3) {
                    stringBuffer.append(GeoNumberFormat.m34.format(this.l1).toString());
                } else {
                    stringBuffer.append("        ");
                }
                stringBuffer.append("  ");
                if (n == 2 || n == 3) {
                    stringBuffer.append(GeoNumberFormat.m43.format(this.l2).toString());
                    break;
                }
                stringBuffer.append("        ");
                break;
            }
            case 270: {
                stringBuffer.append(d43.format(this.l1).toString() + "  ");
                stringBuffer.append(d43.format(this.l2).toString());
                break;
            }
            default: {
                if (n == 1 || n == 3) {
                    stringBuffer.append(d52.format(this.l1).toString() + "  ");
                } else {
                    stringBuffer.append("          ");
                }
                if (n == 2 || n == 3) {
                    stringBuffer.append("  " + d52.format(this.l2).toString());
                    break;
                }
                stringBuffer.append("          ");
            }
        }
        stringBuffer.append("  ");
        stringBuffer.append(GeoNumberFormat.m21.format(d).toString());
        stringBuffer.append("  ");
        stringBuffer.append(GeoNumberFormat.m21.format(d2).toString());
        return stringBuffer.toString();
    }

    public String toXmlLine() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(XmlIOProperties.openln("messung"));
        stringBuffer.append(XmlIOProperties.dataln("ma", IFormat.i.format(this.getMessungsArt() / 10 % 10).toString()));
        if (this.ps != null && this.ps.nr != 0L) {
            stringBuffer.append(XmlIOProperties.dataln("nr1", Long.toString(this.ps.nr)));
        }
        if (this.pz != null && this.pz.nr != 0L) {
            stringBuffer.append(XmlIOProperties.dataln("nr2", Long.toString(this.pz.nr)));
        }
        int n = this.getWerteBelegung();
        switch (this.getMessungsArt()) {
            case 230: 
            case 280: {
                if (n == 1 || n == 3) {
                    stringBuffer.append(XmlIOProperties.dataln("l1", IFormat.f_4.format(this.l1).toString()));
                }
                if (n != 2 && n != 3) break;
                stringBuffer.append(XmlIOProperties.dataln("l2", IFormat.f_3.format(this.l2).toString()));
                break;
            }
            case 270: {
                stringBuffer.append(XmlIOProperties.dataln("l1", IFormat.f_3.format(this.l1).toString()));
                stringBuffer.append(XmlIOProperties.dataln("l2", IFormat.f_3.format(this.l2).toString()));
                break;
            }
            default: {
                if (n == 1 || n == 3) {
                    stringBuffer.append(XmlIOProperties.dataln("l1", IFormat.f_2.format(this.l1).toString()));
                }
                if (n != 2 && n != 3) break;
                stringBuffer.append(XmlIOProperties.dataln("l2", IFormat.f_2.format(this.l2).toString()));
            }
        }
        stringBuffer.append(XmlIOProperties.close("messung"));
        return stringBuffer.toString();
    }

    public String toXdesyLine() {
        StringBuffer stringBuffer = new StringBuffer(160);
        int n = this.getWerteBelegung();
        switch (this.getMessungsArt()) {
            case 230: {
                if (this.ps != null) {
                    stringBuffer.append("S ");
                    stringBuffer.append(IFormat.i14.format(this.ps.buildKatNr(KafkaIOProperties.pnrModus, KafkaIOProperties.writeUmnum ? this.ps.getNr() : this.ps.nr)));
                    stringBuffer.append(" ");
                    stringBuffer.append("1  ");
                    stringBuffer.append(" ");
                    stringBuffer.append(IFormat.f5_4.format(0.0));
                }
                if (n == 1 || n == 3) {
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append(IFormat.EOL);
                    }
                    stringBuffer.append("M ");
                    stringBuffer.append(IFormat.i14.format(this.pz.buildKatNr(KafkaIOProperties.pnrModus, KafkaIOProperties.writeUmnum ? this.pz.getNr() : this.pz.nr)));
                    stringBuffer.append(" ");
                    stringBuffer.append("H  ");
                    stringBuffer.append(" ");
                    stringBuffer.append(IFormat.f5_4.format(this.l1));
                }
                if (n != 2 && n != 3) break;
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(IFormat.EOL);
                }
                stringBuffer.append("M ");
                stringBuffer.append(IFormat.i14.format(this.pz.buildKatNr(KafkaIOProperties.pnrModus, KafkaIOProperties.writeUmnum ? this.pz.getNr() : this.pz.nr)));
                stringBuffer.append(" ");
                stringBuffer.append("S  ");
                stringBuffer.append(" ");
                stringBuffer.append(IFormat.f5_4.format(this.l2));
                break;
            }
        }
        return stringBuffer.toString();
    }

    public void writeObject(DataOutput dataOutput) throws IOException {
        dataOutput.writeByte(12);
        dataOutput.writeShort(this.ma);
        if (this.eMa != 0 || this.mNr != 0) {
            dataOutput.writeByte(3);
            dataOutput.writeShort(this.eMa);
            dataOutput.writeShort(this.mNr);
        } else {
            dataOutput.writeByte(0);
        }
        PunktNummer.writeObject(this.ps != null ? this.ps.nr : 0L, dataOutput);
        PunktNummer.writeObject(this.pz != null ? this.pz.nr : 0L, dataOutput);
        int n = this.getWerteBelegung();
        if (this.l1 != 0.0) {
            dataOutput.writeByte(7);
            dataOutput.writeFloat((float)this.l1);
        } else {
            dataOutput.writeByte(0);
        }
        if (this.l2 != 0.0) {
            dataOutput.writeByte(7);
            dataOutput.writeFloat((float)this.l2);
        } else {
            dataOutput.writeByte(0);
        }
        if (this.hasGewichte() && KpvIOProperties.writeStatistik()) {
            dataOutput.writeShort(KpvIOProperties.getMessungGewichtId(this.getGewichte()));
        } else {
            dataOutput.writeShort(0);
        }
        if (this.hasStatistik() && KpvIOProperties.writeStatistik()) {
            this.getStatistik().writeObject(dataOutput);
        } else {
            dataOutput.writeByte(0);
        }
        dataOutput.writeInt(this.flags);
        KafPlotIOConstants.writeString(dataOutput, this.bemerkung);
    }

    public static Messung readObject(DataInput dataInput) throws IOException {
        Messung messung = new Messung();
        messung.ma = dataInput.readShort();
        if (dataInput.readByte() != 0) {
            messung.eMa = dataInput.readShort();
            messung.mNr = dataInput.readShort();
        }
        messung.ps = new Punkt(PunktNummer.readObject(dataInput));
        messung.pz = new Punkt(PunktNummer.readObject(dataInput));
        if (dataInput.readByte() != 0) {
            messung.l1 = dataInput.readFloat();
        }
        if (dataInput.readByte() != 0) {
            messung.l2 = dataInput.readFloat();
        }
        if (KpvIOProperties.RVER >= 110) {
            messung.setGewichte(KpvIOProperties.getMessungGewichtVal(dataInput.readShort()));
            messung.setStatistik(Stat.readObject(dataInput));
        }
        messung.flags = dataInput.readInt();
        messung.bemerkung = KafPlotIOConstants.readString(dataInput);
        return messung;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.ma + " ");
        if (this.ps != null) {
            stringBuffer.append(this.ps.nr + " ");
        } else {
            stringBuffer.append("null ");
        }
        if (this.pz != null) {
            stringBuffer.append(this.pz.nr + " ");
        } else {
            stringBuffer.append("null ");
        }
        stringBuffer.append(this.l1 + " " + this.l2);
        return stringBuffer.toString();
    }

    public String toMiniString() {
        switch (this.getMessungsArt()) {
            case 220: {
                return "s = " + d03.format(this.l1).toString();
            }
            case 200: {
                return "a = " + d03.format(this.l1).toString() + " o = " + d03.format(this.l2).toString();
            }
            case 230: {
                return "r = " + d03.format(this.l1).toString() + " s = " + d03.format(this.l2).toString();
            }
        }
        return " ";
    }

    public String toMessageString() {
        Punkt punkt;
        StringBuffer stringBuffer = new StringBuffer(40);
        Punkt punkt2 = punkt = this.pz != null ? this.pz : this.ps;
        if (punkt.nr > 0L) {
            stringBuffer.append(PunktArt.toString(punkt.getKafPa()));
            stringBuffer.append("  ");
            switch (KafPlotProperties.getNummerSwitch()) {
                case 101: 
                case 111: {
                    stringBuffer.append(punkt.nr);
                    break;
                }
                case 102: 
                case 103: 
                case 112: {
                    stringBuffer.append(punkt.getNr());
                }
            }
            stringBuffer.append("  ");
        }
        stringBuffer.append(this.toMiniString());
        return stringBuffer.toString();
    }

    @Override
    public DRectangle getBounds() {
        Punkt punkt = this.ps;
        if (punkt == null && this.getReferenz() != null) {
            punkt = this.getReferenz().ps;
        }
        if (this.pz != null && punkt != null) {
            return new DRectangle(Math.min(punkt.y, this.pz.y), Math.min(punkt.x, this.pz.x), Math.abs(punkt.y - this.pz.y), Math.abs(punkt.x - this.pz.x));
        }
        if (this.pz == null) {
            if (punkt == null) {
                return null;
            }
            return new DRectangle(punkt.y, punkt.x, 0.0, 0.0);
        }
        return new DRectangle(this.pz.y, this.pz.x, 0.0, 0.0);
    }

    @Override
    public DDimension getSize() {
        DRectangle dRectangle = this.getBounds();
        return new DDimension(dRectangle.width, dRectangle.height);
    }

    @Override
    public boolean isViewable(IViewport iViewport) {
        return iViewport.intersects(this.getBounds());
    }

    @Override
    public boolean isVisible() {
        switch (this.getMessungsTyp()) {
            case 200: 
            case 210: 
            case 290: {
                return KafPlotProperties.isOrthoVisible && KafPlotProperties.isOrthoLinieVisible;
            }
            case 220: 
            case 240: 
            case 260: {
                return KafPlotProperties.isOrthoVisible && KafPlotProperties.isOrthoBandVisible;
            }
            case 230: 
            case 280: {
                return this.pz != null && this.pz.isStandPunkt() ? KafPlotProperties.isAufnahmeVisible : KafPlotProperties.isAufnahmeVisible && KafPlotProperties.isPolarAufnahmeVisible;
            }
            case 270: {
                return this.pz != null && this.pz.isReferenzPunkt() ? KafPlotProperties.isAufnahmeVisible : KafPlotProperties.isAufnahmeVisible && KafPlotProperties.isGpsAufnahmeVisible;
            }
        }
        return true;
    }

    @Override
    public void drawObject(IGraphics iGraphics, boolean bl, boolean bl2) {
        this.drawForeground(iGraphics, bl, bl2);
        if (KafPlotProperties.isMaszeVisible) {
            this.drawInscription(iGraphics, bl, bl2);
        }
        if (bl2) {
            if (this.ps != null && this.ps.nr != 0L) {
                this.ps.drawObject(iGraphics, KafPlotProperties.isPunktArtVisible, bl2);
            }
            if (this.pz != null && this.pz.nr != 0L) {
                this.pz.drawObject(iGraphics, KafPlotProperties.isPunktArtVisible, bl2);
            }
            if (this.referenz != null) {
                this.referenz.drawForeground(iGraphics, bl, bl2);
            }
        }
    }

    @Override
    public void drawBackground(IGraphics iGraphics, boolean bl, boolean bl2) {
    }

    public Color getColor(int n) {
        int n2 = KafPlotProperties.getColorMessSwitch();
        if (n2 == 2004) {
            if (this.isFehler()) {
                return KafPlotColor.OFFLINE;
            }
            return KafPlotProperties.mgwColor.getColor(this.getAverageGewicht());
        }
        if (n2 >= 2011 && n2 <= 2019) {
            return KafPlotColor.getStatColor(n2, this.stat);
        }
        if (n2 == 2001 || defaultColor == null) {
            return KafPlotProperties.mmaColor.getColor(new Integer(n / 10));
        }
        return defaultColor;
    }

    public Color getColor() {
        if (!this.isOn()) {
            return KafPlotColor.OFFLINE;
        }
        int n = KafPlotProperties.getColorMessSwitch();
        if (n == 2004) {
            if (this.isFehler()) {
                return KafPlotColor.OFFLINE;
            }
            return KafPlotProperties.mgwColor.getColor(this.getAverageGewicht());
        }
        if (n >= 2011 && n <= 2019) {
            return KafPlotColor.getStatColor(n, this.stat);
        }
        if (n == 2001 || defaultColor == null) {
            return KafPlotProperties.mmaColor.getColor(new Integer(this.ma / 10));
        }
        return defaultColor;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void drawForeground(IGraphics var1_1, boolean var2_2, boolean var3_3) {
        if (!var3_3 && !this.isVisible()) {
            return;
        }
        var4_4 = var1_1.getGraphics();
        if (var3_3) {
            var4_4.setColor(Color.white);
            var4_4.setXORMode(Color.magenta);
        } else {
            var4_4.setPaintMode();
            var4_4.setColor(this.getColor());
        }
        var5_5 = this.getMessungsArt(false);
        switch (var5_5) {
            case -200: {
                if (var2_2) {
                    var1_1.drawLine((DPoint)this.ps, (DPoint)this.pz, Messung.STROKE_POLAR, var3_3, this.printSkip());
                } else {
                    var1_1.drawLine(this.ps, this.pz);
                }
                this.drawAufnahmePfeil(var1_1, this.ps, this.pz, var3_3);
                break;
            }
            case 230: 
            case 280: {
                if (this.pz == null || this.ps == null && this.referenz == null) {
                    return;
                }
                if (!this.isViewable(var1_1.getViewport()) || !this.pz.isVisible()) break;
                v0 = var6_6 = this.ps == null ? this.referenz.ps : this.ps;
                if (this.pz.isStandPunkt() && KafPlotProperties.isPolarNetzVisible) {
                    if (var2_2) {
                        var1_1.drawLine((DPoint)var6_6, (DPoint)this.pz, Messung.STROKE_POLAR, var3_3, this.printSkip());
                    } else {
                        var1_1.drawLine(var6_6, this.pz);
                    }
                }
                if (!KafPlotProperties.isPolarAufnahmeVisible) break;
                this.drawAufnahmePfeil(var1_1, var6_6, this.pz, var3_3);
                break;
            }
            case 270: {
                if (this.pz == null) {
                    return;
                }
                if (!this.isViewable(var1_1.getViewport())) {
                    return;
                }
                var6_7 = true;
                var7_8 = this.ps != null;
                var6_7 = this.pz.isVisible();
                v1 = var7_8 = this.ps != null && this.pz.isVisible() != false;
                if (var6_7 && var1_1.contains(this.pz)) {
                    this.drawGpsPfeil(var4_4, var1_1.getGraphicPoint(this.pz, new Point()));
                }
                if (var7_8 && var1_1.contains(this.ps)) {
                    this.drawGpsReferenz(var4_4, var1_1.getGraphicPoint(this.ps, new Point()));
                }
                if (!KafPlotProperties.isGpsNetzVisible || !var6_7 || !var7_8 || !this.pz.isReferenzPunkt()) break;
                var1_1.drawLine(this.ps, this.pz);
                break;
            }
            case 220: 
            case 240: 
            case 260: {
                if (this.ps == null || this.pz == null) {
                    return;
                }
                if (!this.isViewable(var1_1.getViewport())) {
                    return;
                }
                if (var2_2) {
                    var1_1.drawLine((DPoint)this.ps, (DPoint)this.pz, Messung.STROKE_ORTHO, var3_3, this.printSkip());
                    break;
                }
                var1_1.drawLine(this.ps, this.pz);
                break;
            }
            case -100: {
                if (this.ps == null || this.pz == null) {
                    return;
                }
                if (var2_2) {
                    var1_1.drawLine((DPoint)this.ps, (DPoint)this.pz, Messung.STROKE_ORTHO, var3_3, this.printSkip());
                    break;
                }
                var1_1.drawLine(this.ps, this.pz);
                break;
            }
            case 210: {
                if (this.hasReferenz()) {
                    if (var2_2) {
                        var1_1.drawLine((DPoint)(this.pz == null ? this.ps : this.pz), (DPoint)(this.getReferenz().pz == null ? this.getReferenz().ps : this.getReferenz().pz), Messung.STROKE_ORTHO, var3_3, this.printSkip());
                    } else {
                        var1_1.drawLine(this.pz == null ? this.ps : this.pz, this.getReferenz().pz == null ? this.getReferenz().ps : this.getReferenz().pz);
                    }
                }
                if (this.ps == null || this.pz == null) {
                    return;
                }
                if (this.pz == null) break;
                if (var2_2) {
                    var1_1.drawLine((DPoint)this.ps, (DPoint)this.pz, Messung.STROKE_ORTHO, var3_3, this.printSkip());
                } else {
                    var1_1.drawLine(this.ps, this.pz);
                }
                this.drawOrdinate(var1_1, this.ps, this.pz, this.l2 > 0.0, var3_3);
                break;
            }
            case 200: {
                if (!this.hasReferenz()) ** GOTO lbl94
                if (!this.isBefore()) ** GOTO lbl89
                if (var2_2) {
                    var1_1.drawLine((DPoint)(this.referenz.pz != null ? this.referenz.pz : this.referenz.ps), (DPoint)(this.pz != null ? this.pz : this.ps), Messung.STROKE_ORTHO, var3_3, this.printSkip());
                } else {
                    var1_1.drawLine(this.referenz.pz != null ? this.referenz.pz : this.referenz.ps, this.pz != null ? this.pz : this.ps);
                }
                ** GOTO lbl94
lbl89:
                // 1 sources

                if (this.isAfter()) {
                    if (var2_2) {
                        var1_1.drawLine((DPoint)(this.referenz.referenz.pz != null ? this.referenz.referenz.pz : this.referenz.referenz.ps), (DPoint)(this.pz != null ? this.pz : this.ps), Messung.STROKE_ORTHO, var3_3, this.printSkip());
                    } else {
                        var1_1.drawLine(this.referenz.referenz.pz != null ? this.referenz.referenz.pz : this.referenz.referenz.ps, this.pz != null ? this.pz : this.ps);
                    }
                }
            }
lbl94:
            // 8 sources

            case 290: {
                if (this.pz == null) break;
                if (var2_2) {
                    var1_1.drawLine((DPoint)this.ps, (DPoint)this.pz, Messung.STROKE_ORTHO, var3_3, this.printSkip());
                } else {
                    var1_1.drawLine(this.ps, this.pz);
                }
                this.drawOrdinate(var1_1, this.ps, this.pz, this.l2 > 0.0, var3_3);
            }
        }
    }

    @Override
    public void drawInscription(IGraphics iGraphics, boolean bl, boolean bl2) {
        DPoint dPoint;
        if (!this.isVisible()) {
            return;
        }
        Graphics graphics = iGraphics.getGraphics();
        if (bl2) {
            graphics.setColor(Color.white);
            graphics.setXORMode(Color.magenta);
        } else {
            graphics.setPaintMode();
            graphics.setColor(this.getColor());
        }
        double d = 0.0;
        int n = 42011140;
        int n2 = this.isFehler() ? 7 : 1;
        Object var13_8 = null;
        int n3 = this.getMessungsArt(false);
        int n4 = this.getWerteBelegung();
        switch (n3) {
            case 210: {
                if (this.referenz == null) {
                    return;
                }
                int n5 = n = this.l1 != 0.0 ? 160638540 : 42011140;
                n2 = this.isFehler() ? (this.l2 > 0.0 ? 8 : 6) : (this.l2 > 0.0 ? 2 : 0);
                d = DLine.getAngle(this.pz != null ? this.pz : this.ps, this.referenz.pz != null ? this.referenz.pz : this.referenz.ps) + iGraphics.getRotation() + 1.5707963267948966;
                break;
            }
            case 200: 
            case 240: {
                Punkt punkt;
                if (this.referenz == null) {
                    return;
                }
                if (this.l1 == 0.0) {
                    n = this.referenz.l1 != 0.0 ? 43977220 : 42011140;
                } else {
                    int n6 = n = this.isEinbindeMass() ? 42404356 : 42011140;
                }
                n2 = this.isFehler() ? (this.l2 > 0.0 ? 8 : 6) : (this.l2 > 0.0 ? 2 : 0);
                dPoint = this.referenz.pz != null ? this.referenz.pz : this.referenz.ps;
                Punkt punkt2 = punkt = this.pz != null && n3 != 240 ? this.pz : this.ps;
                if (this.l1 == this.referenz.l1 && this.referenz.getReferenz() != null) {
                    punkt = this.referenz.getReferenz().pz != null ? this.referenz.getReferenz().pz : this.referenz.getReferenz().ps;
                }
                d = DLine.getAngle(dPoint, punkt) + iGraphics.getRotation() + 1.5707963267948966;
                if (!(this.l1 < this.referenz.l1)) break;
                d += Math.PI;
                break;
            }
            case 290: {
                if (this.referenz == null) {
                    return;
                }
                n = 43977220;
                n2 = this.isFehler() ? (this.l2 > 0.0 ? 8 : 6) : (this.l2 > 0.0 ? 2 : 0);
                d = DLine.getAngle(this.referenz.pz != null ? this.referenz.pz : this.referenz.ps, this.pz != null ? this.pz : this.ps) + iGraphics.getRotation() + 1.5707963267948966;
                break;
            }
            case 220: 
            case 260: {
                if (this.ps == null || this.pz == null) {
                    return;
                }
                n = 42011140;
                n2 = this.isFehler() ? 7 : 1;
                d = Math.atan2(this.pz.y - this.ps.y, this.pz.x - this.ps.x) + iGraphics.getRotation();
            }
        }
        if (this.isFehler() && KafPlotProperties.getColorMessSwitch() != 2001) {
            n |= 0x10000000;
        }
        switch (n3) {
            case 220: 
            case 260: {
                dPoint = DPoint.getMiddle(this.pz, this.ps);
                if (!iGraphics.contains(dPoint.y, dPoint.x)) {
                    return;
                }
                TextSymbol.paint(graphics, IFormat.f_2k.format(this.l1).toString(), iGraphics.getGraphicPoint(dPoint, new Point()), ta, n2, n, d, 1.0);
                break;
            }
            case 240: {
                dPoint = DPoint.getMiddle(this.pz, this.ps);
                if (!iGraphics.contains(dPoint.y, dPoint.x)) {
                    return;
                }
                TextSymbol.paint(graphics, IFormat.f_2k.format(this.l2).toString(), iGraphics.getGraphicPoint(dPoint, new Point()), ta, this.isFehler() ? 7 : 1, 42011140, Math.atan2(this.pz.y - this.ps.y, this.pz.x - this.ps.x) + iGraphics.getRotation(), 1.0);
            }
            case 200: 
            case 210: 
            case 290: {
                if (n4 > 0 && iGraphics.contains(this.pz == null || n3 == 240 ? this.ps : this.pz)) {
                    TextSymbol.paint(graphics, IFormat.f_2k.format(this.l1).toString(), iGraphics.getGraphicPoint(this.pz == null || n3 == 240 ? this.ps : this.pz, new Point()), ta, n2, n, d, 1.0);
                }
                if (this.pz == null || n3 == 240) break;
                dPoint = DPoint.getMiddle(this.pz, this.ps);
                if (!iGraphics.contains(dPoint.y, dPoint.x)) break;
                int n7 = this.isFehler() && KafPlotProperties.getColorMessSwitch() != 2001 ? 310446596 : 42011140;
                TextSymbol.paint(graphics, IFormat.f_2k.format(Math.abs(this.l2)).toString(), iGraphics.getGraphicPoint(dPoint, new Point()), ta, this.isFehler() ? 7 : 1, n7, d, 1.0);
            }
        }
    }

    public void drawSymbol(IGraphics iGraphics, boolean bl) {
        this.drawForeground(iGraphics, false, bl);
    }

    public void printSymbol(IGraphics iGraphics, boolean bl) {
        this.drawForeground(iGraphics, true, bl);
    }

    public void writeSymbol(DxfFileWriter dxfFileWriter, double d) {
        Punkt punkt = this.ps != null ? this.ps : this.getReferenz().ps;
        switch (this.getMessungsArt(false)) {
            case 230: {
                double d2 = (double)this.pz.getRissSymbolRadius() / 10000.0 * d;
                DPoint dPoint = new DPoint();
                double d3 = Math.atan2(this.pz.y - punkt.y, this.pz.x - punkt.x);
                dPoint.x = this.pz.x - d2 * Math.cos(d3);
                dPoint.y = this.pz.y - d2 * Math.sin(d3);
                dxfFileWriter.writeInsert(DxfConstants.getDxfString(Symbol.POLAR_PFEIL.getName()), dPoint, 1.0, -d3 * 180.0 / Math.PI + 180.0, DxfConstants.getDxfString(Ebene.getEbeneName(50)));
                break;
            }
            case 200: 
            case 210: 
            case 290: {
                if (this.l2 == 0.0) break;
                double d4 = Math.atan2(this.pz.y - punkt.y, this.pz.x - punkt.x);
                dxfFileWriter.writeInsert(DxfConstants.getDxfString(Symbol.WINKEL2.getName()), this.pz, 1.0, -d4 * 180.0 / Math.PI + 180.0, DxfConstants.getDxfString(Ebene.getEbeneName(50)));
            }
        }
    }

    private void drawAufnahmePfeil(IGraphics iGraphics, DPoint dPoint, DPoint dPoint2, boolean bl) {
        if (!iGraphics.contains(dPoint2)) {
            return;
        }
        Graphics graphics = iGraphics.getGraphics();
        double d = DLine.getOrientation(dPoint.y, dPoint.x, dPoint2.y, dPoint2.x) + iGraphics.getRotation() - 1.5707963267948966;
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        int n = 10 * this.mNr;
        Point point = iGraphics.getGraphicPoint(dPoint2, new Point());
        int[] nArray = new int[]{point.x - (int)Math.rint(d2 * (double)(4 + n)), point.x - (int)Math.rint(d2 * (double)(14 + n) + d3 * 3.0), point.x - (int)Math.rint(d2 * (double)(14 + n) - d3 * 3.0), point.x - (int)Math.rint(d2 * 14.0), point.x - (int)Math.rint(d2 * (double)(34 + n))};
        int[] nArray2 = new int[]{point.y - (int)Math.rint(d3 * (double)(4 + n)), point.y - (int)Math.rint(d3 * (double)(14 + n) - d2 * 3.0), point.y - (int)Math.rint(d3 * (double)(14 + n) + d2 * 3.0), point.y - (int)Math.rint(d3 * 14.0), point.y - (int)Math.rint(d3 * (double)(34 + n))};
        Color color = graphics.getColor();
        graphics.drawLine(nArray[3], nArray2[3], nArray[4], nArray2[4]);
        switch (this.getWerteBelegung()) {
            case 1: {
                graphics.setColor(color.brighter().brighter());
                break;
            }
            case 2: {
                graphics.setColor(color.brighter());
            }
        }
        graphics.fillPolygon(nArray, nArray2, 3);
        graphics.setColor(color);
        graphics.drawPolygon(nArray, nArray2, 3);
    }

    private void printAufnahmePfeil(IGraphics iGraphics, DPoint dPoint, DPoint dPoint2, boolean bl) {
        if (!iGraphics.contains(dPoint2)) {
            return;
        }
        Graphics graphics = iGraphics.getGraphics();
        double d = DLine.getOrientation(dPoint.y, dPoint.x, dPoint2.y, dPoint2.x) + iGraphics.getRotation() - 1.5707963267948966;
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        int n = 7 * this.mNr;
        Point point = iGraphics.getGraphicPoint(dPoint2, new Point());
        int[] nArray = new int[]{point.x - (int)Math.rint(d2 * (double)(3 + n)), point.x - (int)Math.rint(d2 * (double)(10 + n) + d3 * 2.0), point.x - (int)Math.rint(d2 * (double)(10 + n) - d3 * 2.0), point.x - (int)Math.rint(d2 * 10.0), point.x - (int)Math.rint(d2 * (double)(23 + n))};
        int[] nArray2 = new int[]{point.y - (int)Math.rint(d3 * (double)(3 + n)), point.y - (int)Math.rint(d3 * (double)(10 + n) - d2 * 2.0), point.y - (int)Math.rint(d3 * (double)(10 + n) + d2 * 2.0), point.y - (int)Math.rint(d3 * 10.0), point.y - (int)Math.rint(d3 * (double)(23 + n))};
        Color color = graphics.getColor();
        graphics.drawLine(nArray[3], nArray2[3], nArray[4], nArray2[4]);
        switch (this.getWerteBelegung()) {
            case 1: {
                graphics.setColor(color.brighter().brighter());
                break;
            }
            case 2: {
                graphics.setColor(color.brighter());
            }
        }
        graphics.fillPolygon(nArray, nArray2, 3);
        graphics.setColor(color);
        graphics.drawPolygon(nArray, nArray2, 3);
    }

    private void drawGpsPfeil(Graphics graphics, Point point) {
        int n = this.pz.isReferenzPunkt() ? 4 : 4 + 10 * this.mNr / 2;
        int[] nArray = new int[]{point.x, point.x - 4, point.x + 4};
        int[] nArray2 = new int[]{point.y - n, point.y - n - 10, point.y - n - 10};
        graphics.fillPolygon(nArray, nArray2, 3);
    }

    private void printGpsPfeil(Graphics graphics, Point point) {
        int n = this.pz.isReferenzPunkt() ? 3 : 3 + 8 * this.mNr;
        int[] nArray = new int[]{point.x, point.x - 3, point.x + 3};
        int[] nArray2 = new int[]{point.y - n, point.y - n - 8, point.y - n - 8};
        graphics.fillPolygon(nArray, nArray2, 3);
    }

    private void drawGpsReferenz(Graphics graphics, Point point) {
        int n = 4;
        int[] nArray = new int[]{point.x, point.x - 6, point.x + 6};
        int[] nArray2 = new int[]{point.y - n, point.y - n - 15, point.y - n - 15};
        graphics.drawPolygon(nArray, nArray2, 3);
    }

    private void printGpsReferenz(Graphics graphics, Point point) {
        int n = 3;
        int[] nArray = new int[]{point.x, point.x - 5, point.x + 5};
        int[] nArray2 = new int[]{point.y - n, point.y - n - 12, point.y - n - 12};
        graphics.fillPolygon(nArray, nArray2, 3);
    }

    private void drawOrdinate(IGraphics iGraphics, DPoint dPoint, DPoint dPoint2, boolean bl, boolean bl2) {
        if (!iGraphics.contains(dPoint2)) {
            return;
        }
        double d = DLine.getOrientation(dPoint.y, dPoint.x, dPoint2.y, dPoint2.x) + iGraphics.getRotation() - 1.5707963267948966;
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        Point point = iGraphics.getGraphicPoint(dPoint2, new Point());
        double d4 = bl ? -1.0 : 1.0;
        int[] nArray = new int[]{point.x - (int)Math.rint(d2 * 9.0), point.x - (int)Math.rint(d2 * 6.0 + d3 * 6.0 * d4), point.x - (int)Math.rint(d3 * 9.0 * d4)};
        int[] nArray2 = new int[]{point.y - (int)Math.rint(d3 * 9.0), point.y - (int)Math.rint(d3 * 6.0 - d2 * 6.0 * d4), point.y - (int)Math.rint(-d2 * 9.0 * d4)};
        iGraphics.getGraphics().drawPolyline(nArray, nArray2, nArray.length);
    }

    private void printOrdinate(IGraphics iGraphics, DPoint dPoint, DPoint dPoint2, boolean bl, boolean bl2) {
        if (!iGraphics.contains(dPoint2)) {
            return;
        }
        double d = DLine.getOrientation(dPoint.y, dPoint.x, dPoint2.y, dPoint2.x) + iGraphics.getRotation() - 1.5707963267948966;
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        Point point = iGraphics.getGraphicPoint(dPoint2, new Point());
        double d4 = bl ? -1.0 : 1.0;
        int[] nArray = new int[]{point.x - (int)Math.rint(d2 * 6.0), point.x - (int)Math.rint(d2 * 5.0 + d3 * 5.0 * d4), point.x - (int)Math.rint(d3 * 6.0 * d4)};
        int[] nArray2 = new int[]{point.y - (int)Math.rint(d3 * 6.0), point.y - (int)Math.rint(d3 * 5.0 - d2 * 5.0 * d4), point.y - (int)Math.rint(-d2 * 6.0 * d4)};
        iGraphics.getGraphics().drawPolyline(nArray, nArray2, nArray.length);
    }

    private boolean printSkip() {
        Punkt punkt = this.ps == null ? this.getReferenz().ps : this.ps;
        return punkt == null || this.pz == null || this.pz.nr < punkt.nr;
    }

    static {
        mass = new Text(1, 50);
        ta = TextArt.create(1);
        sym = new TextSymbol(ta);
        gpt = new Point();
    }

    class PolarMessungHashKey {
        Punkt ps;
        Punkt pz;

        PolarMessungHashKey(Messung messung, Punkt punkt, Punkt punkt2) {
            this.ps = punkt;
            this.pz = punkt2;
        }

        public int hashCode() {
            return (int)(this.ps != null ? this.ps.nr % 10000L : 0L) + (int)(this.pz != null ? this.pz.nr % 10000L : 0L);
        }

        public boolean equals(Object object) {
            PolarMessungHashKey polarMessungHashKey = (PolarMessungHashKey)object;
            return polarMessungHashKey.ps == this.ps && polarMessungHashKey.pz == this.pz;
        }
    }
}

