/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.kafplot.io.kpv.KpvIOProperties;
import de.geocalc.text.IFormat;
import de.geocalc.util.ClearList;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Enumeration;

public final class MessungGewicht {
    public static final MessungGewicht DEFAULT = new MessungGewicht(1.0f, 1.0f, 1.0f, 1.0f);
    private static final ClearList list = new ClearList();
    private float g1;
    private float g2;
    private float g3;
    private float g4;

    public static MessungGewicht intern(MessungGewicht messungGewicht) {
        if (messungGewicht == null) {
            throw new NullPointerException();
        }
        Object object = list.put(messungGewicht);
        return object != null ? (MessungGewicht)object : messungGewicht;
    }

    public MessungGewicht(float f, float f2, float f3, float f4) {
        this.g1 = f;
        this.g2 = f2;
        this.g3 = f3;
        this.g4 = f4;
    }

    public boolean hasG1() {
        return this.g1 != 0.0f;
    }

    public void setG1(float f) {
        this.g1 = f;
    }

    public float getG1() {
        return this.g1;
    }

    public boolean hasG2() {
        return this.g2 != 0.0f;
    }

    public void setG2(float f) {
        this.g2 = f;
    }

    public float getG2() {
        return this.g2;
    }

    public boolean hasG3() {
        return this.g3 != 0.0f;
    }

    public void setG3(float f) {
        this.g3 = f;
    }

    public float getG3() {
        return this.g3;
    }

    public boolean hasG4() {
        return this.g4 != 0.0f;
    }

    public void setG4(float f) {
        this.g4 = f;
    }

    public float getG4() {
        return this.g4;
    }

    public float getMid() {
        float f = 0.0f;
        float f2 = 0.0f;
        if (this.g1 != 0.0f) {
            f += this.g1;
            f2 += 1.0f;
        }
        if (this.g2 != 0.0f) {
            f += this.g2;
            f2 += 1.0f;
        }
        if (this.g3 != 0.0f) {
            f += this.g3;
            f2 += 1.0f;
        }
        if (this.g4 != 0.0f) {
            f += this.g4;
            f2 += 1.0f;
        }
        return f2 > 0.0f ? f / f2 : 0.0f;
    }

    public int hashCode() {
        return (int)this.g1 * 1000 + (int)this.g2 * 100 + (int)this.g3 * 10 + (int)this.g4;
    }

    public String toDatString() {
        StringBuffer stringBuffer = new StringBuffer(24);
        stringBuffer.append(this.hasG1() ? MessungGewicht.getString(this.g1) : "      ");
        stringBuffer.append(this.hasG2() ? MessungGewicht.getString(this.g2) : "      ");
        stringBuffer.append(this.hasG3() ? MessungGewicht.getString(this.g3) : "      ");
        stringBuffer.append(this.hasG4() ? MessungGewicht.getString(this.g4) : "      ");
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return this == object;
        }
        if (object instanceof MessungGewicht) {
            MessungGewicht messungGewicht = (MessungGewicht)object;
            return messungGewicht.g1 == this.g1 && messungGewicht.g2 == this.g2 && messungGewicht.g3 == this.g3 && messungGewicht.g4 == this.g4;
        }
        return false;
    }

    private static String getString(float f) {
        if ((double)f < 1.0E-4) {
            return IFormat.f0_5.format(f).toString();
        }
        if ((double)f < 0.001) {
            return " " + IFormat.f0_4.format(f).toString();
        }
        if ((double)f < 0.01) {
            return " " + IFormat.f1_3.format(f).toString();
        }
        if ((double)f < 1.0) {
            return " " + IFormat.f1_2.format(f).toString() + " ";
        }
        if ((double)f < 10.0) {
            return " " + IFormat.f1_2.format(f).toString() + " ";
        }
        if ((double)f < 100.0) {
            return " " + IFormat.f2_2.format(f).toString();
        }
        if ((double)f < 1000.0) {
            return " " + IFormat.f3_1.format(f).toString();
        }
        if ((double)f < 10000.0) {
            return " " + IFormat.f4_0.format(f).toString();
        }
        return IFormat.f5_0.format(f).toString();
    }

    public static String toString(float f) {
        return MessungGewicht.getString(f);
    }

    public static void writeObjects(DataOutput dataOutput) throws IOException {
        dataOutput.write(94);
        int n = list.size();
        if (n > Short.MAX_VALUE) {
            throw new IOException("overflow MessGew");
        }
        dataOutput.writeShort(n);
        int n2 = 1;
        Enumeration enumeration = list.elements();
        while (enumeration.hasMoreElements()) {
            MessungGewicht messungGewicht = (MessungGewicht)enumeration.nextElement();
            messungGewicht.writeObject(dataOutput);
            KpvIOProperties.setMessungGewicht(n2, messungGewicht);
            ++n2;
        }
    }

    public static void readObjects(DataInput dataInput) throws IOException {
        int n = dataInput.readShort();
        for (int i = 0; i < n; ++i) {
            MessungGewicht messungGewicht = MessungGewicht.intern(MessungGewicht.readObject(dataInput));
            KpvIOProperties.setMessungGewicht(i + 1, messungGewicht);
        }
    }

    private void writeObject(DataOutput dataOutput) throws IOException {
        dataOutput.writeFloat(this.g1);
        dataOutput.writeFloat(this.g2);
        dataOutput.writeFloat(this.g3);
        dataOutput.writeFloat(this.g4);
    }

    private static MessungGewicht readObject(DataInput dataInput) throws IOException {
        return new MessungGewicht(dataInput.readFloat(), dataInput.readFloat(), dataInput.readFloat(), dataInput.readFloat());
    }
}

