/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.IBorder;
import de.geocalc.awt.IDialog;
import de.geocalc.awt.IFrame;
import de.geocalc.awt.IInfoField;
import de.geocalc.awt.IPanel;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.Messung;
import de.geocalc.kafplot.MessungGewicht;
import de.geocalc.kafplot.Stat;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class MessungInfoDialog
extends IDialog
implements ActionListener {
    private static final String OK_COMMAND = "OK";
    private static final String VOID = "                 ";
    private Messung m;
    private Label nr1Label;
    private Label nr2Label;
    private Label ma1Label;
    private Label ma2Label;
    private Label gw1Label;
    private Label gw2Label;
    private Label gw3Label;
    private Label gw4Label;
    private Label dim1Label;
    private Label dim2Label;
    private Label listLabel;
    private Label rissLabel;
    private IInfoField nr1Field;
    private IInfoField nr2Field;
    private IInfoField val1Field;
    private IInfoField val2Field;
    private IInfoField gew1Field;
    private IInfoField gew2Field;
    private IInfoField gew3Field;
    private IInfoField gew4Field;
    private IInfoField listField;
    private IInfoField rissField;
    private IInfoField bemField;
    private Label[] typLabel = new Label[4];
    private IInfoField[] vvvField = new IInfoField[4];
    private IInfoField[] savField = new IInfoField[4];
    private IInfoField[] sanField = new IInfoField[4];
    private IInfoField[] evvField = new IInfoField[4];
    private IInfoField[] epvField = new IInfoField[4];
    private IInfoField[] nvvField = new IInfoField[4];
    private IInfoField[] gfvField = new IInfoField[4];
    private IInfoField[] grzField = new IInfoField[4];
    private IInfoField[] egkField = new IInfoField[4];
    private String dialogName;
    private boolean hasStat = false;

    public MessungInfoDialog(IFrame iFrame, String string) {
        this(iFrame, string, null);
    }

    public MessungInfoDialog(IFrame iFrame, String string, Messung messung) {
        super(iFrame, string, true);
        this.m = messung;
        this.hasStat = DataBase.hasStatistik;
        this.dialogName = string;
        this.setLayout(new BorderLayout());
        this.add("Center", this.createInfoPanel());
        this.add("South", this.createButtonPanel());
        this.pack();
        this.setObject(messung);
        this.setLocationOfParent(iFrame, -11);
        this.setResizable(false);
    }

    private Panel createInfoPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        Panel panel = new Panel(gridBagLayout);
        IPanel iPanel = this.createValPanel();
        panel.add(iPanel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(iPanel, gridBagConstraints);
        if (this.hasStat) {
            iPanel = this.createStatPanel();
            panel.add(iPanel);
            gridBagConstraints.gridx = 0;
            ++gridBagConstraints.gridy;
            gridBagLayout.setConstraints(iPanel, gridBagConstraints);
        }
        iPanel = this.createBemPanel();
        panel.add(iPanel);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagLayout.setConstraints(iPanel, gridBagConstraints);
        return panel;
    }

    private IPanel createValPanel() {
        IPanel iPanel = new IPanel(new BorderLayout());
        iPanel.setBorder(new IBorder(1, "Werte"));
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Panel panel = new Panel(gridBagLayout);
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 17;
        this.nr1Label = new Label("Nummer erster Punkt");
        panel.add(this.nr1Label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.nr1Label, gridBagConstraints);
        this.nr1Field = new IInfoField(15, 2);
        panel.add(this.nr1Field);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.nr1Field, gridBagConstraints);
        this.nr2Label = new Label("Nummer zweiter Punkt");
        panel.add(this.nr2Label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.nr2Label, gridBagConstraints);
        this.nr2Field = new IInfoField(15, 2);
        panel.add(this.nr2Field);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.nr2Field, gridBagConstraints);
        this.ma1Label = new Label("Art erster Messwert");
        panel.add(this.ma1Label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.ma1Label, gridBagConstraints);
        this.val1Field = new IInfoField(15, 2);
        panel.add(this.val1Field);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.val1Field, gridBagConstraints);
        this.dim1Label = new Label("[ohne]");
        panel.add(this.dim1Label);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.dim1Label, gridBagConstraints);
        this.gw1Label = new Label("GW");
        panel.add(this.gw1Label);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.gw1Label, gridBagConstraints);
        this.gew1Field = new IInfoField(6, 2);
        panel.add(this.gew1Field);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.gew1Field, gridBagConstraints);
        this.gw3Label = new Label("GW");
        panel.add(this.gw3Label);
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.gw3Label, gridBagConstraints);
        this.gew3Field = new IInfoField(6, 2);
        panel.add(this.gew3Field);
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.gew3Field, gridBagConstraints);
        this.ma2Label = new Label("Art zweiter Messwert");
        panel.add(this.ma2Label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.ma2Label, gridBagConstraints);
        this.val2Field = new IInfoField(15, 2);
        panel.add(this.val2Field);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.val2Field, gridBagConstraints);
        this.dim2Label = new Label("[ohne]");
        panel.add(this.dim2Label);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.dim2Label, gridBagConstraints);
        this.gw2Label = new Label("GW");
        panel.add(this.gw2Label);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.gw2Label, gridBagConstraints);
        this.gew2Field = new IInfoField(6, 2);
        panel.add(this.gew2Field);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.gew2Field, gridBagConstraints);
        this.gw4Label = new Label("GW");
        panel.add(this.gw4Label);
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.gw4Label, gridBagConstraints);
        this.gew4Field = new IInfoField(6, 2);
        panel.add(this.gew4Field);
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.gew4Field, gridBagConstraints);
        this.rissLabel = new Label("Riss");
        panel.add(this.rissLabel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.rissLabel, gridBagConstraints);
        this.rissField = new IInfoField(40, 1);
        panel.add(this.rissField);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.rissField, gridBagConstraints);
        iPanel.add("West", panel);
        return iPanel;
    }

    private IPanel createStatPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        IPanel iPanel = new IPanel(gridBagLayout);
        iPanel.setBorder(new IBorder(1, "Statistik"));
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 10;
        Label label = new Label("Verbess.");
        iPanel.add(label);
        gridBagConstraints.gridx = 1;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        label = new Label("SA VA");
        iPanel.add(label);
        gridBagConstraints.gridx = 2;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        label = new Label("SA NA");
        iPanel.add(label);
        gridBagConstraints.gridx = 3;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        label = new Label("EV");
        iPanel.add(label);
        gridBagConstraints.gridx = 4;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        label = new Label("EP");
        iPanel.add(label);
        gridBagConstraints.gridx = 5;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        label = new Label("NV");
        iPanel.add(label);
        gridBagConstraints.gridx = 6;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        label = new Label("GF");
        iPanel.add(label);
        gridBagConstraints.gridx = 7;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        label = new Label("GRZW");
        iPanel.add(label);
        gridBagConstraints.gridx = 8;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        label = new Label("EGK");
        iPanel.add(label);
        gridBagConstraints.gridx = 9;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        label = new Label("Art des Wertes");
        iPanel.add(label);
        gridBagConstraints.gridx = 0;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        label = new Label("[m]");
        iPanel.add(label);
        gridBagConstraints.gridx = 1;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        label = new Label("[m]");
        iPanel.add(label);
        gridBagConstraints.gridx = 2;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        label = new Label("[m]");
        iPanel.add(label);
        gridBagConstraints.gridx = 3;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        label = new Label("[%]");
        iPanel.add(label);
        gridBagConstraints.gridx = 4;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        label = new Label("[m]");
        iPanel.add(label);
        gridBagConstraints.gridx = 5;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        label = new Label("  ");
        iPanel.add(label);
        gridBagConstraints.gridx = 6;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        label = new Label("[m]");
        iPanel.add(label);
        gridBagConstraints.gridx = 7;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        label = new Label("[m]");
        iPanel.add(label);
        gridBagConstraints.gridx = 8;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        label = new Label("[m]");
        iPanel.add(label);
        gridBagConstraints.gridx = 9;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        for (int i = 0; i < 4; ++i) {
            gridBagConstraints.gridy = i + 2;
            this.createValLine(i, iPanel, gridBagLayout, gridBagConstraints);
        }
        gridBagConstraints.gridy = 6;
        label = new Label("SA:");
        iPanel.add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        label = new Label("Standardabweichung vor und nach der Ausgleichung");
        iPanel.add(label);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 7;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        gridBagConstraints.gridy = 7;
        label = new Label("EV:");
        iPanel.add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        label = new Label("Kontrollierbarkeit der Messung in %");
        iPanel.add(label);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 7;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        gridBagConstraints.gridy = 8;
        label = new Label("EP:");
        iPanel.add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        label = new Label("Einfluss der Beobachtung auf die relative Punktlage");
        iPanel.add(label);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 7;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        gridBagConstraints.gridy = 9;
        label = new Label("NV:");
        iPanel.add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        label = new Label("Normierte Verbesserung");
        iPanel.add(label);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 7;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        gridBagConstraints.gridy = 10;
        label = new Label("GF:");
        iPanel.add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        label = new Label("Gesch\u00e4tzter grober Fehler");
        iPanel.add(label);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 7;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        gridBagConstraints.gridy = 11;
        label = new Label("GRZW:");
        iPanel.add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        label = new Label("Grenzwert der Erkennbarkeit eines groben Fehlers");
        iPanel.add(label);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 7;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        gridBagConstraints.gridy = 12;
        label = new Label("EGK:");
        iPanel.add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        label = new Label("Einfluss eines nicht erkannten GF auf die relative Punktlage");
        iPanel.add(label);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 7;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        return iPanel;
    }

    private void createValLine(int n, IPanel iPanel, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints) {
        this.typLabel[n] = new Label("Art der Angabe:");
        iPanel.add(this.typLabel[n]);
        gridBagConstraints.gridx = 0;
        gridBagLayout.setConstraints(this.typLabel[n], gridBagConstraints);
        this.vvvField[n] = new IInfoField(8, 2);
        iPanel.add(this.vvvField[n]);
        gridBagConstraints.gridx = 1;
        gridBagLayout.setConstraints(this.vvvField[n], gridBagConstraints);
        this.savField[n] = new IInfoField(6, 2);
        iPanel.add(this.savField[n]);
        gridBagConstraints.gridx = 2;
        gridBagLayout.setConstraints(this.savField[n], gridBagConstraints);
        this.sanField[n] = new IInfoField(6, 2);
        iPanel.add(this.sanField[n]);
        gridBagConstraints.gridx = 3;
        gridBagLayout.setConstraints(this.sanField[n], gridBagConstraints);
        this.evvField[n] = new IInfoField(3, 2);
        iPanel.add(this.evvField[n]);
        gridBagConstraints.gridx = 4;
        gridBagLayout.setConstraints(this.evvField[n], gridBagConstraints);
        this.epvField[n] = new IInfoField(6, 2);
        iPanel.add(this.epvField[n]);
        gridBagConstraints.gridx = 5;
        gridBagLayout.setConstraints(this.epvField[n], gridBagConstraints);
        this.nvvField[n] = new IInfoField(6, 2);
        iPanel.add(this.nvvField[n]);
        gridBagConstraints.gridx = 6;
        gridBagLayout.setConstraints(this.nvvField[n], gridBagConstraints);
        this.gfvField[n] = new IInfoField(6, 2);
        iPanel.add(this.gfvField[n]);
        gridBagConstraints.gridx = 7;
        gridBagLayout.setConstraints(this.gfvField[n], gridBagConstraints);
        this.grzField[n] = new IInfoField(6, 2);
        iPanel.add(this.grzField[n]);
        gridBagConstraints.gridx = 8;
        gridBagLayout.setConstraints(this.grzField[n], gridBagConstraints);
        this.egkField[n] = new IInfoField(6, 2);
        iPanel.add(this.egkField[n]);
        gridBagConstraints.gridx = 9;
        gridBagLayout.setConstraints(this.egkField[n], gridBagConstraints);
    }

    private IPanel createBemPanel() {
        IPanel iPanel = new IPanel(new BorderLayout());
        iPanel.setBorder(new IBorder(1, "Bemerkungen"));
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        Panel panel = new Panel(gridBagLayout);
        this.bemField = new IInfoField(40, 1, 0);
        panel.add(this.bemField);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(this.bemField, gridBagConstraints);
        iPanel.add("West", panel);
        return iPanel;
    }

    private Panel createButtonPanel() {
        Panel panel = new Panel(new FlowLayout(1));
        Button button = new Button(OK_COMMAND);
        button.addActionListener(this);
        panel.add(button);
        return panel;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals(OK_COMMAND)) {
            this.endDialog();
        }
    }

    private void fillValLine(int n, Messung messung) {
        int n2 = n + 1;
        if (messung != null && messung.hasStatistik()) {
            Stat stat = messung.getStatistik();
            String string = messung.getFormatedStatistikName(n2);
            this.typLabel[n].setText((String)(string.length() > 0 ? string + ":" : ""));
            Color color = Color.black;
            if (DataBase.steuerDaten != null && (double)stat.getNv(n2) * 0.1 >= DataBase.steuerDaten.getK()) {
                color = Color.red;
            } else if (stat.getEv(n2) == Short.MIN_VALUE) {
                color = Color.gray;
            }
            this.vvvField[n].setForeground(color);
            this.savField[n].setForeground(color);
            this.sanField[n].setForeground(color);
            this.evvField[n].setForeground(color);
            this.epvField[n].setForeground(color);
            this.nvvField[n].setForeground(color);
            this.gfvField[n].setForeground(color);
            this.grzField[n].setForeground(color);
            this.egkField[n].setForeground(color);
            this.vvvField[n].setText(Stat.toString(stat.getV(n2), 0.001f));
            this.savField[n].setText(Stat.toString(stat.getSaV(n2), 0.001f));
            this.sanField[n].setText(Stat.toString(stat.getSaN(n2), 0.001f));
            this.evvField[n].setText(Stat.toString(stat.getEv(n2)));
            this.epvField[n].setText(Stat.toString(stat.getEp(n2), 0.001f));
            this.nvvField[n].setText(Stat.toString(stat.getNv(n2), 0.1f));
            this.gfvField[n].setText(Stat.toString(stat.getGf(n2), 0.001f));
            this.grzField[n].setText(Stat.toString(stat.getGrzw(n2), 0.001f));
            this.egkField[n].setText(Stat.toString(stat.getEgk(n2), 0.001f));
        } else {
            this.typLabel[n].setText("Art der Angabe:");
            this.vvvField[n].setText("");
            this.savField[n].setText("");
            this.sanField[n].setText("");
            this.evvField[n].setText("");
            this.epvField[n].setText("");
            this.nvvField[n].setText("");
            this.gfvField[n].setText("");
            this.grzField[n].setText("");
            this.egkField[n].setText("");
        }
    }

    public void setObject(Object object) {
        if (object instanceof Messung) {
            this.m = (Messung)object;
            this.setTitle(this.dialogName + " (" + this.m.getClassName() + ")");
            this.nr1Label.setText(this.m.getFormatedPunktName(1));
            this.nr2Label.setText(this.m.getFormatedPunktName(2));
            this.ma1Label.setText(this.m.getFormatedValueName(1));
            this.ma2Label.setText(this.m.getFormatedValueName(2));
            this.nr1Field.setText(this.m.getP1() != null && this.m.getP1().nr != 0L ? Long.toString(this.m.getP1().nr) : "");
            this.nr2Field.setText(this.m.getP2() != null && this.m.getP2().nr != 0L ? Long.toString(this.m.getP2().nr) : "");
            this.val1Field.setText(this.m.getFormatedValue(1));
            this.val2Field.setText(this.m.getFormatedValue(2));
            this.dim1Label.setText(this.m.getFormatedDimension(1));
            this.dim2Label.setText(this.m.getFormatedDimension(2));
            this.rissField.setText(this.m.getContainer().getName());
            this.gw1Label.setText(this.m.getFormatedGewichtName(1));
            this.gw2Label.setText(this.m.getFormatedGewichtName(2));
            this.gw3Label.setText(this.m.getFormatedGewichtName(3));
            this.gw4Label.setText(this.m.getFormatedGewichtName(4));
            if (this.m.hasGewichte()) {
                MessungGewicht messungGewicht = this.m.getGewichte();
                this.gew1Field.setText(this.m.getFormatedGewichtValue(1));
                this.gew2Field.setText(this.m.getFormatedGewichtValue(2));
                this.gew3Field.setText(this.m.getFormatedGewichtValue(3));
                this.gew4Field.setText(this.m.getFormatedGewichtValue(4));
            }
            if (this.hasStat) {
                for (int i = 0; i < 4; ++i) {
                    this.fillValLine(i, this.m);
                }
            }
            this.bemField.setText(this.m.getBemerkungText());
        } else {
            this.setTitle(this.dialogName);
            this.nr1Label.setText("erster Punkt");
            this.nr2Label.setText("zweiter Punkt");
            this.ma1Label.setText("erster Messwert");
            this.ma2Label.setText("zweiter Messwert");
            this.gw1Label.setText("");
            this.gw2Label.setText("");
            this.gw3Label.setText("");
            this.gw4Label.setText("");
            this.nr1Field.setText("");
            this.nr2Field.setText("");
            this.val1Field.setText("");
            this.val2Field.setText("");
            this.gew1Field.setText("");
            this.gew2Field.setText("");
            this.gew3Field.setText("");
            this.gew4Field.setText("");
            this.dim1Label.setText("");
            this.dim2Label.setText("");
            this.rissField.setText("");
            if (this.hasStat) {
                for (int i = 0; i < 4; ++i) {
                    this.fillValLine(i, null);
                }
            }
            this.bemField.setText("");
        }
    }

    @Override
    protected void doStandardAction() {
        this.endDialog();
    }

    @Override
    protected void doAbortAction() {
        this.endDialog();
    }
}

