/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.IException;
import de.geocalc.geodata.Feature;
import de.geocalc.kafplot.DatObject;
import de.geocalc.kafplot.Grundbuchblatt;
import de.geocalc.kafplot.Message;
import de.geocalc.kafplot.io.KafPlotIOConstants;
import de.geocalc.kafplot.io.kpv.KpvIOProperties;
import de.geocalc.lang.Exceptionable;
import de.geocalc.text.IFormat;
import de.geocalc.util.Comparable;
import de.geocalc.util.ListAttribute;
import de.geocalc.util.ListAttributeEnumerator;
import de.geocalc.xml.Node;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Enumeration;
import java.util.StringTokenizer;

public class Name
implements DatObject,
Comparable,
Exceptionable,
Feature {
    private static final int VOID = -1;
    private int bezirk = -1;
    private String plzpf;
    private String postfach;
    private String plz;
    private String gbbl = "";
    private long nr;
    private int ea = -1;
    private int ga = -1;
    private short aktualitaet = (short)-1;
    private short land = (short)-1;
    private String anteil;
    private String name;
    private String geburtName;
    private String geburtDatum;
    private String adresse;
    private String ort;
    private String vertretung;
    protected ListAttribute att;

    public Name() {
    }

    public Name(String string, long l) throws Exception {
        this.gbbl = Grundbuchblatt.createKennzeichen(string);
        this.nr = l;
    }

    public void initGeom() {
    }

    public void setGrundbuchblatt(String string) throws Exception {
        this.gbbl = Grundbuchblatt.createKennzeichen(string);
    }

    public String getGrundbuchblatt() {
        return this.gbbl;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public String getNameAsString() {
        return this.name != null ? this.name : "";
    }

    public String getNameMitVertretung() {
        return this.hasVertretung() ? this.getNameAsString() + " " + this.getVertretung() : this.getNameAsString();
    }

    public void setNummer(long l) {
        this.nr = l;
    }

    public long getNummer() {
        return this.nr;
    }

    public String getNummerAsString() {
        return Long.toString(this.nr);
    }

    public boolean hasArt() {
        return this.ea > -1;
    }

    public void setArt(int n) {
        this.ea = n;
    }

    public int getArt() {
        return this.ea;
    }

    public String getArtAsString() {
        return this.ea != -1 ? Integer.toString(this.ea) : "";
    }

    public boolean hasGemeinschaftsArt() {
        return this.ga > -1;
    }

    public void setGemeinschaftsArt(int n) {
        this.ga = n;
    }

    public int getGemeinschaftsArt() {
        return this.ga;
    }

    public String getGemeinschaftsArtAsString() {
        return this.ga != -1 ? Integer.toString(this.ga) : "";
    }

    public boolean hasAnteil() {
        return this.anteil != null;
    }

    public void setAnteil(String string) {
        this.anteil = string;
    }

    public String getAnteil() {
        return this.anteil;
    }

    public void setAktualitaet(int n) {
        this.aktualitaet = (short)n;
    }

    public int getAktualitaet() {
        return this.aktualitaet;
    }

    public String getAktualitaetAsString() {
        return this.aktualitaet != -1 ? Integer.toString(this.aktualitaet) : "";
    }

    public boolean hasGeburtName() {
        return this.geburtName != null;
    }

    public void setGeburtName(String string) {
        this.geburtName = string;
    }

    public String getGeburtName() {
        return this.geburtName;
    }

    public boolean hasGeburtDatum() {
        return this.geburtDatum != null;
    }

    public void setGeburtDatum(String string) {
        this.geburtDatum = string;
    }

    public String getGeburtDatum() {
        return this.geburtDatum;
    }

    public boolean hasAdresse() {
        return this.adresse != null;
    }

    public void setAdresse(String string) {
        this.adresse = string;
    }

    public String getAdresse() {
        return this.adresse;
    }

    public boolean hasPlzPf() {
        return this.plzpf != null;
    }

    public void setPlzPf(int n) {
        this.plzpf = Integer.toString(n);
    }

    public void setPlzPf(String string) {
        this.plzpf = string;
    }

    public String getPlzPf() {
        return this.plzpf;
    }

    public String getPlzPfAsString() {
        return this.plzpf != null ? this.plzpf : "";
    }

    public boolean hasPostfach() {
        return this.postfach != null;
    }

    public void setPostfach(int n) {
        this.postfach = Integer.toString(n);
    }

    public void setPostfach(String string) {
        this.postfach = string;
    }

    public String getPostfach() {
        return this.postfach;
    }

    public String getPostfachAsString() {
        return this.postfach != null ? this.postfach : "";
    }

    public boolean hasPostleitzahl() {
        return this.plz != null;
    }

    public void setPostleitzahl(int n) {
        this.plz = Integer.toString(n);
    }

    public void setPostleitzahl(String string) {
        this.plz = string;
    }

    public String getPostleitzahl() {
        return this.plz;
    }

    public String getPostleitzahlAsString() {
        return this.plz != null ? this.plz : "";
    }

    public boolean hasOrt() {
        return this.ort != null;
    }

    public void setOrt(String string) {
        this.ort = string;
    }

    public String getOrt() {
        return this.ort;
    }

    public boolean hasLand() {
        return this.land != -1;
    }

    public void setLand(int n) {
        this.land = (short)n;
    }

    public int getLand() {
        return this.land;
    }

    public String getLandAsString() {
        return this.land != -1 ? IFormat.i03.format(this.land) : "";
    }

    public String getKennzeichenAsString() {
        StringBuffer stringBuffer = new StringBuffer(30);
        stringBuffer.append(this.nr / 100000000L);
        int n = 100000000;
        for (int i = (int)(this.nr % (long)n); i > 0; i %= n) {
            stringBuffer.append('.');
            stringBuffer.append(i / (n /= 100));
        }
        return stringBuffer.toString();
    }

    public boolean hasVertretung() {
        return this.vertretung != null;
    }

    public void addVertretung(String string) {
        if (string != null) {
            this.vertretung = this.vertretung == null ? string : this.vertretung + " " + string;
        }
    }

    public String getVertretung() {
        return this.vertretung;
    }

    public void copyNameFrom(Name name) {
        this.copyNameFrom(name, false);
    }

    public void copyNameFrom(Name name, boolean bl) {
        this.setName(name.getName());
        this.setGeburtName(name.getGeburtName());
        this.setGeburtDatum(name.getGeburtDatum());
        if (bl) {
            this.copyAttributesFrom(name);
        }
    }

    public void copyAdresseFrom(Name name) {
        this.copyAdresseFrom(name, false);
    }

    public void copyAdresseFrom(Name name, boolean bl) {
        this.setOrt(name.getOrt());
        this.setPostleitzahl(name.getPostleitzahl());
        this.setPlzPf(name.getPlzPf());
        this.setAdresse(name.getAdresse());
        this.setPostfach(name.getPostfach());
        if (bl) {
            this.copyAttributesFrom(name);
        }
    }

    public void copyAttributesFrom(Name name) {
        Enumeration enumeration = name.attributes();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.setAttribute(string, name.getAttribute(string));
        }
    }

    public String toAdresseString() {
        StringBuffer stringBuffer = new StringBuffer(200);
        if (this.hasPostleitzahl()) {
            stringBuffer.append(this.getPostleitzahlAsString());
            stringBuffer.append(" ");
        }
        if (this.hasOrt()) {
            stringBuffer.append(this.getOrt());
            stringBuffer.append(" ");
        }
        if (this.hasAdresse()) {
            stringBuffer.append(this.getAdresse());
            stringBuffer.append(" ");
        }
        if (this.hasPostfach()) {
            stringBuffer.append("PF ");
            if (this.hasPlzPf()) {
                stringBuffer.append(this.getPlzPfAsString());
                stringBuffer.append("-");
            }
            stringBuffer.append(this.getPostfachAsString());
            stringBuffer.append(" ");
        }
        for (ListAttribute listAttribute = this.att; listAttribute != null; listAttribute = listAttribute.getNext()) {
            if (listAttribute.getName().equals("bestimmungsland")) {
                stringBuffer.insert(0, "-");
                stringBuffer.insert(0, listAttribute.getValue());
                continue;
            }
            if (listAttribute.getName().equals("telefon")) {
                stringBuffer.append("Tel: ");
                stringBuffer.append(listAttribute.getValue());
                stringBuffer.append(" ");
                continue;
            }
            if (!listAttribute.getName().equals("fax")) continue;
            stringBuffer.append("Fax: ");
            stringBuffer.append(listAttribute.getValue());
            stringBuffer.append(" ");
        }
        return stringBuffer.toString().trim();
    }

    public boolean equals(Object object) {
        if (object instanceof Name) {
            return this.compareTo(object) == 0;
        }
        return false;
    }

    public int hashCode() {
        return this.gbbl.hashCode() + (int)(this.nr ^ this.nr >> 32);
    }

    @Override
    public int compareTo(Object object) {
        Name name = (Name)object;
        int n = this.getGrundbuchblatt().compareTo(name.getGrundbuchblatt());
        if (n != 0) {
            return n;
        }
        if (this.getNummer() < name.getNummer()) {
            return -1;
        }
        if (this.getNummer() > name.getNummer()) {
            return 1;
        }
        return 0;
    }

    public Message getMessage() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClassName());
        stringBuffer.append(": ");
        stringBuffer.append(this.getKennzeichenAsString());
        return new Message(this, stringBuffer.toString());
    }

    @Override
    public String getClassName() {
        return "Bestand";
    }

    @Override
    public String getObjectName() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getKennzeichenAsString());
        return stringBuffer.toString();
    }

    @Override
    public String getExceptionableName() {
        return this.getClassName() + ": " + this.getObjectName();
    }

    @Override
    public String toDebugString() {
        return this.getClassName() + ": " + this.getObjectName();
    }

    @Override
    public Object getAttribute(String string) {
        for (ListAttribute listAttribute = this.att; listAttribute != null; listAttribute = listAttribute.getNext()) {
            if (!listAttribute.getName().equals(string)) continue;
            return listAttribute.getValue();
        }
        return null;
    }

    @Override
    public Object setAttribute(String string, Object object) {
        if (this.att == null) {
            this.att = new ListAttribute(string, object);
        } else {
            for (ListAttribute listAttribute = this.att; listAttribute != null; listAttribute = listAttribute.getNext()) {
                if (listAttribute.getName().equals(string)) {
                    Object object2 = listAttribute.getValue();
                    listAttribute.setValue(object);
                    return object2;
                }
                if (listAttribute.getNext() != null) continue;
                listAttribute.setNext(new ListAttribute(string, object));
                return null;
            }
        }
        return null;
    }

    public void addAttribute(String string, Object object) {
        this.att = new ListAttribute(string, object, this.att);
    }

    @Override
    public Object removeAttribute(String string) {
        if (this.att.getName().equals(string)) {
            Object object = this.att.getValue();
            this.att = this.att.getNext();
            return object;
        }
        ListAttribute listAttribute = this.att;
        for (ListAttribute listAttribute2 = this.att.getNext(); listAttribute2 != null; listAttribute2 = listAttribute2.getNext()) {
            if (listAttribute2.getName().equals(string)) {
                listAttribute.setNext(listAttribute2.getNext());
                return listAttribute2.getValue();
            }
            listAttribute = listAttribute2;
        }
        return null;
    }

    @Override
    public Enumeration attributes() {
        return new ListAttributeEnumerator(this.att);
    }

    @Override
    public boolean hasAttributes() {
        return this.att != null;
    }

    @Override
    public boolean isOn() {
        return true;
    }

    public static Name parseDatLine(String string) throws IException {
        Name name = new Name();
        int n = 0;
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                try {
                    if (n == 0 && Character.isDigit(string2.charAt(0))) {
                        var5_5 = string2.lastIndexOf("/");
                        if (var5_5 > 0) {
                            name.setGrundbuchblatt(string2.substring(0, var5_5));
                            string2 = string2.substring(var5_5 + 1);
                        }
                        var6_7 = new StringTokenizer(string2, ".");
                        int n2 = 0;
                        long l = 0L;
                        try {
                            while (((StringTokenizer)var6_7).hasMoreTokens()) {
                                String string3 = ((StringTokenizer)var6_7).nextToken();
                                switch (n2) {
                                    case 0: {
                                        l += Long.parseLong(string3) * 100000000L;
                                        break;
                                    }
                                    case 1: {
                                        l += Long.parseLong(string3) * 1000000L;
                                        break;
                                    }
                                    case 2: {
                                        l += Long.parseLong(string3) * 10000L;
                                        break;
                                    }
                                    case 3: {
                                        l += Long.parseLong(string3) * 100L;
                                        break;
                                    }
                                    case 4: {
                                        l += Long.parseLong(string3);
                                        break;
                                    }
                                    default: {
                                        throw new Exception();
                                    }
                                }
                                ++n2;
                            }
                        }
                        catch (Exception exception) {
                            throw new IException("ung\u00fcltige Namensnummer");
                        }
                        name.setNummer(l);
                    } else {
                        var5_5 = string2.indexOf(61);
                        var6_7 = string2.substring(0, var5_5);
                        String string4 = string2.substring(var5_5 + 1);
                        if (((String)var6_7).equalsIgnoreCase("E")) {
                            name.ea = Integer.parseInt(string4);
                        } else if (((String)var6_7).equalsIgnoreCase("A")) {
                            name.aktualitaet = Short.parseShort(string4);
                        } else if (((String)var6_7).equalsIgnoreCase("N")) {
                            name.name = string4.replace('_', ' ');
                        } else if (((String)var6_7).equalsIgnoreCase("G")) {
                            name.geburtName = string4.replace('_', ' ');
                        } else if (((String)var6_7).equalsIgnoreCase("D")) {
                            name.geburtDatum = string4.replace('_', ' ');
                        } else if (((String)var6_7).equalsIgnoreCase("S")) {
                            name.adresse = string4.replace('_', ' ');
                        } else if (((String)var6_7).equalsIgnoreCase("T")) {
                            name.anteil = string4.replace('_', ' ');
                        } else if (((String)var6_7).equalsIgnoreCase("Z")) {
                            name.plzpf = string4.replace('_', ' ');
                        } else if (((String)var6_7).equalsIgnoreCase("F")) {
                            name.postfach = string4.replace('_', ' ');
                        } else if (((String)var6_7).equalsIgnoreCase("P")) {
                            name.plz = string4.replace('_', ' ');
                        } else if (((String)var6_7).equalsIgnoreCase("O")) {
                            name.ort = string4.replace('_', ' ');
                        } else if (((String)var6_7).equalsIgnoreCase("L")) {
                            name.land = Short.parseShort(string4);
                        } else if (((String)var6_7).equalsIgnoreCase("V")) {
                            name.vertretung = string4.replace('_', ' ');
                        } else {
                            throw new IException("unzul\u00e4ssige Variable: " + (String)var6_7);
                        }
                    }
                    ++n;
                }
                catch (Exception exception) {
                    throw new IException("**unzul\u00e4ssige Zeichen in Zeichenkette: " + string2);
                }
            }
        }
        return name;
    }

    @Override
    public final String toDatLine() {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("C!Name:");
        stringBuffer.append(" ");
        stringBuffer.append(Grundbuchblatt.createDatLineKennzeichen(this.gbbl));
        stringBuffer.append("/");
        stringBuffer.append(this.getKennzeichenAsString());
        if (this.getArt() != -1) {
            stringBuffer.append(" E=");
            stringBuffer.append(IFormat.i02.format(this.getArt()));
        }
        if (this.getAktualitaet() != -1) {
            stringBuffer.append(" A=");
            stringBuffer.append(IFormat.i04.format(this.getAktualitaet()));
        }
        if (this.hasName()) {
            stringBuffer.append(" N=");
            stringBuffer.append(this.getName().replace(' ', '_'));
        }
        if (this.hasGeburtName()) {
            stringBuffer.append(" G=");
            stringBuffer.append(this.getGeburtName().replace(' ', '_'));
        }
        if (this.hasGeburtDatum()) {
            stringBuffer.append(" D=");
            stringBuffer.append(this.getGeburtDatum().replace(' ', '_'));
        }
        if (this.hasAdresse()) {
            stringBuffer.append(" S=");
            stringBuffer.append(this.getAdresse().replace(' ', '_'));
        }
        if (this.hasAnteil()) {
            stringBuffer.append(" T=");
            stringBuffer.append(this.getAnteil().replace(' ', '_'));
        }
        if (this.hasPlzPf()) {
            stringBuffer.append(" Z=");
            stringBuffer.append(this.getPlzPf().replace(' ', '_'));
        }
        if (this.hasPostfach()) {
            stringBuffer.append(" F=");
            stringBuffer.append(this.getPostfach().replace(' ', '_'));
        }
        if (this.hasPostleitzahl()) {
            stringBuffer.append(" P=");
            stringBuffer.append(this.getPostleitzahl().replace(' ', '_'));
        }
        if (this.hasOrt()) {
            stringBuffer.append(" O=");
            stringBuffer.append(this.getOrt().replace(' ', '_'));
        }
        if (this.hasLand()) {
            stringBuffer.append(" L=");
            stringBuffer.append(this.getLandAsString());
        }
        if (this.hasVertretung()) {
            stringBuffer.append(" V=");
            stringBuffer.append(this.getVertretung().replace(' ', '_'));
        }
        return stringBuffer.toString();
    }

    public Node toGml() throws Exception {
        Node node = new Node("kafplot:name");
        if (this.hasName()) {
            node.addNode(new Node("kafplot:person", this.getName()));
        }
        if (this.hasGeburtName()) {
            node.addNode(new Node("kafplot:geburt_name", this.getGeburtName()));
        }
        if (this.hasGeburtDatum()) {
            node.addNode(new Node("kafplot:geburt_datum", this.getGeburtDatum()));
        }
        if (this.hasAdresse()) {
            node.addNode(new Node("kafplot:adresse", this.getAdresse()));
        }
        if (this.hasPlzPf()) {
            node.addNode(new Node("kafplot:postleitzahl_postfach", this.getPlzPf()));
        }
        if (this.hasPostfach()) {
            node.addNode(new Node("kafplot:postfach", this.getPostfach()));
        }
        if (this.hasPostleitzahl()) {
            node.addNode(new Node("kafplot:postleitzahl", this.getPostleitzahl()));
        }
        if (this.hasOrt()) {
            node.addNode(new Node("kafplot:ort", this.getOrt()));
        }
        if (this.hasLand()) {
            node.addNode(new Node("kafplot:land", this.getLandAsString()));
        }
        return node;
    }

    public void writeObject(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.bezirk);
        KafPlotIOConstants.writeString(dataOutput, this.gbbl);
        KafPlotIOConstants.writeString(dataOutput, this.plzpf);
        KafPlotIOConstants.writeString(dataOutput, this.postfach);
        KafPlotIOConstants.writeString(dataOutput, this.plz);
        dataOutput.writeLong(this.nr);
        dataOutput.writeInt(this.ea);
        dataOutput.writeShort(this.aktualitaet);
        dataOutput.writeShort(this.land);
        KafPlotIOConstants.writeString(dataOutput, this.anteil);
        KafPlotIOConstants.writeString(dataOutput, this.name);
        KafPlotIOConstants.writeString(dataOutput, this.geburtName);
        KafPlotIOConstants.writeString(dataOutput, this.geburtDatum);
        KafPlotIOConstants.writeString(dataOutput, this.adresse);
        KafPlotIOConstants.writeString(dataOutput, this.ort);
    }

    public static Name readObject(DataInput dataInput) throws IOException {
        Name name = new Name();
        name.bezirk = dataInput.readInt();
        if (KpvIOProperties.RVER >= 200) {
            name.gbbl = KafPlotIOConstants.readString(dataInput);
            name.plzpf = KafPlotIOConstants.readString(dataInput);
            name.postfach = KafPlotIOConstants.readString(dataInput);
            name.plz = KafPlotIOConstants.readString(dataInput);
        } else {
            name.gbbl = Integer.toString(dataInput.readInt());
            name.plzpf = Integer.toString(dataInput.readInt());
            name.postfach = Integer.toString(dataInput.readInt());
            name.plz = Integer.toString(dataInput.readInt());
        }
        name.nr = dataInput.readLong();
        name.ea = KpvIOProperties.RVER >= 200 ? dataInput.readInt() : (int)dataInput.readByte();
        name.aktualitaet = dataInput.readShort();
        name.land = dataInput.readShort();
        name.anteil = KafPlotIOConstants.readString(dataInput);
        name.name = KafPlotIOConstants.readString(dataInput);
        name.geburtName = KafPlotIOConstants.readString(dataInput);
        name.geburtDatum = KafPlotIOConstants.readString(dataInput);
        name.adresse = KafPlotIOConstants.readString(dataInput);
        name.ort = KafPlotIOConstants.readString(dataInput);
        return name;
    }

    public final String toHumanString() {
        return this.toHumanString("\n");
    }

    public final String toHumanString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.hasName()) {
            stringBuffer.append(this.getName());
        }
        if (this.hasGeburtName() || this.hasGeburtDatum()) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(string);
            }
            stringBuffer.append("geb.");
            if (this.hasGeburtName()) {
                stringBuffer.append(" " + this.getGeburtName());
            }
            if (this.hasGeburtDatum()) {
                stringBuffer.append(" " + this.getGeburtDatum());
            }
        }
        if (this.hasAdresse() || this.hasPlzPf() || this.hasPostfach()) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(string);
            }
            if (this.hasAdresse()) {
                stringBuffer.append(this.getAdresse());
            }
            if (this.hasPlzPf() || this.hasPostfach()) {
                stringBuffer.append("PF:");
                if (this.hasPlzPf()) {
                    stringBuffer.append(this.getPlzPf() + "-");
                }
                if (this.hasPostfach()) {
                    stringBuffer.append(this.getPostfach());
                }
            }
        }
        if (this.hasPostleitzahl() || this.hasOrt() || this.hasLand()) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(string);
            }
            if (this.hasLand()) {
                stringBuffer.append(this.getLandAsString() + "-");
            }
            if (this.hasPostleitzahl()) {
                stringBuffer.append(this.getPostleitzahl() + " ");
            }
            if (this.hasOrt()) {
                stringBuffer.append(this.getOrt());
            }
        }
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append(this.getGrundbuchblatt());
        stringBuffer.append("/");
        stringBuffer.append(this.getKennzeichenAsString());
        return stringBuffer.toString();
    }
}

