/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.ErrorDialog;
import de.geocalc.awt.ExceptionList;
import de.geocalc.awt.IBorder;
import de.geocalc.awt.IDialog;
import de.geocalc.awt.IFrame;
import de.geocalc.awt.IPanel;
import de.geocalc.awt.IProgressBar;
import de.geocalc.awt.IProgressElement;
import de.geocalc.io.IFileOutputException;
import de.geocalc.io.Util;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.NummerierungsBezirkTable;
import de.geocalc.kafplot.PunktTable;
import de.geocalc.kafplot.io.IFileWriter;
import de.geocalc.kafplot.io.NasFFWriter;
import de.geocalc.kafplot.io.NasPunktInfoReader;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Hashtable;

public class NasExportDialog
extends IDialog
implements ActionListener {
    DataBase db;
    protected ExceptionList exceptions;
    private static final String FILE_NAME_BUTTON_TEXT = "...";
    private static final String EXPORT_FILE_NAME_COMMAND = "NasExport";
    private static final String OK_COMMAND = "OK";
    private static final String ABORT_COMMAND = "Abbrechen";
    private static final String OPTION_COMMAND = "Optionen";
    private static final String EXPORT_FILE_DEFAULT_NAME = "NasOhneAntrag";
    private TextField fortfuehrungFileNameTextField;
    private Button fortfuehrungFileNameButton;
    private Button okButton;
    private Button optionButton;
    private Button abortButton;
    private Label fortfuehrungFileNameLabel;
    private Label progressLabel;
    private IProgressBar progressBar;
    private String filePath;

    public NasExportDialog(IFrame iFrame, String string, DataBase dataBase, String string2) {
        this(iFrame, string, dataBase, string2, false);
    }

    public NasExportDialog(IFrame iFrame, String string, DataBase dataBase, String string2, boolean bl) {
        super(iFrame, string, !bl);
        this.db = dataBase;
        this.filePath = dataBase.getDestPath();
        this.exceptions = new ExceptionList();
        this.setLayout(new BorderLayout());
        Panel panel = new Panel(new BorderLayout());
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.ipady = 2;
        gridBagConstraints.anchor = 17;
        IPanel iPanel = new IPanel(gridBagLayout);
        iPanel.setBorder(new IBorder(1, "Datei"));
        this.fortfuehrungFileNameLabel = new Label("NAS: ");
        iPanel.add(this.fortfuehrungFileNameLabel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagLayout.setConstraints(this.fortfuehrungFileNameLabel, gridBagConstraints);
        this.fortfuehrungFileNameTextField = new TextField(DataBase.getDestFileDisplayName((string2 != null ? string2 : EXPORT_FILE_DEFAULT_NAME) + ".xml"), 40);
        iPanel.add(this.fortfuehrungFileNameTextField);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(this.fortfuehrungFileNameTextField, gridBagConstraints);
        this.fortfuehrungFileNameButton = new Button(FILE_NAME_BUTTON_TEXT);
        iPanel.add(this.fortfuehrungFileNameButton);
        this.fortfuehrungFileNameButton.setActionCommand(EXPORT_FILE_NAME_COMMAND);
        this.fortfuehrungFileNameButton.addActionListener(this);
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(this.fortfuehrungFileNameButton, gridBagConstraints);
        panel.add("North", iPanel);
        IPanel iPanel2 = new IPanel(new BorderLayout());
        IBorder iBorder = new IBorder(1);
        iPanel2.setBorder(iBorder);
        Panel panel2 = new Panel(new FlowLayout());
        this.progressBar = new IProgressBar();
        panel2.add(this.progressBar);
        iPanel2.add("North", panel2);
        Panel panel3 = new Panel(new GridLayout(1, 1));
        this.progressLabel = new Label();
        panel3.add(this.progressLabel);
        iPanel2.add("South", panel3);
        panel.add("South", iPanel2);
        this.add("North", panel);
        Panel panel4 = new Panel(new FlowLayout(2));
        this.okButton = new Button(OK_COMMAND);
        this.okButton.addActionListener(this);
        panel4.add(this.okButton);
        this.abortButton = new Button(ABORT_COMMAND);
        this.abortButton.addActionListener(this);
        panel4.add(this.abortButton);
        this.add("South", panel4);
        this.pack();
        this.setLocationOfParent(iFrame);
        if (bl) {
            this.setVisible(true);
            this.write();
            this.endDialog();
        }
    }

    public void write() {
        try {
            Object object;
            PunktTable punktTable = new PunktTable();
            Hashtable hashtable = new Hashtable();
            NummerierungsBezirkTable nummerierungsBezirkTable = new NummerierungsBezirkTable();
            Object object2 = this.db.nasFiles();
            while (object2.hasMoreElements()) {
                object = object2.nextElement().toString();
                File file = new File((String)object);
                this.progressLabel.setText("Filtere " + (String)object);
                if (!file.exists()) {
                    this.progressLabel.setText("Datei " + (String)object + " nicht vorhanden");
                    this.exceptions.addException(new Exception("AugangsDatei " + (String)object + " nicht vorhanden"));
                }
                NasPunktInfoReader nasPunktInfoReader = new NasPunktInfoReader(file, punktTable, hashtable, nummerierungsBezirkTable, this.progressBar);
                nasPunktInfoReader.setExceptionList(this.exceptions);
                try {
                    nasPunktInfoReader.read();
                }
                catch (Exception exception) {
                    this.exceptions.addException(exception);
                }
            }
            object2 = Util.getFile(this.filePath, this.fortfuehrungFileNameTextField.getText());
            object = new NasFFWriter((File)object2, this.db, punktTable, nummerierungsBezirkTable);
            ((IFileWriter)object).setExceptionList(this.exceptions);
            ((IProgressElement)object).setProgressBar(this.progressBar);
            ((IProgressElement)object).setProgressLabel(this.progressLabel);
            ((NasFFWriter)object).write();
        }
        catch (IFileOutputException iFileOutputException) {
            ErrorDialog errorDialog = new ErrorDialog(this.parent, iFileOutputException);
            errorDialog.setVisible(true);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(OK_COMMAND)) {
            this.write();
            this.endDialog();
        } else if (string.equals(ABORT_COMMAND)) {
            this.endDialog();
        } else if (!string.equals(OPTION_COMMAND) && string.equals(EXPORT_FILE_NAME_COMMAND)) {
            FileDialog fileDialog = new FileDialog((Frame)this.parent, "Speichern", 1);
            fileDialog.setFile(this.fortfuehrungFileNameTextField.getText());
            fileDialog.setDirectory(this.filePath);
            fileDialog.setVisible(true);
            if (fileDialog.getFile() != null) {
                this.fortfuehrungFileNameTextField.setText(fileDialog.getDirectory() + fileDialog.getFile());
                this.filePath = fileDialog.getDirectory();
            }
        }
    }

    @Override
    protected void endDialog() {
        if (!this.exceptions.isEmpty()) {
            ErrorDialog errorDialog = new ErrorDialog(this.parent, "Es sind Fehler beim Schreiben der Daten aufgetreten, \ndie fehlerhafte Daten wurden markiert.", this.exceptions);
            errorDialog.setVisible(true);
        }
        super.endDialog();
    }

    @Override
    protected void doStandardAction() {
        this.write();
        this.endDialog();
    }

    @Override
    protected void doAbortAction() {
        this.endDialog();
    }
}

