/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.IException;

public class NummerZuschlag {
    private long additive;
    private long border;
    private long zuschlag;
    private int length;

    public NummerZuschlag() {
        this(0L, 0);
    }

    public NummerZuschlag(long l, int n) {
        this.zuschlag = l;
        this.length = n;
        this.calculate();
    }

    public void setZuschlag(long l) {
        this.zuschlag = l;
        this.calculate();
    }

    public long getZuschlag() {
        return this.zuschlag;
    }

    public void setLength(int n) {
        this.length = n;
        this.calculate();
    }

    public int getLength() {
        return this.length;
    }

    public long getNummer(long l) {
        return l < this.border ? l + this.additive : l;
    }

    private void calculate() {
        this.border = (long)Math.rint(Math.pow(10.0, this.length));
        this.additive = this.zuschlag * this.border;
    }

    public static NummerZuschlag parseNummerZuschlag(String string) throws IException {
        NummerZuschlag nummerZuschlag = new NummerZuschlag();
        if (string.length() == 0) {
            return nummerZuschlag;
        }
        int n = string.indexOf("#");
        try {
            if (n < 0) {
                if (Long.parseLong(string) == 0L) {
                    return null;
                }
                throw new IException("In Nummernzuschlag m\u00fcssen Platzhalterzeichen (#) enthalten sein");
            }
            nummerZuschlag.setZuschlag(Long.parseLong(string.substring(0, n)));
            for (int i = n; i < string.length(); ++i) {
                if (string.charAt(i) == '#') continue;
                throw new NumberFormatException();
            }
            nummerZuschlag.setLength(string.length() - n);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IException("Der Nummernzuschlag enth\u00e4lt ung\u00fcltige Zeichen");
        }
        return nummerZuschlag;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(20);
        stringBuffer.append(this.zuschlag);
        for (int i = 0; i < this.length; ++i) {
            stringBuffer.append('#');
        }
        return stringBuffer.toString();
    }
}

