/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.kafplot.DatObject;
import de.geocalc.text.IFormat;

public class NummerierungsBezirk
implements DatObject {
    private int nb;
    private int art;
    private long nrStart;
    private long nrEnde;
    private long nrNext;

    public NummerierungsBezirk() {
    }

    public NummerierungsBezirk(int n, long l, long l2) {
        this(n, l, l2, -1);
    }

    public NummerierungsBezirk(int n, long l, long l2, int n2) {
        this.nb = n;
        this.art = n2;
        this.nrStart = l;
        this.nrEnde = l2;
        this.nrNext = l;
    }

    @Override
    public boolean isOn() {
        return true;
    }

    public int getNb() {
        return this.nb;
    }

    public void setNb(int n) {
        this.nb = n;
    }

    public int getArt() {
        return this.art;
    }

    public void setArt(int n) {
        this.art = n;
    }

    public boolean isArtSpec() {
        return this.art != -1;
    }

    public void reset() {
        this.nrNext = this.nrStart;
    }

    public boolean isFull() {
        return this.nrNext > this.nrEnde;
    }

    public long getNextNummer() {
        if (this.nrNext <= this.nrEnde) {
            return this.nrNext++;
        }
        return 0L;
    }

    public long getNextCandidate() {
        if (this.nrNext <= this.nrEnde) {
            return this.nrNext;
        }
        return 0L;
    }

    public void setStartNummer(long l) {
        this.nrStart = l;
        this.reset();
    }

    public long getStartNummer() {
        return this.nrStart;
    }

    public void setEndeNummer(long l) {
        this.nrEnde = l;
    }

    public long getEndNummer() {
        return this.nrEnde;
    }

    @Override
    public String toDatLine() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("6 ");
        stringBuffer.append(" ");
        stringBuffer.append(IFormat.i14.format(this.nrStart));
        stringBuffer.append(" ");
        stringBuffer.append(IFormat.i14.format(this.nrEnde));
        stringBuffer.append(" ");
        stringBuffer.append(IFormat.i8.format(this.nb));
        stringBuffer.append(" ");
        if (this.art != -1) {
            stringBuffer.append(IFormat.i1.format(this.art));
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return new String(this.nb + "-" + this.art + ": " + this.nrStart + " > " + this.nrEnde);
    }
}

