/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.kafplot.DatContainer;
import de.geocalc.kafplot.DatObject;
import de.geocalc.kafplot.KoordinatenSystem;
import de.geocalc.kafplot.NummerierungsBezirk;
import de.geocalc.kafplot.NummerierungsBezirkException;
import de.geocalc.kafplot.Punkt;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;

public class NummerierungsBezirkTable
extends Vector
implements DatContainer {
    private int numSystem = -1;

    public long getNextCandidate(int n, int n2) throws NummerierungsBezirkException {
        return this.getNextNummer(n, n2, true);
    }

    public long getNextNummer(int n, int n2) throws NummerierungsBezirkException {
        return this.getNextNummer(n, n2, false);
    }

    private long getNextNummer(int n, int n2, boolean bl) throws NummerierungsBezirkException {
        boolean bl2 = false;
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            NummerierungsBezirk nummerierungsBezirk = (NummerierungsBezirk)enumeration.nextElement();
            if (nummerierungsBezirk.getNb() != n || nummerierungsBezirk.isArtSpec() && nummerierungsBezirk.getArt() != n2) continue;
            if (!nummerierungsBezirk.isFull()) {
                return bl ? nummerierungsBezirk.getNextCandidate() : nummerierungsBezirk.getNextNummer();
            }
            bl2 = true;
        }
        if (bl2) {
            throw new NummerierungsBezirkException("Der Nummerierungsbezirk " + n + " ist belegt!");
        }
        throw new NummerierungsBezirkException("F\u00fcr den NummerierungsBezirk " + n + (String)(n2 == -1 ? " " : " PA=" + n2) + " sind keine Punktnummer vorgegeben!");
    }

    public void addElement(NummerierungsBezirk nummerierungsBezirk) throws NummerierungsBezirkException {
        if (nummerierungsBezirk.getStartNummer() <= 0L) {
            throw new NummerierungsBezirkException("StartNummer: " + nummerierungsBezirk.getStartNummer() + " ist ung\u00fcltig!");
        }
        if (nummerierungsBezirk.getEndNummer() <= 0L) {
            throw new NummerierungsBezirkException("EndNummer: " + nummerierungsBezirk.getEndNummer() + " ist ung\u00fcltig!");
        }
        if (nummerierungsBezirk.getEndNummer() < nummerierungsBezirk.getStartNummer()) {
            throw new NummerierungsBezirkException("EndNummer: " + nummerierungsBezirk.getEndNummer() + "ist kleiner als StartNumerer: " + nummerierungsBezirk.getStartNummer() + " !");
        }
        int n = KoordinatenSystem.getSystemOf(new Punkt(nummerierungsBezirk.getNb() / 10000 * 1000, nummerierungsBezirk.getNb() % 10000 * 1000));
        if (this.size() == 0) {
            this.numSystem = n;
        }
        if (n != this.numSystem) {
            throw new NummerierungsBezirkException("System: " + KoordinatenSystem.getSystemName(n) + " ist ungleich des Systems der NummerierungsBezirksTabelle: " + KoordinatenSystem.getSystemName(this.numSystem) + ".\nNur ein Koordinatensystem ist m\u00f6glich!");
        }
        super.addElement(nummerierungsBezirk);
    }

    public void reset() {
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            NummerierungsBezirk nummerierungsBezirk = (NummerierungsBezirk)enumeration.nextElement();
            nummerierungsBezirk.reset();
        }
    }

    public int getNumSystem() {
        return this.numSystem;
    }

    @Override
    public void writeDatContainer(PrintWriter printWriter) {
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            printWriter.println(((DatObject)enumeration.nextElement()).toDatLine());
        }
    }
}

