/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.ExceptionList;
import de.geocalc.awt.IColor;
import de.geocalc.awt.IException;
import de.geocalc.awt.IGraphics;
import de.geocalc.kafplot.DatObject;
import de.geocalc.kafplot.DataContainer;
import de.geocalc.kafplot.Ebene;
import de.geocalc.kafplot.GObject;
import de.geocalc.kafplot.KafPlotProperties;
import de.geocalc.kafplot.LineDisplayProp;
import de.geocalc.kafplot.Linie;
import de.geocalc.kafplot.LinieParameter;
import de.geocalc.kafplot.Message;
import de.geocalc.kafplot.Messager;
import de.geocalc.kafplot.NutzungsArt;
import de.geocalc.kafplot.ObjectDecor;
import de.geocalc.kafplot.ObjectLine;
import de.geocalc.kafplot.ObjectSymbol;
import de.geocalc.kafplot.ObjectText;
import de.geocalc.kafplot.PaintObject;
import de.geocalc.kafplot.Text;
import de.geocalc.kafplot.TextSymbol;
import de.geocalc.kafplot.io.KafPlotIOConstants;
import de.geocalc.kafplot.io.xml.XmlIOProperties;
import de.geocalc.kataster.model.Alkis;
import de.geocalc.lang.Exceptionable;
import de.geocalc.text.IFormat;
import de.geocalc.util.Comparable;
import de.geocalc.util.Comparator;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Toolkit;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class Nutzung
extends GObject
implements PaintObject,
DatObject,
Comparable,
Exceptionable,
Messager {
    private int count = 0;
    private int art = 0;
    private static final Text text = new Text(2, 2, null, 0.0, 0.0, 0.0, 1, 0);
    private static final TextSymbol sym = new TextSymbol(text, new Point());
    private static final Point p = new Point();
    private static final Font font = Alkis.FONT_NUTZUNG;

    public Nutzung() {
        this(0, 0);
    }

    public Nutzung(int n, int n2) {
        this.art = n;
        this.setOska(n2);
    }

    public int getArt() {
        return this.art;
    }

    public void setArt(int n) {
        this.art = n;
    }

    @Override
    public LinieParameter getLineDefaults() {
        return LinieParameter.NUTZ;
    }

    @Override
    public boolean defMultiArea() {
        return true;
    }

    @Override
    public boolean isVoid() {
        return this.count == 0;
    }

    @Override
    public void deleteName() {
        this.count = 0;
    }

    public boolean equals(Object object) {
        if (object instanceof Nutzung) {
            return this.compareTo(object) == 0;
        }
        return false;
    }

    @Override
    public int compareTo(Object object) {
        Nutzung nutzung = (Nutzung)object;
        if (this.count == nutzung.count) {
            return 0;
        }
        if (this.count > nutzung.count) {
            return 1;
        }
        return -1;
    }

    public void setNummer(int n) {
        this.count = n;
    }

    public int getNummer() {
        return this.count;
    }

    public String getNummerAsString() {
        return this.count > 0 ? IFormat.i06.format(this.count) : "";
    }

    public void setCount(int n) {
        this.count = n;
    }

    public int getCount() {
        return this.count;
    }

    @Override
    public String getName() {
        NutzungsArt nutzungsArt;
        StringBuffer stringBuffer = new StringBuffer("NU");
        if (this.count != 0) {
            stringBuffer.append(IFormat.i06.format(this.count).toString());
        }
        if (this.getArt() != 0) {
            stringBuffer.append(" N=");
            stringBuffer.append(this.getArt());
        }
        if ((nutzungsArt = NutzungsArt.getNutzungsArt(this.getArt())) != null) {
            stringBuffer.append(" ( " + nutzungsArt.getAbkuerzung() + " )");
        }
        return stringBuffer.toString();
    }

    @Override
    public Message getMessage() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClassName());
        stringBuffer.append(": ");
        stringBuffer.append(this.getName());
        return new Message(this, stringBuffer.toString());
    }

    @Override
    public String getClassName() {
        return "Nutzung";
    }

    @Override
    public String getObjectName() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.count != 0) {
            stringBuffer.append(IFormat.i06.format(this.count));
        }
        if (this.getArt() != 0) {
            stringBuffer.append(" N=");
            stringBuffer.append(IFormat.i05.format(this.getArt()).toString());
        }
        if (this.getOska() != 0) {
            stringBuffer.append(" O=");
            stringBuffer.append(this.getOska());
        }
        if (this.hasLocation()) {
            stringBuffer.append(" Y=");
            stringBuffer.append(IFormat.f_3.format(this.y).toString());
            stringBuffer.append(" X=");
            stringBuffer.append(IFormat.f_3.format(this.x).toString());
        }
        return stringBuffer.toString();
    }

    @Override
    public String toDebugString() {
        return this.getClassName() + ": " + this.getObjectName();
    }

    public static DataContainer parseDatLine(String string) throws IException {
        Nutzung nutzung = new Nutzung();
        int n = 0;
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                try {
                    if (n == 0 && string2.startsWith("NU")) {
                        ++n;
                        try {
                            nutzung.setNummer(Integer.parseInt(string2.substring(2)));
                            continue;
                        }
                        catch (Exception exception) {
                            throw new IException("fehlerhaftes Objektkennzeichen");
                        }
                    }
                    ++n;
                    int n2 = string2.indexOf(61);
                    String string3 = string2.substring(0, n2);
                    String string4 = string2.substring(n2 + 1);
                    if (string3.equalsIgnoreCase("N")) {
                        nutzung.setArt(Integer.parseInt(string4));
                        continue;
                    }
                    if (string3.equalsIgnoreCase("O")) {
                        nutzung.setOska(Integer.parseInt(string4));
                        continue;
                    }
                    if (string3.equalsIgnoreCase("Y")) {
                        nutzung.y = Double.parseDouble(string4);
                        continue;
                    }
                    if (string3.equalsIgnoreCase("X")) {
                        nutzung.x = Double.parseDouble(string4);
                        continue;
                    }
                    throw new IException("unzul\u00e4ssige Variable: " + string3);
                }
                catch (Exception exception) {
                    throw new IException("unzul\u00e4ssige Zeichen in Zeichenkette: " + string2);
                }
            }
        }
        return nutzung;
    }

    @Override
    public final String toDatLine() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("C!Nutz:");
        stringBuffer.append(" ");
        if (this.count != 0) {
            stringBuffer.append("NU");
            stringBuffer.append(IFormat.i06.format(this.count).toString());
        }
        if (this.getArt() != 0) {
            stringBuffer.append(" N=");
            stringBuffer.append(this.getArt());
        }
        if (this.getOska() != 0) {
            stringBuffer.append(" O=");
            stringBuffer.append(this.getOska());
        }
        if (this.hasLocation()) {
            stringBuffer.append(" Y=");
            stringBuffer.append(IFormat.f_3.format(this.y).toString());
            stringBuffer.append(" X=");
            stringBuffer.append(IFormat.f_3.format(this.x).toString());
        }
        return stringBuffer.toString();
    }

    public void writeXmlLine(PrintWriter printWriter) throws IOException {
        printWriter.println(XmlIOProperties.openln("nutzung"));
        if (this.count != 0) {
            printWriter.println(XmlIOProperties.data("idnr", Integer.toString(this.count)));
        }
        if (this.hasLocation()) {
            printWriter.println(XmlIOProperties.data("y", IFormat.f_3.format(this.y).toString()));
            printWriter.println(XmlIOProperties.data("x", IFormat.f_3.format(this.x).toString()));
        }
        if (this.getArt() != 0) {
            printWriter.println(XmlIOProperties.data("nutz", IFormat.i05.format(this.getArt()).toString()));
        }
        printWriter.println(XmlIOProperties.open("linien"));
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            printWriter.println(((Linie)enumeration.nextElement()).toXmlLine());
        }
        printWriter.println(XmlIOProperties.close("linien"));
        printWriter.println(XmlIOProperties.close("nutzung"));
    }

    @Override
    public void writeObject(DataOutput dataOutput) throws IOException {
        dataOutput.writeDouble(this.y);
        dataOutput.writeDouble(this.x);
        if (this.yt != 0.0 || this.xt != 0.0) {
            dataOutput.writeByte(8);
            dataOutput.writeDouble(this.yt);
            dataOutput.writeDouble(this.xt);
        } else {
            dataOutput.writeByte(0);
        }
        dataOutput.writeFloat(this.getTextAngle());
        dataOutput.writeInt(this.count);
        dataOutput.writeInt(this.art);
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            ((Linie)enumeration.nextElement()).writeObject(dataOutput);
        }
        if (this.hasDecor()) {
            enumeration = this.decors();
            while (enumeration.hasMoreElements()) {
                ((ObjectDecor)enumeration.nextElement()).writeObject(dataOutput);
            }
        }
        if (this.att != null) {
            enumeration = this.attributes();
            while (enumeration.hasMoreElements()) {
                dataOutput.writeByte(110);
                String string = (String)enumeration.nextElement();
                KafPlotIOConstants.writeString(dataOutput, string);
                KafPlotIOConstants.writeString(dataOutput, this.getAttribute(string).toString());
            }
        }
        dataOutput.writeByte(0);
    }

    public static Nutzung readObject(DataInput dataInput) throws IOException {
        Nutzung nutzung = new Nutzung();
        nutzung.y = dataInput.readDouble();
        nutzung.x = dataInput.readDouble();
        if (dataInput.readByte() != 0) {
            nutzung.yt = dataInput.readDouble();
            nutzung.xt = dataInput.readDouble();
        }
        nutzung.setTextAngle(dataInput.readFloat());
        nutzung.count = dataInput.readInt();
        nutzung.art = dataInput.readInt();
        byte by = 0;
        while ((by = dataInput.readByte()) != -1) {
            if (by == 15) {
                nutzung.addElement(Linie.readObject(dataInput));
                continue;
            }
            if (by == 61) {
                nutzung.addDecor(ObjectText.readObject(dataInput));
                continue;
            }
            if (by == 62) {
                nutzung.addDecor(ObjectSymbol.readObject(dataInput));
                continue;
            }
            if (by == 63) {
                nutzung.addDecor(ObjectLine.readObject(dataInput));
                continue;
            }
            if (by != 110) break;
            nutzung.setAttribute(KafPlotIOConstants.readString(dataInput), KafPlotIOConstants.readString(dataInput));
        }
        return nutzung;
    }

    @Override
    public Vector getKatasterNachweisLinien(ExceptionList exceptionList) {
        return new Vector(1);
    }

    @Override
    public void drawObject(IGraphics iGraphics, boolean bl, boolean bl2) {
        if (!this.isVisible() || !this.isViewable(iGraphics.getViewport())) {
            return;
        }
        if (bl2 || KafPlotProperties.isFlaecheFillVisible && KafPlotProperties.isNutzFillVisible) {
            this.drawBackground(iGraphics, bl, bl2);
        }
        if (bl2 || KafPlotProperties.isFlaechePolyVisible && KafPlotProperties.isNutzPolyVisible) {
            this.drawForeground(iGraphics, bl, bl2);
        }
        if (KafPlotProperties.isFlaecheTextVisible) {
            this.drawInscription(iGraphics, bl, bl2);
        }
        if (bl2) {
            this.drawHashpoint(iGraphics, bl, bl2);
        }
    }

    @Override
    public void drawForeground(IGraphics iGraphics, boolean bl, boolean bl2) {
        Linie.objectDisplayProp = LineDisplayProp.getObjectProp(this.getOska());
        if (super.getColor() != null) {
            if (Linie.objectDisplayProp != null) {
                Linie.objectDisplayProp = new LineDisplayProp(Linie.objectDisplayProp);
                Linie.objectDisplayProp.setColor(super.getColor());
            } else {
                Linie.objectDisplayProp = new LineDisplayProp(0, super.getColor(), 1, 0);
            }
        }
        super.drawForeground(iGraphics, bl, bl2);
        Linie.objectDisplayProp = null;
    }

    @Override
    public void drawBackground(IGraphics iGraphics, boolean bl, boolean bl2) {
        if (this.size() > 0 && KafPlotProperties.getColorSwitch() == 1002) {
            iGraphics.getGraphics().setColor(KafPlotProperties.aNuColor.getColor(new Integer(this.getArt())));
            super.drawBackground(iGraphics, bl, bl2);
        }
    }

    @Override
    public void drawInscription(IGraphics iGraphics, boolean bl, boolean bl2) {
        Object object;
        if (!this.isVisible() || !this.isViewable(iGraphics.getViewport())) {
            return;
        }
        Graphics graphics = iGraphics.getGraphics();
        Color color = Ebene.getColor(47);
        if (KafPlotProperties.getColorSwitch() == 1009) {
            color = KafPlotProperties.aBgColor.getColor("O");
        } else if (KafPlotProperties.getColorSwitch() == 1004 && !this.isFortfuehrung()) {
            color = IColor.getDarker(KafPlotProperties.aFoColor.getColor("F0"), 0.85f);
        }
        graphics.setColor(color);
        if (this.hasLocation() && KafPlotProperties.isNutzTextVisible && iGraphics.contains(this.y, this.x)) {
            Object object2;
            object = Toolkit.getDefaultToolkit().getFontMetrics(font);
            int n = ((FontMetrics)object).getHeight();
            Point point = new Point();
            point = iGraphics.getGraphicPoint(this.y, this.x, point);
            graphics.setFont(font);
            if (KafPlotProperties.isNutzTextVisible && (object2 = NutzungsArt.getNutzungsArt(this.art)) != null) {
                String string = ((NutzungsArt)object2).getAbkuerzung();
                int n2 = ((FontMetrics)object).stringWidth(string);
                graphics.drawString(string, point.x - n2 / 2, point.y + (KafPlotProperties.isNutzNumberVisible ? 0 : n / 2));
            }
            if (KafPlotProperties.isNutzNumberVisible) {
                object2 = "(" + this.art + ")";
                int n3 = ((FontMetrics)object).stringWidth((String)object2);
                graphics.drawString((String)object2, point.x - n3 / 2, point.y + (KafPlotProperties.isNutzTextVisible ? n : n / 2));
            }
        }
        if (this.hasDecor()) {
            object = this.decors();
            while (object.hasMoreElements()) {
                ObjectDecor objectDecor = (ObjectDecor)object.nextElement();
                objectDecor.setColor(color);
                if (objectDecor instanceof ObjectSymbol) {
                    if (!KafPlotProperties.isTopSymVisible) continue;
                    objectDecor.drawObject(iGraphics, bl, bl2);
                    continue;
                }
                if (!KafPlotProperties.isTopTextVisible) continue;
                objectDecor.drawObject(iGraphics, bl, bl2);
            }
        }
    }

    public static Comparator getDefaultComparator() {
        return new NutzungComparator();
    }

    private static class NutzungComparator
    implements Comparator {
        private NutzungComparator() {
        }

        @Override
        public int compare(Object object, Object object2) {
            Nutzung nutzung = (Nutzung)object;
            Nutzung nutzung2 = (Nutzung)object2;
            return nutzung.getArt() - nutzung2.getArt();
        }
    }
}

