/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.IBorder;
import de.geocalc.awt.IFrame;
import de.geocalc.awt.IPanel;
import de.geocalc.awt.ITable;
import de.geocalc.awt.ITableCell;
import de.geocalc.awt.ITableLine;
import de.geocalc.awt.event.ElementInfoEvent;
import de.geocalc.awt.event.ITableEvent;
import de.geocalc.awt.event.ITableListener;
import de.geocalc.kafplot.Nutzung;
import de.geocalc.kafplot.NutzungsArt;
import de.geocalc.kafplot.ObjectInfoDialog;
import de.geocalc.kafplot.event.DataBaseEvent;
import de.geocalc.kafplot.event.DataBaseListener;
import de.geocalc.kataster.model.Alkis;
import java.awt.Button;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;

public class NutzungInfoDialog
extends ObjectInfoDialog
implements ActionListener,
ITableListener,
DataBaseListener {
    private static final String ART_COMMAND = "_Art";
    private Label idLabel;
    private Label oskaLabel;
    private Label oskaNameLabel;
    private Label artLabel;
    private Label artNameLabel;
    private Button artButton;

    public NutzungInfoDialog(IFrame iFrame, String string) {
        this(iFrame, string, (Nutzung)null);
    }

    public NutzungInfoDialog(IFrame iFrame, String string, Nutzung nutzung) {
        super(iFrame, string, nutzung);
    }

    @Override
    protected Panel createInfoPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        IPanel iPanel = new IPanel(gridBagLayout);
        iPanel.setBorder(new IBorder(0));
        Label label = new Label("Kennzeichen: ", 0);
        iPanel.add(label);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.idLabel = new Label("", 0);
        iPanel.add(this.idLabel);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 2;
        gridBagLayout.setConstraints(this.idLabel, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        label = new Label("Oska: ", 0);
        iPanel.add(label);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.oskaLabel = new Label("", 0);
        iPanel.add(this.oskaLabel);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(this.oskaLabel, gridBagConstraints);
        this.oskaNameLabel = new Label("", 0);
        iPanel.add(this.oskaNameLabel);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.oskaNameLabel, gridBagConstraints);
        this.artButton = new Button("...");
        iPanel.add(this.artButton);
        this.artButton.setActionCommand(ART_COMMAND);
        this.artButton.addActionListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(this.artButton, gridBagConstraints);
        label = new Label("Nutzung: ", 0);
        iPanel.add(label);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.artLabel = new Label("", 0);
        iPanel.add(this.artLabel);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(this.artLabel, gridBagConstraints);
        this.artNameLabel = new Label("", 0);
        iPanel.add(this.artNameLabel);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.artNameLabel, gridBagConstraints);
        return iPanel;
    }

    @Override
    protected ITable createTable() {
        ITable iTable = new ITable(6);
        ITableCell[] iTableCellArray = new ITableCell[]{new ITableCell("Art", 0), new ITableCell("Bereich", 0), new ITableCell("Gruppe", 0), new ITableCell("Nutzungsart", 0), new ITableCell("1. Untergliederung", 0), new ITableCell("2. Untergliederung", 0)};
        iTable.setHeader(new ITableLine(iTableCellArray));
        iTable.addTableListener(this);
        return iTable;
    }

    @Override
    public void setObject(Object object) {
        super.setObject(object);
        Nutzung nutzung = (Nutzung)object;
        this.table.removeLines();
        if (nutzung != null) {
            this.addObjectToTable(nutzung);
        }
        this.table.doLayout();
        this.table.requestFocus();
    }

    public void setObjects(Enumeration enumeration) {
        this.table.removeLines();
        while (enumeration.hasMoreElements()) {
            Nutzung nutzung = (Nutzung)enumeration.nextElement();
            this.addObjectToTable(nutzung);
        }
        this.table.select(0);
        this.table.doLayout();
        this.table.requestFocus();
    }

    @Override
    protected void showObject(Object object) {
        if (object != null && object instanceof Nutzung) {
            Nutzung nutzung = (Nutzung)object;
            this.idLabel.setText(nutzung.getName());
            this.oskaLabel.setText(Integer.toString(nutzung.getOska()));
            this.oskaNameLabel.setText(Alkis.getObjectName(nutzung.getOska()));
            this.artLabel.setText(Integer.toString(nutzung.getArt()));
            NutzungsArt nutzungsArt = NutzungsArt.getNutzungsArt(nutzung.getArt());
            if (nutzungsArt != null) {
                this.artNameLabel.setText(nutzungsArt.createFullName());
            }
        } else {
            this.oskaLabel.setText("");
            this.oskaNameLabel.setText("");
            this.artLabel.setText("");
            this.artNameLabel.setText("");
        }
    }

    private void addObjectToTable(Nutzung nutzung) {
        ITableCell[] iTableCellArray = new ITableCell[6];
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        if (nutzung != null) {
            NutzungsArt nutzungsArt;
            NutzungsArt nutzungsArt2;
            NutzungsArt nutzungsArt3;
            NutzungsArt nutzungsArt4;
            int n = nutzung.getArt();
            NutzungsArt nutzungsArt5 = NutzungsArt.getKlasse(n);
            if (nutzungsArt5 != null) {
                string = nutzungsArt5.getBezeichnung();
            }
            if ((nutzungsArt4 = NutzungsArt.getGruppe(n)) != null) {
                string2 = nutzungsArt4.getBezeichnung();
            }
            if ((nutzungsArt3 = NutzungsArt.getNutzung(n)) != null) {
                string3 = nutzungsArt3.getBezeichnung();
            }
            if ((nutzungsArt2 = NutzungsArt.getUnterNutzung1(n)) != null) {
                string4 = nutzungsArt2.getBezeichnung();
            }
            if ((nutzungsArt = NutzungsArt.getUnterNutzung2(n)) != null) {
                string5 = nutzungsArt.getBezeichnung();
            }
        }
        iTableCellArray[0] = new ITableCell(Integer.toString(nutzung.getArt()), 0);
        iTableCellArray[1] = new ITableCell(string, 0);
        iTableCellArray[2] = new ITableCell(string2, 0);
        iTableCellArray[3] = new ITableCell(string3, 0);
        iTableCellArray[4] = new ITableCell(string4, 0);
        iTableCellArray[5] = new ITableCell(string5, 0);
        this.table.addLine(new ITableLine(iTableCellArray, nutzung));
    }

    @Override
    public void dataBaseUpdated(DataBaseEvent dataBaseEvent) {
    }

    @Override
    public void cellClicked(ITableEvent iTableEvent) {
        Nutzung nutzung = (Nutzung)iTableEvent.getContent();
        this.object = nutzung;
        this.showObject(nutzung);
        if (!(iTableEvent.getClickCount() <= 1 || iTableEvent.getCol() == 0 && this.elementListener != null || iTableEvent.getCol() == 1 && this.elementListener != null || this.actionListener == null || this.actionCommand == null)) {
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, this.actionCommand));
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(ART_COMMAND)) {
            if (this.object != null && this.object instanceof Nutzung) {
                this.elementListener.elementClicked(new ElementInfoEvent(actionEvent.getSource(), NutzungsArt.getNutzungsArt(((Nutzung)this.object).getArt()), actionEvent.getID(), 2, actionEvent.getModifiers()));
            }
        } else {
            super.actionPerformed(actionEvent);
        }
    }
}

