/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.geodata.Feature;
import de.geocalc.geom.GeomException;
import de.geocalc.kafplot.DataContainerTable;
import de.geocalc.kafplot.Nutzung;

public class NutzungTable
extends DataContainerTable {
    private int countVoid = 0;

    public NutzungTable() {
        this.reset();
    }

    public void reset() {
        this.countVoid = 0;
    }

    @Override
    public void put(Feature feature) throws GeomException {
        Nutzung nutzung = (Nutzung)feature;
        if (nutzung.isVoid()) {
            nutzung.setCount(++this.countVoid);
        } else {
            this.countVoid = Math.max(this.countVoid, nutzung.getCount());
        }
        for (int i = 0; i < this.size(); ++i) {
            Nutzung nutzung2 = (Nutzung)this.elementAt(i);
            int n = nutzung2.compareTo(nutzung);
            if (n > 0) {
                super.insertElementAt(nutzung, i);
                return;
            }
            if (n != 0) continue;
            throw new GeomException(nutzung.getHashPoint(), nutzung.getPolygon(), nutzung.getClassName() + ": " + nutzung.getObjectName() + " ist doppelt vergeben");
        }
        super.addElement(nutzung);
    }

    public void addElement(Feature feature) {
        Nutzung nutzung = (Nutzung)feature;
        if (nutzung.isVoid()) {
            nutzung.setCount(++this.countVoid);
        } else {
            this.countVoid = Math.max(this.countVoid, nutzung.getCount());
        }
        super.addElement(nutzung);
    }

    @Override
    public Feature get(Feature feature) {
        return null;
    }
}

