/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.kafplot.PropertyLoader;
import de.geocalc.kafplot.io.KafPlotIOConstants;
import de.geocalc.text.IFormat;
import de.geocalc.util.IntegerHashList;
import de.geocalc.util.IntegerHashObject;
import java.awt.Color;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class NutzungsArt
implements IntegerHashObject {
    public static final int VOID = 0;
    public static final int MAX_ALK = 9999;
    public static final int MAX_ALKIS2014 = 99999;
    private static final IntegerHashList arten = new IntegerHashList();
    private static Vector sort = new Vector();
    private static final Color STANDARD_COLOR = new Color(200, 200, 200);
    private int art;
    private int unterGruppe;
    private String bez;
    private String abk;
    private Color color;
    private boolean isZul;

    public NutzungsArt() {
        this(0, null, null, null, false);
    }

    public NutzungsArt(int n) {
        this(n, null, null, null, false);
    }

    public NutzungsArt(int n, String string, String string2) {
        this(n, string, string2, null, false);
    }

    public NutzungsArt(int n, String string, String string2, Color color, boolean bl) {
        this.art = n;
        this.bez = string;
        this.abk = string2;
        this.color = color != null ? color : STANDARD_COLOR;
        this.isZul = bl;
    }

    @Override
    public final int intHashKey() {
        return this.art;
    }

    public int getArt() {
        return this.art;
    }

    public void setBezeichnung(String string) {
        this.bez = string;
    }

    public String getBezeichnung() {
        return this.bez;
    }

    public void setAbkuerzung(String string) {
        this.abk = string;
    }

    public String getAbkuerzung() {
        return this.abk;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Color getColor() {
        return this.color;
    }

    public boolean isValid() {
        return this.isZul;
    }

    public int hashCode() {
        return this.art;
    }

    public int getUnderGroupLevels() {
        return this.unterGruppe;
    }

    public boolean equals(Object object) {
        if (object instanceof NutzungsArt) {
            NutzungsArt nutzungsArt = (NutzungsArt)object;
            return nutzungsArt.art == this.art;
        }
        return false;
    }

    public String createFullName() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getBezeichnung());
        int n = 10;
        int n2 = 0;
        while (n2 < 4) {
            NutzungsArt nutzungsArt;
            int n3 = this.art / n * n;
            if (n3 != this.art && (nutzungsArt = (NutzungsArt)arten.get(n3)) != null) {
                stringBuffer.insert(0, " > ");
                stringBuffer.insert(0, nutzungsArt.getBezeichnung());
            }
            ++n2;
            n *= 10;
        }
        return stringBuffer.toString();
    }

    public static void load(InputStream inputStream) throws IOException {
        LineNumberReader lineNumberReader = null;
        String string = null;
        Color color = null;
        try {
            String string2;
            lineNumberReader = PropertyLoader.createReader(inputStream);
            while ((string2 = lineNumberReader.readLine()) != null) {
                String string3;
                if (string2.length() == 0 || string2.startsWith("#")) continue;
                StringTokenizer stringTokenizer = new StringTokenizer(string2, "=");
                int n = 0;
                if (!stringTokenizer.hasMoreElements()) {
                    throw new IOException("fehlende Werte");
                }
                try {
                    n = Integer.parseInt(stringTokenizer.nextToken().trim());
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IOException("nicht numerischer Schl\u00fcssel");
                }
                if (!stringTokenizer.hasMoreElements()) {
                    throw new IOException("fehlende Werte");
                }
                boolean bl = false;
                try {
                    bl = IFormat.parseBoolean(stringTokenizer.nextToken());
                }
                catch (Exception exception) {
                    throw new IOException("Unzul\u00e4ssiger Wert in ZUL");
                }
                if (!stringTokenizer.hasMoreElements()) {
                    throw new IOException("fehlende Werte");
                }
                String string4 = stringTokenizer.nextToken().trim();
                if (stringTokenizer.hasMoreElements() && (string3 = stringTokenizer.nextToken().trim()).length() > 0) {
                    string = string3;
                }
                if (stringTokenizer.hasMoreElements()) {
                    try {
                        color = IFormat.parseColor(stringTokenizer.nextToken().trim());
                    }
                    catch (Exception exception) {
                        throw new IOException("fehlerhafte Farbangabe");
                    }
                }
                arten.put(new NutzungsArt(n, string4, string, color, bl));
            }
            NutzungsArt.rehash();
        }
        catch (IOException iOException) {
            throw new IOException("Fehler in Zeile: " + (lineNumberReader != null ? lineNumberReader.getLineNumber() : 0) + "\n" + iOException.getMessage());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void rehash() {
        NutzungsArt nutzungsArt;
        int n;
        NutzungsArt nutzungsArt2;
        sort = new Vector();
        Enumeration enumeration = arten.elements();
        while (enumeration.hasMoreElements()) {
            nutzungsArt2 = (NutzungsArt)enumeration.nextElement();
            for (n = 0; n < sort.size(); ++n) {
                nutzungsArt = (NutzungsArt)sort.elementAt(n);
                if (nutzungsArt.getArt() <= nutzungsArt2.getArt()) continue;
                sort.insertElementAt(nutzungsArt2, n);
                nutzungsArt2 = null;
                break;
            }
            if (nutzungsArt2 == null) continue;
            sort.addElement(nutzungsArt2);
        }
        for (int i = sort.size() - 1; i >= 0; --i) {
            nutzungsArt2 = (NutzungsArt)sort.elementAt(i);
            n = nutzungsArt2.getArt();
            if (n % 10 != 0) {
                nutzungsArt = NutzungsArt.getNutzungsArt(n / 10 * 10);
                if (nutzungsArt == null) continue;
                nutzungsArt.unterGruppe = nutzungsArt2.unterGruppe + 1;
                continue;
            }
            if (n % 100 == 0 || (nutzungsArt = NutzungsArt.getNutzungsArt(n / 100 * 100)) == null) continue;
            nutzungsArt.unterGruppe = nutzungsArt2.unterGruppe + 1;
        }
    }

    public static NutzungsArt getNutzungsArt(int n) {
        return (NutzungsArt)arten.get(n);
    }

    public static NutzungsArt getKlasse(int n) {
        int n2 = n < 9999 ? 100 : 10000;
        return (NutzungsArt)arten.get(n / n2 * n2);
    }

    public static NutzungsArt getGruppe(int n) {
        int n2 = n < 9999 ? 10 : 1000;
        return (NutzungsArt)arten.get(n / n2 * n2);
    }

    public static NutzungsArt getNutzung(int n) {
        int n2 = n < 9999 ? 1 : 100;
        return (NutzungsArt)arten.get(n / n2 * n2);
    }

    public static NutzungsArt getUnterNutzung1(int n) {
        return n < 9999 || n % 100 / 10 == 0 ? null : (NutzungsArt)arten.get(n / 10 * 10);
    }

    public static NutzungsArt getUnterNutzung2(int n) {
        return n < 9999 || n % 10 == 0 ? null : (NutzungsArt)arten.get(n);
    }

    public static int indexOf(int n) {
        return sort.indexOf(new NutzungsArt(n));
    }

    public static Enumeration elements() {
        return arten.elements();
    }

    public static Enumeration getKatalog() {
        if (sort.size() != arten.size()) {
            NutzungsArt.rehash();
        }
        return sort.elements();
    }

    public void writeObject(DataOutput dataOutput) throws IOException {
        dataOutput.writeShort(this.art);
        KafPlotIOConstants.writeString(dataOutput, this.bez);
        KafPlotIOConstants.writeString(dataOutput, this.abk);
        dataOutput.writeInt(this.color.getRGB());
    }

    public static NutzungsArt readObject(DataInput dataInput) throws IOException {
        NutzungsArt nutzungsArt = new NutzungsArt();
        nutzungsArt.art = dataInput.readShort();
        nutzungsArt.bez = KafPlotIOConstants.readString(dataInput);
        nutzungsArt.abk = KafPlotIOConstants.readString(dataInput);
        nutzungsArt.color = new Color(dataInput.readInt());
        return nutzungsArt;
    }

    public static void saveObject(NutzungsArt nutzungsArt) {
        if (nutzungsArt == null) {
            throw new NullPointerException("NutzungsArt");
        }
        arten.put(nutzungsArt);
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.art + "," + this.abk + "," + this.bez + "]";
    }
}

