/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.IBorder;
import de.geocalc.awt.IFrame;
import de.geocalc.awt.IPanel;
import de.geocalc.awt.ITable;
import de.geocalc.awt.ITableCell;
import de.geocalc.awt.ITableLine;
import de.geocalc.awt.event.ITableEvent;
import de.geocalc.awt.event.ITableListener;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.NutzungsArt;
import de.geocalc.kafplot.ObjectInfoDialog;
import de.geocalc.kafplot.event.DataBaseEvent;
import java.awt.Checkbox;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;

public class NutzungsArtInfoDialog
extends ObjectInfoDialog
implements ITableListener,
ItemListener {
    private Checkbox validCheckbox;
    private Label klasseLabel;
    private Label gruppeLabel;
    private Label nutzungLabel;

    public NutzungsArtInfoDialog(IFrame iFrame, String string) {
        this(iFrame, string, (NutzungsArt)null);
    }

    public NutzungsArtInfoDialog(IFrame iFrame, String string, NutzungsArt nutzungsArt) {
        super(iFrame, string, nutzungsArt);
    }

    @Override
    protected Panel createInfoPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        IPanel iPanel = new IPanel(gridBagLayout);
        iPanel.setBorder(new IBorder(1, "Bezeichnung"));
        this.validCheckbox = new Checkbox("nur zul\u00e4ssige Arten anzeigen", true);
        iPanel.add(this.validCheckbox);
        this.validCheckbox.addItemListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(this.validCheckbox, gridBagConstraints);
        this.klasseLabel = new Label("", 0);
        iPanel.add(this.klasseLabel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.klasseLabel, gridBagConstraints);
        this.gruppeLabel = new Label("", 0);
        iPanel.add(this.gruppeLabel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(this.gruppeLabel, gridBagConstraints);
        this.nutzungLabel = new Label("", 0);
        iPanel.add(this.nutzungLabel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagLayout.setConstraints(this.nutzungLabel, gridBagConstraints);
        return iPanel;
    }

    @Override
    protected ITable createTable() {
        ITable iTable = new ITable(3);
        ITableCell[] iTableCellArray = new ITableCell[]{new ITableCell("Schl\u00fcssel", 0), new ITableCell("Abk.", 0), new ITableCell("Bezeichnung", -10)};
        iTable.setHeader(new ITableLine(iTableCellArray));
        this.addTableLines(iTable);
        iTable.addTableListener(this);
        return iTable;
    }

    private void addTableLines(ITable iTable) {
        Enumeration enumeration = NutzungsArt.getKatalog();
        while (enumeration.hasMoreElements()) {
            NutzungsArt nutzungsArt = (NutzungsArt)enumeration.nextElement();
            if (this.validCheckbox.getState() && !nutzungsArt.isValid() || (DataBase.model.getModel() == 2 ? DataBase.nutzVersion == 2 && nutzungsArt.getArt() < 99999 || DataBase.nutzVersion == 1 && (nutzungsArt.getArt() < 9999 || nutzungsArt.getArt() > 99999) : nutzungsArt.getArt() > 9999)) continue;
            ITableCell[] iTableCellArray = new ITableCell[]{new ITableCell(new Integer(nutzungsArt.getArt()).toString(), 0), new ITableCell(nutzungsArt.getAbkuerzung(), 0), new ITableCell(nutzungsArt.getBezeichnung(), -10)};
            iTable.addLine(new ITableLine(iTableCellArray, nutzungsArt));
        }
    }

    @Override
    public void setObject(Object object) {
        this.table.select(object);
        super.setObject(object);
    }

    @Override
    public void showObject(Object object) {
        NutzungsArt nutzungsArt = (NutzungsArt)object;
        if (nutzungsArt == null) {
            this.klasseLabel.setText("");
            this.gruppeLabel.setText("");
            this.nutzungLabel.setText("");
        } else {
            this.table.select(nutzungsArt);
            NutzungsArt nutzungsArt2 = NutzungsArt.getKlasse(nutzungsArt.getArt());
            this.klasseLabel.setText(nutzungsArt2 != null ? nutzungsArt2.getBezeichnung() : "");
            NutzungsArt nutzungsArt3 = NutzungsArt.getGruppe(nutzungsArt.getArt());
            this.gruppeLabel.setText(nutzungsArt3 != null ? nutzungsArt3.getBezeichnung() : "");
            NutzungsArt nutzungsArt4 = NutzungsArt.getNutzungsArt(nutzungsArt.getArt());
            this.nutzungLabel.setText(nutzungsArt4 != null ? nutzungsArt4.getBezeichnung() : "");
        }
    }

    @Override
    public void cellClicked(ITableEvent iTableEvent) {
        this.showObject(iTableEvent.getContent());
    }

    @Override
    public void dataBaseUpdated(DataBaseEvent dataBaseEvent) {
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = this.table.getSelectedObject();
        this.table.removeLines();
        this.addTableLines(this.table);
        this.table.repaint();
        this.table.select(object);
    }
}

