/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.IGraphics;
import de.geocalc.kafplot.OskaObject;
import java.awt.Color;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Enumeration;

public abstract class ObjectDecor
implements OskaObject {
    private int oska;
    public double y;
    public double x;
    public double yt;
    public double xt;
    private float w;
    private Color fgColor = Color.black;
    private Color bgColor = Color.white;
    private boolean autoCreate = false;
    private ObjectDecor next = null;

    public ObjectDecor() {
        this(0, 0.0, 0.0, 0.0f);
    }

    public ObjectDecor(int n, double d, double d2, float f) {
        this.oska = n;
        this.y = d;
        this.x = d2;
        this.w = f;
    }

    public boolean hasNext() {
        return this.next != null;
    }

    public void setNext(ObjectDecor objectDecor) {
        this.next = objectDecor;
    }

    public ObjectDecor getNext() {
        return this.next;
    }

    public Enumeration elements() {
        return new DecorEnumerator(this, this);
    }

    public boolean hasLocation() {
        return this.x != 0.0 && this.y != 0.0;
    }

    public boolean hasDecorLocation() {
        return this.yt != 0.0 && this.xt != 0.0;
    }

    public void setAutoCreate(boolean bl) {
        this.autoCreate = bl;
    }

    public boolean isAutoCreate() {
        return this.autoCreate;
    }

    @Override
    public void setOska(int n) {
        this.oska = n;
    }

    @Override
    public int getOska() {
        return this.oska;
    }

    @Override
    public void setFolie(int n) {
    }

    @Override
    public int getFolie() {
        return 0;
    }

    public void setAngle(double d) {
        this.w = (float)d;
    }

    public void setAngle(float f) {
        this.w = f;
    }

    public float getAngle() {
        return this.w;
    }

    public final void setColor(Color color) {
        this.fgColor = color;
        this.bgColor = color;
    }

    public final void setForeground(Color color) {
        this.fgColor = color;
    }

    public final Color getForeground() {
        return this.fgColor;
    }

    public final void setBackground(Color color) {
        this.bgColor = color;
    }

    public final Color getBackground() {
        return this.bgColor;
    }

    public abstract void drawObject(IGraphics var1, boolean var2, boolean var3);

    public abstract String toDatLine();

    public abstract void writeObject(DataOutput var1) throws IOException;

    public class DecorEnumerator
    implements Enumeration {
        ObjectDecor next;

        public DecorEnumerator(ObjectDecor objectDecor, ObjectDecor objectDecor2) {
            this.next = objectDecor2;
        }

        @Override
        public boolean hasMoreElements() {
            return this.next != null;
        }

        public Object nextElement() {
            ObjectDecor objectDecor = this.next;
            this.next = this.next.getNext();
            return objectDecor;
        }
    }
}

