/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.IBorder;
import de.geocalc.awt.IDialog;
import de.geocalc.awt.IFrame;
import de.geocalc.awt.IPanel;
import de.geocalc.awt.IScrollTable;
import de.geocalc.awt.ITable;
import de.geocalc.awt.ITableCell;
import de.geocalc.awt.ITableLine;
import de.geocalc.awt.event.ElementInfoListener;
import de.geocalc.awt.event.ITableEvent;
import de.geocalc.awt.event.ITableListener;
import de.geocalc.geodata.Feature;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.GObject;
import de.geocalc.kafplot.event.DataBaseEvent;
import de.geocalc.kafplot.event.DataBaseListener;
import de.geocalc.kataster.model.Alkis;
import de.geocalc.text.IFormat;
import java.awt.AWTEventMulticaster;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;

public abstract class ObjectInfoDialog
extends IDialog
implements ActionListener,
ITableListener,
DataBaseListener {
    protected static final String OK_COMMAND = "OK";
    protected static final String DETAIL_COMMAND = "...";
    protected Object object;
    protected ElementInfoListener elementListener;
    protected ActionListener actionListener;
    protected String actionCommand;
    protected Panel tablePanel;
    protected ITable table;
    protected ITable attTable;

    public ObjectInfoDialog(IFrame iFrame, String string) {
        this(iFrame, string, null, false);
    }

    public ObjectInfoDialog(IFrame iFrame, String string, Object object) {
        this(iFrame, string, object, false);
    }

    public ObjectInfoDialog(IFrame iFrame, String string, Object object, boolean bl) {
        super(iFrame, string, bl);
        this.setLayout(new BorderLayout());
        Panel panel = this.createInfoPanel();
        if (panel != null) {
            this.add("North", panel);
        }
        this.tablePanel = this.createTablePanel(object instanceof Feature && ((Feature)object).hasAttributes());
        this.add("Center", this.tablePanel);
        this.add("South", this.createButtonPanel());
        this.pack();
        this.setObject(object);
        this.setLocationOfParent(iFrame, -11);
        this.table.select(object);
    }

    @Override
    public void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
    }

    @Override
    public void removeActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
    }

    @Override
    public void setActionCommand(String string) {
        this.actionCommand = string;
    }

    @Override
    public String getActionCommand() {
        return this.actionCommand;
    }

    public void addElementInfoListener(ElementInfoListener elementInfoListener) {
        this.elementListener = elementInfoListener;
        if (this.table != null) {
            this.table.addTableListener(this);
        }
    }

    public void removeElementInfoListener(ElementInfoListener elementInfoListener) {
        this.elementListener = null;
        if (this.table != null) {
            this.table.removeTableListener(this);
        }
    }

    protected Panel createInfoPanel() {
        return null;
    }

    protected Panel createTablePanel(boolean bl) {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        IPanel iPanel = new IPanel(gridBagLayout);
        iPanel.setBorder(new IBorder(0));
        this.table = this.createTable();
        IScrollTable iScrollTable = new IScrollTable(this.table);
        iPanel.add(iScrollTable);
        iScrollTable.setPreferredLines(10);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagLayout.setConstraints(iScrollTable, gridBagConstraints);
        if (bl) {
            this.attTable = this.createAttributeTable();
            iScrollTable = new IScrollTable(this.attTable);
            iPanel.add(iScrollTable);
            iScrollTable.setPreferredLines(3);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.2;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(5, 0, 0, 0);
            gridBagLayout.setConstraints(iScrollTable, gridBagConstraints);
        } else {
            this.attTable = null;
        }
        return iPanel;
    }

    protected ITable createAttributeTable() {
        ITable iTable = new ITable(3);
        ITableCell[] iTableCellArray = new ITableCell[]{new ITableCell("Attribut", 0), new ITableCell("Wert", 0), new ITableCell("Beschreibung", 0)};
        iTable.setHeader(new ITableLine(iTableCellArray));
        return iTable;
    }

    protected abstract ITable createTable();

    protected Panel createButtonPanel() {
        Panel panel = new Panel(new FlowLayout(1));
        Button button = new Button(OK_COMMAND);
        button.addActionListener(this);
        panel.add(button);
        return panel;
    }

    public void setObject(Object object) {
        boolean bl;
        boolean bl2 = this.object != null && this.object instanceof Feature && ((Feature)this.object).hasAttributes();
        this.object = object;
        boolean bl3 = bl = this.object != null && this.object instanceof Feature && ((Feature)this.object).hasAttributes();
        if (bl2 != bl) {
            this.remove(this.tablePanel);
            this.tablePanel = this.createTablePanel(bl);
            this.add("Center", this.tablePanel);
            this.pack();
        }
        this.table.doLayout();
        this.table.requestFocus();
        if (this.attTable != null) {
            this.attTable.removeLines();
            if (object != null && object instanceof Feature) {
                Feature feature = (Feature)object;
                Enumeration enumeration = feature.attributes();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    String string2 = feature.getAttribute(string).toString();
                    String string3 = "";
                    if (DataBase.model.getModel() == 2 && object instanceof GObject) {
                        int n = 0;
                        if (IFormat.isNumber(string2)) {
                            try {
                                n = Integer.parseInt(string2);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            string3 = Alkis.getAttributeValue(((GObject)object).getOska(), string, n);
                        }
                        if (string3 == null) {
                            string3 = "";
                        }
                    }
                    ITableCell[] iTableCellArray = new ITableCell[]{new ITableCell(string, -10), new ITableCell(string2, -10), new ITableCell(string3, -10)};
                    this.attTable.addLine(new ITableLine(iTableCellArray, object));
                }
            }
            this.attTable.doLayout();
        }
        this.pack();
        this.showObject(object);
    }

    public Object getObject() {
        return this.object;
    }

    public void select(Object object) {
        this.table.select(object);
        this.showObject(object);
    }

    protected abstract void showObject(Object var1);

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals(OK_COMMAND)) {
            this.endDialog();
        }
    }

    @Override
    public abstract void dataBaseUpdated(DataBaseEvent var1);

    @Override
    public abstract void cellClicked(ITableEvent var1);

    @Override
    public void cellChanged(ITableEvent iTableEvent) {
    }

    @Override
    protected void doStandardAction() {
        this.endDialog();
    }

    @Override
    protected void doAbortAction() {
        this.endDialog();
    }
}

